/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ksom.pm.panther.paint.matrix;

import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.paint.datamodel.GeneNode;
import org.paint.main.PaintManager;
import org.paint.util.GeneNodeUtil;

public class NodeInfoForMatrix {
    private boolean nonExpBackground = false;
    private boolean expBackground = false;
    private boolean nonExpAnnotToTerm = false;
    private boolean expAnnotToTerm = false;
    private boolean nonExpNot = false;
    private boolean expNot = false;
    private boolean paintExp = false;
    private GeneNode gNode;
    private GOTerm gTerm;
    private HashSet<Qualifier> qSet;
    private HashSet<Qualifier> nonQset;
    private HashMap<String, HashSet<String>> allQualifierToListOfTerms = new HashMap();
    private static String BLANK_QUALIFIER = "-";
    private static String BLANK_LABEL = "-";
    private static final String STR_BRACKET_START = "(";
    private static final String STR_BRACKET_END = ")";

    public NodeInfoForMatrix(GeneNode gNode, GOTerm gTerm, GOTermHelper gth) {
        new NodeInfoForMatrix(gNode, gTerm, gth, false);
    }

    public NodeInfoForMatrix(GeneNode gNode, GOTerm gTerm, GOTermHelper gth, boolean checkNonDisplayedAnnotMatrixOrg) {
        HashSet<String> termSet;
        String text;
        HashSet<Object> termSet2;
        this.gNode = gNode;
        this.gTerm = gTerm;
        if (GeneNodeUtil.inPrunedBranch(gNode)) {
            return;
        }
        Node n = gNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            return;
        }
        PaintManager pm = PaintManager.inst();
        HashSet<Annotation> handledSet = new HashSet<Annotation>();
        HashSet<Annotation> skippedAnnots = new HashSet<Annotation>();
        ArrayList notAncestors = gth.getAncestors(gTerm);
        for (Annotation a : annotList) {
            if (a.isExpAnnotCreatedInPaint()) {
                this.paintExp = true;
            }
            if (checkNonDisplayedAnnotMatrixOrg && AnnotationHelper.ignoreAnnot((Annotation)a, (Node)n, pm.getnonDisplayedAnnotMatrixOrgToEvdnceLookup())) {
                skippedAnnots.add(a);
                continue;
            }
            HashSet qualifiers = a.getQualifierSet();
            boolean not = QualifierDif.containsNegative((Set)qualifiers);
            if (!not) continue;
            handledSet.add(a);
            String curTerm = a.getGoTerm();
            GOTerm cGOTerm = gth.getTerm(curTerm);
            String label = cGOTerm.getName();
            if (null == label) {
                label = BLANK_LABEL;
            }
            if (!notAncestors.contains(cGOTerm) && !cGOTerm.equals(gTerm)) continue;
            boolean experimental = a.isExperimental();
            if (experimental) {
                this.expBackground = true;
                if (cGOTerm.equals(gTerm)) {
                    this.expAnnotToTerm = true;
                }
                this.expNot = true;
                if (null == qualifiers) {
                    termSet2 = this.allQualifierToListOfTerms.get(BLANK_QUALIFIER);
                    if (null == termSet2) {
                        termSet2 = new HashSet();
                        this.allQualifierToListOfTerms.put(BLANK_QUALIFIER, termSet2);
                    }
                    termSet2.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                    continue;
                }
                for (Qualifier q : qualifiers) {
                    text = q.getText();
                    if (null == text || 0 == text.trim().length()) {
                        termSet = this.allQualifierToListOfTerms.get(BLANK_QUALIFIER);
                        if (null == termSet) {
                            termSet = new HashSet();
                            this.allQualifierToListOfTerms.put(BLANK_QUALIFIER, termSet);
                        }
                        termSet.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                        continue;
                    }
                    termSet = this.allQualifierToListOfTerms.get(text);
                    if (null == termSet) {
                        termSet = new HashSet();
                        this.allQualifierToListOfTerms.put(text, termSet);
                    }
                    termSet.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                }
                if (null == this.qSet) {
                    this.qSet = new HashSet();
                }
                QualifierDif.addIfNotPresent(this.qSet, (HashSet)qualifiers);
                continue;
            }
            this.nonExpBackground = true;
            if (cGOTerm.equals(gTerm)) {
                this.nonExpAnnotToTerm = true;
            }
            this.nonExpNot = true;
            if (null == qualifiers) {
                termSet2 = this.allQualifierToListOfTerms.get(BLANK_QUALIFIER);
                if (null == termSet2) {
                    termSet2 = new HashSet();
                    this.allQualifierToListOfTerms.put(BLANK_QUALIFIER, termSet2);
                }
                termSet2.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                continue;
            }
            for (Qualifier q : qualifiers) {
                text = q.getText();
                if (null == text || 0 == text.trim().length()) {
                    termSet = this.allQualifierToListOfTerms.get(BLANK_QUALIFIER);
                    if (null == termSet) {
                        termSet = new HashSet();
                        this.allQualifierToListOfTerms.put(BLANK_QUALIFIER, termSet);
                    }
                    termSet.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                    continue;
                }
                termSet = this.allQualifierToListOfTerms.get(text);
                if (null == termSet) {
                    termSet = new HashSet();
                    this.allQualifierToListOfTerms.put(text, termSet);
                }
                termSet.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
            }
            if (null == this.nonQset) {
                this.nonQset = new HashSet();
            }
            QualifierDif.addIfNotPresent(this.nonQset, (HashSet)a.getQualifierSet());
        }
        for (Annotation a : annotList) {
            HashSet curSet;
            ArrayList ancestors;
            if (handledSet.contains(a) || skippedAnnots.contains(a) || checkNonDisplayedAnnotMatrixOrg && AnnotationHelper.ignoreAnnot((Annotation)a, (Node)n, pm.getnonDisplayedAnnotMatrixOrgToEvdnceLookup())) continue;
            boolean experimental = a.isExperimental();
            String curTerm = a.getGoTerm();
            GOTerm cGOTerm = gth.getTerm(curTerm);
            String label = cGOTerm.getName();
            if (null == label) {
                label = BLANK_LABEL;
            }
            if (!(ancestors = gth.getAncestors(cGOTerm)).contains(gTerm) && !cGOTerm.equals(gTerm)) continue;
            if (experimental) {
                this.expBackground = true;
                if (cGOTerm.equals(gTerm)) {
                    this.expAnnotToTerm = true;
                }
                if (null == (curSet = a.getQualifierSet())) {
                    termSet2 = this.allQualifierToListOfTerms.get(BLANK_QUALIFIER);
                    if (null == termSet2) {
                        termSet2 = new HashSet();
                        this.allQualifierToListOfTerms.put(BLANK_QUALIFIER, termSet2);
                    }
                    termSet2.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                    continue;
                }
                for (Qualifier q : curSet) {
                    text = q.getText();
                    if (null == text || 0 == text.trim().length()) {
                        termSet = this.allQualifierToListOfTerms.get(BLANK_QUALIFIER);
                        if (null == termSet) {
                            termSet = new HashSet();
                            this.allQualifierToListOfTerms.put(BLANK_QUALIFIER, termSet);
                        }
                        termSet.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                        continue;
                    }
                    termSet = this.allQualifierToListOfTerms.get(text);
                    if (null == termSet) {
                        termSet = new HashSet();
                        this.allQualifierToListOfTerms.put(text, termSet);
                    }
                    termSet.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                }
                if (null == this.qSet) {
                    this.qSet = new HashSet();
                }
                for (Qualifier q : curSet) {
                    if (!gth.isQualifierValidForTerm(gTerm, q)) continue;
                    QualifierDif.addIfNotPresent(this.qSet, (Qualifier)q);
                }
                continue;
            }
            this.nonExpBackground = true;
            if (cGOTerm.equals(gTerm)) {
                this.nonExpAnnotToTerm = true;
            }
            if (null == (curSet = a.getQualifierSet())) {
                termSet2 = this.allQualifierToListOfTerms.get(BLANK_QUALIFIER);
                if (null == termSet2) {
                    termSet2 = new HashSet();
                    this.allQualifierToListOfTerms.put(BLANK_QUALIFIER, termSet2);
                }
                termSet2.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                continue;
            }
            for (Qualifier q : curSet) {
                text = q.getText();
                if (null == text || 0 == text.trim().length()) {
                    termSet = this.allQualifierToListOfTerms.get(BLANK_QUALIFIER);
                    if (null == termSet) {
                        termSet = new HashSet();
                        this.allQualifierToListOfTerms.put(BLANK_QUALIFIER, termSet);
                    }
                    termSet.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
                    continue;
                }
                termSet = this.allQualifierToListOfTerms.get(text);
                if (null == termSet) {
                    termSet = new HashSet();
                    this.allQualifierToListOfTerms.put(text, termSet);
                }
                termSet.add(label + STR_BRACKET_START + curTerm + STR_BRACKET_END);
            }
            if (null == this.nonQset) {
                this.nonQset = new HashSet();
            }
            for (Qualifier q : curSet) {
                if (!gth.isQualifierValidForTerm(gTerm, q)) continue;
                QualifierDif.addIfNotPresent(this.nonQset, (Qualifier)q);
            }
        }
    }

    public boolean isNonExpBackground() {
        return this.nonExpBackground;
    }

    public boolean isExpBackground() {
        return this.expBackground;
    }

    public boolean isNonExpAnnotToTerm() {
        return this.nonExpAnnotToTerm;
    }

    public boolean isExpAnnotToTerm() {
        return this.expAnnotToTerm;
    }

    public boolean isNonExpNot() {
        return this.nonExpNot;
    }

    public boolean isExpNot() {
        return this.expNot;
    }

    public GeneNode getgNode() {
        return this.gNode;
    }

    public GOTerm getgTerm() {
        return this.gTerm;
    }

    public HashSet<Qualifier> getqSet() {
        return this.qSet;
    }

    public HashSet<Qualifier> getNonQset() {
        return this.nonQset;
    }

    public HashMap<String, HashSet<String>> getAllQualifierToListOfTerms() {
        return this.allQualifierToListOfTerms;
    }

    public boolean isPaintExp() {
        return this.paintExp;
    }

    public boolean containsMultipleQualifiers() {
        return null != this.allQualifierToListOfTerms && 1 < this.allQualifierToListOfTerms.size();
    }
}

