/*
 * Decompiled with CFR 0.152.
 */
package org.paint.config;

import com.sri.panther.paintCommon.util.ReadResources;
import edu.usc.ksom.pm.panther.paintCommon.PAINTVersion;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.obo.util.VersionNumber;
import org.paint.gui.familytree.TreeModel;
import org.paint.util.SVGIcon;

public class Preferences {
    private static final long serialVersionUID = -5472475387423113108L;
    protected static Logger log = Logger.getLogger((String)"org.paint.config.Preferences");
    private String pantherURL = null;
    private double tree_distance_scaling = 50.0;
    private TreeModel.TreeColorSchema colorSchema = TreeModel.TreeColorSchema.DUPLICATION;
    protected ReadResources RR = this.initResources();
    private boolean useDistances = true;
    private Font font = new Font("Arial", 0, 12);
    private Map<String, Icon> iconIndex = new HashMap<String, Icon>();
    private Map<String, String> iconURLIndex = new HashMap<String, String>();
    private Color foregroundColor = Color.black;
    private Color backgroundColor = Color.white;
    private Color selectionColor = Color.black;
    private VersionNumber version;
    private Color expPaintColor = new Color(16, 128, 64);
    private Color curatedPaintColor = new Color(255, 127, 0);
    private Color inferPaintColor = new Color(16, 64, 128);
    public static final Color SEA_BLUE = new Color(43, 148, 201);
    public static final Color BRIGHT_GREEN;
    public static final Color EXP_ANNOT_ADDED_IN_PAINT;
    public static final int HIGHLIGHT_BP = 1;
    public static final int HIGHLIGHT_CC = 2;
    public static final int HIGHLIGHT_MF = 4;
    private Color mfPaintColor = new Color(232, 248, 232);
    private Color ccPaintColor = new Color(224, 248, 255);
    private Color bpPaintColor = new Color(255, 248, 220);
    private float[] msa_threshold = new float[]{80.0f, 60.0f, 40.0f};
    private float[] msa_weighted_threshold = new float[]{90.0f, 75.0f};
    private Color[] msa_colors = new Color[]{new Color(21, 138, 255), new Color(185, 220, 255), new Color(220, 233, 255)};
    private Color[] msa_weighted_colors = new Color[]{new Color(21, 138, 255), new Color(220, 233, 255)};
    public static final Color COLOR_WARNING_DEV;
    public static Color COLOR_DEFAULT;
    private String[] high_throughput = new String[]{"PMID:10341420", "PMID:10662773", "PMID:11027285", "PMID:11452010", "PMID:11914276", "PMID:12077337", "PMID:12089449", "PMID:12134085", "PMID:12150911", "PMID:12192589", "PMID:12482937", "PMID:12524434", "PMID:12586695", "PMID:14562095", "PMID:14576278", "PMID:14645503", "PMID:14690591", "PMID:14690608", "PMID:15024427", "PMID:15343339", "PMID:15575969", "PMID:15632165", "PMID:15738404", "PMID:16121259", "PMID:16269340", "PMID:16319894", "PMID:16407407", "PMID:16467407", "PMID:16622836", "PMID:16702403", "PMID:16823372", "PMID:16823961", "PMID:17176761", "PMID:17443350", "PMID:1848238", "PMID:18627600", "PMID:19001347", "PMID:19040720", "PMID:19053807", "PMID:19056867", "PMID:19061648", "PMID:19111667", "PMID:19158363", "PMID:20424846", "PMID:2153142", "PMID:22842922", "PMID:23212245", "PMID:23222640", "PMID:23376485", "PMID:23533145", "PMID:24390141", "PMID:2445736", "PMID:3031032", "PMID:3065625", "PMID:8660468", "PMID:9020838", "PMID:9182565"};
    private static Preferences preferences;
    private Map<String, String> taxa2IDs;
    private Map<String, String> IDs2taxa;

    private ReadResources initResources() {
        try {
            ReadResources rr = new ReadResources("user");
            this.pantherURL = rr.getKey("servlet_url");
            this.tree_distance_scaling = Double.parseDouble(rr.getKey("tree_scaling"));
            return rr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Preferences() {
        this.iconURLIndex.put("trash", "resource:trash.png");
        this.iconURLIndex.put("paint", "resource:direct_annot.png");
        this.iconURLIndex.put("arrowDown", "resource:arrowDown.png");
        this.iconURLIndex.put("block", "resource:Emblem-question.svg");
        this.iconURLIndex.put("not", "resource:round-stop.png");
        this.iconURLIndex.put("exp", "resource:Bkchem.png");
        this.iconURLIndex.put("inherited", "resource:inherited_annot.png");
        this.iconURLIndex.put("colocate", "resource:colocate.png");
        this.iconURLIndex.put("contribute", "resource:contribute.svg");
    }

    public static Preferences inst() {
        if (preferences == null) {
            preferences = new Preferences();
            GUIManager.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Preferences.writePreferences(Preferences.inst());
                    }
                    catch (IOException ex) {
                        log.info((Object)"Could not write verification settings!");
                        ex.printStackTrace();
                    }
                }
            });
        }
        return preferences;
    }

    protected static void writePreferences(Preferences preferences) throws IOException {
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(Preferences.getPrefsXMLFile())));
        log.info((Object)("Writing preferences to " + Preferences.getPrefsXMLFile()));
        encoder.setPersistenceDelegate(Font.class, new DefaultPersistenceDelegate(new String[]{"name", "style", "size"}));
        encoder.setPersistenceDelegate(Color.class, new DefaultPersistenceDelegate(new String[]{"red", "green", "blue"}));
        encoder.writeObject(preferences);
        encoder.close();
    }

    public static File getPrefsXMLFile() {
        return new File(Preferences.getPaintPrefsDir(), "preferences.xml");
    }

    public static File getPaintPrefsDir() {
        Path currentRelativePath = Paths.get("", new String[0]);
        String s = currentRelativePath.toAbsolutePath().toString();
        File prefsDir = new File(s + File.separator + "perspectives");
        return prefsDir;
    }

    public String getPAINTversion() {
        return PAINTVersion.getPAINTClientversion();
    }

    public VersionNumber getVersion() {
        if (this.version == null) {
            try {
                URL url = Preferences.getExtensionLoader().getResource("org/paint/resources/VERSION");
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                this.version = new VersionNumber(reader.readLine());
                reader.close();
            }
            catch (Exception e) {
                try {
                    this.version = new VersionNumber("1.0");
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return this.version;
    }

    public String getSpeciesName(String taxon_id) {
        if (this.IDs2taxa == null) {
            this.loadTaxaMapping();
        }
        return this.IDs2taxa.get(taxon_id);
    }

    public String getTaxonID(String species_name) {
        String taxon_id;
        if (this.taxa2IDs == null) {
            this.loadTaxaMapping();
        }
        if (!((String)species_name).equals("root")) {
            species_name = ((String)species_name).substring(0, 1).toUpperCase() + ((String)species_name).substring(1);
        }
        if ((taxon_id = this.taxa2IDs.get(species_name)) == null) {
            taxon_id = this.taxa2IDs.get(((String)species_name).toLowerCase());
        }
        if (taxon_id == null) {
            taxon_id = this.taxa2IDs.get(this.speciesNameHack((String)species_name));
        }
        return taxon_id;
    }

    private void loadTaxaMapping() {
        this.taxa2IDs = new HashMap<String, String>();
        this.IDs2taxa = new HashMap<String, String>();
        try {
            URL url = Preferences.getExtensionLoader().getResource("org/paint/resources/ncbi_taxa_ids.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String id_pair = reader.readLine();
            while (id_pair != null) {
                if (!id_pair.contains("authority")) {
                    id_pair = id_pair.replace('\t', ' ');
                    String[] ids = id_pair.split("\\|");
                    String taxon_id = "taxon:" + ids[0].trim();
                    String name = ids[1].trim();
                    if (!ids[2].contains(name)) {
                        name = (name + " " + ids[2].trim()).trim();
                    } else if (ids[2].trim().length() > name.length()) {
                        name = ids[2].trim();
                    }
                    if (id_pair.contains("scientific name")) {
                        this.IDs2taxa.put(taxon_id, name);
                    }
                    this.taxa2IDs.put(name, taxon_id);
                }
                id_pair = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static ClassLoader getExtensionLoader() {
        return Preferences.class.getClassLoader();
    }

    protected Icon loadLibraryIconLocal(String name) {
        String dir = "org/paint/resources/";
        URL url = Preferences.getExtensionLoader().getResource(dir + name);
        if (url == null) {
            url = Preferences.getExtensionLoader().getResource("org/paint/resources/icons" + name);
        }
        if (url == null) {
            log.debug((Object)("Oops, could not find icon " + name));
        }
        return Preferences.getIconForURL(url);
    }

    public static Icon getIconForURL(URL url) {
        if (url == null) {
            return null;
        }
        try {
            String urlStr = url.toString();
            if (urlStr.endsWith("svg")) {
                return new SVGIcon(urlStr);
            }
        }
        catch (Exception e) {
            log.info((Object)("WARNING: Exception getting icon for " + url + ": " + e));
        }
        return new ImageIcon(url);
    }

    public static Image loadLibraryImage(String name) {
        URL url = Preferences.getExtensionLoader().getResource("org/paint/gui/resources/" + name);
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    public Icon loadLibraryIcon(String name) {
        return Preferences.inst().loadLibraryIconLocal(name);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color c) {
        this.foregroundColor = c;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color c) {
        this.selectionColor = c;
    }

    public double getTree_distance_scaling() {
        return this.tree_distance_scaling;
    }

    public void setTree_distance_scaling(double scale) {
        this.tree_distance_scaling = scale;
    }

    public TreeModel.TreeColorSchema getColorSchema() {
        return this.colorSchema;
    }

    public void setTreeColorSchema(TreeModel.TreeColorSchema colorSchema) {
        this.colorSchema = colorSchema;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean isUseDistances() {
        return this.useDistances;
    }

    public boolean getUseDistances() {
        return this.isUseDistances();
    }

    public void setUseDistances(boolean distance) {
        this.useDistances = distance;
    }

    public void toggleUseDistances() {
        this.setUseDistances(!this.useDistances);
    }

    public Icon getIconByName(String id) {
        Icon out = this.iconIndex.get(id);
        if (out == null) {
            block9: {
                String iconURL = this.iconURLIndex.get(id);
                if (iconURL != null) {
                    if (iconURL.startsWith("resource:")) {
                        out = this.loadLibraryIcon(iconURL.substring(9));
                    } else {
                        try {
                            out = Preferences.getIconForURL(new URL(iconURL));
                        }
                        catch (MalformedURLException e) {
                            File file = new File(iconURL);
                            if (!file.exists()) break block9;
                            try {
                                out = Preferences.getIconForURL(file.toURI().toURL());
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (out != null) {
                this.iconIndex.put(id, out);
            }
        }
        return out;
    }

    public String getPantherURL() {
        return this.pantherURL;
    }

    public void setPantherURL(String url) {
        if (url != null && url.length() > 0) {
            this.pantherURL = url;
        }
    }

    public Color getAspectColor(int aspect) {
        Color color = this.getBackgroundColor();
        if (aspect > 0) {
            switch (aspect) {
                case 4: {
                    color = this.mfPaintColor;
                    break;
                }
                case 2: {
                    color = this.ccPaintColor;
                    break;
                }
                case 1: {
                    color = this.bpPaintColor;
                }
            }
        }
        return color;
    }

    public void setAspectColor(int aspect, Color color) {
        if (aspect > 0) {
            switch (aspect) {
                case 4: {
                    this.mfPaintColor = color;
                    break;
                }
                case 2: {
                    this.ccPaintColor = color;
                    break;
                }
                case 1: {
                    this.bpPaintColor = color;
                }
            }
        }
    }

    public Color getMfPaintColor() {
        return this.mfPaintColor;
    }

    public void setMfPaintColor(Color mfColor) {
        this.mfPaintColor = mfColor;
    }

    public Color getCcPaintColor() {
        return this.ccPaintColor;
    }

    public void setCcPaintColor(Color ccColor) {
        this.ccPaintColor = ccColor;
    }

    public Color getBpPaintColor() {
        return this.bpPaintColor;
    }

    public void setBpPaintColor(Color bpColor) {
        this.bpPaintColor = bpColor;
    }

    public Color getExpPaintColor() {
        return this.expPaintColor;
    }

    public void setExpPaintColor(Color c) {
        this.expPaintColor = c;
    }

    public Color getCuratedPaintColor() {
        return this.curatedPaintColor;
    }

    public void setCuratedPaintColor(Color c) {
        this.curatedPaintColor = c;
    }

    public Color getInferPaintColor() {
        return this.inferPaintColor;
    }

    public void setInferPaintColor(Color c) {
        this.inferPaintColor = c;
    }

    public float[] getMSAThresholds(boolean weighted) {
        if (weighted) {
            return this.msa_weighted_threshold;
        }
        return this.msa_threshold;
    }

    public Color[] getMSAColors(boolean weighted) {
        if (weighted) {
            return this.msa_weighted_colors;
        }
        return this.msa_colors;
    }

    public void setMSAThresholds(boolean weighted, float[] thresholds) {
        if (weighted) {
            this.msa_weighted_threshold = thresholds;
        } else {
            this.msa_threshold = thresholds;
        }
    }

    public void setMSAColors(boolean weighted, Color[] colors) {
        if (weighted) {
            this.msa_weighted_colors = colors;
        } else {
            this.msa_colors = colors;
        }
    }

    public float[] getMsa_threshold() {
        return this.msa_threshold;
    }

    public void setMsa_threshold(float[] thresholds) {
        this.msa_threshold = thresholds;
    }

    public float[] getMsa_weighted_threshold() {
        return this.msa_weighted_threshold;
    }

    public void setMsa_weighted_threshold(float[] thresholds) {
        this.msa_weighted_threshold = thresholds;
    }

    public Color[] getMsa_colors() {
        return this.msa_colors;
    }

    public void setMsa_colors(Color[] colors) {
        this.msa_colors = colors;
    }

    public Color[] getMsa_weighted_colors() {
        return this.msa_weighted_colors;
    }

    public void setMsa_weighted_colors(Color[] colors) {
        this.msa_weighted_colors = colors;
    }

    public boolean isExcluded(String pubmedID) {
        boolean excluded = false;
        for (int i = 0; i < this.high_throughput.length && !excluded; ++i) {
            excluded = pubmedID.equals(this.high_throughput[i]);
        }
        return excluded;
    }

    private String speciesNameHack(String name) {
        String lcName = name.toLowerCase();
        if (lcName.equals("human")) {
            name = "Homo sapiens";
        } else if (lcName.equals("pantr")) {
            name = "Pan troglodytes";
        } else if (lcName.equals("homo-pan")) {
            name = "Homininae";
        } else if (lcName.equals("mouse")) {
            name = "Mus musculus";
        } else if (lcName.equals("rat")) {
            name = "Rattus norvegicus";
        } else if (lcName.equals("bovin")) {
            name = "Bos taurus";
        } else if (lcName.equals("canis familiaris") || lcName.equals("canfa")) {
            name = "Canis lupus familiaris";
        } else if (lcName.equals("mondo")) {
            name = "Monodelphis domestica";
        } else if (lcName.equals("ornan")) {
            name = "Ornithorhynchus anatinus";
        } else if (lcName.equals("chick")) {
            name = "Gallus gallus";
        } else if (lcName.equals("xentr")) {
            name = "Xenopus (Silurana) tropicalis";
        } else if (lcName.equals("fugu rubripes") || lcName.equals("fugru")) {
            name = "Takifugu rubripes";
        } else if (lcName.equals("brachydanio rerio") || lcName.equals("danre")) {
            name = "Danio rerio";
        } else if (lcName.equals("cioin")) {
            name = "Ciona intestinalis";
        } else if (lcName.equals("strpu")) {
            name = "Strongylocentrotus purpuratus";
        } else if (lcName.equals("caenorhabditis")) {
            name = "Caenorhabditis elegans";
        } else if (lcName.equals("briggsae") || lcName.equals("caebr")) {
            name = "Caenorhabditis briggsae";
        } else if (lcName.equals("drome")) {
            name = "Drosophila melanogaster";
        } else if (lcName.equals("anopheles gambiae str. pest") || lcName.equals("anoga")) {
            name = "Anopheles gambiae";
        } else if (lcName.equals("yeast")) {
            name = "Saccharomyces cerevisiae";
        } else if (lcName.equals("ashbya gossypii") || lcName.equals("ashgo")) {
            name = "Eremothecium gossypii";
        } else if (lcName.equals("neucr")) {
            name = "Neurospora crassa";
        } else if (lcName.equals("schpo")) {
            name = "Schizosaccharomyces pombe";
        } else if (lcName.equals("dicdi")) {
            name = "Dictyostelium discoideum";
        } else if (lcName.equals("aspergillus nidulans")) {
            name = "Emericella nidulans";
        } else if (lcName.equals("chlre")) {
            name = "Chlamydomonas reinhardtii";
        } else if (lcName.equals("orysj")) {
            name = "Oryza sativa";
        } else if (lcName.equals("arath")) {
            name = "Arabidopsis thaliana";
        } else if (lcName.equals("metac")) {
            name = "Methanosarcina acetivorans";
        } else if (lcName.equals("strco")) {
            name = "Streptomyces coelicolor";
        } else if (lcName.equals("glovi")) {
            name = "Gloeobacter violaceus";
        } else if (lcName.equals("lepin")) {
            name = "Leptospira interrogans";
        } else if (lcName.equals("braja")) {
            name = "Bradyrhizobium japonicum";
        } else if (lcName.equals("escherichia coli coli str. K-12 substr. MG1655") || lcName.equals("ecoli")) {
            name = "Escherichia coli";
        } else if (lcName.equals("enthi")) {
            name = "Entamoeba histolytica";
        } else if (lcName.equals("bacsu")) {
            name = "Bacillus subtilis";
        } else if (lcName.equals("deira")) {
            name = "Deinococcus radiodurans";
        } else if (lcName.equals("thema")) {
            name = "Thermotoga maritima";
        } else if (lcName.equals("opisthokonts")) {
            name = "Opisthokonta";
        } else if (lcName.equals("bactn")) {
            name = "Bacteroides thetaiotaomicron";
        } else if (lcName.equals("leima")) {
            name = "Leishmania major";
        } else if (lcName.equals("eubacteria")) {
            name = "Bacteria <prokaryote>";
        } else if (lcName.equals("theria")) {
            name = "Theria <Mammalia>";
        } else if (lcName.equals("geobacter sufurreducens") || lcName.equals("geosl")) {
            name = "Geobacter sulfurreducens";
        } else if (lcName.equals("psea7")) {
            name = "Pseudomonas aeruginosa";
        } else if (lcName.equals("aquae") || lcName.equals("aquifex aeolicus vf5")) {
            name = "Aquifex aeolicus";
        } else if (lcName.equals("metac") || lcName.equals("methanosarcina acetivorans c2a")) {
            name = "Methanosarcina acetivorans";
        } else if (lcName.equals("sulso") || lcName.equals("sulfolobus solfataricus p2")) {
            name = "Sulfolobus solfataricus";
        } else if (lcName.equals("saccharomycetaceae-candida")) {
            name = "mitosporic Nakaseomyces";
        } else if (lcName.equals("sordariomycetes-leotiomycetes")) {
            name = "Leotiomycetes";
        } else if (lcName.equals("excavates")) {
            name = "Excavarus";
        } else if (lcName.equals("metazoa-choanoflagellida")) {
            name = "Opisthokonta";
        } else if (lcName.equals("alveolata-stramenopiles")) {
            name = "Eukaryota";
        } else if (lcName.equals("pezizomycotina-saccharomycotina")) {
            name = "saccharomyceta";
        } else if (lcName.equals("unikonts")) {
            name = "Eukaryota";
        } else if (lcName.equals("archaea-eukaryota")) {
            name = "cellular organisms";
        } else if (lcName.equals("osteichthyes")) {
            name = "Euteleostomi";
        } else if (lcName.equals("craniata-cephalochordata")) {
            name = "Chordata";
        } else if (lcName.equals("hexapoda-crustacea")) {
            name = "Pancrustacea";
        } else if (lcName.equals("rhabditida-chromadorea")) {
            name = "Chromadorea";
        }
        return name;
    }

    public void warnUserDevEnv() {
        GUIManager guiManager = GUIManager.getManager();
        if (null == guiManager || null == guiManager.getFrame()) {
            return;
        }
        JRootPane rootPane = guiManager.getFrame().getRootPane();
        if (null == rootPane || null == rootPane.getJMenuBar()) {
            return;
        }
        JMenuBar mBar = rootPane.getJMenuBar();
        if (PAINTVersion.IS_TEST_ENV.booleanValue()) {
            mBar.setBackground(COLOR_WARNING_DEV);
        } else {
            mBar.setBackground(COLOR_DEFAULT);
        }
    }

    static {
        EXP_ANNOT_ADDED_IN_PAINT = BRIGHT_GREEN = new Color(37, 224, 20);
        COLOR_WARNING_DEV = new Color(255, 204, 204);
        COLOR_DEFAULT = new Color(238, 238, 238);
    }
}

