/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dataadapter;

import com.sri.panther.paintCommon.FixedInfo;
import com.sri.panther.paintCommon.util.Utils;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.paint.config.PantherDbInfo;
import org.paint.datamodel.GeneNode;
import org.paint.util.PantherParseUtil;

public class AttrTable {
    private static final String DELIMITER = "\t";
    private static final String DELIM_TAB = "\t";
    private static final String DELIM_QUOTE = "'";
    private static final String DELIM_NEW_LINE = "\n";
    private static final Logger log = Logger.getLogger(AttrTable.class);

    public static Vector<Vector<String>> parse(String[] tableContents) {
        if (null == tableContents) {
            return null;
        }
        if (0 == tableContents.length) {
            return null;
        }
        Vector<Vector<String>> rows = new Vector<Vector<String>>();
        int numCols = Utils.tokenize((String)tableContents[0], (String)"\t").length;
        for (int i = 0; i < tableContents.length; ++i) {
            String[] columns;
            Vector<String> modifiedCols;
            if (tableContents[i].endsWith(DELIM_NEW_LINE)) {
                tableContents[i] = tableContents[i].substring(0, tableContents[i].length() - 1);
            }
            if (numCols != (modifiedCols = AttrTable.removeQuotes(columns = Utils.tokenize((String)tableContents[i], (String)"\t"))).size()) {
                log.error((Object)("num columns does not match, i is " + Integer.toString(i) + " num columns in title row is " + Integer.toString(numCols)));
                return null;
            }
            rows.addElement(modifiedCols);
        }
        return rows;
    }

    private static Vector<String> removeQuotes(String[] columns) {
        Vector<String> updated = new Vector<String>();
        for (int i = 0; i < columns.length; ++i) {
            String contents = columns[i];
            if (contents.startsWith(DELIM_QUOTE) && (contents = contents.substring(1)).endsWith(DELIM_QUOTE)) {
                contents = contents.substring(0, contents.length() - 1);
            }
            updated.addElement(contents);
        }
        return updated;
    }

    public static String[] saveAttrTable(Vector<GeneNode> contents, Vector<String> headings) {
        if (null == contents || 0 == contents.size()) {
            return null;
        }
        if (null == headings) {
            return null;
        }
        return AttrTable.saveAttrTableBasedOnHeadings(contents, headings);
    }

    private static String[] saveAttrTableBasedOnHeadings(Vector<GeneNode> contents, Vector<String> headings) {
        int numHeadings = headings.size();
        int numRows = contents.size();
        FixedInfo fixedInfo = PantherDbInfo.getFixedInfo();
        int seqColIndex = PantherParseUtil.inst().getColIndex(fixedInfo.getSeqColName());
        if (seqColIndex < 0) {
            seqColIndex = fixedInfo.getOrigSeqColIndex();
        }
        Vector<Object> all = new Vector<Object>(numRows + 1);
        String headerStr = Utils.listToString(headings, (String)DELIM_QUOTE, (String)"\t") + DELIM_NEW_LINE;
        all.addElement(headerStr);
        StringBuffer columnBuff = new StringBuffer();
        for (int i = 0; i < contents.size(); ++i) {
            GeneNode gene = contents.elementAt(i);
            boolean isLeaf = gene.isLeaf();
            columnBuff.setLength(0);
            for (int j = 0; j < numHeadings; ++j) {
                String value = j == seqColIndex && false == isLeaf ? gene.getSeqId() : gene.getAttrLookup(headings.get(j));
                if (null == value) {
                    value = "";
                }
                columnBuff.append(DELIM_QUOTE);
                columnBuff.append(value);
                columnBuff.append(DELIM_QUOTE);
                if (j + 1 >= numHeadings) continue;
                columnBuff.append("\t");
            }
            columnBuff.append(DELIM_NEW_LINE);
            all.addElement(columnBuff.toString());
        }
        Object[] returnArray = new String[all.size()];
        all.copyInto(returnArray);
        return returnArray;
    }
}

