/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dataadapter;

import com.sri.panther.paintCommon.util.FileUtils;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.paint.dataadapter.FileUtil;
import org.paint.gui.evidence.EvidencePanel;

public class EvidenceAdapter {
    protected static Logger log = Logger.getLogger(EvidenceAdapter.class);

    public static void importEvidence(String path) {
        int start;
        File evi_file;
        StringBuffer errors = new StringBuffer();
        Object text = null;
        if (path != null && (evi_file = FileUtil.inst().getFile(path, "txt")).isFile() && evi_file.canRead()) {
            try {
                String file_name = evi_file.getCanonicalPath();
                String[] evidence = FileUtils.readFile((String)file_name);
                if (null != evidence && evidence.length > 0) {
                    text = "";
                    for (int i = 0; i < evidence.length; ++i) {
                        text = (String)text + evidence[i] + "\n";
                    }
                } else {
                    errors.append(file_name + " is empty");
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), errors.toString(), "Failed to import evidence file", 0);
            }
        }
        if (text != null && (start = ((String)text).indexOf("Annotation inferences using phylogenetic trees")) >= 0) {
            String prefix = ((String)text).substring(0, start);
            int end = start + "Annotation inferences using phylogenetic trees\n\nThe goal of the GO Reference Genome Project, described in PMID 19578431, is to provide accurate, complete and consistent GO annotations for all genes in twelve model organism genomes. To this end, GO curators are annotating evolutionary trees from the PANTHER database with GO terms describing molecular function, biological process and cellular component. GO terms based on experimental data from the scientific literature are used to annotate ancestral genes in the phylogenetic tree by sequence similarity (ISS), and unannotated descendants of these ancestral genes are inferred to have inherited these same GO annotations by descent. The annotations are done using a tool called PAINT (Phylogenetic Annotation and INference Tool).\n".length();
            String suffix = end >= ((String)text).length() ? "" : ((String)text).substring(end - 1);
            text = prefix + suffix;
        }
    }

    public static boolean exportEvidence(String path) {
        boolean success = false;
        try {
            if (path != null) {
                File f = FileUtil.inst().getFile(path, "txt");
                String file_name = f.getCanonicalPath();
                String warnings = EvidencePanel.inst().getWarnings();
                if (warnings == null || warnings.length() > 0) {
                    // empty if block
                }
                success = true;
            }
        }
        catch (IOException ie) {
            log.error((Object)("IO exception " + ie.getMessage() + " returned while attempting to export evidence file " + path));
        }
        return success;
    }
}

