/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dataadapter;

import com.sri.panther.paintCommon.FixedInfo;
import com.sri.panther.paintCommon.TransferInfo;
import com.sri.panther.paintCommon.User;
import edu.usc.ksom.pm.panther.paintCommon.DataTransferObj;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import edu.usc.ksom.pm.panther.paintCommon.VersionContainer;
import edu.usc.ksom.pm.panther.paintCommon.VersionInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.ProgressEvent;

public class PantherServer {
    public static final String CHAR_ENCODING = "UTF-8";
    public static final String STRING_EMPTY = "";
    private static final String SUFFIX_PATH_VERSIONS = "/servlet/edu.usc.ksom.pm.panther.paintServer.servlet.DataServlet?action=versions";
    public static final String MSG_ERROR_UNABLE_TO_LOCK_BOOKS = "Error unable to lock books";
    public static final String MSG_ERROR_CONCAT = "Server has returned the following error:  ";
    public static final String MSG_SUCCESS = new String();
    private static final String SERVLET_CONNECTION_CONTENT_TYPE = "Content-Type";
    private static final String SERVLET_CONNECTION_OBJECT_TYPE_JAVA = "java/object";
    private static final String SERVLET_REQUEST_PROPERTY_COOKIE = "Cookie";
    private static final String SERVLET_PATH = "/servlet/edu.usc.ksom.pm.panther.paintServer.servlet.DataServlet?action=";
    public static final String ACTION_GET_GO_HIERARCHY = "goHierarchy";
    public static final String ACTION_GET_VERSION_INFO = "versionInfo";
    public static final String ACTION_GET_MSA = "msa";
    public static final String ACTION_GET_MSA_KEY_RESIDUE = "msaKeyResidue";
    public static final String ACTION_GET_TREE = "tree";
    public static final String ACTION_GET_NODES = "nodes";
    public static final String ACTION_GET_FAMILY_NAME = "familyName";
    public static final String ACTION_GET_FAMILY_DOMAIN = "familyDomain";
    public static final String ACTION_GET_FAMILY_COMMENT = "familyComment";
    public static final String ACTION_SAVE_BOOK = "saveBook";
    public static final String REQUEST_SEARCH_GENE_NAME = "searchGeneName";
    public static final String REQUEST_SEARCH_GENE_EXT_ID = "searchGeneExtId";
    public static final String REQUEST_SEARCH_PROTEIN_EXT_ID = "searchProteinExtId";
    public static final String REQUEST_SEARCH_DEFINITION = "searchDefinition";
    public static final String REQUEST_SEARCH_BOOK_ID = "searchBookId";
    public static final String REQUEST_SEARCH_BOOK_PTN = "searchBookPTN";
    public static final String REQUEST_SEARCH_ALL_BOOKS = "allBooks";
    public static final String REQUEST_LOCK_BOOKS = "LockBooks";
    public static final String REQUEST_UNLOCK_BOOKS = "UnlockBooks";
    public static final String REQUEST_LOCK_UNLOCK_BOOKS = "LockUnLockBooks";
    public static final String REQUEST_MY_BOOKS = "MyBooks";
    public static final String REQUEST_SEARCH_UNCURATED_BOOKS = "uncuratedBooks";
    public static final String REQUEST_SEARCH_REQUIRE_PAINT_REVIEW_UNLOCKED = "requirePaintReviewUnlocked";
    public static final String REQUEST_ALL_ORGANISMS = "allOrganisms";
    public static final String REQUEST_ALL_GENOMES_BACTERIA = "allGenomesBacteria";
    public static final String REQUEST_ALL_GENOMES_PLANT = "allGenomesPlant";
    public static final String REQUEST_OPEN_BOOK = "OpenBook";
    public static final String SERVER_ERROR = "Server cannot access information, please contact Systems Administrator";
    public static String server_status;
    private static PantherServer INSTANCE;

    public static synchronized PantherServer inst() {
        if (INSTANCE == null) {
            INSTANCE = new PantherServer();
        }
        return INSTANCE;
    }

    public DataTransferObj searchGeneName(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_GENE_NAME, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj searchGeneExtId(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_GENE_EXT_ID, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj searchProteinExtId(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_PROTEIN_EXT_ID, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj searchDefinition(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_DEFINITION, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj searchBookId(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_BOOK_ID, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj searchBookPTN(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_BOOK_PTN, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj searchRequirePaintReviewUnlocked(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_REQUIRE_PAINT_REVIEW_UNLOCKED, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj searchAllBooks(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_ALL_BOOKS, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj getMyBooks(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return (DataTransferObj)this.sendAndReceiveZip(servletURL, REQUEST_MY_BOOKS, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj searchUncuratedBooks(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.doSearch(servletURL, REQUEST_SEARCH_UNCURATED_BOOKS, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj lockAndUnLockBooks(String servletURL, String actionRequest, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return (DataTransferObj)this.sendAndReceiveZip(servletURL, actionRequest, sendInfo, sessionIdName, sessionIdValue);
    }

    public DataTransferObj unlockBooks(String servletURL, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return this.lockAndUnLockBooks(servletURL, REQUEST_UNLOCK_BOOKS, sendInfo, sessionIdName, sessionIdValue);
    }

    private void fireProgressChange(String message, int percentageDone, ProgressEvent.Status status) {
    }

    private void fireProgressChange(String message, int percentageDone) {
    }

    private DataTransferObj doSearch(String servletURL, String actionRequest, Object sendInfo, String sessionIdName, String sessionIdValue) {
        return (DataTransferObj)this.sendAndReceiveZip(servletURL, actionRequest, sendInfo, sessionIdName, sessionIdValue);
    }

    public String getServerStatus() {
        return server_status;
    }

    public static void setServerStatus(String serverStatus) {
        server_status = serverStatus;
    }

    protected Object sendAndReceiveZip(String completeServletPath, Object sendInfo, String sessionIdName, String sessionIdValue) {
        String message = null;
        Object outputFromServlet = null;
        try {
            String progressMessage = "Fetching zip data";
            this.fireProgressChange(progressMessage, 0, ProgressEvent.Status.START);
            URL servlet = new URL(completeServletPath);
            URLConnection servletConnection = servlet.openConnection();
            servletConnection.setRequestProperty(SERVLET_CONNECTION_CONTENT_TYPE, SERVLET_CONNECTION_OBJECT_TYPE_JAVA);
            if (null != sessionIdName && null != sessionIdValue) {
                servletConnection.setRequestProperty(SERVLET_REQUEST_PROPERTY_COOKIE, sessionIdName + "=".concat(sessionIdValue));
            }
            servletConnection.setUseCaches(false);
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(servletConnection.getOutputStream()));
            this.fireProgressChange(progressMessage, 50);
            objectOutputStream.writeObject(sendInfo);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream servletOutput = new ObjectInputStream(new GZIPInputStream(servletConnection.getInputStream()));
            outputFromServlet = servletOutput.readObject();
            this.fireProgressChange(progressMessage, 100, ProgressEvent.Status.END);
            servletOutput.close();
            return outputFromServlet;
        }
        catch (MalformedURLException muex) {
            message = "MalformedURLException " + muex.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
            muex.printStackTrace();
        }
        catch (IOException ioex) {
            message = "IOException " + ioex.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
        }
        catch (Exception e) {
            message = "Exception " + e.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
        }
        if (message != null) {
            EventManager.inst().fireProgressEvent(new ProgressEvent(this, message, 0, ProgressEvent.Status.FAIL));
        }
        return outputFromServlet;
    }

    protected Object sendAndReceiveZip(String servletURL, String actionRequest, Object sendInfo, String sessionIdName, String sessionIdValue) {
        String message = null;
        Object outputFromServlet = null;
        try {
            String progressMessage = "Fetching zip data";
            this.fireProgressChange(progressMessage, 0, ProgressEvent.Status.START);
            URL servlet = new URL(servletURL + SERVLET_PATH + actionRequest);
            URLConnection servletConnection = servlet.openConnection();
            servletConnection.setRequestProperty(SERVLET_CONNECTION_CONTENT_TYPE, SERVLET_CONNECTION_OBJECT_TYPE_JAVA);
            if (null != sessionIdName && null != sessionIdValue) {
                servletConnection.setRequestProperty(SERVLET_REQUEST_PROPERTY_COOKIE, sessionIdName + "=".concat(sessionIdValue));
            }
            servletConnection.setUseCaches(false);
            servletConnection.setRequestProperty("Accept-Encoding", "gzip");
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(servletConnection.getOutputStream()));
            this.fireProgressChange(progressMessage, 50);
            objectOutputStream.writeObject(sendInfo);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream servletOutput = new ObjectInputStream(new GZIPInputStream(servletConnection.getInputStream()));
            System.out.println("Received object from server for action request " + actionRequest);
            System.out.println("Going to start reading the object");
            outputFromServlet = servletOutput.readObject();
            System.out.println("Finished reading the object from the server");
            this.fireProgressChange(progressMessage, 100, ProgressEvent.Status.END);
            servletOutput.close();
            return outputFromServlet;
        }
        catch (MalformedURLException muex) {
            message = "MalformedURLException " + muex.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
            muex.printStackTrace();
        }
        catch (IOException ioex) {
            message = "IOException " + ioex.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
            ioex.printStackTrace();
        }
        catch (Exception e) {
            message = "Exception " + e.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
            e.printStackTrace();
        }
        if (message != null) {
            EventManager.inst().fireProgressEvent(new ProgressEvent(this, message, 0, ProgressEvent.Status.FAIL));
        }
        return outputFromServlet;
    }

    public Object sendAndReceive(String servletURL, String actionRequest, Object sendInfo, String sessionIdName, String sessionIdValue) {
        String message = null;
        Object outputFromServlet = null;
        try {
            URL servlet = new URL(servletURL + SERVLET_PATH + actionRequest);
            URLConnection servletConnection = servlet.openConnection();
            servletConnection.setRequestProperty(SERVLET_CONNECTION_CONTENT_TYPE, "application/octet-stream");
            if (null != sessionIdName && null != sessionIdValue) {
                servletConnection.setRequestProperty(SERVLET_REQUEST_PROPERTY_COOKIE, sessionIdName + "=".concat(sessionIdValue));
            }
            servletConnection.setUseCaches(false);
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(servletConnection.getOutputStream());
            objectOutputStream.writeObject(sendInfo);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream servletOutput = new ObjectInputStream(new GZIPInputStream(servletConnection.getInputStream()));
            outputFromServlet = servletOutput.readObject();
            servletOutput.close();
        }
        catch (MalformedURLException muex) {
            message = "MalformedURLException " + muex.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
            muex.printStackTrace();
        }
        catch (IOException ioex) {
            message = "IOException " + ioex.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
        }
        catch (Exception e) {
            message = "Exception " + e.getMessage() + " has been returned while sending and receiving information from server";
            System.out.println(message);
        }
        if (message != null) {
            EventManager.inst().fireProgressEvent(new ProgressEvent(this, message, 0, ProgressEvent.Status.FAIL));
        }
        return outputFromServlet;
    }

    public DataTransferObj getFamilyComment(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, ACTION_GET_FAMILY_COMMENT, dto, null, null);
    }

    public DataTransferObj getFamilyName(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, ACTION_GET_FAMILY_NAME, dto, null, null);
    }

    public DataTransferObj getAllOrganisms(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, REQUEST_ALL_ORGANISMS, dto, null, null);
    }

    public DataTransferObj getPlantGenomes(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, REQUEST_ALL_GENOMES_PLANT, dto, null, null);
    }

    public DataTransferObj getBacterialGenomes(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, REQUEST_ALL_GENOMES_BACTERIA, dto, null, null);
    }

    public DataTransferObj getFamilyDomain(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, ACTION_GET_FAMILY_DOMAIN, dto, null, null);
    }

    public DataTransferObj getTree(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, ACTION_GET_TREE, dto, null, null);
    }

    public DataTransferObj getNodes(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        Object serverOutput = this.sendAndReceiveZip(serverPath, ACTION_GET_NODES, dto, null, null);
        if (null == serverOutput) {
            System.out.println("Nodes information from server is null");
        }
        return (DataTransferObj)serverOutput;
    }

    public DataTransferObj getMSA(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, ACTION_GET_MSA, dto, null, null);
    }

    public DataTransferObj getMsaKeyResidue(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, ACTION_GET_MSA_KEY_RESIDUE, dto, null, null);
    }

    public DataTransferObj saveBook(String serverPath, DataTransferObj dto) {
        server_status = STRING_EMPTY;
        return (DataTransferObj)this.sendAndReceiveZip(serverPath, ACTION_SAVE_BOOK, dto, null, null);
    }

    public VersionContainer getVersions(String serverPath) {
        server_status = STRING_EMPTY;
        try {
            URL servlet = new URL(serverPath + SUFFIX_PATH_VERSIONS);
            System.out.println("Getting versions from " + serverPath);
            URLConnection servletConnection = servlet.openConnection();
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            ObjectInputStream inputFromServlet = new ObjectInputStream(new GZIPInputStream(servletConnection.getInputStream()));
            DataTransferObj dto = (DataTransferObj)inputFromServlet.readObject();
            inputFromServlet.close();
            return dto.getVc();
        }
        catch (MalformedURLException muex) {
            muex.printStackTrace();
            PantherServer.setServerStatus(muex.getLocalizedMessage());
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            PantherServer.setServerStatus(ioex.getLocalizedMessage());
        }
        catch (ClassNotFoundException cnfex) {
            cnfex.printStackTrace();
            PantherServer.setServerStatus(cnfex.getLocalizedMessage());
        }
        return null;
    }

    public VersionInfo getVersionInfo(String serverPath) {
        VersionInfo vi = null;
        server_status = STRING_EMPTY;
        try {
            URL servlet = new URL(serverPath + "/servlet/edu.usc.ksom.pm.panther.paintServer.servlet.DataServlet?action=versionInfo");
            System.out.println("Getting version info  from " + serverPath);
            URLConnection servletConnection = servlet.openConnection();
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            ObjectInputStream inputFromServlet = new ObjectInputStream(new GZIPInputStream(servletConnection.getInputStream()));
            vi = (VersionInfo)inputFromServlet.readObject();
            inputFromServlet.close();
        }
        catch (MalformedURLException muex) {
            muex.printStackTrace();
            PantherServer.setServerStatus(muex.getLocalizedMessage());
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            PantherServer.setServerStatus(ioex.getLocalizedMessage());
        }
        catch (ClassNotFoundException cnfex) {
            cnfex.printStackTrace();
            PantherServer.setServerStatus(cnfex.getLocalizedMessage());
        }
        return vi;
    }

    public GOTermHelper getGOTermHelper(String serverPath) {
        GOTermHelper goTermHelper = null;
        try {
            URL servlet = new URL(serverPath + "/servlet/edu.usc.ksom.pm.panther.paintServer.servlet.DataServlet?action=goHierarchy");
            System.out.println("Connecting to " + serverPath);
            URLConnection servletConnection = servlet.openConnection();
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            ObjectInputStream inputFromServlet = new ObjectInputStream(new GZIPInputStream(servletConnection.getInputStream()));
            goTermHelper = (GOTermHelper)inputFromServlet.readObject();
            inputFromServlet.close();
        }
        catch (MalformedURLException muex) {
            PantherServer.setServerStatus(muex.getLocalizedMessage());
        }
        catch (IOException ioex) {
            PantherServer.setServerStatus(ioex.getLocalizedMessage());
        }
        catch (ClassNotFoundException cnfex) {
            PantherServer.setServerStatus(cnfex.getLocalizedMessage());
        }
        return goTermHelper;
    }

    public DataTransferObj getCuratableBooks(String serverPath, DataTransferObj dto) {
        return (DataTransferObj)this.sendAndReceiveZip(serverPath + "/servlet/edu.usc.ksom.pm.panther.paintServer.servlet.DataServlet?action=booksWithExpEvdnce", dto, null, null);
    }

    public TaxonomyHelper getTaxonomyHelper(String serverPath) {
        TaxonomyHelper taxonHelper = null;
        try {
            URL servlet = new URL(serverPath + "/servlet/edu.usc.ksom.pm.panther.paintServer.servlet.DataServlet?action=taxonomyConstraints");
            System.out.println("Connecting to " + serverPath + " Get taxonomy constraints information");
            URLConnection servletConnection = servlet.openConnection();
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            ObjectInputStream inputFromServlet = new ObjectInputStream(new GZIPInputStream(servletConnection.getInputStream()));
            taxonHelper = (TaxonomyHelper)inputFromServlet.readObject();
            inputFromServlet.close();
        }
        catch (MalformedURLException muex) {
            PantherServer.setServerStatus(muex.getLocalizedMessage());
            muex.printStackTrace();
            taxonHelper = null;
        }
        catch (IOException ioex) {
            PantherServer.setServerStatus(ioex.getLocalizedMessage());
            ioex.printStackTrace();
            taxonHelper = null;
        }
        catch (ClassNotFoundException cnfex) {
            PantherServer.setServerStatus(cnfex.getLocalizedMessage());
            cnfex.printStackTrace();
            taxonHelper = null;
        }
        return taxonHelper;
    }

    public FixedInfo getFixedInfoFromServer(String serverPath) {
        Vector objs = null;
        server_status = STRING_EMPTY;
        try {
            URL servlet = new URL(serverPath + "/servlet/com.sri.panther.paintServer.servlet.Client2Servlet?action=FixedInfo");
            URLConnection servletConnection = servlet.openConnection();
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            ObjectInputStream inputFromServlet = new ObjectInputStream(new GZIPInputStream(servletConnection.getInputStream()));
            objs = (Vector)inputFromServlet.readObject();
            inputFromServlet.close();
        }
        catch (MalformedURLException muex) {
            PantherServer.setServerStatus(muex.getLocalizedMessage());
        }
        catch (IOException ioex) {
            PantherServer.setServerStatus(ioex.getLocalizedMessage());
        }
        catch (ClassNotFoundException cnfex) {
            PantherServer.setServerStatus(cnfex.getLocalizedMessage());
        }
        if (null != objs) {
            TransferInfo ti = (TransferInfo)objs.elementAt(0);
            if (0 != ti.getInfo().length()) {
                PantherServer.setServerStatus("Server cannot access information for transfer: " + ti.getInfo());
                return null;
            }
            return (FixedInfo)objs.elementAt(1);
        }
        return null;
    }

    public User getUserInfo(String serverPath, Vector userInfo) {
        Vector userInfoList = (Vector)this.sendAndReceiveZip(serverPath, "userInfo", userInfo, null, null);
        if (null == userInfoList || 0 == userInfoList.size()) {
            System.out.println("Server sent null or empty user information");
            return null;
        }
        return (User)userInfoList.get(0);
    }

    static {
        INSTANCE = null;
    }
}

