/*
 * Decompiled with CFR 0.152.
 */
package org.paint.datamodel;

import edu.usc.ksom.pm.panther.paintCommon.Comment;
import edu.usc.ksom.pm.panther.paintCommon.DataTransferObj;
import edu.usc.ksom.pm.panther.paintCommon.Domain;
import edu.usc.ksom.pm.panther.paintCommon.KeyResidue;
import edu.usc.ksom.pm.panther.paintCommon.MSA;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.SaveBookInfo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;
import org.bbop.framework.GUIManager;
import org.paint.config.Preferences;
import org.paint.dataadapter.PantherAdapter;
import org.paint.dataadapter.PantherServer;
import org.paint.main.PaintManager;

public class Family
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] treeStrings;
    private String[] msa_content;
    private String[] wts_content;
    private ArrayList<KeyResidue> keyResidueList;
    HashMap<String, HashMap<String, ArrayList<Domain>>> nodeToDomainLookup;
    private HashMap<String, Node> nodeLookup;
    private StringBuffer nodeInfoBuf;
    private String familyID;
    private String name;
    private Comment familyComment;
    public static final String MSG_ERROR = "Error";
    public static final String MSG_ERROR_CANNOT_ACCESS_INFORMATION_FROM_SERVER = "Error cannot access information from server";
    public static final String MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_COMMENT = "Unable to retrieve comment information from server";
    public static final String MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_FAMILY_NAME = "Unable to retrieve family name from server";
    public static final String MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_FAMILY_DOMAIN = "Unable to retrieve family domain info from server";
    public static final String MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_TREE = "Unable to retrieve tree info from server";
    public static final String MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_MSA = "Unable to retrieve MSA info from server";
    public static final String MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_NODE_INFO = "Unable to retrieve node info from server";
    public static final String MSG_ERROR_CANNOT_SAVE_BOOK = "Unable to save information";
    public static final String MSG_ERROR_NODE_INFO_FAILS_CONSISTENCY_CHECKS = "Node information fails consistency checks";

    public boolean loadFamily(String familyID) {
        PantherAdapter adapter = new PantherAdapter(familyID);
        ExecutorService executor = Executors.newFixedThreadPool(6);
        LoadTreeNodes nodesWorker = new LoadTreeNodes(familyID);
        executor.execute(nodesWorker);
        LoadFamilyName familyNameWorker = new LoadFamilyName(familyID);
        executor.execute(familyNameWorker);
        LoadFamilyComment familyCommentWorker = new LoadFamilyComment(familyID);
        executor.execute(familyCommentWorker);
        LoadTreeStrings treeStringsWorker = new LoadTreeStrings(familyID);
        executor.execute(treeStringsWorker);
        LoadMSAKeyResidue msaKeyResidueWorker = new LoadMSAKeyResidue(familyID);
        executor.execute(msaKeyResidueWorker);
        LoadFamilyDomain familyDomainWorker = new LoadFamilyDomain(familyID);
        executor.execute(familyDomainWorker);
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.treeStrings = treeStringsWorker.treeStrings;
        if (null == this.treeStrings) {
            this.familyID = null;
        }
        this.nodeLookup = nodesWorker.nodeLookup;
        this.nodeInfoBuf = nodesWorker.errorBuf;
        if (null == this.nodeLookup) {
            this.familyID = null;
        }
        this.name = familyNameWorker.familyName;
        MSA msa = msaKeyResidueWorker.msa;
        if (null != msa) {
            this.msa_content = msa.getMsaContents();
            this.wts_content = msa.getWeightsContents();
            this.keyResidueList = msa.getKeyResidueList();
        }
        this.familyComment = familyCommentWorker.familyComment;
        this.familyID = familyID;
        this.nodeToDomainLookup = familyDomainWorker.nodeToDomainLookup;
        System.gc();
        return this.isLoaded();
    }

    public HashMap<String, HashMap<String, ArrayList<Domain>>> getNodeToDomainLookup() {
        return this.nodeToDomainLookup;
    }

    public ArrayList<KeyResidue> getKeyResidueList() {
        return this.keyResidueList;
    }

    public boolean isLoaded() {
        return this.familyID != null;
    }

    public String[] getMSAcontent() {
        return this.msa_content;
    }

    public void setMSAcontent(String[] msa_content) {
        this.msa_content = msa_content;
    }

    public String[] getWtsContent() {
        return this.wts_content;
    }

    public void setWtsContent(String[] wts_content) {
        this.wts_content = wts_content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Comment getFamilyComment() {
        return this.familyComment;
    }

    public void setFamilyComment(Comment familyComment) {
        this.familyComment = familyComment;
    }

    public String getFamilyID() {
        return this.familyID;
    }

    public String[] getTreeStrings() {
        return this.treeStrings;
    }

    public HashMap<String, Node> getNodeLookup() {
        return this.nodeLookup;
    }

    public StringBuffer getNodeInfoBuf() {
        return this.nodeInfoBuf;
    }

    public String saveBookToDatabase(SaveBookInfo sbi) {
        StringBuffer sb;
        SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss:SSS");
        System.out.println("Start of save execution " + df.format(new Date(System.currentTimeMillis())));
        DataTransferObj dto = new DataTransferObj();
        dto.setVc(PaintManager.inst().getVersionContainer());
        dto.setObj((Object)sbi);
        DataTransferObj serverOutput = PantherServer.inst().saveBook(Preferences.inst().getPantherURL(), dto);
        if (null == serverOutput) {
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_COMMENT, MSG_ERROR, 0);
        }
        if (null != (sb = serverOutput.getMsg()) && 0 != sb.length()) {
            JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), sb.toString(), MSG_ERROR, 0);
        }
        String saveInfo = (String)serverOutput.getObj();
        System.out.println("End of save execution " + df.format(new Date(System.currentTimeMillis())));
        return saveInfo;
    }

    public class LoadTreeNodes
    implements Runnable {
        private final String familyId;
        public HashMap<String, Node> nodeLookup = null;
        public StringBuffer errorBuf = null;

        LoadTreeNodes(String familyId) {
            this.familyId = familyId;
        }

        @Override
        public void run() {
            StringBuffer sb;
            SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss:SSS");
            System.out.println("Start of get nodes execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
            DataTransferObj serverInput = new DataTransferObj();
            serverInput.setVc(PaintManager.inst().getVersionContainer());
            serverInput.setObj((Object)this.familyId);
            DataTransferObj serverOutput = PantherServer.inst().getNodes(Preferences.inst().getPantherURL(), serverInput);
            if (null == serverOutput) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), Family.MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_NODE_INFO, Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            if (null != (sb = serverOutput.getMsg()) && 0 != sb.length()) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), sb.toString(), Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            Vector outputInfo = (Vector)serverOutput.getObj();
            this.nodeLookup = (HashMap)outputInfo.get(0);
            this.errorBuf = (StringBuffer)outputInfo.get(1);
            if (null == outputInfo || 2 > outputInfo.size()) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), Family.MSG_ERROR_NODE_INFO_FAILS_CONSISTENCY_CHECKS, Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            System.out.println("End of get nodes info for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
        }
    }

    public class LoadMSAKeyResidue
    implements Runnable {
        private final String familyId;
        public MSA msa = null;

        LoadMSAKeyResidue(String familyId) {
            this.familyId = familyId;
        }

        @Override
        public void run() {
            SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss:SSS");
            System.out.println("Start of get msa  execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(PaintManager.inst().getVersionContainer());
            dto.setObj((Object)this.familyId);
            DataTransferObj serverOutput = PantherServer.inst().getMsaKeyResidue(Preferences.inst().getPantherURL(), dto);
            if (null == serverOutput) {
                System.out.println(Family.MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_MSA);
            } else {
                StringBuffer sb = serverOutput.getMsg();
                if (null != sb && 0 != sb.length()) {
                    System.out.println("Error loading MSA and keyResidue with message: " + sb.toString());
                } else {
                    this.msa = (MSA)serverOutput.getObj();
                    System.out.println("End of get msa and Key Residue execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
                }
            }
        }
    }

    public class LoadTreeStrings
    implements Runnable {
        private final String familyId;
        public String[] treeStrings = null;

        LoadTreeStrings(String familyId) {
            this.familyId = familyId;
        }

        @Override
        public void run() {
            StringBuffer sb;
            SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss:SSS");
            System.out.println("Start of get tree  execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(PaintManager.inst().getVersionContainer());
            dto.setObj((Object)this.familyId);
            DataTransferObj serverOutput = PantherServer.inst().getTree(Preferences.inst().getPantherURL(), dto);
            if (null == serverOutput) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), Family.MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_TREE, Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            if (null != (sb = serverOutput.getMsg()) && 0 != sb.length()) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), sb.toString(), Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            this.treeStrings = (String[])serverOutput.getObj();
            System.out.println("End of get tree  execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
        }
    }

    public class LoadFamilyDomain
    implements Runnable {
        private final String familyId;
        public HashMap<String, HashMap<String, ArrayList<Domain>>> nodeToDomainLookup;

        LoadFamilyDomain(String familyId) {
            this.familyId = familyId;
        }

        @Override
        public void run() {
            SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss:SSS");
            System.out.println("Start of get family domain  execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(PaintManager.inst().getVersionContainer());
            dto.setObj((Object)this.familyId);
            DataTransferObj serverOutput = PantherServer.inst().getFamilyDomain(Preferences.inst().getPantherURL(), dto);
            if (null == serverOutput) {
                System.out.println(Family.MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_FAMILY_DOMAIN);
            } else {
                StringBuffer sb = serverOutput.getMsg();
                if (null != sb && 0 != sb.length()) {
                    JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), sb.toString(), Family.MSG_ERROR, 0);
                    System.exit(-1);
                }
                this.nodeToDomainLookup = (HashMap)serverOutput.getObj();
                System.out.println("End of get family domain execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
            }
        }
    }

    public class LoadFamilyName
    implements Runnable {
        private final String familyId;
        public String familyName = null;

        LoadFamilyName(String familyId) {
            this.familyId = familyId;
        }

        @Override
        public void run() {
            StringBuffer sb;
            SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss:SSS");
            System.out.println("Start of get family name  execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(PaintManager.inst().getVersionContainer());
            dto.setObj((Object)this.familyId);
            DataTransferObj serverOutput = PantherServer.inst().getFamilyName(Preferences.inst().getPantherURL(), dto);
            if (null == serverOutput) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), Family.MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_FAMILY_NAME, Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            if (null != (sb = serverOutput.getMsg()) && 0 != sb.length()) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), sb.toString(), Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            this.familyName = (String)serverOutput.getObj();
            System.out.println("End of get family name execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
        }
    }

    public class LoadFamilyComment
    implements Runnable {
        private final String familyId;
        public Comment familyComment = null;

        LoadFamilyComment(String familyId) {
            this.familyId = familyId;
        }

        @Override
        public void run() {
            StringBuffer sb;
            SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss:SSS");
            System.out.println("Start of get comment execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(PaintManager.inst().getVersionContainer());
            dto.setObj((Object)this.familyId);
            DataTransferObj serverOutput = PantherServer.inst().getFamilyComment(Preferences.inst().getPantherURL(), dto);
            if (null == serverOutput) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), Family.MSG_ERROR_CANNOT_ACCESS_VERSION_INFO_COMMENT, Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            if (null != (sb = serverOutput.getMsg()) && 0 != sb.length()) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), sb.toString(), Family.MSG_ERROR, 0);
                System.exit(-1);
            }
            this.familyComment = (Comment)serverOutput.getObj();
            System.out.println("End of get comment execution for " + this.familyId + " at " + df.format(new Date(System.currentTimeMillis())));
        }
    }
}

