/*
 * Decompiled with CFR 0.152.
 */
package org.paint.datamodel;

import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.Domain;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.KeyResidue;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeStaticInfo;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.swing.HyperlinkLabel;
import org.paint.config.Preferences;
import org.paint.go.GO_Util;
import org.paint.gui.event.TermHyperlinkListener;
import org.paint.gui.familytree.TreeModel;
import org.paint.gui.table.OrthoCell;
import org.paint.main.PaintManager;
import org.paint.util.AnnotationUtil;
import org.paint.util.DuplicationColor;
import org.paint.util.HTMLUtil;
import org.paint.util.HorizontalTransferColor;
import org.paint.util.RenderUtil;
import org.paint.util.SpeciesClsColor;

public class GeneNode {
    private static final long serialVersionUID = 1L;
    public static final int nodeToTextDist = 10;
    private static final int TextToLineDist = 5;
    public static final int GLYPH_DIAMETER = 8;
    public static final int GLYPH_RADIUS = 4;
    private static final BasicStroke dashed = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private static final String NODE_TYPE_DUPLICATION = "1>0";
    private static final String NODE_TYPE_HORIZONTAL_TRANSFER = "0>0";
    private static final String STR_UNDERSCORE = "_";
    private GeneNode parent = null;
    private List<GeneNode> children;
    private List<GeneNode> originalChildrenOrder;
    private String seq_db = "";
    private String seq_id = "";
    private String seq_name;
    private String db;
    private String db_id = "";
    private String paint_id = "";
    private String persistantNodeID;
    private String species;
    private List<String> species_labels;
    private String species_shortname;
    private String sequence;
    private HashMap<String, ArrayList<Domain>> domainLookup;
    private ArrayList<ArrayList<Domain>> domainRows;
    private ArrayList<KeyResidue> keyResidueList;
    private String nodeType;
    private String nodeNote;
    private String description;
    private String geneId;
    private String geneSource;
    private String proteinId;
    private String proteinSource;
    private String ortho_mcl;
    private float distanceFromParent;
    private float distanceFromRoot;
    private boolean is_leaf = true;
    private boolean is_subfamily;
    private boolean is_expanded;
    private boolean selected;
    private boolean visible;
    private Rectangle screenRectangle;
    private Point screenPosition;
    private static Logger log = Logger.getLogger(GeneNode.class);
    private String subFamilyName;
    private Color subFamilyColor = Color.black;
    private int depthInTree;
    private int dupColorIndex;
    private int horizontalColorIndex;
    private String speciesClassification;
    private double sequenceWt = 0.0;
    private String hmm_seq;
    private HyperlinkLabel accLabel;
    private HyperlinkLabel modLabel;
    private OrthoCell ortho_cell;
    private HyperlinkLabel permaID;
    private Thread thread;
    private long startTime;
    private int bpCount;
    private int ccCount;
    private int mfCount;
    private Node node;
    private Hashtable<String, String> attrLookup = new Hashtable();
    private Color dropColor;
    static final BasicStroke wideStroke = new BasicStroke(8.0f);

    public GeneNode(boolean isExpanded) {
        this.is_expanded = isExpanded;
        this.visible = true;
        this.ortho_mcl = "";
    }

    public String getSeqName() {
        return this.seq_name;
    }

    public void setSeqName(String node_name) {
        if (node_name != null && node_name.length() > 0) {
            String[] name = node_name.split(",");
            this.seq_name = name[0];
        }
    }

    public String getSeqId() {
        return this.seq_id;
    }

    public void setSeqId(String seqdb, String acc) {
        if (acc != null && acc.length() > 0 && seqdb != null && seqdb.length() > 0) {
            this.seq_db = seqdb;
            if (this.seq_id != null && this.seq_id.length() > 0 && !this.seq_id.equals(acc)) {
                log.debug((Object)("Changing seq_id from " + this.seq_id + " to " + acc));
            }
            this.seq_id = acc;
        }
    }

    public void setDatabaseID(String name, String id) {
        if (name != null && name.length() > 0 && id != null && id.length() > 0) {
            this.db = GO_Util.inst().dbNameHack(name);
            this.db_id = id;
        }
    }

    public String getDatabase() {
        return this.db == null ? "" : this.db;
    }

    public String getDatabaseID() {
        return this.db_id == null ? "" : this.db_id;
    }

    public void setDepthInTree(int depth) {
        this.depthInTree = depth;
    }

    public int getDepthInTree() {
        return this.depthInTree;
    }

    private void connectToParent(GeneNode currentRoot, Graphics g) {
        GeneNode parent = this.getParent();
        if (null != parent && currentRoot != this) {
            Point parentPos = new Point(parent.getScreenPosition());
            Point currentPos = new Point(this.getScreenPosition());
            g.setColor(RenderUtil.getLineColor(this));
            parentPos.x += 4;
            if (parentPos.y < currentPos.y) {
                parentPos.y += Math.min(4, currentPos.y - parentPos.y);
            } else if (parentPos.y > currentPos.y) {
                parentPos.y -= Math.min(4, parentPos.y - currentPos.y);
            }
            if (parentPos.y != currentPos.y) {
                g.drawLine(parentPos.x, parentPos.y, parentPos.x, currentPos.y);
            }
            g.drawLine(parentPos.x, currentPos.y, currentPos.x, currentPos.y);
            boolean containsDirectNot = AnnotationUtil.hasDirectNot(this, PaintManager.inst().goTermHelper());
            if (containsDirectNot) {
                int distance = currentPos.x - parentPos.x;
                int spacing = distance / 2;
                int x = parentPos.x + spacing;
                int top = currentPos.y - 4;
                g.setColor(Color.red);
                g.fillRect(x, top, 3, 9);
            }
        }
    }

    public void drawMarker(GeneNode currentRoot, Graphics g, boolean triangle, Rectangle viewport) {
        int[] yCoords;
        int[] xCoords;
        if (!this.nodeAndParentFallInViewport(viewport)) {
            return;
        }
        Rectangle r = new Rectangle(this.getScreenRectangle());
        Point p = new Point(this.getScreenPosition());
        Preferences user_settings = Preferences.inst();
        Color fillColor = this.dropColor != null ? this.dropColor : RenderUtil.annotationStatusColor(this, user_settings.getForegroundColor());
        Color drawColor = user_settings.getForegroundColor();
        this.connectToParent(currentRoot, g);
        if (this.isSubfamily()) {
            xCoords = new int[]{p.x, p.x + 4, p.x + 8, p.x + 4};
            yCoords = new int[]{p.y, p.y - 4, p.y, p.y + 4};
            g.setColor(fillColor);
            g.fillPolygon(xCoords, yCoords, 4);
            g.setColor(drawColor);
            g.drawPolygon(xCoords, yCoords, 4);
        } else if (!this.isLeaf()) {
            if (triangle) {
                xCoords = new int[]{p.x, p.x, p.x + 8};
                yCoords = new int[]{p.y - 4, p.y + 4, p.y};
                g.setColor(fillColor);
                g.fillPolygon(xCoords, yCoords, 3);
                g.setColor(drawColor);
                g.drawPolygon(xCoords, yCoords, 3);
            } else if (this.isExpanded() && !this.isPruned()) {
                if (this.isDuplication()) {
                    g.setColor(fillColor);
                    g.fillRect(p.x, p.y - 4, 8, 8);
                    g.setColor(drawColor);
                    g.drawRect(p.x, p.y - 4, 8, 8);
                } else if (this.isHorizontalTransfer()) {
                    xCoords = new int[]{--p.x, p.x + 4 + 1, p.x + 8 + 2, p.x + 4 + 1};
                    yCoords = new int[]{p.y, p.y - 4 - 1, p.y, p.y + 4 + 1};
                    g.setColor(Color.WHITE);
                    g.fillPolygon(xCoords, yCoords, 4);
                    g.setColor(drawColor);
                    g.drawPolygon(xCoords, yCoords, 4);
                } else {
                    g.setColor(fillColor);
                    g.fillOval(p.x, p.y - 4, 8, 8);
                    g.setColor(drawColor);
                    g.drawOval(p.x, p.y - 4, 8, 8);
                }
            } else if (this.isPruned()) {
                g.setColor(Color.gray.brighter());
                g.fillRect(p.x, p.y - 4, 8, 8);
                g.setColor(drawColor);
                g.drawRect(p.x, p.y - 4, 8, 8);
                g.drawLine(p.x, p.y - 4, p.x + 8, p.y + 4);
                g.drawLine(p.x, p.y + 4, p.x + 8, p.y - 4);
            } else {
                g.setColor(fillColor);
                g.fillRect(p.x, p.y - 4, 4, 8);
                g.setColor(drawColor);
                g.drawRect(p.x, p.y - 4, 4, 8);
            }
        }
        if (this.isTerminus()) {
            Color labelColor;
            int x = p.x + 10;
            Font f = RenderUtil.getNodeFont(this);
            g.setFont(f);
            Object s = this.getNodeLabel();
            if (this.isPruned()) {
                s = "XXX-" + (String)s;
                g.setColor(Preferences.inst().getBackgroundColor());
            } else {
                TreeModel.TreeColorSchema tcs = PaintManager.inst().getTree().getTreeModel().getTreeColorSchema();
                if (TreeModel.TreeColorSchema.DUPLICATION == tcs) {
                    g.setColor(DuplicationColor.inst().getDupColor(this.getDupColorIndex()));
                } else if (TreeModel.TreeColorSchema.SPECIES_CLS == tcs) {
                    g.setColor(SpeciesClsColor.getInst().getColorForSpecies(this.speciesClassification));
                } else {
                    g.setColor(HorizontalTransferColor.getInstance().getHorizontalTransferColor(this.getHorizontalColorIndex()));
                }
            }
            g.fillRect(x, p.y - 4, viewport.width, 16);
            AttributedString as = new AttributedString((String)s);
            if (null != s && 0 != ((String)s).length()) {
                as.addAttribute(TextAttribute.FONT, f);
            }
            if ((labelColor = RenderUtil.annotationStatusColor(this, user_settings.getBackgroundColor())).equals(user_settings.getBackgroundColor())) {
                labelColor = Color.BLACK;
            }
            g.setColor(labelColor);
            if (null != s) {
                int text_x = p.x + 10;
                int text_y = p.y + r.height / 2;
                g.drawString(as.getIterator(), text_x, text_y);
                FontMetrics fm = g.getFontMetrics(f);
                int text_width = fm.stringWidth((String)s);
                x += text_width;
            } else {
                log.debug((Object)("Why is label null for " + this.toString()));
            }
            x += 5;
            g.setColor(drawColor);
            if (!(g instanceof Graphics2D)) {
                g.drawLine(x, p.y, viewport.width, p.y);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                Stroke oldStroke = g2.getStroke();
                g2.setStroke(dashed);
                g2.drawLine(x, p.y, viewport.x + viewport.width, p.y);
                g2.setStroke(oldStroke);
            }
        }
    }

    public boolean isPruned() {
        NodeVariableInfo nvi = this.node.getVariableInfo();
        if (null != nvi) {
            return nvi.isPruned();
        }
        return false;
    }

    public void setPrune(boolean prune) {
        NodeVariableInfo nvi = this.node.getVariableInfo();
        if (null == nvi) {
            nvi = new NodeVariableInfo();
            this.node.setVariableInfo(nvi);
        }
        nvi.setPruned(prune);
    }

    private boolean nodeAndParentFallInViewport(Rectangle viewport) {
        GeneNode parent = this.parent;
        if (parent == null) {
            return true;
        }
        Rectangle parentRect = parent.getScreenRectangle();
        if (this.screenRectangle != null) {
            return (this.screenRectangle.y >= viewport.y || this.screenRectangle.y + this.screenRectangle.height >= viewport.y || parentRect.y >= viewport.y || parentRect.y + parentRect.height >= viewport.y) && (viewport.y + viewport.height >= this.screenRectangle.y || viewport.y + viewport.height >= parentRect.y);
        }
        return false;
    }

    public String getNodeLabel() {
        Object s = null;
        if (this.isLeaf()) {
            NodeStaticInfo nsi = this.node.getStaticInfo();
            ArrayList geneSymbols = nsi.getGeneSymbol();
            if (null != geneSymbols && 0 < geneSymbols.size()) {
                s = (String)geneSymbols.get(0);
            } else {
                String longGeneName = nsi.getLongGeneName();
                if (null != longGeneName) {
                    s = this.getGeneId();
                }
            }
            String sp = this.takeFive();
            if (sp.length() <= 5 && sp.length() > 0) {
                s = this.takeFive() + STR_UNDERSCORE + (String)s;
            }
        } else {
            s = this.getSpeciesLabel().length() > 0 ? this.getSpeciesLabel() + STR_UNDERSCORE : "";
        }
        if (null == s) {
            s = this.getDatabaseID();
        }
        return s;
    }

    public String getNodeLabelWithPTN() {
        Object s = null;
        NodeStaticInfo nsi = this.node.getStaticInfo();
        if (this.isLeaf()) {
            ArrayList geneSymbols = nsi.getGeneSymbol();
            if (null != geneSymbols && 0 < geneSymbols.size()) {
                s = (String)geneSymbols.get(0);
            } else {
                String longGeneName = nsi.getLongGeneName();
                if (null != longGeneName) {
                    s = this.getGeneId();
                }
            }
            String sp = this.takeFive();
            if (sp.length() <= 5 && sp.length() > 0) {
                s = this.takeFive() + STR_UNDERSCORE + (String)s;
            }
        } else {
            s = this.getSpeciesLabel().length() > 0 ? this.getSpeciesLabel() + STR_UNDERSCORE : "";
        }
        if (null == s) {
            s = this.getDatabaseID();
        }
        if (((String)s).isEmpty() || ((String)s).endsWith(STR_UNDERSCORE)) {
            return (String)s + nsi.getPublicId();
        }
        return (String)s + STR_UNDERSCORE + nsi.getPublicId();
    }

    public void setNodeArea(double x, double y, double w, double h) {
        int x_spot = (int)Math.round(x);
        int y_spot = (int)Math.round(y);
        int width = (int)Math.round(w);
        int height = (int)Math.round(h);
        Point p = new Point(x_spot, y_spot);
        this.setScreenPosition(p);
        this.screenRectangle = new Rectangle(x_spot, y_spot, height, width);
    }

    public String getSpeciesLabel() {
        String species = null;
        if (species == null && this.species_labels != null) {
            species = this.species_labels.get(this.species_labels.size() - 1);
        }
        return species == null ? "" : species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getSpecies() {
        if (null != this.species && TreeModel.SPECIES_CLASSIFICATION.contains(this.species.toUpperCase())) {
            System.out.println("HERE - Found " + this.species);
        }
        return this.species;
    }

    public String getCalculatedSpecies() {
        if (null != this.species) {
            return this.species;
        }
        if (null != this.parent) {
            return this.parent.getCalculatedSpecies();
        }
        return null;
    }

    public List<String> getSpeciesList() {
        return this.species_labels;
    }

    public void addSpeciesLabel(String species) {
        species.trim();
        if (species != null && species.length() > 0) {
            if (TreeModel.SPECIES_CLASSIFICATION.contains(species.toUpperCase())) {
                System.out.println("HERE - Found " + species);
            }
            if (this.species_labels == null) {
                this.species_labels = new ArrayList<String>();
            }
            boolean duplicate = false;
            for (String label : this.species_labels) {
                duplicate |= species.equals(label);
            }
            if (!duplicate) {
                this.species_labels.add(species);
            }
            if (this.species_labels.size() > 1) {
                System.out.println("Multiple species labels for a node");
            }
            if (species.length() <= 5) {
                this.species_shortname = species;
            }
        }
    }

    private String takeFive() {
        return this.species_shortname != null ? this.species_shortname : "";
    }

    public Color getSubFamilyColor() {
        return this.subFamilyColor;
    }

    public void setSubFamilyColor(Color subFamilyColor) {
        this.subFamilyColor = subFamilyColor;
    }

    public Rectangle getScreenRectangle() {
        if (this.screenRectangle == null) {
            log.debug((Object)(this + " has not had its screen rectangle set!"));
        }
        return this.screenRectangle;
    }

    private void setScreenPosition(Point position) {
        this.screenPosition = position;
    }

    private Point getScreenPosition() {
        return this.screenPosition;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public void setSequenceWt(double sequenceWt) {
        this.sequenceWt = sequenceWt;
    }

    public double getSequenceWt() {
        return this.sequenceWt;
    }

    public void setDomainLookup(HashMap<String, ArrayList<Domain>> domainLookup) {
        this.domainLookup = domainLookup;
    }

    public HashMap<String, ArrayList<Domain>> getDomainLookup() {
        return this.domainLookup;
    }

    public ArrayList<ArrayList<Domain>> getDomainRows() {
        return this.domainRows;
    }

    public void setDomainRows(ArrayList<ArrayList<Domain>> domainRows) {
        this.domainRows = domainRows;
    }

    public ArrayList<KeyResidue> getKeyResidueList() {
        return this.keyResidueList;
    }

    public void setKeyResidueList(ArrayList<KeyResidue> keyResidueList) {
        this.keyResidueList = keyResidueList;
    }

    public HyperlinkLabel getAccLabel() {
        if (this.accLabel == null) {
            this.accLabel = HTMLUtil.makeHyperlinkField(new TermHyperlinkListener());
            HTMLUtil.setHyperlinkField(this, this.accLabel, "Accession");
        }
        return this.accLabel;
    }

    public HyperlinkLabel getModLabel() {
        if (this.modLabel == null) {
            this.modLabel = HTMLUtil.makeHyperlinkField(new TermHyperlinkListener());
            HTMLUtil.setHyperlinkField(this, this.modLabel, this.getDatabase());
        }
        return this.modLabel;
    }

    public HyperlinkLabel getPermaCell() {
        if (this.permaID == null) {
            this.permaID = HTMLUtil.makeHyperlinkField(new TermHyperlinkListener());
            HTMLUtil.setHyperlinkField(this, this.permaID, "Permanent Tree ID");
        }
        return this.permaID;
    }

    public OrthoCell getOrthoCell() {
        if (this.ortho_cell == null) {
            Color color = this.ortho_mcl.equals("") ? Preferences.inst().getBackgroundColor() : RenderUtil.getOrthoColor(this.ortho_mcl);
            this.ortho_cell = new OrthoCell(color, this.ortho_mcl);
        }
        return this.ortho_cell;
    }

    public OrthoCell getOrthoCell(String heading) {
        if (this.ortho_cell == null) {
            String value = this.getAttrLookup(heading);
            if (null == value) {
                value = "";
            }
            Color color = value.equals("") ? Preferences.inst().getBackgroundColor() : RenderUtil.getOrthoColor(value);
            this.ortho_cell = new OrthoCell(color, this.ortho_mcl);
        }
        return this.ortho_cell;
    }

    public void setOrthoMCL(String ortho_mcl) {
        this.ortho_mcl = ortho_mcl;
    }

    public String getOrthoMCL() {
        return this.ortho_mcl;
    }

    public String getDescription() {
        if (!this.isLeaf() && this.description == null) {
            StringBuffer about_me = new StringBuffer();
            this.myChildren(this, about_me);
            this.description = about_me.toString();
        }
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private void myChildren(GeneNode node, StringBuffer about_me) {
        List<GeneNode> nodes_children = node.getChildren();
        for (GeneNode child : nodes_children) {
            if (child.isLeaf()) {
                about_me.append(child.getDatabaseID() + " ");
                continue;
            }
            this.myChildren(child, about_me);
        }
    }

    public void setAttrLookup(String type, String value) {
        if (null != type && null != value) {
            this.attrLookup.put(type, value);
        }
    }

    public String getAttrLookup(String type) {
        return this.attrLookup.get(type);
    }

    public String getSeqDB() {
        return this.seq_db;
    }

    public void setParent(GeneNode parent) {
        this.parent = parent;
    }

    public GeneNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.is_leaf;
    }

    public void setSubFamilyName(String name) {
        this.subFamilyName = name;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public void setIsSubfamily(boolean subfamily) {
        this.is_subfamily = subfamily;
    }

    public boolean isSubfamily() {
        return this.is_subfamily;
    }

    public boolean isTerminus() {
        return this.is_leaf || !this.is_leaf && !this.is_expanded;
    }

    public void setType(String s) {
        this.nodeType = s;
    }

    public String getType() {
        return this.nodeType;
    }

    public void setNodeNote(String note) {
        this.nodeNote = note;
    }

    public String getNodeNote() {
        return this.nodeNote;
    }

    public void setExpanded(boolean expanded) {
        this.is_expanded = expanded;
    }

    public boolean isExpanded() {
        return this.is_expanded;
    }

    public boolean initChildren(List<GeneNode> children) {
        if (null == children) {
            this.children = children;
            this.is_leaf = true;
            return true;
        }
        if (children.isEmpty()) {
            return false;
        }
        this.children = children;
        this.is_leaf = false;
        return true;
    }

    public List<GeneNode> getOriginalChildrenOrder() {
        if (null == this.originalChildrenOrder) {
            return null;
        }
        ArrayList<GeneNode> copy = new ArrayList<GeneNode>(this.originalChildrenOrder.size());
        copy.addAll(this.originalChildrenOrder);
        return copy;
    }

    public boolean setChildren(List<GeneNode> children) {
        if (null == this.originalChildrenOrder && this.initChildren(children)) {
            this.setOriginalChildrenToCurrentChildren();
            return true;
        }
        boolean returnVal = this.initChildren(children);
        this.setOriginalChildrenToCurrentChildren();
        return returnVal;
    }

    public List<GeneNode> getChildren() {
        return this.children;
    }

    public void getTermini(List<GeneNode> leaves) {
        if (leaves != null) {
            if (this.isTerminus()) {
                leaves.add(this);
            } else {
                for (int i = 0; i < this.children.size(); ++i) {
                    GeneNode child = this.children.get(i);
                    child.getTermini(leaves);
                }
            }
        }
    }

    public void setOriginalChildrenToCurrentChildren() {
        if (this.children == null) {
            return;
        }
        if (this.originalChildrenOrder == null) {
            this.originalChildrenOrder = new ArrayList<GeneNode>();
        }
        this.originalChildrenOrder.clear();
        this.originalChildrenOrder.addAll(this.children);
    }

    public boolean isDuplication() {
        if (null == this.nodeType) {
            return false;
        }
        int index = this.nodeType.indexOf(NODE_TYPE_DUPLICATION);
        return index >= 0;
    }

    public boolean isHorizontalTransfer() {
        if (null == this.nodeType) {
            return false;
        }
        int index = this.nodeType.indexOf(NODE_TYPE_HORIZONTAL_TRANSFER);
        return index >= 0;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDistanceFromParent(float dist) {
        this.distanceFromParent = dist;
    }

    public float getDistanceFromParent() {
        return this.distanceFromParent;
    }

    public void setDistanceFromRoot(float dist) {
        this.distanceFromRoot = dist;
    }

    public float getDistanceFromRoot() {
        return this.distanceFromRoot;
    }

    public String getPaintId() {
        return this.paint_id;
    }

    public void setPaintId(String an_number) {
        if (an_number == null || an_number != null && an_number.length() == 0) {
            log.debug((Object)"Trying to set PAINT id to null");
        } else {
            if (this.paint_id != null && this.paint_id.length() > 0) {
                log.debug((Object)("Changing paint_id from " + this.paint_id + " to " + an_number));
            }
            this.paint_id = an_number;
            PaintManager.inst().indexByPaintID(this);
        }
    }

    public String toString() {
        if (this.db != null && this.db_id != null && !this.db.equals("PANTHER")) {
            return this.db + ":" + this.db_id;
        }
        if (this.persistantNodeID != null && this.db != null && this.db.equals("PANTHER")) {
            return this.persistantNodeID;
        }
        if (this.paint_id != null) {
            return this.paint_id;
        }
        return "Unidentified node";
    }

    public String getHMMSeq() {
        return this.hmm_seq;
    }

    public void setHMMSeq(String hmm_seq) {
        this.hmm_seq = hmm_seq;
    }

    public boolean hasBiologicalProcessEvidence() {
        Node n = this.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList || 0 == annotList.size()) {
            return false;
        }
        for (Annotation annot : annotList) {
            String term = annot.getGoTerm();
            GOTerm gTerm = PaintManager.inst().goTermHelper().getTerm(term);
            if (!"P".equals(gTerm.getAspect())) continue;
            return true;
        }
        return false;
    }

    public boolean hasBiologicalProcessEvidenceOld() {
        return this.bpCount > 0;
    }

    public int getBiologicalProcessCount() {
        return this.bpCount;
    }

    public void setBiologicalProcessCount(int bpCount) {
        this.bpCount = bpCount;
    }

    public boolean hasCellularComponentEvidence() {
        Node n = this.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList || 0 == annotList.size()) {
            return false;
        }
        for (Annotation annot : annotList) {
            String term = annot.getGoTerm();
            GOTerm gTerm = PaintManager.inst().goTermHelper().getTerm(term);
            if (!"C".equals(gTerm.getAspect())) continue;
            return true;
        }
        return false;
    }

    public boolean hasCellularComponentEvidenceOld() {
        return this.ccCount > 0;
    }

    public int getCellularComponentCount() {
        return this.ccCount;
    }

    public void setCellularComponentCount(int ccCount) {
        this.ccCount = ccCount;
    }

    public boolean hasMolecularFunctionEvidence() {
        Node n = this.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            return false;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList || 0 == annotList.size()) {
            return false;
        }
        for (Annotation annot : annotList) {
            String term = annot.getGoTerm();
            GOTerm gTerm = PaintManager.inst().goTermHelper().getTerm(term);
            if (!"F".equals(gTerm.getAspect())) continue;
            return true;
        }
        return false;
    }

    public boolean hasMolecularFunctionEvidenceOld() {
        return this.mfCount > 0;
    }

    public int getMolecularFunctionCount() {
        return this.mfCount;
    }

    public void setMolecularFunctionCount(int mfCount) {
        this.mfCount = mfCount;
    }

    public void setDropColor(Color dropColor) {
        this.dropColor = dropColor;
    }

    public String getPersistantNodeID() {
        return this.persistantNodeID;
    }

    public void setPersistantNodeID(String persistantNodeID) {
        if (persistantNodeID == null) {
            log.debug((Object)(this + " PTN is being set to null"));
        } else {
            if (persistantNodeID.equals("PTN000657503")) {
                log.debug((Object)("Check this out " + this));
            }
            if (this.persistantNodeID == null) {
                this.persistantNodeID = persistantNodeID;
                PaintManager.inst().indexNodeByPTN(this);
                if (this.db == null || this.db != null && this.db.length() == 0) {
                    this.db = "PANTHER";
                    this.db_id = persistantNodeID;
                }
            } else if (this.persistantNodeID != null && this.persistantNodeID.length() > 0) {
                log.debug((Object)("Changing PTN from " + this.persistantNodeID + " to " + persistantNodeID));
            }
        }
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public String getGeneSource() {
        return this.geneSource;
    }

    public void setGeneSource(String geneSource) {
        this.geneSource = geneSource;
    }

    public String getProteinId() {
        return this.proteinId;
    }

    public void setProteinId(String proteinId) {
        this.proteinId = proteinId;
    }

    public String getProteinSource() {
        return this.proteinSource;
    }

    public void setProteinSource(String proteinSource) {
        this.proteinSource = proteinSource;
    }

    public int getDupColorIndex() {
        return this.dupColorIndex;
    }

    public void setDupColorIndex(int sfColorIndex) {
        this.dupColorIndex = sfColorIndex;
    }

    public int getHorizontalColorIndex() {
        return this.horizontalColorIndex;
    }

    public void setHorizontalColorIndex(int horizontalColorIndex) {
        this.horizontalColorIndex = horizontalColorIndex;
    }

    public String getSpeciesClassification() {
        return this.speciesClassification;
    }

    public void setSpeciesClassification(String speciesClassification) {
        this.speciesClassification = speciesClassification;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }
}

