/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.bbop.io.FileUtil;
import org.paint.config.Preferences;

public class AboutDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String paint_fullname = "PAINT: Protein Annotion and INference Tool";
    private static final String developers = "Developed by: Suzanna Lewis, Ed Lee, Paul Thomas, Pascale Gaudet, and Michael Livstone\n\nFormer developers: Kara Dolinski, Anushya Muruganujan";
    private static final String logoFile = "images/paints.jpg";
    private ImageIcon image;

    public AboutDialog(Frame owner) {
        super(owner, "About", false);
        this.setDefaultCloseOperation(2);
    }

    public void showDialog() {
        this.configure();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.pack();
    }

    protected void configure() {
        try {
            try {
                this.image = new ImageIcon(FileUtil.findUrl((String)logoFile));
            }
            catch (FileNotFoundException ex) {
                System.out.println("Unable to open logoFile");
            }
            this.setLayout(new GridBagLayout());
            JPanel icon_panel = new JPanel();
            icon_panel.setLayout(new BorderLayout());
            JLabel program = new JLabel(paint_fullname, this.image, 0);
            JLabel version = new JLabel(Preferences.inst().getVersion().toString(), this.image, 0);
            program.setFont(new Font("Arial", 1, 14));
            version.setFont(new Font("Arial", 1, 12));
            icon_panel.add((Component)program, "Center");
            icon_panel.add((Component)version, "South");
            JPanel listPane = new JPanel();
            listPane.setLayout(new BorderLayout());
            listPane.add(Box.createRigidArea(new Dimension(0, 5)));
            JTextArea dev = new JTextArea(developers);
            dev.setRows(3);
            dev.setLineWrap(true);
            dev.setWrapStyleWord(true);
            dev.setMargin(new Insets(4, 4, 4, 4));
            dev.setEditable(false);
            listPane.add(dev);
            JPanel buttonPane = new JPanel();
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(this);
            buttonPane.add(closeButton);
            GridBagConstraints c = new GridBagConstraints();
            this.add((Component)icon_panel, c);
            c.fill = 2;
            c.gridy = 1;
            this.add((Component)listPane, c);
            c.gridy = 2;
            this.add((Component)buttonPane, c);
            this.pack();
        }
        catch (Exception e) {
            System.out.println("Some kind of error loading about dialog");
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

