/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.paint.datamodel.Family;
import org.paint.main.PaintManager;

public class ActiveFamily {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(ActiveFamily.class);
    private static String extension;
    private static final String USER_DIR = "user.dir";
    private static final String DATA_DIR = "data";
    private JFileChooser chooser;
    private Frame frame;

    public ActiveFamily(Frame frame) {
        this.frame = frame;
    }

    private void setCurrentDirectory() {
        if (PaintManager.inst().getCurrentDirectory() != null) {
            this.chooser.setCurrentDirectory(PaintManager.inst().getCurrentDirectory());
        } else {
            StringBuffer defaultDirectory = new StringBuffer(System.getProperty(USER_DIR));
            defaultDirectory.append(File.separator);
            defaultDirectory.append(DATA_DIR);
            File f = new File(defaultDirectory.toString());
            if (f.exists()) {
                this.chooser.setCurrentDirectory(f);
            }
        }
    }

    public File getSelectedFile(boolean save, String suffix) {
        int returned;
        this.chooser = new JFileChooser();
        this.chooser.setDialogTitle("Choose a family");
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setFileSelectionMode(0);
        this.chooser.setFileFilter(new PAINTFileFilter());
        Family family = PaintManager.inst().getFamily();
        extension = suffix == null || suffix.equals("") ? "" : suffix;
        if (family != null && family.getFamilyID() != null) {
            Object filename = family.getFamilyID();
            if (extension.length() > 0) {
                filename = (String)filename + "." + extension;
            }
            this.chooser.setSelectedFile(new File((String)filename));
        }
        this.setCurrentDirectory();
        this.chooser.setVisible(true);
        if (this.frame == null) {
            log.debug((Object)"Frame is null");
        }
        if (save) {
            this.chooser.setDialogType(1);
            returned = this.chooser.showDialog(this.frame, "Save");
        } else {
            this.chooser.setDialogType(0);
            returned = this.chooser.showDialog(this.frame, "Open");
        }
        File f = null;
        if (returned == 0 && (f = this.chooser.getSelectedFile()) != null) {
            PaintManager.inst().setCurrentDirectory(f);
        }
        return f;
    }

    public class PAINTFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String suffix = this.getExtension(f);
            if (suffix != null) {
                return suffix.equals(extension);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "PAINT FILES";
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

