/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.Evidence;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.bbop.framework.GUIManager;
import org.paint.datamodel.GeneNode;
import org.paint.dialog.Java2sAutoComboBox;
import org.paint.gui.association.ExpAssociationTable;
import org.paint.gui.event.EventManager;
import org.paint.gui.evidence.PaintAction;
import org.paint.main.PaintManager;
import org.paint.util.HTMLUtil;

public class AddExpEvidenceDlg
extends JDialog
implements ActionListener {
    private static String LABEL_TITLE = "Update Experimental Evidence to Sequence ";
    protected String[] expEvidence;
    public static final String MSG_ANNOT_TO_TERM_ALREADY_EXISTS_PART_1 = "Annotation to term ";
    public static final String MSG_ANNOT_TO_TERM_ALREADY_EXISTS_PART_2 = " already exists.";
    public static final String MSG_ANNOT_TO_MORE_SPECIFIC_TERM_ALREADY_EXISTS_PART_1 = "Annotation to more specific term ";
    public static final String MSG_ANNOT_TO_MORE_SPECIFIC_TERM_ALREADY_EXISTS_PART_2 = " already exists.";
    public static final String MSG_FOUND_EXISTING_EXP_ANNOTATIONS = "Found, existing experimental annotations, continue?";
    protected ArrayList<String> terms;
    protected ExpEvidencePanel evidencePanel = null;
    protected boolean operationSuccess = false;
    private GeneNode geneNode;

    public AddExpEvidenceDlg(GeneNode geneNode) {
        super((Frame)GUIManager.getManager().getFrame(), false);
        this.setTitle(LABEL_TITLE + geneNode.getNode().getStaticInfo().getPublicId());
        this.geneNode = geneNode;
        this.expEvidence = new String[Evidence.getExperimental().size()];
        Evidence.getExperimental().toArray(this.expEvidence);
        this.terms = PaintManager.inst().goTermHelper().getDisplayList();
        this.evidencePanel = new ExpEvidencePanel(this.terms, this.expEvidence);
        this.setContentPane(this.evidencePanel);
        this.pack();
        this.setLocationRelativeTo(GUIManager.getManager().getFrame());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (null != AddExpEvidenceDlg.this.evidencePanel) {
                    AddExpEvidenceDlg.this.evidencePanel.windowClosing();
                }
            }
        });
    }

    public boolean isOperationSuccess() {
        return this.operationSuccess;
    }

    public String getSelectedTerm() {
        return this.evidencePanel.getSelctedTerm();
    }

    public HashSet<String> getQualifierSet() {
        return this.evidencePanel.getSelectedQualifierSet();
    }

    public String getEvidenceCode() {
        return this.evidencePanel.getSelectedEvidence();
    }

    public String getPMID() {
        return this.evidencePanel.getPMID();
    }

    public int display() {
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
        EventManager.inst().removeGeneAnnotationChangeListener(this.evidencePanel.jTable1);
    }

    private class ExpEvidencePanel
    extends JPanel {
        private ArrayList<String> termList;
        private String[] evidenceList;
        private JButton jButton1;
        private JButton jButton3;
        private JCheckBox jCheckBox2;
        private JCheckBox jCheckBox3;
        private JCheckBox jCheckBox4;
        private Java2sAutoComboBox jComboBox1;
        private JComboBox<String> jComboBox2;
        private JLabel jLabel1;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JLabel jLabel4;
        private JPanel jPanel1;
        private JPanel jPanel2;
        private JScrollPane jScrollPane1;
        private ExpAssociationTable jTable1;
        private JTextField jTextField1;
        public static final String QUALIFIER_NONE = "None";

        public ExpEvidencePanel(ArrayList<String> termList, String[] evidenceList) {
            this.termList = termList;
            this.evidenceList = evidenceList;
            this.initComponents();
        }

        public void windowClosing() {
            if (null != this.jTable1) {
                this.jTable1.windowClosing();
            }
        }

        private void initComponents() {
            this.jLabel1 = new JLabel();
            String[] arrayList = new String[this.termList.size()];
            this.termList.toArray(arrayList);
            this.jComboBox1 = new Java2sAutoComboBox(this.termList);
            this.jComboBox1.setSelectedIndex(-1);
            this.jLabel2 = new JLabel();
            this.jComboBox2 = new JComboBox<String>(this.evidenceList);
            this.jLabel3 = new JLabel();
            this.jPanel1 = new JPanel();
            this.jCheckBox3 = new JCheckBox();
            this.jCheckBox4 = new JCheckBox();
            this.jCheckBox2 = new JCheckBox();
            this.jLabel4 = new JLabel();
            this.jTextField1 = new JTextField();
            this.jScrollPane1 = new JScrollPane();
            this.jTable1 = new ExpAssociationTable(AddExpEvidenceDlg.this.geneNode);
            this.jButton3 = new JButton();
            this.jButton1 = new JButton();
            this.jLabel1.setText("GO Id:");
            this.jLabel2.setText("Evidence Code");
            this.jLabel3.setText("Qualifier");
            this.jCheckBox3.setText("COLOCALIZES_WITH");
            this.jCheckBox3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExpEvidencePanel.this.jCheckBox3ActionPerformed(evt);
                }
            });
            this.jCheckBox4.setText("CONTRIBUTES_TO");
            this.jCheckBox4.setToolTipText("");
            this.jCheckBox4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExpEvidencePanel.this.jCheckBox4ActionPerformed(evt);
                }
            });
            this.jCheckBox2.setText("NOT");
            this.jCheckBox2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExpEvidencePanel.this.jCheckBox2ActionPerformed(evt);
                }
            });
            GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
            this.jPanel1.setLayout(jPanel1Layout);
            jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox3, -2, 144, -2).addGap(30, 30, 30).addComponent(this.jCheckBox4, -2, 159, -2).addContainerGap(-1, Short.MAX_VALUE)));
            jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox3).addComponent(this.jCheckBox4).addComponent(this.jCheckBox2)).addContainerGap(-1, Short.MAX_VALUE)));
            this.jLabel4.setText("PMID");
            this.jScrollPane1.setViewportView(this.jTable1);
            this.jButton3.setText("Add Experimental Annotation");
            this.jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExpEvidencePanel.this.jButton3ActionPerformed(evt);
                }
            });
            this.jButton1.setText("Finished Updating Experimental Annotations");
            this.jButton1.setToolTipText("");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExpEvidencePanel.this.jButton1ActionPerformed(evt);
                }
            });
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBox2, -2, -1, -2)).addGap(462, 462, 462)).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1, -2, 118, -2).addContainerGap(-1, Short.MAX_VALUE)))).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGap(445, 445, 445).addComponent(this.jButton1).addGap(0, 0, Short.MAX_VALUE)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jComboBox2, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton3).addGap(23, 23, 23).addComponent(this.jScrollPane1, -2, 90, -2).addGap(19, 19, 19).addComponent(this.jButton1).addContainerGap()));
        }

        private void jCheckBox4ActionPerformed(ActionEvent evt) {
        }

        private void jCheckBox2ActionPerformed(ActionEvent evt) {
        }

        private void jCheckBox3ActionPerformed(ActionEvent evt) {
        }

        private void jButton3ActionPerformed(ActionEvent evt) {
            int dialogResult;
            ArrayList annotList;
            String selectedTerm = AddExpEvidenceDlg.this.evidencePanel.getSelctedTerm();
            if (null == selectedTerm) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Please select a valid term", "Invalid GO term", 0);
                return;
            }
            GOTerm t = PaintManager.inst().goTermHelper().getTerm(selectedTerm);
            if (null == t) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Unable to find term " + selectedTerm + " in system", "Invalid GO term", 0);
                return;
            }
            HashSet<String> qualifierSet = AddExpEvidenceDlg.this.evidencePanel.getSelectedQualifierSet();
            for (String qualifier : qualifierSet) {
                if (PaintManager.inst().goTermHelper().canTermHaveQualifier(t, qualifier)) continue;
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Term not valid with qualifier " + qualifier, "Invalid Qualifier", 0);
                return;
            }
            String pmid = AddExpEvidenceDlg.this.evidencePanel.getPMID();
            if (null == pmid) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "Please enter a PubMed ID", "PMID not specified", 0);
                return;
            }
            try {
                Long.parseLong(pmid);
                BrowserLauncher bl = PaintManager.inst().getBrowserLauncher();
                HTMLUtil.bringUpInBrowser(bl, "https://www.ncbi.nlm.nih.gov/pubmed/" + pmid);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(GUIManager.getManager().getFrame(), "PubMed ID should only have digits", "Invalid PMID", 0);
                return;
            }
            HashSet<Qualifier> qset = new HashSet<Qualifier>();
            for (String q : AddExpEvidenceDlg.this.getQualifierSet()) {
                Qualifier qualifier = new Qualifier();
                qualifier.setText(q);
                qset.add(qualifier);
            }
            boolean isNot = QualifierDif.containsNegative(qset);
            GOTermHelper gth = PaintManager.inst().goTermHelper();
            GOTerm selectedGoTerm = gth.getTerm(selectedTerm);
            NodeVariableInfo nvi = AddExpEvidenceDlg.this.geneNode.getNode().getVariableInfo();
            if (nvi == null) {
                nvi = new NodeVariableInfo();
                AddExpEvidenceDlg.this.geneNode.getNode().setVariableInfo(nvi);
            }
            if (null == (annotList = nvi.getGoAnnotationList())) {
                annotList = new ArrayList();
            }
            StringBuffer sb = new StringBuffer();
            for (Annotation a : annotList) {
                ArrayList ancestorTerms;
                if (!a.isExperimental()) continue;
                if (isNot && QualifierDif.containsNegative((Set)a.getQualifierSet()) && QualifierDif.allQualifiersSame(qset, (Set)a.getQualifierSet())) {
                    HashSet descTerms;
                    if (selectedTerm.equals(a.getGoTerm())) {
                        if (0 != sb.length()) {
                            sb.append("\n");
                        }
                        sb.append(AddExpEvidenceDlg.MSG_ANNOT_TO_TERM_ALREADY_EXISTS_PART_1);
                        sb.append(selectedTerm);
                        sb.append(" already exists.");
                    }
                    if ((descTerms = gth.getDescendants(gth.getTerm(a.getGoTerm()))).contains(selectedGoTerm)) {
                        if (0 != sb.length()) {
                            sb.append("\n");
                        }
                        sb.append(AddExpEvidenceDlg.MSG_ANNOT_TO_MORE_SPECIFIC_TERM_ALREADY_EXISTS_PART_1);
                        sb.append(a.getGoTerm());
                        sb.append(" already exists.");
                    }
                }
                if (isNot || QualifierDif.containsNegative((Set)a.getQualifierSet()) || !QualifierDif.allQualifiersSame(qset, (Set)a.getQualifierSet())) continue;
                if (selectedTerm.equals(a.getGoTerm())) {
                    if (0 != sb.length()) {
                        sb.append("\n");
                    }
                    sb.append(AddExpEvidenceDlg.MSG_ANNOT_TO_TERM_ALREADY_EXISTS_PART_1);
                    sb.append(selectedTerm);
                    sb.append(" already exists.");
                }
                if (!(ancestorTerms = gth.getAncestors(gth.getTerm(a.getGoTerm()))).contains(selectedGoTerm)) continue;
                if (0 != sb.length()) {
                    sb.append("\n");
                }
                sb.append(AddExpEvidenceDlg.MSG_ANNOT_TO_MORE_SPECIFIC_TERM_ALREADY_EXISTS_PART_1);
                sb.append(a.getGoTerm());
                sb.append(" already exists.");
            }
            if (0 != sb.length() && (dialogResult = JOptionPane.showConfirmDialog(GUIManager.getManager().getFrame(), sb.toString(), AddExpEvidenceDlg.MSG_FOUND_EXISTING_EXP_ANNOTATIONS, 1, 2)) != 0) {
                return;
            }
            PaintAction.inst().addExperimentalAnnotation(selectedTerm, AddExpEvidenceDlg.this.geneNode, AddExpEvidenceDlg.this.evidencePanel.getSelectedEvidence(), this.getPMID(), qset);
        }

        private void jButton1ActionPerformed(ActionEvent evt) {
            AddExpEvidenceDlg.this.actionPerformed(evt);
        }

        public String getPMID() {
            if (null != this.jTextField1 && null != this.jTextField1.getText()) {
                String rtn = this.jTextField1.getText().trim();
                if (rtn.isEmpty()) {
                    return null;
                }
                return rtn;
            }
            return null;
        }

        public HashSet<String> getSelectedQualifierSet() {
            HashSet<String> qualifierSet = new HashSet<String>();
            if (this.jCheckBox2.isSelected()) {
                qualifierSet.add(this.jCheckBox2.getText());
            }
            if (this.jCheckBox3.isSelected()) {
                qualifierSet.add(this.jCheckBox3.getText());
            }
            if (this.jCheckBox4.isSelected()) {
                qualifierSet.add(this.jCheckBox4.getText());
            }
            return qualifierSet;
        }

        public String getSelectedEvidence() {
            return this.jComboBox2.getItemAt(this.jComboBox2.getSelectedIndex());
        }

        public String getSelctedTerm() {
            String itemText = (String)this.jComboBox1.getItemAt(this.jComboBox1.getSelectedIndex());
            if (null == itemText) {
                return null;
            }
            int index = itemText.indexOf("-");
            if (index < 0) {
                return null;
            }
            String acc = itemText.startsWith("GO:") ? itemText.substring(0, index) : itemText.substring(index + 1);
            if (null == PaintManager.inst().goTermHelper().getTerm(acc)) {
                return null;
            }
            return acc;
        }
    }
}

