/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.paint.config.Preferences;
import org.paint.dialog.CustomPreviewPanel;
import org.paint.gui.AspectSelector;
import org.paint.gui.event.AspectChangeEvent;
import org.paint.gui.event.EventManager;

public class AspectColorPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    Color oldBPcolor = Preferences.inst().getAspectColor(1);
    Color oldMFcolor = Preferences.inst().getAspectColor(4);
    Color oldCCcolor = Preferences.inst().getAspectColor(2);
    JColorChooser chooser = new JColorChooser();
    JRadioButton mf = new JRadioButton(AspectSelector.Aspect.MOLECULAR_FUNCTION.toString());
    JRadioButton cc = new JRadioButton(AspectSelector.Aspect.CELLULAR_COMPONENT.toString());
    JRadioButton bp = new JRadioButton(AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString());

    public AspectColorPane() {
        final CustomPreviewPanel previewPanel = new CustomPreviewPanel(this.chooser);
        this.setLayout(new BoxLayout(this, 1));
        this.mf.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    previewPanel.setOldColor(AspectColorPane.this.oldMFcolor);
                    AspectColorPane.this.chooser.setColor(Preferences.inst().getAspectColor(4));
                }
            }
        });
        this.mf.setSelected(true);
        this.cc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    previewPanel.setOldColor(AspectColorPane.this.oldCCcolor);
                    AspectColorPane.this.chooser.setColor(Preferences.inst().getAspectColor(2));
                }
            }
        });
        this.bp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    previewPanel.setOldColor(AspectColorPane.this.oldBPcolor);
                    AspectColorPane.this.chooser.setColor(Preferences.inst().getAspectColor(1));
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.mf);
        group.add(this.cc);
        group.add(this.bp);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        radioPanel.add(this.mf);
        radioPanel.add(this.cc);
        radioPanel.add(this.bp);
        previewPanel.setSize(previewPanel.getPreferredSize());
        previewPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.chooser.setPreviewPanel(previewPanel);
        this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Preferences preferences = Preferences.inst();
                if (AspectColorPane.this.mf.isSelected()) {
                    preferences.setAspectColor(4, AspectColorPane.this.chooser.getColor());
                } else if (AspectColorPane.this.cc.isSelected()) {
                    preferences.setAspectColor(2, AspectColorPane.this.chooser.getColor());
                } else if (AspectColorPane.this.bp.isSelected()) {
                    preferences.setAspectColor(1, AspectColorPane.this.chooser.getColor());
                }
                AspectChangeEvent aspEvent = new AspectChangeEvent(this);
                EventManager.inst().fireAspectChangeEvent(aspEvent);
            }
        });
        this.add(radioPanel);
        this.add(this.chooser);
    }

    public void cancelColorChange() {
        Preferences preferences = Preferences.inst();
        preferences.setAspectColor(1, this.oldBPcolor);
        preferences.setAspectColor(4, this.oldMFcolor);
        preferences.setAspectColor(2, this.oldCCcolor);
        AspectChangeEvent aspEvent = new AspectChangeEvent(this);
        EventManager.inst().fireAspectChangeEvent(aspEvent);
    }

    public void resetColorChange() {
        Preferences preferences = Preferences.inst();
        preferences.setAspectColor(1, this.oldBPcolor);
        preferences.setAspectColor(4, this.oldMFcolor);
        preferences.setAspectColor(2, this.oldCCcolor);
        Color c = null;
        if (this.bp.isSelected()) {
            c = this.oldBPcolor;
        } else if (this.mf.isSelected()) {
            c = this.oldMFcolor;
        } else if (this.cc.isSelected()) {
            c = this.oldCCcolor;
        }
        this.chooser.setColor(c);
        AspectChangeEvent aspEvent = new AspectChangeEvent(this);
        EventManager.inst().fireAspectChangeEvent(aspEvent);
    }
}

