/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.paint.config.Preferences;
import org.paint.dialog.CustomPreviewPanel;
import org.paint.gui.event.CurationColorEvent;
import org.paint.gui.event.EventManager;

public class CurationStatusColorPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color oldExperimentalColor = Preferences.inst().getExpPaintColor();
    private Color oldCuratedColor = Preferences.inst().getCuratedPaintColor();
    private Color oldInferColor = Preferences.inst().getInferPaintColor();
    private JColorChooser chooser = new JColorChooser();
    private JRadioButton experimental = new JRadioButton("Experimental");
    private JRadioButton curated = new JRadioButton("Curated");
    private JRadioButton inferred = new JRadioButton("Inferred");

    public CurationStatusColorPane() {
        this.setLayout(new BoxLayout(this, 1));
        final CustomPreviewPanel previewPanel = new CustomPreviewPanel(this.chooser);
        previewPanel.setSize(previewPanel.getPreferredSize());
        previewPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.experimental.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    previewPanel.setOldColor(CurationStatusColorPane.this.oldExperimentalColor);
                    CurationStatusColorPane.this.chooser.setColor(Preferences.inst().getExpPaintColor());
                }
            }
        });
        this.experimental.setSelected(true);
        this.curated.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    previewPanel.setOldColor(CurationStatusColorPane.this.oldCuratedColor);
                    CurationStatusColorPane.this.chooser.setColor(Preferences.inst().getCuratedPaintColor());
                }
            }
        });
        this.inferred.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    previewPanel.setOldColor(CurationStatusColorPane.this.oldInferColor);
                    CurationStatusColorPane.this.chooser.setColor(Preferences.inst().getInferPaintColor());
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.experimental);
        group.add(this.curated);
        group.add(this.inferred);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        radioPanel.add(this.experimental);
        radioPanel.add(this.curated);
        radioPanel.add(this.inferred);
        this.chooser.setPreviewPanel(previewPanel);
        this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Preferences preferences = Preferences.inst();
                if (CurationStatusColorPane.this.experimental.isSelected()) {
                    preferences.setExpPaintColor(CurationStatusColorPane.this.chooser.getColor());
                } else if (CurationStatusColorPane.this.curated.isSelected()) {
                    preferences.setCuratedPaintColor(CurationStatusColorPane.this.chooser.getColor());
                } else if (CurationStatusColorPane.this.inferred.isSelected()) {
                    preferences.setInferPaintColor(CurationStatusColorPane.this.chooser.getColor());
                }
                CurationColorEvent colorEvent = new CurationColorEvent(this);
                EventManager.inst().fireCurationColorEvent(colorEvent);
            }
        });
        this.add(radioPanel);
        this.add(this.chooser);
    }

    public void cancelColorChange() {
        Preferences preferences = Preferences.inst();
        preferences.setExpPaintColor(this.oldExperimentalColor);
        preferences.setCuratedPaintColor(this.oldCuratedColor);
        preferences.setInferPaintColor(this.oldInferColor);
        CurationColorEvent colorEvent = new CurationColorEvent(this);
        EventManager.inst().fireCurationColorEvent(colorEvent);
    }

    public void resetColorChange() {
        this.cancelColorChange();
        Color c = this.chooser.getColor();
        if (this.experimental.isSelected()) {
            c = this.oldExperimentalColor;
        } else if (this.curated.isSelected()) {
            c = this.oldCuratedColor;
        } else if (this.inferred.isSelected()) {
            c = this.oldInferColor;
        }
        this.chooser.setColor(c);
        CurationColorEvent colorEvent = new CurationColorEvent(this);
        EventManager.inst().fireCurationColorEvent(colorEvent);
    }
}

