/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class CustomPreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int squareSize = 25;
    private int squareGap = 5;
    private int innerGap = 5;
    private int textGap = 5;
    private String sampleText = UIManager.getString("ColorChooser.sampleText");
    private int swatchWidth = 50;
    private Color oldColor = null;
    private JComponent host;

    public CustomPreviewPanel(JColorChooser host) {
        this.host = host;
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.host.getFontMetrics(this.getFont());
        int height = fm.getHeight();
        int width = SwingUtilities.computeStringWidth(fm, this.sampleText);
        int y = height * 3 + this.textGap * 3;
        int x = this.squareSize * 3 + this.squareGap * 2 + this.swatchWidth + width + this.textGap * 3;
        return new Dimension(x, y);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.oldColor == null) {
            this.oldColor = this.getForeground();
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getComponentOrientation().isLeftToRight()) {
            int squareWidth = this.paintSquares(g, 0);
            int textWidth = this.paintText(g, squareWidth);
            this.paintSwatch(g, squareWidth + textWidth);
        } else {
            int swatchWidth = this.paintSwatch(g, 0);
            int textWidth = this.paintText(g, swatchWidth);
            this.paintSquares(g, swatchWidth + textWidth);
        }
    }

    public void setOldColor(Color oldColor) {
        this.oldColor = oldColor;
    }

    private int paintSwatch(Graphics g, int offsetX) {
        int swatchX = offsetX;
        g.setColor(this.oldColor);
        g.fillRect(swatchX, 0, this.swatchWidth, this.squareSize + this.squareGap / 2);
        g.setColor(this.getForeground());
        g.fillRect(swatchX, this.squareSize + this.squareGap / 2, this.swatchWidth, this.squareSize + this.squareGap / 2);
        return swatchX + this.swatchWidth;
    }

    private int paintText(Graphics g, int offsetX) {
        g.setFont(this.getFont());
        if (this.host == null) {
            this.host = this;
        }
        FontMetrics fm = this.host.getFontMetrics(this.getFont());
        int ascent = fm.getAscent();
        int height = fm.getHeight();
        int width = SwingUtilities.computeStringWidth(fm, this.sampleText);
        int textXOffset = offsetX + this.textGap;
        Color color = this.getForeground();
        g.setColor(color);
        g.drawString(this.sampleText, textXOffset + this.textGap / 2, ascent + 2);
        g.fillRect(textXOffset, height + this.textGap, width + this.textGap, height + 2);
        g.setColor(Color.black);
        g.drawString(this.sampleText, textXOffset + this.textGap / 2, height + ascent + this.textGap + 2);
        g.setColor(Color.white);
        g.fillRect(textXOffset, (height + this.textGap) * 2, width + this.textGap, height + 2);
        g.setColor(color);
        g.drawString(this.sampleText, textXOffset + this.textGap / 2, (height + this.textGap) * 2 + ascent + 2);
        return width + this.textGap * 3;
    }

    private int paintSquares(Graphics g, int offsetX) {
        int squareXOffset = offsetX;
        Color color = this.getForeground();
        g.setColor(Color.white);
        g.fillRect(squareXOffset, 0, this.squareSize, this.squareSize);
        g.setColor(color);
        g.fillRect(squareXOffset + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        g.setColor(Color.white);
        g.fillRect(squareXOffset + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        g.setColor(color);
        g.fillRect(squareXOffset, this.squareSize + this.squareGap, this.squareSize, this.squareSize);
        g.translate(this.squareSize + this.squareGap, 0);
        g.setColor(Color.black);
        g.fillRect(squareXOffset, 0, this.squareSize, this.squareSize);
        g.setColor(color);
        g.fillRect(squareXOffset + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        g.setColor(Color.white);
        g.fillRect(squareXOffset + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        g.translate(-(this.squareSize + this.squareGap), 0);
        g.translate(this.squareSize + this.squareGap, this.squareSize + this.squareGap);
        g.setColor(Color.white);
        g.fillRect(squareXOffset, 0, this.squareSize, this.squareSize);
        g.setColor(color);
        g.fillRect(squareXOffset + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        g.translate(-(this.squareSize + this.squareGap), -(this.squareSize + this.squareGap));
        g.translate((this.squareSize + this.squareGap) * 2, 0);
        g.setColor(Color.white);
        g.fillRect(squareXOffset, 0, this.squareSize, this.squareSize);
        g.setColor(color);
        g.fillRect(squareXOffset + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        g.setColor(Color.black);
        g.fillRect(squareXOffset + this.innerGap * 2, this.innerGap * 2, this.squareSize - this.innerGap * 4, this.squareSize - this.innerGap * 4);
        g.translate(-((this.squareSize + this.squareGap) * 2), 0);
        g.translate((this.squareSize + this.squareGap) * 2, this.squareSize + this.squareGap);
        g.setColor(Color.black);
        g.fillRect(squareXOffset, 0, this.squareSize, this.squareSize);
        g.setColor(color);
        g.fillRect(squareXOffset + this.innerGap, this.innerGap, this.squareSize - this.innerGap * 2, this.squareSize - this.innerGap * 2);
        g.translate(-((this.squareSize + this.squareGap) * 2), -(this.squareSize + this.squareGap));
        return this.squareSize * 3 + this.squareGap * 2;
    }
}

