/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.paint.datamodel.GeneNode;
import org.paint.main.PaintManager;
import org.paint.util.GeneNodeUtil;
import org.paint.util.RenderUtil;

public class EvdnceCdeAndNewAnnotDlg
extends JDialog
implements ActionListener {
    private static final HashMap<String, String> evidenceCdeToString = EvdnceCdeAndNewAnnotDlg.initEvidenceCdeToDisplayString();
    private Map<JRadioButton, String> selections;
    private Map<JCheckBox, String> leavesLookup;
    private String selected = null;
    JTextField pmidTextField = null;
    JComboBox<GeneNode> leavesComboBox = null;
    JList<String> leafLabels = null;
    JPanel residuesPane = null;
    private Map<JRadioButton, GOTerm> ancestorLookup;
    private GOTerm ancestor;
    private JRadioButton residuesBtn = null;
    private JRadioButton divergentBtn = null;
    private JButton doneButton = null;
    private List<GeneNode> leaves;
    private Annotation annotation;
    private List<GeneNode> defaultEvdnceLeaves;
    private boolean ancestorsApplicable = false;

    public static HashMap<String, String> initEvidenceCdeToDisplayString() {
        HashMap<String, String> rtnTbl = new HashMap<String, String>();
        rtnTbl.put("IKR", "NOT due to change in key residue(s)");
        rtnTbl.put("IRD", "NOT due to rapid divergence");
        return rtnTbl;
    }

    public EvdnceCdeAndNewAnnotDlg(Frame frame, Annotation annotation, List<GeneNode> leaves, List<GeneNode> defaultEvdnceLeaves) {
        super(frame, "Evidence Code for NOT and New Annotation", true);
        this.leaves = leaves;
        this.annotation = annotation;
        this.defaultEvdnceLeaves = defaultEvdnceLeaves;
        this.setLayout(new BorderLayout());
        this.setContentPane(this.evidenceAndNewAnnot(annotation));
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JPanel evidenceAndNewAnnot(Annotation annotation) {
        JPanel qualify = new JPanel();
        qualify.setLayout(new BoxLayout(qualify, 3));
        JPanel selectionPane = this.createSelectionPane(annotation);
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(true);
        buttonPane.setBackground(RenderUtil.getAspectColor());
        this.doneButton = new JButton("Continue");
        this.doneButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.doneButton);
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.doneButton);
        qualify.add(selectionPane);
        qualify.add(buttonPane);
        return qualify;
    }

    private JPanel createResiduesPane() {
        JLabel residueLabel = new JLabel("Please enter PMID and also select sequence(s) from descendents providing evidence");
        JPanel box = new JPanel();
        residueLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        box.setOpaque(true);
        box.setBackground(RenderUtil.getAspectColor());
        box.setLayout(new BoxLayout(box, 3));
        box.add(residueLabel);
        JPanel pmidPane = new JPanel();
        pmidPane.setAlignmentX(0.0f);
        pmidPane.setBackground(RenderUtil.getAspectColor());
        pmidPane.setLayout(new BoxLayout(pmidPane, 0));
        JLabel pmidLabel = new JLabel("PMID:  ");
        pmidLabel.setAlignmentX(0.0f);
        pmidPane.add(pmidLabel);
        this.pmidTextField = new JTextField(10);
        this.pmidTextField.setMaximumSize(this.pmidTextField.getPreferredSize());
        pmidPane.add(this.pmidTextField);
        box.add(pmidPane);
        JScrollPane leavesScrollPane = this.getLeavesListBox();
        leavesScrollPane.setAlignmentX(0.0f);
        JLabel defaultLeavesLabel = null;
        if (this.defaultEvdnceLeaves.isEmpty()) {
            defaultLeavesLabel = new JLabel("No leaves selected by default");
        } else {
            StringBuffer leavesLabel = new StringBuffer();
            int counter = 0;
            int size = this.defaultEvdnceLeaves.size();
            for (GeneNode geneNode : this.defaultEvdnceLeaves) {
                leavesLabel.append(geneNode.getNodeLabel());
                if (++counter >= size) continue;
                leavesLabel.append(",");
                leavesLabel.append(" ");
            }
            defaultLeavesLabel = size > 1 ? new JLabel("The following leaves will be included as evidence: " + leavesLabel.toString()) : new JLabel(leavesLabel.toString() + " will be included as evidence");
        }
        defaultLeavesLabel.setAlignmentX(0.0f);
        defaultLeavesLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel listBoxLabel = new JLabel("Select additional leaf node(s) if necessary...  ");
        listBoxLabel.setAlignmentX(0.0f);
        listBoxLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        listBoxLabel.setBackground(RenderUtil.getAspectColor());
        JPanel leavesPanel = new JPanel();
        leavesPanel.setAlignmentX(0.0f);
        leavesPanel.setBackground(RenderUtil.getAspectColor());
        leavesPanel.setLayout(new BoxLayout(leavesPanel, 1));
        leavesPanel.add(defaultLeavesLabel);
        leavesPanel.add(listBoxLabel);
        leavesPanel.add(leavesScrollPane);
        box.add(leavesPanel);
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        return box;
    }

    private JScrollPane getLeavesListBox() {
        ArrayList<String> labels = new ArrayList<String>(this.leaves.size());
        for (GeneNode geneNode : this.leaves) {
            labels.add(geneNode.getNodeLabel());
        }
        this.leafLabels = new JList<String>(labels.toArray(new String[labels.size()]));
        this.leafLabels.setSelectionMode(2);
        JScrollPane listScroller = new JScrollPane();
        listScroller.setViewportView(this.leafLabels);
        this.leafLabels.setLayoutOrientation(0);
        return listScroller;
    }

    private JComboBox<GeneNode> getLeavesComboBox() {
        List<GeneNode> nodes = this.leaves;
        JComboBox<GeneNode> comboBox = new JComboBox<GeneNode>(new Vector<GeneNode>(nodes));
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof GeneNode) {
                    this.setText(((GeneNode)value).getNodeLabel());
                    Dimension d = this.getPreferredSize();
                    d.height = 40;
                    this.setMaximumSize(d);
                }
                return this;
            }
        });
        comboBox.setSelectedItem(null);
        return comboBox;
    }

    private JPanel createLeavesPane(boolean currentNegative) {
        String description = "Select leaf nodes";
        JPanel box = new JPanel();
        JLabel label = new JLabel(description);
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        label.setAlignmentX(0.0f);
        box.setOpaque(true);
        box.setBackground(RenderUtil.getAspectColor());
        box.setLayout(new BoxLayout(box, 3));
        box.add(label);
        this.leavesLookup = new HashMap<JCheckBox, String>();
        return box;
    }

    private JPanel createSelectionPane(Annotation annotation) {
        String description = null;
        boolean isNegative = true;
        HashSet qSet = annotation.getQualifierSet();
        if (QualifierDif.containsNegative((Set)qSet)) {
            description = "Select evidence code for positive annotation";
        } else {
            description = "Select evidence code for NOT annotation";
            isNegative = false;
        }
        JPanel box = new JPanel();
        JLabel label = new JLabel(description);
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        label.setAlignmentX(0.0f);
        box.setOpaque(true);
        box.setBackground(RenderUtil.getAspectColor());
        box.setLayout(new BoxLayout(box, 3));
        box.add(label);
        this.selections = new HashMap<JRadioButton, String>();
        this.divergentBtn = this.addRadioButton("IRD");
        this.divergentBtn.setAlignmentX(0.0f);
        this.divergentBtn.addActionListener(this);
        this.selections.put(this.divergentBtn, "IRD");
        ButtonGroup bG = new ButtonGroup();
        bG.add(this.divergentBtn);
        box.add(this.divergentBtn);
        this.residuesBtn = this.addRadioButton("IKR");
        this.residuesBtn.addActionListener(this);
        this.selections.put(this.residuesBtn, "IKR");
        bG.add(this.residuesBtn);
        box.add(this.residuesBtn);
        this.residuesBtn.setAlignmentX(0.0f);
        this.residuesBtn.setSelected(true);
        this.residuesPane = this.createResiduesPane();
        this.residuesPane.setAlignmentX(0.0f);
        box.add(this.residuesPane);
        if (!isNegative) {
            this.ancestorsApplicable = true;
            String term = annotation.getGoTerm();
            GOTermHelper gth = PaintManager.inst().goTermHelper();
            GOTerm gterm = gth.getTerm(term);
            String aspect = gterm.getAspect();
            ArrayList ancestors = gth.getAncestors(gterm);
            GOTermHelper goTermHelper = PaintManager.inst().goTermHelper();
            Iterator termIter = ancestors.iterator();
            while (termIter.hasNext()) {
                GOTerm aTerm = (GOTerm)termIter.next();
                List curParents = aTerm.getParents();
                if (null == curParents || 0 == curParents.size()) {
                    termIter.remove();
                }
                if (!GOTermHelper.isAnnotAllowedForTerm((String)term)) {
                    termIter.remove();
                    continue;
                }
                if (null == AnnotationHelper.existingAnnotsAllowNewAnnotation((Set)annotation.getQualifierSet(), (String)aTerm.getId(), (Node)annotation.getAnnotationDetail().getAnnotatedNode(), (GOTermHelper)goTermHelper)) continue;
                System.out.println(aTerm.getId() + " cannot be used as ancestor term");
                termIter.remove();
            }
            if (ancestors.size() > 0) {
                JPanel ancestorPanel = new JPanel();
                ancestorPanel.setOpaque(true);
                ancestorPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                ancestorPanel.setLayout(new BoxLayout(ancestorPanel, 3));
                JLabel ancestorLabel = new JLabel("Annotate with an ancestor term?");
                ancestorLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                ancestorLabel.setAlignmentX(0.0f);
                ancestorPanel.add(ancestorLabel);
                JPanel buttonPanel = new JPanel(new GridLayout(0, 1));
                this.ancestorLookup = new HashMap<JRadioButton, GOTerm>();
                ButtonGroup ancestorBtnGrp = new ButtonGroup();
                for (GOTerm curTerm : ancestors) {
                    JRadioButton btn = this.addRadioButton(curTerm);
                    btn.setAlignmentX(0.0f);
                    ancestorBtnGrp.add(btn);
                    buttonPanel.add(btn);
                    this.ancestorLookup.put(btn, curTerm);
                }
                JScrollPane buttonScroll = new JScrollPane();
                buttonScroll.setViewportView(buttonPanel);
                buttonScroll.setPreferredSize(new Dimension(300, 200));
                ancestorPanel.add(buttonScroll);
                ancestorPanel.setBackground(RenderUtil.getAspectColor());
                box.add(ancestorPanel);
            }
        }
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)box, "First");
        Border padding = BorderFactory.createEmptyBorder(20, 20, 5, 20);
        pane.setBorder(padding);
        pane.setOpaque(true);
        pane.setBackground(RenderUtil.getAspectColor());
        return pane;
    }

    private JCheckBox getCheckBox(GeneNode gNode, boolean curNegative, GOTerm term) {
        JCheckBox check = new JCheckBox();
        check.setText(gNode.getNodeLabel());
        AnnotationStatus as = new AnnotationStatus(gNode);
        if (0 == as.status) {
            return check;
        }
        if (curNegative && as.containsNegative || !curNegative && as.containsPositive) {
            return check;
        }
        if (curNegative && as.containsPositive && !as.containsNegative) {
            check.setSelected(true);
            check.setEnabled(false);
            return check;
        }
        if (!curNegative && as.containsNegative && !as.containsPositive) {
            check.setSelected(true);
            check.setEnabled(false);
            return check;
        }
        return check;
    }

    private JRadioButton addRadioButton(String evidenceCode) {
        JRadioButton radio = new JRadioButton();
        radio.setText(evidenceCdeToString.get(evidenceCode));
        radio.setSelected(false);
        return radio;
    }

    private JRadioButton addRadioButton(GOTerm goTerm) {
        JRadioButton radio = new JRadioButton();
        radio.setText(goTerm.getName() + " (" + goTerm.getAcc() + ")");
        radio.setSelected(false);
        return radio;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.doneButton == e.getSource()) {
            Set<JRadioButton> buttons = this.selections.keySet();
            for (JRadioButton radio : buttons) {
                if (!radio.isSelected()) continue;
                this.selected = this.selections.get(radio);
                break;
            }
            if (null != this.ancestorLookup) {
                Set<JRadioButton> ancestorButtons = this.ancestorLookup.keySet();
                for (JRadioButton radio : ancestorButtons) {
                    if (!radio.isSelected()) continue;
                    this.ancestor = this.ancestorLookup.get(radio);
                    break;
                }
            }
            this.setVisible(false);
        }
    }

    public String getSelectedEvidenceCode() {
        return this.selected;
    }

    public boolean areAncestorsApplicable() {
        return this.ancestorsApplicable;
    }

    public GOTerm getAncestor() {
        if (this.ancestorsApplicable) {
            return this.ancestor;
        }
        return null;
    }

    public String getPMID() {
        if (null != this.pmidTextField && null != this.pmidTextField.getText()) {
            String rtn = this.pmidTextField.getText().trim();
            if (rtn.isEmpty()) {
                return null;
            }
            return rtn;
        }
        return null;
    }

    public int[] getSelectedLeafIndices() {
        return this.leafLabels.getSelectedIndices();
    }

    private class AnnotationStatus {
        public static final int ANNOT_NONE = 0;
        public static final int ANNOT_POS = 1;
        public static final int ANNOT_NEG = 2;
        public int status = 0;
        public boolean containsPositive = false;
        public boolean containsNegative = false;

        private AnnotationStatus(GeneNode geneNode) {
            ArrayList annotList;
            Node node;
            NodeVariableInfo nvi;
            if (GeneNodeUtil.inPrunedBranch(geneNode)) {
                this.status = 0;
            }
            if (null == (nvi = (node = geneNode.getNode()).getVariableInfo())) {
                this.status = 0;
            }
            if (null == (annotList = nvi.getGoAnnotationList())) {
                this.status = 0;
            }
            for (Annotation a : annotList) {
                if (QualifierDif.containsNegative((Set)a.getQualifierSet())) {
                    this.containsNegative = true;
                }
                if (null != a.getQualifierSet() && !QualifierDif.containsPositive((HashSet)a.getQualifierSet())) continue;
                this.containsPositive = true;
            }
        }
    }
}

