/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geneontology.db.model.Term;
import org.paint.datamodel.GeneNode;
import org.paint.dialog.FindStatusPane;
import org.paint.dialog.FoundResultsTable;
import org.paint.gui.table.GeneSearch;
import org.paint.main.PaintManager;

public class FindPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = LogManager.getLogger(FindPanel.class);
    protected static Color color = new Color(255, 255, 204);
    JTextField findField;
    JButton findButton;
    JRadioButton geneButton;
    JRadioButton termButton;
    JButton clearButton;
    JButton closeButton;
    JPanel controlPanel;
    JScrollPane resultTableScroller;
    FoundResultsTable resultTable;
    Box resultBox;
    JPanel closePanel;
    private SEARCH_TYPE search_type;
    private FindStatusPane resultsPane;
    private static String gene_search;
    private static List<GeneNode> gene_results;
    private static String term_search;
    private static List<Term> term_results;

    public FindPanel() {
        this.componentInit();
    }

    private void componentInit() {
        this.setBackground(color);
        JPanel radioPanel = new JPanel();
        radioPanel.setBackground(color);
        radioPanel.setLayout(new BoxLayout(radioPanel, 0));
        this.geneButton = new JRadioButton("Gene");
        this.termButton = new JRadioButton("Term");
        this.geneButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.geneButton);
        buttonGroup.add(this.termButton);
        radioPanel.add(this.geneButton);
        radioPanel.add(Box.createHorizontalStrut(20));
        radioPanel.add(this.termButton);
        radioPanel.setPreferredSize(new Dimension(400, 30));
        this.findField = new JTextField();
        this.findButton = new JButton("Find");
        this.clearButton = new JButton("Clear");
        this.closeButton = new JButton("Close");
        Dimension buttonSize = new Dimension(90, 20);
        this.findButton.setPreferredSize(buttonSize);
        this.clearButton.setPreferredSize(buttonSize);
        this.closeButton.setPreferredSize(buttonSize);
        this.controlPanel = new JPanel();
        this.controlPanel.setBackground(color);
        this.controlPanel.setForeground(Color.black);
        Box findBox = new Box(0);
        findBox.add(this.findField);
        findBox.add(this.findButton);
        findBox.add(Box.createHorizontalGlue());
        findBox.setPreferredSize(new Dimension(400, 30));
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 1));
        this.controlPanel.add(radioPanel);
        this.controlPanel.add(findBox);
        this.controlPanel.add(Box.createVerticalGlue());
        this.controlPanel.setPreferredSize(new Dimension(400, 60));
        this.resultsPane = new FindStatusPane(" Results ", "", color);
        this.resultsPane.setBackground(color);
        this.resultsPane.setPreferredSize(new Dimension(400, 24));
        this.resultsPane.setFont(this.getFont());
        this.resultTable = new FoundResultsTable();
        this.resultTableScroller = new JScrollPane(this.resultTable);
        this.resultTableScroller.setPreferredSize(new Dimension(400, 125));
        this.resultTable.setFillsViewportHeight(true);
        this.search_type = SEARCH_TYPE.GENE;
        this.resultTable.setType(this.search_type);
        this.resultBox = new Box(1);
        this.resultBox.add(this.resultsPane);
        this.resultBox.add(Box.createVerticalStrut(10));
        this.resultBox.add(this.resultTableScroller);
        this.resultBox.add(Box.createVerticalGlue());
        this.geneButton.addActionListener(this);
        this.termButton.addActionListener(this);
        this.findButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.findField.addActionListener(this);
        this.closePanel = new JPanel();
        this.closePanel.setBackground(color);
        this.closePanel.setForeground(Color.black);
        this.closePanel.setLayout(new BorderLayout());
        this.closePanel.setPreferredSize(new Dimension(400, 30));
        this.closePanel.add((Component)this.clearButton, "West");
        this.closePanel.add((Component)this.closeButton, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.resultBox, "Center");
        this.resultBox.setVisible(false);
        this.add((Component)this.closePanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.geneButton) {
            this.search_type = SEARCH_TYPE.GENE;
            this.resultTable.setType(this.search_type);
            this.findField.setText(gene_search);
            this.findField.requestFocus();
            this.showResults();
        } else if (evt.getSource() == this.termButton) {
            this.search_type = SEARCH_TYPE.TERM;
            this.resultTable.setType(this.search_type);
            this.findField.setText(term_search);
            this.findField.requestFocus();
            this.showResults();
        }
        if (evt.getSource() == this.findButton || evt.getSource() == this.findField) {
            String text = this.findField.getText();
            if (text != null && text.length() > 0) {
                text = text.substring(0, 1).equals(Character.valueOf('*')) ? text.substring(1) : text;
                String string = text = text.length() > 0 && text.substring(text.length() - 1).equals(Character.valueOf('*')) ? text.substring(0, text.length() - 1) : text;
            }
            if (!text.equals("")) {
                if (this.search_type == SEARCH_TYPE.GENE) {
                    gene_search = text;
                    gene_results = GeneSearch.inst().search(PaintManager.inst().getTree().getAllNodes(), text);
                    this.showResults();
                } else if (this.search_type == SEARCH_TYPE.TERM) {
                    term_search = text;
                    term_results = PaintManager.inst().findTerm(text);
                    this.showResults();
                }
            }
        } else if (evt.getSource() == this.clearButton) {
            this.findField.setText("");
            if (this.search_type == SEARCH_TYPE.GENE) {
                gene_search = "";
                gene_results = null;
            } else {
                term_search = "";
                term_results = null;
            }
            this.showResults();
        } else if (evt.getSource() == this.closeButton) {
            Window win = SwingUtilities.windowForComponent(this);
            win.setVisible(false);
        }
    }

    private void showResults() {
        if (this.search_type == SEARCH_TYPE.GENE) {
            this.resultTable.setGeneResults(gene_results);
        } else {
            this.resultTable.setTermResults(term_results);
        }
        this.resultBox.setVisible(true);
        int count = this.resultTable.getRowCount();
        if (count == 0) {
            this.resultsPane.setText("Nothing found that matches.");
            this.resultTableScroller.setVisible(false);
        } else {
            this.resultsPane.setText("Found " + count + " matches.");
            this.resultTableScroller.setVisible(true);
        }
        this.controlPanel.validate();
        Window win = SwingUtilities.windowForComponent(this.resultTableScroller);
        win.validate();
        win.pack();
    }

    public static enum SEARCH_TYPE {
        GENE,
        TERM;

    }
}

