/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.geneontology.db.model.Term;
import org.paint.datamodel.GeneNode;
import org.paint.dialog.FindPanel;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.GeneSelectEvent;
import org.paint.gui.event.TermSelectEvent;
import org.paint.main.PaintManager;

public class FoundResultsTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private String[] columns = new String[]{"ID"};
    List<GeneNode> gene_results;
    List<Term> term_results;
    MatchModel model = new MatchModel();
    private FindPanel.SEARCH_TYPE search_type;

    public FoundResultsTable() {
        super.setModel(this.model);
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new TableSelector());
    }

    public void setGeneResults(List<GeneNode> geneResults) {
        if (this.search_type == FindPanel.SEARCH_TYPE.GENE) {
            this.gene_results = geneResults;
            if (geneResults != null && geneResults.size() > 0) {
                this.getSelectionModel().addSelectionInterval(0, 0);
                GeneNode node = geneResults.get(0);
                ArrayList<GeneNode> selection = new ArrayList<GeneNode>();
                selection.add(node);
                PaintManager.inst().getTree().getDescendentList(node, selection);
                GeneSelectEvent event = new GeneSelectEvent(this, selection, node);
                EventManager.inst().fireGeneEvent(event);
            }
        }
        this.model.fireTableDataChanged();
    }

    public void setTermResults(List<Term> term_results) {
        if (this.search_type == FindPanel.SEARCH_TYPE.TERM) {
            this.term_results = term_results;
            if (term_results != null && term_results.size() > 0) {
                this.setRowSelectionInterval(0, 0);
                Term selected_term = term_results.get(0);
                TermSelectEvent term_event = new TermSelectEvent((Object)this, selected_term);
                List<GeneNode> selection = EventManager.inst().fireTermEvent(term_event);
                GeneSelectEvent gene_event = new GeneSelectEvent(this, selection, EventManager.inst().getAncestralSelection());
                EventManager.inst().fireGeneEvent(gene_event);
            }
        }
        this.model.fireTableDataChanged();
    }

    public void setType(FindPanel.SEARCH_TYPE search_type) {
        this.search_type = search_type;
        this.setGeneResults(this.gene_results);
        this.setTermResults(this.term_results);
    }

    protected class MatchModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected MatchModel() {
        }

        @Override
        public int getRowCount() {
            if (FoundResultsTable.this.search_type == FindPanel.SEARCH_TYPE.GENE && FoundResultsTable.this.gene_results != null) {
                return FoundResultsTable.this.gene_results.size();
            }
            if (FoundResultsTable.this.search_type == FindPanel.SEARCH_TYPE.TERM && FoundResultsTable.this.term_results != null) {
                return FoundResultsTable.this.term_results.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return FoundResultsTable.this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return FoundResultsTable.this.columns[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (FoundResultsTable.this.search_type == FindPanel.SEARCH_TYPE.GENE) {
                GeneNode match = FoundResultsTable.this.gene_results.get(row);
                return match.getDatabase() + ":" + match.getDatabaseID();
            }
            if (FoundResultsTable.this.search_type == FindPanel.SEARCH_TYPE.TERM) {
                Term match = FoundResultsTable.this.term_results.get(row);
                return match.getName();
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, 0).getClass();
        }
    }

    private class TableSelector
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = FoundResultsTable.this.getSelectedRow();
            if (row >= 0 && !e.getValueIsAdjusting()) {
                if (FoundResultsTable.this.search_type == FindPanel.SEARCH_TYPE.GENE) {
                    GeneNode node = FoundResultsTable.this.gene_results.get(row);
                    ArrayList<GeneNode> selection = new ArrayList<GeneNode>();
                    selection.add(node);
                    PaintManager.inst().getTree().getDescendentList(node, selection);
                    GeneSelectEvent event = new GeneSelectEvent(this, selection, node);
                    EventManager.inst().fireGeneEvent(event);
                } else if (FoundResultsTable.this.search_type == FindPanel.SEARCH_TYPE.TERM) {
                    Term selected_term = FoundResultsTable.this.term_results.get(row);
                    TermSelectEvent term_event = new TermSelectEvent((Object)this, selected_term);
                    List<GeneNode> selection = EventManager.inst().fireTermEvent(term_event);
                    GeneSelectEvent gene_event = new GeneSelectEvent(this, selection, EventManager.inst().getAncestralSelection());
                    EventManager.inst().fireGeneEvent(gene_event);
                }
            }
        }
    }
}

