/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.paint.config.Preferences;

public class MSAColorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected Frame frame;
    protected float[] orig_thresholds;
    protected Color[] orig_colorList;
    protected boolean weighted;
    protected String description;
    protected JPanel mainPanel;
    protected JList choiceList;
    protected DefaultListModel listModel;
    protected JScrollPane listScroller;
    protected JTextField percentField;
    protected Hashtable<String, Color> percentToColor;
    protected boolean choice = false;

    public MSAColorDialog(Frame f, boolean weighted) {
        super(f, true);
        int i;
        this.setTitle("Update MSA parameters");
        this.frame = f;
        this.weighted = weighted;
        Preferences prefs = Preferences.inst();
        this.orig_thresholds = prefs.getMSAThresholds(weighted);
        float[] thresholds = this.orig_thresholds;
        this.orig_colorList = prefs.getMSAColors(weighted);
        Color[] colorList = this.orig_colorList;
        this.description = weighted ? "Color based on sequence weights being greater than a given thresholds" : "Color based on percentage of entries for a column being greater than given thresholds";
        this.percentToColor = new Hashtable();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        JTextArea text = new JTextArea(this.description);
        text.setRows(1);
        text.setEditable(false);
        text.setAlignmentX(0.0f);
        JScrollPane areaScrollPane = new JScrollPane(text);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        areaScrollPane.setPreferredSize(new Dimension(250, 40));
        this.mainPanel.add(areaScrollPane);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BoxLayout(middlePanel, 1));
        JPanel percentPanel = new JPanel();
        percentPanel.setLayout(new BoxLayout(percentPanel, 0));
        String[] strPercent = new String[thresholds.length];
        for (i = 0; i < thresholds.length; ++i) {
            strPercent[i] = Float.toString(thresholds[i]);
            this.percentToColor.put(strPercent[i], colorList[i]);
        }
        this.listModel = new DefaultListModel();
        for (i = 0; i < strPercent.length; ++i) {
            this.listModel.addElement(strPercent[i]);
        }
        this.choiceList = new JList(this.listModel);
        this.choiceList.setSelectionMode(1);
        this.choiceList.setCellRenderer(new CellRenderer());
        this.listScroller = new JScrollPane(this.choiceList);
        this.listScroller.setPreferredSize(new Dimension(50, 60));
        this.listScroller.setMinimumSize(new Dimension(50, 60));
        this.listScroller.setAlignmentX(0.0f);
        this.listScroller.setAlignmentY(0.0f);
        percentPanel.add(this.listScroller);
        JPanel operationsPanel = new JPanel();
        operationsPanel.setLayout(new BoxLayout(operationsPanel, 1));
        JButton changeColor = new JButton("Change Color");
        changeColor.addActionListener(new ChangeColorActionListener());
        changeColor.setAlignmentX(0.0f);
        operationsPanel.add(changeColor);
        JPanel addThreshPanel = new JPanel();
        addThreshPanel.setLayout(new BoxLayout(addThreshPanel, 0));
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new AddActionListener());
        addButton.setAlignmentY(0.0f);
        this.percentField = new JTextField();
        this.percentField.setColumns(3);
        this.percentField.setPreferredSize(new Dimension(50, 20));
        this.percentField.setAlignmentY(0.0f);
        addThreshPanel.add(addButton);
        addThreshPanel.add(this.percentField);
        addThreshPanel.setAlignmentX(0.0f);
        operationsPanel.add(addThreshPanel);
        JButton remove = new JButton("Remove");
        remove.addActionListener(new RemoveActionListener());
        remove.setAlignmentX(0.0f);
        operationsPanel.add(remove);
        operationsPanel.setAlignmentY(0.0f);
        percentPanel.add(operationsPanel);
        percentPanel.setAlignmentX(0.0f);
        middlePanel.add(percentPanel);
        Rectangle r = this.frame.getBounds();
        this.setBounds(r.x + r.width / 2, r.y + r.height / 2, 300, 200);
        middlePanel.setAlignmentX(0.0f);
        this.mainPanel.add(middlePanel);
        JPanel decisionPanel = new JPanel();
        decisionPanel.setAlignmentX(0.0f);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new OKButtonActionListener());
        decisionPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new CancelButtonActionListener());
        decisionPanel.add(cancelButton);
        this.mainPanel.add(decisionPanel);
        this.setContentPane(this.mainPanel);
    }

    public boolean display() {
        this.setVisible(true);
        return this.choice;
    }

    public float[] getThresholds() {
        Object[] values = new String[this.listModel.getSize()];
        this.listModel.copyInto(values);
        float[] percentages = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            percentages[i] = Float.parseFloat((String)values[i]);
        }
        return percentages;
    }

    public Color[] getColors() {
        Object[] values = new String[this.listModel.getSize()];
        this.listModel.copyInto(values);
        Color[] colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            colors[i] = this.percentToColor.get(values[i]);
        }
        return colors;
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MSAColorDialog.this.choice = false;
            MSAColorDialog.this.setVisible(false);
        }
    }

    private class OKButtonActionListener
    implements ActionListener {
        private OKButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MSAColorDialog.this.choice = true;
            Preferences.inst().setMSAColors(MSAColorDialog.this.weighted, MSAColorDialog.this.getColors());
            Preferences.inst().setMSAThresholds(MSAColorDialog.this.weighted, MSAColorDialog.this.getThresholds());
            MSAColorDialog.this.setVisible(false);
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = MSAColorDialog.this.choiceList.getSelectedValue();
            if (null == o) {
                JOptionPane.showMessageDialog(MSAColorDialog.this.frame, "Please select an entry from the list");
                return;
            }
            MSAColorDialog.this.percentToColor.remove(o);
            MSAColorDialog.this.listModel.remove(MSAColorDialog.this.choiceList.getSelectedIndex());
        }
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = MSAColorDialog.this.percentField.getText();
            if (null == s || 0 == s.length()) {
                JOptionPane.showMessageDialog(MSAColorDialog.this.frame, "Please enter a percentage value in the text box");
                return;
            }
            try {
                int i;
                Float f = new Float(s);
                if (f.floatValue() <= 0.0f || f.floatValue() > 100.0f) {
                    JOptionPane.showMessageDialog(MSAColorDialog.this.frame, "Please enter a value that is between 0 and 100");
                    return;
                }
                s = f.toString();
                if (null != MSAColorDialog.this.percentToColor.get(s)) {
                    JOptionPane.showMessageDialog(MSAColorDialog.this.frame, "Please enter a value that is not currently in the list");
                    return;
                }
                Color c = JColorChooser.showDialog(MSAColorDialog.this, "Choose Color", Color.black);
                if (null == c) {
                    return;
                }
                MSAColorDialog.this.percentToColor.put(s, c);
                float[] entries = new float[MSAColorDialog.this.choiceList.getModel().getSize() + 1];
                for (i = 0; i < MSAColorDialog.this.choiceList.getModel().getSize(); ++i) {
                    entries[i] = Float.parseFloat((String)MSAColorDialog.this.choiceList.getModel().getElementAt(i));
                }
                entries[entries.length - 1] = f.floatValue();
                Arrays.sort(entries);
                MSAColorDialog.this.listModel.removeAllElements();
                for (i = entries.length - 1; i >= 0; --i) {
                    MSAColorDialog.this.listModel.addElement(Float.toString(entries[i]));
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(MSAColorDialog.this.frame, "Please enter a valid float value");
                return;
            }
        }
    }

    private class ChangeColorActionListener
    implements ActionListener {
        private ChangeColorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String o = (String)MSAColorDialog.this.choiceList.getSelectedValue();
            if (null == o) {
                JOptionPane.showMessageDialog(MSAColorDialog.this.frame, "Please select an entry from the list");
                return;
            }
            Color c = JColorChooser.showDialog(MSAColorDialog.this, "Choose Color", MSAColorDialog.this.percentToColor.get(o));
            if (null != c) {
                MSAColorDialog.this.percentToColor.put(o, c);
            }
        }
    }

    private class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean chf) {
            this.setText((String)value);
            Color c = MSAColorDialog.this.percentToColor.get(value);
            if (null == c) {
                System.out.println("Color not found for percent");
                return this;
            }
            this.setBackground(c);
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setForeground(Color.black);
            }
            return this;
        }
    }
}

