/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import com.sri.panther.paintCommon.Book;
import com.sri.panther.paintCommon.TransferInfo;
import com.sri.panther.paintCommon.User;
import com.sri.panther.paintCommon.util.Utils;
import edu.usc.ksom.pm.panther.paintCommon.DataTransferObj;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.bbop.framework.GUIManager;
import org.paint.dataadapter.PantherServer;
import org.paint.main.PaintManager;
import org.paint.util.HTMLUtil;

public class ManageBooksDlg
extends JDialog {
    Frame frame;
    private PaintManager pm;
    JTabbedPane mainPanel;
    JPanel SearchLockPanel;
    JPanel myBooksPanel;
    JPanel searchPanel;
    JPanel booksPanel;
    JPanel bookListPanel;
    JPanel unlockedBookListPanel;
    JLabel myBooksStatusLabel;
    public JTextField searchTerm;
    public JRadioButton geneSymbolBtn;
    public JRadioButton geneIdentifierBtn;
    public JRadioButton proteinIdentifierBtn;
    public JRadioButton definitionBtn;
    public JRadioButton getAllBooksBtn;
    public JRadioButton getBookByIdBtn;
    public JRadioButton getAllUncurtedBtn;
    public JRadioButton getRequirePaintReviewBtn;
    public JRadioButton getBooksByPTNBtn;
    public JTable searchBooksTable;
    public JTable myBooksTable;
    public static final String MSG_PLEASE_ENTER_SEARCH_TERM = "Please enter a search term";
    public static final String MSG_PLEASE_SELECT_LOCK_UNLOCK_BOOKS = "Please select books to lock or unlock";
    public static final String MSG_PLEASE_SELECT_UNLOCK_BOOKS = "Please select books to unlock";
    public static final String MSG_BOOKS_LOCKED = "Selected books have been locked";
    public static final String MSG_BOOKS_UNLOCKED = "Selected books have been unlocked";
    public static final String MSG_BOOKS_CANNOT_BE_LOCKED = "Selected books cannot be locked, the\n  following error has been returned:  ";
    public static final String MSG_NO_LOCKED_BOOKS_FOUND = "No locked books found";
    public static final String MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS = "Server returned error, cannot search for books";
    public static final String MSG_SERVER_ERROR_CANNOT_LOCK_BOOKS = "Server returned error, cannot lock books";
    public static final String MSG_SERVER_ERROR_CANNOT_UNLOCK_BOOKS = "Server returned error, cannot unlock books";
    public static final String MSG_SERVER_ERROR_CANNOT_LOCK_UNLOCK_BOOKS = "Server returned error, cannot lock and unlock books";
    public static final String MSG_SERVER_ERROR_CANNOT_ACCESS_LOCKED_BOOKS = "Server returned error, cannot access locked books";
    public static final String MSG_NO_BOOKS_FOR_SEARCH_CRITERIA = "No books found matching search criteria";
    public static final String MSG_NO_BOOKS_FOR_EXPORTING = "No books found for exporting";
    public static final String MSG_SUCCESS_EXPORTED = "Information has  been exported";
    public static final String MSG_HEADER_LOCK_BOOKS = "Lock Books";
    public static final String MSG_HEADER_UNLOCK_BOOKS = "Unlock Books";
    public static final String MSG_HEADER_LOCK_UNLOCK_BOOKS = "Lock and Unlock Books";
    public static final String MSG_HEADER_MY_BOOKS = "My Books";
    public static final String MSG_HEADER_SEARCH_BOOKS = "Search Books";
    public static final String LABEL_SEARCH = "Search Term";
    public static final String LABEL_SUBMIT = "Submit";
    public static final String LABEL_EXPORT = "Export";
    public static final String LABEL_SELECT_ALL = "Select all";
    public static final String LABEL_DESELECT_ALL = "Deselect all";
    public static final String BUTTON_LABEL_VIEW = "View";
    public static final String LABEL_UNLOCK_SELECTED_BOOKS = "Unlock selected books";
    public static final String LABEL_SEARCH_GENE_SYMBOL = "Gene Symbol";
    public static final String LABEL_SEARCH_GENE_IDENTIFIER = "Gene Identifier";
    public static final String LABEL_SEARCH_PROTEIN_IDENTIFIER = "Protein Identifier";
    public static final String LABEL_SEARCH_DEFINITION = "Definition (partial def supported)";
    public static final String LABEL_GET_FULL_LIST = "Get list of all books";
    public static final String LABEL_GET_BOOK_BY_ID = "Get book by id";
    public static final String LABEL_GET_UNCURATED_LIST = "Get unlocked and non-manually curated books";
    public static final String LABEL_GET_REQUIRE_PAINT_REVIEW_LIST = "Get books marked as require PAINT review";
    public static final String LABEL_GET_BOOK_BY_PTN = "Get book by PTN";
    public static final String LABEL_TITLE = "Manage Books";
    private static final String COLUMN_NAME_BOOK_ID = "Book Id";
    private static final String COLUMN_NAME_NAME = "Name";
    private static final String COLUMN_NAME_CURATION_STATUS = "Curation status";
    private static final String COLUMN_NAME_EXP_EVDNCE = "Experimental";
    private static final String COLUMN_NAME_NOTES = "Notes";
    private static final String COLUMN_NAME_ORG = "Organism";
    private static final String COLUMN_NUM_LEAVES = "# leaves";
    private static final String COLUMN_NAME_LOCKED_BY = "Locked by";
    private static final String COLUMN_NAME_DATE = "Last Status Change";
    private static final String COLUMN_NAME_DATE_ANNOTATION = "Last Annotation Change";
    private static final String COLUMN_NAME_OPEN = "Open";
    private static final String COLUMN_NAME_LOCK_UNLOCK = "Lock/UnLock";
    private static final String COLUMN_NAME_UNLOCK = "Unlock";
    private static final String[] COLUMN_NAMES_SEARCH = new String[]{"Book Id", "Name", "Curation status", "Last Status Change", "Last Annotation Change", "Experimental", "Notes", "Organism", "# leaves", "Open", "Lock/UnLock", "Locked by"};
    public static final Class[] COLUMN_TYPES_SEARCH = new Class[]{String.class, String.class, String.class, Date.class, Date.class, Boolean.class, Boolean.class, String.class, Integer.class, JButton.class, Boolean.class, String.class};
    public static final String LABEL_LOCKED = "Locked";
    public static final String LINE_BREAK = "\\\\n";
    public static final String HTML_LINEBREAK = "<BR>";
    public static final String HTML_START = "<HTML>";
    public static final String CLICK_MSG = "Left click to view notes in pantree<BR>";
    public static final String HTML_END = "</HTML>";
    int defaultSortColSearchTbl = 8;
    int nonSortCol = 9;
    int COL_INDEX_COMMENT = 6;
    public static final int COL_INDEX_ORG = Utils.getIndex((String[])COLUMN_NAMES_SEARCH, (String)"Organism");
    private static final String[] COLUMN_NAMES_MY_BOOKS = new String[]{"Book Id", "Name", "Curation status", "Open", "Unlock"};
    private static final Class[] COLUMN_TYPES_MY_BOOKS = new Class[]{String.class, String.class, String.class, JButton.class, Boolean.class};
    private static final String JLABEL_MY_BOOKS_RETRIEVING_BOOKS = "Retrieving books...";
    private static final String JLABEL_MY_BOOKS_SELECT_BOOKS_TO_UNLOCK = "Select books to unlock";
    public static final String[] ORG_LIST_SPECIAL = new String[]{"HUMAN", "MOUSE", "DROME", "CAEEL", "YEAST", "ARATH"};
    public static final String PLANT_GENOME = "Plant";
    public static final String BACTERIAL_GENOME = "Bacteria";
    boolean DEBUG = true;
    protected String servletUrl;
    Vector userInfo;
    String openBookId = null;
    User lockedBy = null;
    JRadioButton lastValidSearchBtn = null;
    String lastValidSearchStr = null;
    public static final String URL_LINK_PREFIX_PANTREE_BOOK_COMMENT = "http://pantree.org/tree/familyCuratorNotes.jsp?accession=";

    public ManageBooksDlg(Frame frame, String servletUrl, Vector userInfo) {
        super(frame, true);
        this.setTitle(LABEL_TITLE);
        this.frame = frame;
        this.servletUrl = servletUrl;
        this.userInfo = userInfo;
        this.pm = PaintManager.inst();
        this.initializePanel();
    }

    protected void initializePanel() {
        this.initializeSearchLockUnlockPanel();
        this.initializeMyBooksPanel();
        this.mainPanel = new JTabbedPane();
        this.mainPanel.addChangeListener(new PanelChangeListener());
        this.mainPanel.add("Search And Lock or Unlock Books", this.SearchLockPanel);
        this.mainPanel.add("View Locked Books", this.myBooksPanel);
        this.setContentPane(this.mainPanel);
        Rectangle r = this.frame.getBounds();
        this.setBounds(r.x + r.width / 2, r.y + r.height / 2, 1000, 800);
        this.pack();
        this.setLocationRelativeTo(this.frame);
    }

    protected void initializeSearchLockUnlockPanel() {
        this.SearchLockPanel = new JPanel();
        this.SearchLockPanel.setLayout(new BoxLayout(this.SearchLockPanel, 1));
        this.SearchLockPanel.setAlignmentX(0.0f);
        this.initializeSearchPanel();
        this.initializeBookListPanel();
        this.SearchLockPanel.add(this.searchPanel);
        this.SearchLockPanel.add(this.booksPanel);
    }

    protected void initializeSearchPanel() {
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout(new BoxLayout(this.searchPanel, 3));
        JPanel searchTermPanel = new JPanel();
        searchTermPanel.setLayout(new FlowLayout(0));
        searchTermPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        searchTermPanel.add(new JLabel(LABEL_SEARCH));
        this.searchTerm = new JTextField(40);
        searchTermPanel.add(this.searchTerm);
        GridLayout gl = new GridLayout(0, 2, 0, 0);
        gl.setVgap(0);
        gl.setHgap(0);
        JPanel searchTypePanel = new JPanel(gl);
        searchTypePanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.getBookByIdBtn = new JRadioButton(LABEL_GET_BOOK_BY_ID);
        this.getBookByIdBtn.setSelected(true);
        this.geneSymbolBtn = new JRadioButton(LABEL_SEARCH_GENE_SYMBOL);
        this.geneIdentifierBtn = new JRadioButton(LABEL_SEARCH_GENE_IDENTIFIER);
        this.proteinIdentifierBtn = new JRadioButton(LABEL_SEARCH_PROTEIN_IDENTIFIER);
        this.definitionBtn = new JRadioButton(LABEL_SEARCH_DEFINITION);
        this.getAllBooksBtn = new JRadioButton(LABEL_GET_FULL_LIST);
        this.getAllUncurtedBtn = new JRadioButton(LABEL_GET_UNCURATED_LIST);
        this.getRequirePaintReviewBtn = new JRadioButton(LABEL_GET_REQUIRE_PAINT_REVIEW_LIST);
        this.getBooksByPTNBtn = new JRadioButton(LABEL_GET_BOOK_BY_PTN);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.getBookByIdBtn);
        bg.add(this.geneSymbolBtn);
        bg.add(this.geneIdentifierBtn);
        bg.add(this.proteinIdentifierBtn);
        bg.add(this.definitionBtn);
        bg.add(this.getAllBooksBtn);
        bg.add(this.getAllUncurtedBtn);
        bg.add(this.getRequirePaintReviewBtn);
        bg.add(this.getBooksByPTNBtn);
        searchTypePanel.add(this.getBookByIdBtn);
        searchTypePanel.add(this.geneSymbolBtn);
        searchTypePanel.add(this.geneIdentifierBtn);
        searchTypePanel.add(this.proteinIdentifierBtn);
        searchTypePanel.add(this.definitionBtn);
        searchTypePanel.add(this.getAllBooksBtn);
        searchTypePanel.add(this.getAllUncurtedBtn);
        searchTypePanel.add(this.getRequirePaintReviewBtn);
        searchTypePanel.add(this.getBooksByPTNBtn);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 3));
        centerPanel.add(searchTypePanel);
        JButton submitBtn = new JButton(LABEL_SUBMIT);
        submitBtn.addActionListener(new SearchActionListener());
        JPanel submitPanel = new JPanel();
        submitPanel.add(submitBtn);
        JButton exportBtn = new JButton(LABEL_EXPORT);
        exportBtn.addActionListener(new ExportActionListener());
        submitPanel.add(exportBtn);
        this.searchPanel.add(searchTermPanel);
        this.searchPanel.add(centerPanel);
        this.searchPanel.add(submitPanel);
    }

    protected void initializeMyBooksPanel() {
        this.myBooksPanel = new JPanel();
        this.myBooksPanel.setLayout(new BoxLayout(this.myBooksPanel, 1));
        this.myBooksStatusLabel = new JLabel(JLABEL_MY_BOOKS_RETRIEVING_BOOKS);
        this.myBooksStatusLabel.setPreferredSize(this.myBooksStatusLabel.getPreferredSize());
        this.myBooksPanel.add(this.myBooksStatusLabel);
        this.myBooksTable = new JTable(new MyBooksTableModel(new ArrayList<Book>(), COLUMN_NAMES_MY_BOOKS, COLUMN_TYPES_MY_BOOKS));
        this.myBooksTable.getTableHeader().setReorderingAllowed(false);
        this.myBooksTable.setDefaultRenderer(JButton.class, new ButtonCellRenderer(BUTTON_LABEL_VIEW));
        this.myBooksTable.addMouseListener(new LaunchBtnMouseAdapter(this.myBooksTable));
        this.myBooksTable.setPreferredScrollableViewportSize(new Dimension(750, 90));
        JScrollPane myBooksScrollPane = new JScrollPane(this.myBooksTable);
        this.myBooksPanel.add(myBooksScrollPane);
        JButton selectAllBtn = new JButton(LABEL_SELECT_ALL);
        selectAllBtn.addActionListener(new SelectAllListener());
        JButton deselectAllBtn = new JButton(LABEL_DESELECT_ALL);
        deselectAllBtn.addActionListener(new DeselectAllListener());
        JButton unlockSelectedBtn = new JButton(LABEL_UNLOCK_SELECTED_BOOKS);
        unlockSelectedBtn.addActionListener(new UnlockSelectedBooksListener());
        JPanel submitPanel = new JPanel();
        submitPanel.add(selectAllBtn);
        submitPanel.add(deselectAllBtn);
        submitPanel.add(unlockSelectedBtn);
        this.myBooksPanel.add(submitPanel);
    }

    protected void populateMyBooksList() {
        ArrayList<Book> myBooks = this.getMyBooks();
        if (null == myBooks) {
            JOptionPane.showMessageDialog(this.frame, MSG_NO_LOCKED_BOOKS_FOUND, MSG_HEADER_MY_BOOKS, 1);
            this.mainPanel.setSelectedIndex(0);
            return;
        }
        this.displayMyBooks(myBooks);
    }

    public void displayMyBooks(ArrayList<Book> myBooks) {
        this.myBooksStatusLabel.setText(JLABEL_MY_BOOKS_SELECT_BOOKS_TO_UNLOCK);
        this.myBooksStatusLabel.invalidate();
        MyBooksTableModel mbtm = new MyBooksTableModel(myBooks, COLUMN_NAMES_MY_BOOKS, COLUMN_TYPES_MY_BOOKS);
        this.myBooksTable.setModel(mbtm);
        this.myBooksTable.setAutoCreateRowSorter(true);
        TableModelEvent le = new TableModelEvent(mbtm);
        mbtm.fireTableChanged(le);
    }

    public ArrayList<Book> getMyBooks() {
        Vector<Vector> sendInfo = new Vector<Vector>(2);
        sendInfo.add(this.userInfo);
        DataTransferObj dto = new DataTransferObj();
        dto.setVc(this.pm.getVersionContainer());
        dto.setObj(sendInfo);
        DataTransferObj serverObj = PantherServer.inst().getMyBooks(this.servletUrl, dto, null, null);
        if (null == serverObj) {
            JOptionPane.showMessageDialog(this.frame, MSG_SERVER_ERROR_CANNOT_ACCESS_LOCKED_BOOKS, MSG_HEADER_MY_BOOKS, 0);
            return new ArrayList<Book>();
        }
        StringBuffer sb = serverObj.getMsg();
        if (null != sb && 0 != sb.length()) {
            JOptionPane.showMessageDialog(this.frame, sb.toString(), MSG_HEADER_MY_BOOKS, 0);
            return new ArrayList<Book>();
        }
        return (ArrayList)serverObj.getObj();
    }

    protected void setData(ArrayList<Book> books) {
        SearchBookTableModel sbtm = new SearchBookTableModel(books, COLUMN_NAMES_SEARCH, COLUMN_TYPES_SEARCH);
        this.searchBooksTable.setModel(sbtm);
        this.searchBooksTable.setAutoCreateRowSorter(true);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.searchBooksTable.getModel());
        this.searchBooksTable.setRowSorter(sorter);
        sorter.setSortable(this.nonSortCol, false);
        TableModelEvent le = new TableModelEvent(sbtm);
        sbtm.fireTableChanged(le);
    }

    protected void initializeBookListPanel() {
        this.bookListPanel = new JPanel();
        this.bookListPanel.setLayout(new BoxLayout(this.bookListPanel, 1));
        ArrayList<Book> bookList = new ArrayList<Book>();
        this.getBookByIdBtn.setSelected(true);
        this.lastValidSearchBtn = this.getBookByIdBtn;
        this.searchBooksTable = new JTable(new SearchBookTableModel(bookList, COLUMN_NAMES_SEARCH, COLUMN_TYPES_SEARCH)){

            @Override
            public String getToolTipText(MouseEvent e) {
                BookTableModel model;
                Object tip = null;
                Point p = e.getPoint();
                int rowIndex = ManageBooksDlg.this.searchBooksTable.rowAtPoint(p);
                int colIndex = ManageBooksDlg.this.searchBooksTable.columnAtPoint(p);
                int row = ManageBooksDlg.this.searchBooksTable.convertRowIndexToModel(rowIndex);
                int realColumnIndex = ManageBooksDlg.this.searchBooksTable.convertColumnIndexToModel(colIndex);
                if (realColumnIndex == ManageBooksDlg.this.COL_INDEX_COMMENT) {
                    BookTableModel model2 = (BookTableModel)ManageBooksDlg.this.searchBooksTable.getModel();
                    Book aBook = model2.data.get(row);
                    tip = aBook.getCommentUser();
                    if (null != tip) {
                        tip = ((String)tip).replaceAll(ManageBooksDlg.LINE_BREAK, ManageBooksDlg.HTML_LINEBREAK);
                        tip = "<HTML>Left click to view notes in pantree<BR>" + (String)tip + ManageBooksDlg.HTML_END;
                    }
                } else if (realColumnIndex == COL_INDEX_ORG && null != (tip = (String)(model = (BookTableModel)ManageBooksDlg.this.searchBooksTable.getModel()).getValueAt(row, realColumnIndex))) {
                    tip = ((String)tip).replaceAll(ManageBooksDlg.LINE_BREAK, ManageBooksDlg.HTML_LINEBREAK);
                    tip = ManageBooksDlg.HTML_START + (String)tip + ManageBooksDlg.HTML_END;
                }
                if (null == tip) {
                    return "";
                }
                return tip;
            }
        };
        this.searchBooksTable.getTableHeader().setReorderingAllowed(false);
        this.searchBooksTable.setDefaultRenderer(JButton.class, new ButtonCellRenderer(BUTTON_LABEL_VIEW));
        this.searchBooksTable.addMouseListener(new LaunchBtnMouseAdapter(this.searchBooksTable));
        this.searchBooksTable.setPreferredScrollableViewportSize(new Dimension(750, 90));
        JScrollPane lockedScrollPane = new JScrollPane(this.searchBooksTable);
        JLabel booksLabel = new JLabel("Books");
        booksLabel.setPreferredSize(booksLabel.getPreferredSize());
        this.bookListPanel.add(booksLabel);
        this.bookListPanel.add(lockedScrollPane);
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 1));
        containerPanel.add(this.bookListPanel);
        this.booksPanel = new JPanel();
        this.booksPanel.setLayout(new BorderLayout());
        this.booksPanel.add((Component)containerPanel, "Center");
        JButton lockUnlockBooks = new JButton("Lock or Unlock selected Books");
        lockUnlockBooks.addActionListener(new LockUnlockSelectedBooksActionListener());
        JPanel lockBooksPanel = new JPanel();
        lockBooksPanel.add(lockUnlockBooks);
        this.booksPanel.add((Component)lockBooksPanel, "South");
    }

    public String display() {
        this.setVisible(true);
        return this.openBookId;
    }

    public void openBook(Book aBook) {
        System.out.println("Going to open book " + aBook.getId());
        this.openBookId = aBook.getId();
        this.lockedBy = aBook.getLockedBy();
        this.setVisible(false);
    }

    public String getOpenBookId() {
        return this.openBookId;
    }

    public User getLockedBy() {
        return this.lockedBy;
    }

    public void searchAgain() {
        if (null == this.lastValidSearchBtn) {
            return;
        }
        Vector<String> sendInfo = new Vector<String>(2);
        sendInfo.add(this.lastValidSearchStr);
        DataTransferObj dto = new DataTransferObj();
        dto.setVc(this.pm.getVersionContainer());
        dto.setObj(sendInfo);
        DataTransferObj infoFromServer = null;
        ArrayList books = null;
        if (this.geneSymbolBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchGeneName(this.servletUrl, dto, null, null);
        } else if (this.geneIdentifierBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchGeneExtId(this.servletUrl, dto, null, null);
        } else if (this.proteinIdentifierBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchProteinExtId(this.servletUrl, dto, null, null);
        } else if (this.definitionBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchDefinition(this.servletUrl, dto, null, null);
        } else if (this.getBookByIdBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchBookId(this.servletUrl, dto, null, null);
        } else if (this.getBooksByPTNBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchBookPTN(this.servletUrl, dto, null, null);
        } else if (this.getAllBooksBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchAllBooks(this.servletUrl, dto, null, null);
        } else if (this.getAllUncurtedBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchUncuratedBooks(this.servletUrl, dto, null, null);
        } else if (this.getRequirePaintReviewBtn.equals(this.lastValidSearchBtn)) {
            infoFromServer = PantherServer.inst().searchRequirePaintReviewUnlocked(this.servletUrl, dto, null, null);
        }
        if (null == infoFromServer) {
            JOptionPane.showMessageDialog(this.frame, MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS, MSG_HEADER_SEARCH_BOOKS, 0);
            this.setData(new ArrayList<Book>());
            return;
        }
        StringBuffer sb = infoFromServer.getMsg();
        if (null != sb && 0 != sb.length()) {
            JOptionPane.showMessageDialog(this.frame, sb.toString(), MSG_HEADER_MY_BOOKS, 0);
            this.setData(new ArrayList<Book>());
            return;
        }
        Vector serverRtnList = (Vector)infoFromServer.getObj();
        if (null == serverRtnList || 2 < serverRtnList.size()) {
            JOptionPane.showMessageDialog(this.frame, MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS, MSG_HEADER_SEARCH_BOOKS, 0);
            this.setData(new ArrayList<Book>());
            return;
        }
        ArrayList bookList = (ArrayList)serverRtnList.get(1);
        books = bookList;
        if (null != books) {
            this.setData(books);
        }
    }

    public class UnlockSelectedBooksListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            MyBooksTableModel model = (MyBooksTableModel)ManageBooksDlg.this.myBooksTable.getModel();
            Vector<String> booksForUnlocking = model.booksForUnlocking(ManageBooksDlg.this.pm.getUser().getloginName());
            if (0 == booksForUnlocking.size()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_PLEASE_SELECT_UNLOCK_BOOKS, ManageBooksDlg.MSG_HEADER_UNLOCK_BOOKS, 0);
                ManageBooksDlg.this.populateMyBooksList();
                return;
            }
            Vector<Vector<String>> sendInfo = new Vector<Vector<String>>(3);
            sendInfo.add(ManageBooksDlg.this.userInfo);
            sendInfo.add(booksForUnlocking);
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(ManageBooksDlg.this.pm.getVersionContainer());
            dto.setObj(sendInfo);
            DataTransferObj infoFromServer = PantherServer.inst().unlockBooks(ManageBooksDlg.this.servletUrl, dto, null, null);
            if (null == infoFromServer) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_SERVER_ERROR_CANNOT_UNLOCK_BOOKS, ManageBooksDlg.MSG_HEADER_UNLOCK_BOOKS, 0);
                ManageBooksDlg.this.populateMyBooksList();
                return;
            }
            StringBuffer sb = infoFromServer.getMsg();
            if (null != sb && 0 != sb.length()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, sb.toString(), ManageBooksDlg.MSG_HEADER_UNLOCK_BOOKS, 0);
                ManageBooksDlg.this.populateMyBooksList();
                return;
            }
            Vector serverRtnList = (Vector)infoFromServer.getObj();
            TransferInfo ti = (TransferInfo)serverRtnList.elementAt(0);
            String msg = ti.getInfo();
            if (null == msg) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_SERVER_ERROR_CANNOT_UNLOCK_BOOKS, ManageBooksDlg.MSG_HEADER_UNLOCK_BOOKS, 0);
            } else if (0 != msg.length()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, infoFromServer, ManageBooksDlg.MSG_HEADER_UNLOCK_BOOKS, 0);
            }
            ManageBooksDlg.this.populateMyBooksList();
        }
    }

    public class DeselectAllListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            MyBooksTableModel model = (MyBooksTableModel)ManageBooksDlg.this.myBooksTable.getModel();
            int col = model.getUnLockCol();
            if (-1 == col) {
                return;
            }
            int numRows = model.getRowCount();
            for (int i = 0; i < numRows; ++i) {
                model.setValueAt(Boolean.FALSE, i, col);
            }
        }
    }

    public class SelectAllListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            MyBooksTableModel model = (MyBooksTableModel)ManageBooksDlg.this.myBooksTable.getModel();
            int col = model.getUnLockCol();
            if (-1 == col) {
                return;
            }
            int numRows = model.getRowCount();
            for (int i = 0; i < numRows; ++i) {
                model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    public class LaunchBtnMouseAdapter
    extends MouseAdapter {
        JTable table;

        public LaunchBtnMouseAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableModel tm = this.table.getModel();
            Point p = e.getPoint();
            int column = this.table.columnAtPoint(p);
            int row = this.table.rowAtPoint(p);
            int convertRow = this.table.convertRowIndexToModel(row);
            if (column < 0 || convertRow < 0) {
                return;
            }
            if (tm instanceof MyBooksTableModel) {
                String header = COLUMN_NAMES_MY_BOOKS[column];
                if (header.equals(ManageBooksDlg.COLUMN_NAME_OPEN)) {
                    Book aBook = ((BookTableModel)tm).getBookAtRow(convertRow);
                    ManageBooksDlg.this.openBook(aBook);
                }
            } else if (tm instanceof SearchBookTableModel) {
                int modifiers;
                String header = COLUMN_NAMES_SEARCH[column];
                if (header.equals(ManageBooksDlg.COLUMN_NAME_OPEN)) {
                    Book aBook = ((BookTableModel)tm).getBookAtRow(convertRow);
                    ManageBooksDlg.this.openBook(aBook);
                    return;
                }
                if (header.equals(ManageBooksDlg.COLUMN_NAME_NOTES) && ((modifiers = e.getModifiers()) & 0x10) != 0 && (modifiers & 4) == 0) {
                    Book aBook = ((BookTableModel)tm).getBookAtRow(convertRow);
                    String id = aBook.getId();
                    HTMLUtil.bringUpInBrowser(ManageBooksDlg.this.pm.getBrowserLauncher(), ManageBooksDlg.URL_LINK_PREFIX_PANTREE_BOOK_COMMENT + id);
                }
            }
        }
    }

    public class ButtonCellRenderer
    implements TableCellRenderer {
        JButton launchButton;
        String label;

        public ButtonCellRenderer(String label) {
            this.label = label;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (null == this.launchButton) {
                this.launchButton = new JButton(this.label);
            }
            return this.launchButton;
        }
    }

    public class PanelChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent evt) {
            JTabbedPane pane = (JTabbedPane)evt.getSource();
            int sel = pane.getSelectedIndex();
            if (1 == sel) {
                ManageBooksDlg.this.populateMyBooksList();
            } else if (0 == sel) {
                ManageBooksDlg.this.searchAgain();
            }
        }
    }

    public class LockUnlockSelectedBooksActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Vector serverRtnList;
            TransferInfo ti;
            String msg;
            StringBuffer sb;
            User u = ManageBooksDlg.this.pm.getUser();
            if (null == u) {
                return;
            }
            String loginName = u.getloginName();
            if (null == loginName) {
                return;
            }
            BookTableModel model = (BookTableModel)ManageBooksDlg.this.searchBooksTable.getModel();
            Vector<String> booksForLocking = model.booksForLocking();
            Vector<String> booksForUnlocking = model.booksForUnlocking(loginName);
            if (0 == booksForLocking.size() && 0 == booksForUnlocking.size()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_PLEASE_SELECT_LOCK_UNLOCK_BOOKS, ManageBooksDlg.MSG_HEADER_LOCK_BOOKS, 0);
                return;
            }
            Vector<Vector<String>> sendInfo = new Vector<Vector<String>>(4);
            sendInfo.add(ManageBooksDlg.this.userInfo);
            sendInfo.add(booksForLocking);
            sendInfo.add(booksForUnlocking);
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(ManageBooksDlg.this.pm.getVersionContainer());
            dto.setObj(sendInfo);
            DataTransferObj infoFromServer = PantherServer.inst().lockAndUnLockBooks(ManageBooksDlg.this.servletUrl, "LockUnLockBooks", dto, null, null);
            if (null == infoFromServer) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_SERVER_ERROR_CANNOT_LOCK_UNLOCK_BOOKS, ManageBooksDlg.MSG_HEADER_LOCK_UNLOCK_BOOKS, 0);
                ManageBooksDlg.this.searchAgain();
            }
            if (null != (sb = infoFromServer.getMsg()) && 0 != sb.length()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, sb.toString(), ManageBooksDlg.MSG_HEADER_LOCK_UNLOCK_BOOKS, 0);
                ManageBooksDlg.this.searchAgain();
            }
            if (null == (msg = (ti = (TransferInfo)(serverRtnList = (Vector)infoFromServer.getObj()).elementAt(0)).getInfo())) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_SERVER_ERROR_CANNOT_LOCK_UNLOCK_BOOKS, ManageBooksDlg.MSG_HEADER_LOCK_UNLOCK_BOOKS, 0);
            } else if (0 != msg.length()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, msg, ManageBooksDlg.MSG_HEADER_LOCK_UNLOCK_BOOKS, 0);
            }
            ManageBooksDlg.this.searchAgain();
        }
    }

    public class SearchActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String searchStr = ManageBooksDlg.this.searchTerm.getText();
            if (!(null != searchStr && 0 != searchStr.trim().length() || ManageBooksDlg.this.getAllBooksBtn.isSelected() || ManageBooksDlg.this.getAllUncurtedBtn.isSelected() || ManageBooksDlg.this.getRequirePaintReviewBtn.isSelected())) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_PLEASE_ENTER_SEARCH_TERM, ManageBooksDlg.MSG_HEADER_SEARCH_BOOKS, 0);
                return;
            }
            Vector<String> sendInfo = new Vector<String>(2);
            sendInfo.add(searchStr.trim());
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(ManageBooksDlg.this.pm.getVersionContainer());
            dto.setObj(sendInfo);
            DataTransferObj infoFromServer = null;
            ArrayList books = null;
            if (ManageBooksDlg.this.geneSymbolBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchGeneName(ManageBooksDlg.this.servletUrl, dto, null, null);
            } else if (ManageBooksDlg.this.geneIdentifierBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchGeneExtId(ManageBooksDlg.this.servletUrl, dto, null, null);
            } else if (ManageBooksDlg.this.proteinIdentifierBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchProteinExtId(ManageBooksDlg.this.servletUrl, dto, null, null);
            } else if (ManageBooksDlg.this.definitionBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchDefinition(ManageBooksDlg.this.servletUrl, dto, null, null);
            } else if (ManageBooksDlg.this.getBookByIdBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchBookId(ManageBooksDlg.this.servletUrl, dto, null, null);
            } else if (ManageBooksDlg.this.getBooksByPTNBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchBookPTN(ManageBooksDlg.this.servletUrl, dto, null, null);
            } else if (ManageBooksDlg.this.getAllBooksBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchAllBooks(ManageBooksDlg.this.servletUrl, dto, null, null);
            } else if (ManageBooksDlg.this.getAllUncurtedBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchUncuratedBooks(ManageBooksDlg.this.servletUrl, dto, null, null);
            } else if (ManageBooksDlg.this.getRequirePaintReviewBtn.isSelected()) {
                infoFromServer = PantherServer.inst().searchRequirePaintReviewUnlocked(ManageBooksDlg.this.servletUrl, dto, null, null);
            }
            if (null == infoFromServer) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS, ManageBooksDlg.MSG_HEADER_SEARCH_BOOKS, 0);
                ManageBooksDlg.this.setData(new ArrayList<Book>());
                return;
            }
            StringBuffer sb = infoFromServer.getMsg();
            if (null != sb && 0 != sb.length()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, sb.toString(), ManageBooksDlg.MSG_HEADER_MY_BOOKS, 0);
                ManageBooksDlg.this.setData(new ArrayList<Book>());
                return;
            }
            Vector serverRtnList = (Vector)infoFromServer.getObj();
            if (null == serverRtnList || 2 < serverRtnList.size()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS, ManageBooksDlg.MSG_HEADER_SEARCH_BOOKS, 0);
                ManageBooksDlg.this.setData(new ArrayList<Book>());
                return;
            }
            ArrayList bookList = (ArrayList)serverRtnList.get(1);
            if (null == bookList || 0 == bookList.size()) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_NO_BOOKS_FOR_SEARCH_CRITERIA, ManageBooksDlg.MSG_HEADER_SEARCH_BOOKS, 0);
                ManageBooksDlg.this.setData(new ArrayList<Book>());
                return;
            }
            ManageBooksDlg.this.lastValidSearchStr = searchStr;
            ManageBooksDlg.this.lastValidSearchBtn = ManageBooksDlg.this.geneSymbolBtn.isSelected() ? ManageBooksDlg.this.geneSymbolBtn : (ManageBooksDlg.this.geneIdentifierBtn.isSelected() ? ManageBooksDlg.this.geneIdentifierBtn : (ManageBooksDlg.this.proteinIdentifierBtn.isSelected() ? ManageBooksDlg.this.proteinIdentifierBtn : (ManageBooksDlg.this.definitionBtn.isSelected() ? ManageBooksDlg.this.definitionBtn : (ManageBooksDlg.this.getBookByIdBtn.isSelected() ? ManageBooksDlg.this.getBookByIdBtn : (ManageBooksDlg.this.getAllBooksBtn.isSelected() ? ManageBooksDlg.this.getAllBooksBtn : ManageBooksDlg.this.getAllUncurtedBtn)))));
            books = bookList;
            ManageBooksDlg.this.setData(books);
        }
    }

    public class ExportActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int rtrnVal;
            if (null == ManageBooksDlg.this.searchBooksTable) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_NO_BOOKS_FOR_EXPORTING, ManageBooksDlg.MSG_HEADER_SEARCH_BOOKS, 0);
                return;
            }
            SearchBookTableModel model = (SearchBookTableModel)ManageBooksDlg.this.searchBooksTable.getModel();
            int numBooks = model.getRowCount();
            if (numBooks <= 0) {
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_NO_BOOKS_FOR_EXPORTING, ManageBooksDlg.MSG_HEADER_SEARCH_BOOKS, 0);
                return;
            }
            int numCols = COLUMN_NAMES_SEARCH.length;
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < numCols; ++j) {
                int realColumnIndex = ManageBooksDlg.this.searchBooksTable.convertColumnIndexToModel(j);
                if (ManageBooksDlg.COLUMN_NAME_OPEN.equals(COLUMN_NAMES_SEARCH[realColumnIndex])) continue;
                if (ManageBooksDlg.COLUMN_NAME_LOCK_UNLOCK.equals(COLUMN_NAMES_SEARCH[realColumnIndex])) {
                    sb.append(ManageBooksDlg.LABEL_LOCKED);
                } else {
                    sb.append(COLUMN_NAMES_SEARCH[realColumnIndex]);
                }
                if (realColumnIndex + 1 == numCols) {
                    sb.append("\n");
                    continue;
                }
                sb.append("\t");
            }
            for (int i = 0; i < numBooks; ++i) {
                int row = ManageBooksDlg.this.searchBooksTable.convertRowIndexToModel(i);
                for (int j = 0; j < numCols; ++j) {
                    int realColumnIndex = ManageBooksDlg.this.searchBooksTable.convertColumnIndexToModel(j);
                    Object o = model.getValueAt(row, realColumnIndex);
                    if (null == o) {
                        o = "-";
                    }
                    if (ManageBooksDlg.COLUMN_NAME_OPEN.equals(COLUMN_NAMES_SEARCH[j])) continue;
                    sb.append(o.toString());
                    if (realColumnIndex + 1 == numCols) {
                        sb.append("\n");
                        continue;
                    }
                    sb.append("\t");
                }
            }
            JFileChooser dlg = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Export file", "txt");
            dlg.setFileFilter(filter);
            if (null != ManageBooksDlg.this.pm.getCurrentDirectory()) {
                dlg.setCurrentDirectory(ManageBooksDlg.this.pm.getCurrentDirectory());
            }
            if (0 != (rtrnVal = dlg.showSaveDialog(GUIManager.getManager().getFrame()))) {
                return;
            }
            File f = dlg.getSelectedFile();
            try {
                FileWriter fstream = new FileWriter(f);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write(sb.toString());
                out.close();
                JOptionPane.showMessageDialog(ManageBooksDlg.this.frame, ManageBooksDlg.MSG_SUCCESS_EXPORTED, ManageBooksDlg.MSG_HEADER_SEARCH_BOOKS, 1);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    class MyBooksTableModel
    extends BookTableModel {
        public MyBooksTableModel(ArrayList<Book> data, String[] columnNames, Class[] columnTypes) {
            super(data, columnNames, columnTypes);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Object o = this.getValueAt(row, col);
            return false != o instanceof Boolean;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Book aBook = (Book)this.data.get(row);
            String header = COLUMN_NAMES_MY_BOOKS[col];
            if (ManageBooksDlg.COLUMN_NAME_BOOK_ID.equals(header)) {
                return aBook.getId();
            }
            if (ManageBooksDlg.COLUMN_NAME_NAME.equals(header)) {
                return aBook.getName();
            }
            if (ManageBooksDlg.COLUMN_NAME_CURATION_STATUS.equals(header)) {
                return Book.getCurationStatusString((int)aBook.getCurationStatus());
            }
            if (ManageBooksDlg.COLUMN_NAME_OPEN.equals(header)) {
                return "";
            }
            if (ManageBooksDlg.COLUMN_NAME_UNLOCK.equals(header)) {
                return !this.locked[row];
            }
            System.out.println("MyBooksTableModel requesting data for unhandled column " + header);
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Object oldValue = this.getValueAt(row, col);
            if (!(oldValue instanceof Boolean)) {
                return;
            }
            this.locked[row] = (Boolean)value == false;
            this.fireTableCellUpdated(row, col);
        }

        public int getUnLockCol() {
            if (null == this.columnNames) {
                return -1;
            }
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (!this.columnNames[i].equals(ManageBooksDlg.COLUMN_NAME_UNLOCK)) continue;
                return i;
            }
            return -1;
        }

        public Vector getSelectedBooks() {
            Vector selectedBooks = new Vector();
            return selectedBooks;
        }
    }

    class SearchBookTableModel
    extends BookTableModel {
        HashSet<String> curatableBookSet;

        public SearchBookTableModel(ArrayList<Book> data, String[] columnNames, Class[] columnTypes) {
            super(data, columnNames, columnTypes);
            this.curatableBookSet = null;
            if (null == data || 0 == data.size()) {
                this.curatableBookSet = new HashSet();
            } else {
                this.curatableBookSet = ManageBooksDlg.this.pm.getCuratableBookSet();
                if (null == this.curatableBookSet) {
                    this.curatableBookSet = new HashSet();
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Object aValue = this.getValueAt(rowIndex, columnIndex);
            if (!(aValue instanceof Boolean)) {
                return false;
            }
            String header = COLUMN_NAMES_SEARCH[columnIndex];
            if (ManageBooksDlg.COLUMN_NAME_EXP_EVDNCE.equals(header)) {
                return false;
            }
            if (ManageBooksDlg.COLUMN_NAME_NOTES.equals(header)) {
                return false;
            }
            if (ManageBooksDlg.COLUMN_NAME_ORG.equals(header)) {
                return false;
            }
            if (ManageBooksDlg.COLUMN_NUM_LEAVES.equals(header)) {
                return false;
            }
            Book aBook = (Book)this.data.get(rowIndex);
            User u = aBook.getLockedBy();
            if (null == u) {
                return true;
            }
            User currentUser = ManageBooksDlg.this.pm.getUser();
            return true == currentUser.getloginName().equals(u.getloginName());
        }

        @Override
        public Object getValueAt(int row, int col) {
            Book aBook = (Book)this.data.get(row);
            String header = COLUMN_NAMES_SEARCH[col];
            if (ManageBooksDlg.COLUMN_NAME_BOOK_ID.equals(header)) {
                return aBook.getId();
            }
            if (ManageBooksDlg.COLUMN_NAME_NAME.equals(header)) {
                return aBook.getName();
            }
            if (ManageBooksDlg.COLUMN_NAME_EXP_EVDNCE.equals(header)) {
                String id = aBook.getId();
                if (null != id && this.curatableBookSet.contains(id)) {
                    return true;
                }
                return false;
            }
            if (ManageBooksDlg.COLUMN_NAME_NOTES.equals(header)) {
                String comment = aBook.getCommentUser();
                if (null != comment && 0 != comment.trim().length()) {
                    return true;
                }
                return false;
            }
            if (ManageBooksDlg.COLUMN_NAME_ORG.equals(header)) {
                HashSet orgSet = aBook.getOrgSet();
                if (null == orgSet || 0 == orgSet.size()) {
                    return "";
                }
                StringBuffer sb = new StringBuffer();
                boolean containsBacteria = false;
                boolean containsPlant = false;
                for (String bacteria : ManageBooksDlg.this.pm.getBacterialGenomes()) {
                    if (!orgSet.contains(bacteria)) continue;
                    containsBacteria = true;
                    break;
                }
                if (containsBacteria) {
                    sb.append(ManageBooksDlg.BACTERIAL_GENOME);
                }
                for (String plant : ManageBooksDlg.this.pm.getPlantGenomes()) {
                    if (!orgSet.contains(plant)) continue;
                    containsPlant = true;
                    break;
                }
                if (containsPlant) {
                    if (0 != sb.length()) {
                        sb.append(",");
                        sb.append(" ");
                    }
                    sb.append(ManageBooksDlg.PLANT_GENOME);
                }
                for (String org : ORG_LIST_SPECIAL) {
                    if (!orgSet.contains(org)) continue;
                    if (0 != sb.length()) {
                        sb.append(",");
                        sb.append(" ");
                    }
                    sb.append(org);
                }
                return sb.toString();
            }
            if (ManageBooksDlg.COLUMN_NUM_LEAVES.equals(header)) {
                return aBook.getNumLeaves();
            }
            if (ManageBooksDlg.COLUMN_NAME_CURATION_STATUS.equals(header)) {
                return Book.getCurationStatusString((int)aBook.getCurationStatus());
            }
            if (ManageBooksDlg.COLUMN_NAME_LOCKED_BY.equals(header)) {
                User u = aBook.getLockedBy();
                if (null == u) {
                    return "";
                }
                return u.getFirstName();
            }
            if (ManageBooksDlg.COLUMN_NAME_DATE.equals(header)) {
                return aBook.getCurationStatusUpdateDate();
            }
            if (ManageBooksDlg.COLUMN_NAME_DATE_ANNOTATION.equals(header)) {
                return aBook.getLastAnnotationUpdateDate();
            }
            if (ManageBooksDlg.COLUMN_NAME_OPEN.equals(header)) {
                return "";
            }
            if (ManageBooksDlg.COLUMN_NAME_LOCK_UNLOCK.equals(header)) {
                return this.locked[row];
            }
            System.out.println("Search books model requesting data for unhandled column " + header);
            return null;
        }
    }

    abstract class BookTableModel
    extends AbstractTableModel {
        protected ArrayList<Book> data = null;
        protected String[] columnNames = null;
        protected Class[] columnTypes;
        protected boolean[] locked = null;

        BookTableModel(ArrayList<Book> data, String[] columnNames, Class[] columnTypes) {
            this.data = data;
            this.columnNames = columnNames;
            this.columnTypes = columnTypes;
            if (null == data) {
                return;
            }
            int size = data.size();
            this.locked = new boolean[size];
            for (int i = 0; i < size; ++i) {
                Book aBook = data.get(i);
                if (null == aBook) continue;
                User aUser = aBook.getLockedBy();
                this.locked[i] = null != aUser;
            }
        }

        public Book getBookAtRow(int row) {
            return this.data.get(row);
        }

        Vector<String> booksForLocking() {
            if (null == this.data) {
                return null;
            }
            Vector<String> lockBooksList = new Vector<String>();
            for (int i = 0; i < this.locked.length; ++i) {
                Book aBook;
                User u;
                if (!this.locked[i] || null != (u = (aBook = this.data.get(i)).getLockedBy())) continue;
                lockBooksList.add(aBook.getId());
            }
            return lockBooksList;
        }

        Vector<String> booksForUnlocking(String loginName) {
            if (null == this.data || null == loginName) {
                return null;
            }
            Vector<String> unlockBooksList = new Vector<String>();
            for (int i = 0; i < this.locked.length; ++i) {
                Book aBook;
                User u;
                if (this.locked[i] || null == (u = (aBook = this.data.get(i)).getLockedBy()) || !u.getloginName().equals(loginName)) continue;
                unlockBooksList.add(aBook.getId());
            }
            return unlockBooksList;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return this.columnTypes[c];
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Object oldValue;
            if (ManageBooksDlg.this.DEBUG) {
                // empty if block
            }
            if (!((oldValue = this.getValueAt(row, col)) instanceof Boolean)) {
                return;
            }
            this.locked[row] = (Boolean)value;
            this.fireTableCellUpdated(row, col);
        }

        private void printDebugData() {
        }
    }
}

