/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import com.sri.panther.paintCommon.Book;
import edu.usc.ksom.pm.panther.paintCommon.DataTransferObj;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.paint.config.PantherDbInfo;
import org.paint.config.Preferences;
import org.paint.dataadapter.PantherServer;
import org.paint.main.PaintManager;
import org.paint.util.SpringUtilities;

public class NewFamily
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel openFamilyPanel;
    private JPanel booksPanel;
    private JPanel bookListPanel;
    private JTextField searchTerm;
    private JRadioButton geneSymbolBtn;
    private JRadioButton geneIdentifierBtn;
    private JRadioButton proteinIdentifierBtn;
    private JRadioButton definitionBtn;
    protected JComboBox pickBook;
    protected JTable familyTable;
    protected JButton openBtn;
    protected JButton submitBtn;
    private JLabel status_message;
    private static final String MSG_PLEASE_ENTER_SEARCH_TERM = "Please enter a search term";
    private static final String MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS = "Server returned error, cannot search for protein family";
    private static final String MSG_NO_BOOKS_FOR_SEARCH_CRITERIA = "No protein families found matching search criteria";
    private static final String LABEL_ENTER = "Search for";
    private static final String LABEL_SEARCH = "Search";
    private static final String LABEL_CANCEL = "Cancel";
    private static final String LABEL_OPEN = "Open";
    private static final String LABEL_PICK_ID = "Or Pick family ID";
    private static final String LABEL_SEARCH_GENE_SYMBOL = "Gene Symbol";
    private static final String LABEL_SEARCH_GENE_IDENTIFIER = "Gene Identifier";
    private static final String LABEL_SEARCH_PROTEIN_IDENTIFIER = "Protein Identifier";
    private static final String LABEL_SEARCH_DEFINITION = "Definition (partial def supported)";
    private static final String LABEL_TITLE = "Open Protein Family";
    private static final String[] COLUMN_NAMES = new String[]{"PANTHER Id", "Protein Family Name"};
    private ArrayList<Book> bookList;
    String openBookId = null;
    private static Logger log = Logger.getLogger(NewFamily.class);

    public NewFamily(Frame frame) {
        super(frame, true);
        this.setTitle(LABEL_TITLE);
        this.bookList = new ArrayList();
        this.openFamilyPanel = new JPanel();
        this.openFamilyPanel.setLayout(new BorderLayout());
        this.openFamilyPanel.add((Component)this.initializeChoicePanel(), "North");
        this.openFamilyPanel.add((Component)this.initializeBookListPanel(), "Center");
        this.openFamilyPanel.add((Component)this.initializeControlPanel(), "South");
        this.setContentPane(this.openFamilyPanel);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private JPanel initializeChoicePanel() {
        JPanel choicePanel = new JPanel();
        choicePanel.setLayout(new SpringLayout());
        JLabel label = new JLabel(LABEL_ENTER);
        choicePanel.add(label);
        this.searchTerm = new JTextField(20);
        this.searchTerm.addActionListener(new BooksListActionListener());
        label.setLabelFor(this.searchTerm);
        choicePanel.add(this.searchTerm);
        choicePanel.add(this.getSearchButton());
        choicePanel.add(this.getSearchTypePanel());
        label = new JLabel(LABEL_PICK_ID);
        choicePanel.add(label);
        JComboBox bookBox = this.getBookBox();
        label.setLabelFor(bookBox);
        choicePanel.add(bookBox);
        SpringUtilities.makeCompactGrid(choicePanel, 3, 2, 6, 6, 6, 6);
        return choicePanel;
    }

    private JComboBox getBookBox() {
        this.pickBook = new JComboBox<String>(this.getBooks());
        this.pickBook.setEditable(true);
        this.pickBook.setMaximumRowCount(10);
        this.pickBook.setName(LABEL_PICK_ID);
        this.pickBook.setAlignmentY(0.0f);
        this.pickBook.addActionListener(this);
        return this.pickBook;
    }

    private JPanel getSearchButton() {
        this.submitBtn = new JButton(LABEL_SEARCH);
        this.submitBtn.addActionListener(new BooksListActionListener());
        JPanel searchBtnPanel = new JPanel();
        searchBtnPanel.setLayout(new BoxLayout(searchBtnPanel, 2));
        searchBtnPanel.add(this.submitBtn);
        return searchBtnPanel;
    }

    private JPanel getSearchTypePanel() {
        JPanel searchTypePanel = new JPanel(new GridLayout(4, 1));
        this.geneSymbolBtn = new JRadioButton(LABEL_SEARCH_GENE_SYMBOL);
        this.geneIdentifierBtn = new JRadioButton(LABEL_SEARCH_GENE_IDENTIFIER);
        this.proteinIdentifierBtn = new JRadioButton(LABEL_SEARCH_PROTEIN_IDENTIFIER);
        this.definitionBtn = new JRadioButton(LABEL_SEARCH_DEFINITION);
        this.geneSymbolBtn.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.geneSymbolBtn);
        bg.add(this.geneIdentifierBtn);
        bg.add(this.proteinIdentifierBtn);
        bg.add(this.definitionBtn);
        searchTypePanel.add(this.geneSymbolBtn);
        searchTypePanel.add(this.geneIdentifierBtn);
        searchTypePanel.add(this.proteinIdentifierBtn);
        searchTypePanel.add(this.definitionBtn);
        return searchTypePanel;
    }

    protected void initializeBooksList(ArrayList<Book> books) {
        BookTableModel book_list = new BookTableModel(books, COLUMN_NAMES);
        this.familyTable.setModel(book_list);
        book_list.fireTableChanged(new TableModelEvent(book_list));
    }

    protected JPanel initializeBookListPanel() {
        this.bookListPanel = new JPanel();
        this.bookListPanel.setLayout(new BoxLayout(this.bookListPanel, 1));
        this.familyTable = new JTable();
        this.initializeBooksList(this.bookList);
        this.familyTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.familyTable.setSelectionMode(0);
        JScrollPane familiesScrollPane = new JScrollPane(this.familyTable);
        this.familyTable.addMouseListener(this.getMouseListener());
        JLabel lockedBooksLabel = new JLabel("Search Results");
        lockedBooksLabel.setPreferredSize(lockedBooksLabel.getPreferredSize());
        this.bookListPanel.add(lockedBooksLabel);
        this.bookListPanel.add(familiesScrollPane);
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 1));
        containerPanel.add(this.bookListPanel);
        this.booksPanel = new JPanel();
        this.booksPanel.setLayout(new BorderLayout());
        this.booksPanel.add((Component)containerPanel, "West");
        return this.booksPanel;
    }

    private JPanel initializeControlPanel() {
        JButton cancelBtn = new JButton(LABEL_CANCEL);
        cancelBtn.addActionListener(this);
        this.openBtn = new JButton(LABEL_OPEN);
        this.openBtn.addActionListener(this);
        this.openBtn.setEnabled(this.bookList.size() > 0);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(cancelBtn);
        buttonPanel.add(this.openBtn);
        this.status_message = new JLabel();
        this.status_message.setText(null);
        controlPanel.add((Component)buttonPanel, "North");
        controlPanel.add((Component)this.status_message, "South");
        return controlPanel;
    }

    private MouseListener getMouseListener() {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = NewFamily.this.familyTable.rowAtPoint(e.getPoint());
                    NewFamily.this.openBook(row);
                } else {
                    NewFamily.this.openBtn.setEnabled(NewFamily.this.familyTable.getSelectedRow() >= 0);
                }
            }
        };
        return mouseListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LABEL_OPEN.equals(e.getActionCommand())) {
            int row = this.familyTable.getSelectedRow();
            if (row >= 0) {
                this.openBook(row);
            }
        } else if (e.getActionCommand().equals(LABEL_CANCEL)) {
            this.openBookId = null;
            this.setVisible(false);
        } else if (e.getActionCommand().equals("comboBoxChanged") && this.pickBook.getSelectedIndex() >= 0) {
            String book_id = (String)this.pickBook.getSelectedItem();
            Book fake_book = new Book(book_id, "", 0, null);
            this.bookList.clear();
            this.bookList.add(fake_book);
            this.initializeBooksList(this.bookList);
        }
    }

    protected void openBook(int row) {
        this.setVisible(false);
        Book book = this.bookList.get(row);
        this.openBookId = book.getId();
    }

    public String display() {
        this.setVisible(true);
        return this.openBookId;
    }

    private String[] getBooks() {
        Vector<String> sendInfo = new Vector<String>();
        sendInfo.add(PantherDbInfo.getDbAndVersionKey());
        DataTransferObj dto = new DataTransferObj();
        dto.setVc(PaintManager.inst().getVersionContainer());
        dto.setObj(sendInfo);
        String servletUrl = Preferences.inst().getPantherURL();
        DataTransferObj infoFromServer = PantherServer.inst().searchAllBooks(Preferences.inst().getPantherURL(), dto, null, null);
        if (null == infoFromServer) {
            this.status_message.setText(MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS);
            return new String[0];
        }
        StringBuffer sb = infoFromServer.getMsg();
        if (null != sb && 0 != sb.length()) {
            this.status_message.setText(sb.toString());
            return new String[0];
        }
        Vector serverRtnList = (Vector)infoFromServer.getObj();
        if (null == serverRtnList || 2 < serverRtnList.size()) {
            this.status_message.setText(MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS);
            return new String[0];
        }
        ArrayList bookList = (ArrayList)serverRtnList.get(1);
        if (null == bookList) {
            return new String[0];
        }
        String[] bookArray = new String[bookList.size()];
        for (int i = 0; i < bookList.size(); ++i) {
            bookArray[i] = ((Book)bookList.get(i)).getId();
        }
        return bookArray;
    }

    public class BooksListActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            NewFamily.this.status_message.setText("");
            String searchStr = NewFamily.this.searchTerm.getText();
            if (null == searchStr || 0 == searchStr.length()) {
                NewFamily.this.status_message.setText(NewFamily.MSG_PLEASE_ENTER_SEARCH_TERM);
                return;
            }
            Vector<String> sendInfo = new Vector<String>(2);
            sendInfo.add(searchStr);
            sendInfo.add(PantherDbInfo.getDbAndVersionKey());
            DataTransferObj dto = new DataTransferObj();
            dto.setVc(PaintManager.inst().getVersionContainer());
            dto.setObj(sendInfo);
            String servletUrl = Preferences.inst().getPantherURL();
            NewFamily.this.bookList.clear();
            DataTransferObj infoFromServer = null;
            NewFamily.this.submitBtn.setSelected(true);
            PantherServer server = PantherServer.inst();
            infoFromServer = NewFamily.this.geneSymbolBtn.isSelected() ? server.searchGeneName(servletUrl, dto, null, null) : (NewFamily.this.geneIdentifierBtn.isSelected() ? server.searchGeneExtId(servletUrl, dto, null, null) : (NewFamily.this.proteinIdentifierBtn.isSelected() ? server.searchProteinExtId(servletUrl, dto, null, null) : server.searchDefinition(servletUrl, dto, null, null)));
            if (null == infoFromServer) {
                NewFamily.this.status_message.setText(NewFamily.MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS);
                NewFamily.this.initializeBooksList(NewFamily.this.bookList);
                NewFamily.this.submitBtn.setSelected(false);
                return;
            }
            StringBuffer sb = infoFromServer.getMsg();
            if (null != sb && 0 != sb.length()) {
                NewFamily.this.status_message.setText(sb.toString());
                NewFamily.this.initializeBooksList(NewFamily.this.bookList);
                NewFamily.this.submitBtn.setSelected(false);
                return;
            }
            Vector serverRtnList = (Vector)infoFromServer.getObj();
            if (null == serverRtnList || 2 < serverRtnList.size()) {
                NewFamily.this.status_message.setText(NewFamily.MSG_SERVER_ERROR_CANNOT_SEARCH_BOOKS);
                NewFamily.this.initializeBooksList(NewFamily.this.bookList);
                NewFamily.this.submitBtn.setSelected(false);
                return;
            }
            ArrayList bookList = (ArrayList)serverRtnList.get(1);
            int numBooks = bookList.size();
            if (0 == numBooks) {
                NewFamily.this.status_message.setText(NewFamily.MSG_NO_BOOKS_FOR_SEARCH_CRITERIA);
            }
            NewFamily.this.initializeBooksList(bookList);
            NewFamily.this.submitBtn.setSelected(false);
        }
    }

    private class BookTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        protected ArrayList<Book> bookList = null;
        protected String[] columnNames = null;

        BookTableModel(ArrayList<Book> bookList, String[] columnNames) {
            this.bookList = bookList;
            this.columnNames = columnNames;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.bookList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Book book = this.bookList.get(rowIndex);
            if (columnIndex == 0) {
                return book.getId();
            }
            return book.getName();
        }
    }
}

