/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import edu.usc.ksom.pm.panther.paintCommon.Evidence;
import edu.usc.ksom.pm.panther.paintCommon.Organism;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.paint.main.PaintManager;

public class OrgEvidenceDlg
extends JDialog {
    protected Frame frame;
    protected JPanel orgEvdnecePanel;
    protected String servletUrl;
    public static final String COLUMN_NAME_ORGANISM = "Organism";
    protected static final ArrayList<String> EXP_EVIDENCE = new ArrayList(Evidence.getExperimental());
    private String LABEL_TITLE = "Select Organisms with Experimental Evidence codes that are not to be displayed in the annotation matrix";
    private String LABEL_INST_SELECT_CLEAR_ALL = "Click on an organism label or an evidence code for option to select all or clear all";
    public static final String LABEL_SUBMIT = "Submit";
    public static final String LABEL_CLEAR = "Clear All";
    private ArrayList<String> colHeaders = null;
    private ArrayList<Class> colTypes = null;
    private JTable orgTable = null;
    private boolean changes = false;

    public OrgEvidenceDlg(Frame frame, String servletUrl, Vector userInfo) {
        super(frame, true);
        this.setTitle(this.LABEL_TITLE);
        this.frame = frame;
        this.servletUrl = servletUrl;
        this.initializePanel();
    }

    protected void initializePanel() {
        this.orgEvdnecePanel = new JPanel();
        this.orgEvdnecePanel.setLayout(new BoxLayout(this.orgEvdnecePanel, 1));
        JLabel instLbl = new JLabel(this.LABEL_INST_SELECT_CLEAR_ALL);
        instLbl.setAlignmentX(0.0f);
        this.orgEvdnecePanel.add(instLbl);
        Collections.sort(EXP_EVIDENCE);
        this.colHeaders = new ArrayList<String>(EXP_EVIDENCE);
        this.colHeaders.add(0, COLUMN_NAME_ORGANISM);
        this.colTypes = new ArrayList(this.colHeaders.size());
        this.colTypes.add(String.class);
        for (int i = 1; i < this.colHeaders.size(); ++i) {
            this.colTypes.add(Boolean.class);
        }
        PaintManager pm = PaintManager.inst();
        ArrayList<Organism> allOrgs = pm.getAllOrgList();
        Collections.sort(allOrgs, new Comparator<Organism>(){

            @Override
            public int compare(Organism org1, Organism org2) {
                int rank2;
                Organism comp1 = org1;
                Organism comp2 = org2;
                int rank1 = comp1.getLogicalRank();
                if (rank1 == (rank2 = comp2.getLogicalRank())) {
                    return comp1.getLongName().compareTo(comp2.getLongName());
                }
                if (rank1 > rank2) {
                    return 1;
                }
                return -1;
            }
        });
        Hashtable<Object, HashSet<String>> nonDisplay = pm.getnonDisplayedAnnotMatrixOrgToEvdnceLookup();
        if (null == nonDisplay) {
            nonDisplay = new Hashtable();
        }
        ArrayList<HashMap<Organism, LinkedHashMap<String, Boolean>>> allOrgsList = new ArrayList<HashMap<Organism, LinkedHashMap<String, Boolean>>>();
        for (Organism o : allOrgs) {
            if (null == o.getName()) continue;
            HashSet<String> nonDisplaySet = nonDisplay.get(o);
            LinkedHashMap<String, Boolean> lookup = new LinkedHashMap<String, Boolean>();
            for (String s : this.colHeaders) {
                boolean value = false;
                if (null != nonDisplaySet && nonDisplaySet.contains(s)) {
                    value = true;
                }
                lookup.put(s, value);
            }
            HashMap<Organism, LinkedHashMap<String, Boolean>> currentLookup = new HashMap<Organism, LinkedHashMap<String, Boolean>>();
            currentLookup.put(o, lookup);
            allOrgsList.add(currentLookup);
        }
        this.orgTable = new JTable(new OrganismTableModel(allOrgsList, this.colHeaders, this.colTypes)){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                int selectedRow;
                Component comp = super.prepareRenderer(renderer, rowIndex, vColIndex);
                int row = OrgEvidenceDlg.this.orgTable.convertRowIndexToModel(rowIndex);
                if (row == (selectedRow = super.getSelectedRow())) {
                    return comp;
                }
                comp.setBackground(row % 2 == 0 ? Color.LIGHT_GRAY : Color.WHITE);
                return comp;
            }
        };
        this.orgTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                Point p = e.getPoint();
                int rowIndex = OrgEvidenceDlg.this.orgTable.rowAtPoint(p);
                int colIndex = OrgEvidenceDlg.this.orgTable.columnAtPoint(p);
                int realRowIndex = OrgEvidenceDlg.this.orgTable.convertRowIndexToModel(rowIndex);
                int selectedRow = OrgEvidenceDlg.this.orgTable.getSelectedRow();
                if (selectedRow != realRowIndex) {
                    return;
                }
                int realColumnIndex = OrgEvidenceDlg.this.orgTable.convertColumnIndexToModel(colIndex);
                if (realColumnIndex > 0) {
                    return;
                }
                SelectClearPopUpMenu pm = new SelectClearPopUpMenu(realRowIndex, -1, false);
                pm.showMenu(e);
            }
        });
        this.orgTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                Point p = e.getPoint();
                int colIndex = OrgEvidenceDlg.this.orgTable.columnAtPoint(p);
                int realColumnIndex = OrgEvidenceDlg.this.orgTable.convertColumnIndexToModel(colIndex);
                if (realColumnIndex == 0) {
                    return;
                }
                SelectClearPopUpMenu pm = new SelectClearPopUpMenu(-1, realColumnIndex, true);
                pm.showMenu(e);
            }
        });
        this.setColumnWidthForOrgColumn(this.orgTable);
        this.orgTable.setPreferredScrollableViewportSize(new Dimension(750, 90));
        JScrollPane orgScrollPane = new JScrollPane(this.orgTable);
        orgScrollPane.setAlignmentX(0.0f);
        this.orgEvdnecePanel.add(orgScrollPane);
        JButton submitBtn = new JButton(LABEL_SUBMIT);
        submitBtn.addActionListener(new UpdateChoices());
        JPanel choicesPanel = new JPanel();
        choicesPanel.setAlignmentX(0.0f);
        choicesPanel.add(submitBtn);
        JButton clearBtn = new JButton(LABEL_CLEAR);
        clearBtn.addActionListener(new ClearChoices());
        choicesPanel.add(clearBtn);
        this.orgEvdnecePanel.add(choicesPanel);
        this.setContentPane(this.orgEvdnecePanel);
        Rectangle r = this.frame.getBounds();
        this.setBounds(r.x + r.width / 2, r.y + r.height / 2, 1000, 800);
        this.pack();
        this.setLocationRelativeTo(this.frame);
    }

    public void setColumnWidthForOrgColumn(JTable orgTable) {
        if (null == orgTable) {
            return;
        }
        TableColumnModel col_model = orgTable.getColumnModel();
        FontMetrics fm = orgTable.getFontMetrics(orgTable.getFont());
        int numRows = orgTable.getRowCount();
        int colIndex = 0;
        int maxWidth = 0;
        for (int i = 0; i < numRows; ++i) {
            int curWidth = fm.stringWidth((String)orgTable.getValueAt(i, colIndex));
            if (maxWidth >= curWidth) continue;
            maxWidth = curWidth;
        }
        TableColumn orgColumn = col_model.getColumn(colIndex);
        orgColumn.setPreferredWidth(maxWidth);
        orgColumn.setWidth(maxWidth);
        int numCols = orgTable.getColumnCount();
        for (int i = 1; i < numCols; ++i) {
            int width = fm.stringWidth(this.colHeaders.get(i));
            TableColumn curModel = col_model.getColumn(i);
            curModel.setWidth(width);
            curModel.setPreferredWidth(width);
        }
    }

    public boolean display() {
        this.setVisible(true);
        return this.changes;
    }

    public class SelectClearPopUpMenu
    extends JPopupMenu
    implements ActionListener {
        int row;
        int col;
        boolean isHeader;
        public static final String STR_SELECT_ALL = "Select All";
        public static final String STR_CLEAR_ALL = "Clear All";

        public SelectClearPopUpMenu(int row, int col, boolean isHeader) {
            super("");
            this.row = row;
            this.col = col;
            this.isHeader = isHeader;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            OrganismTableModel otm = (OrganismTableModel)OrgEvidenceDlg.this.orgTable.getModel();
            if (STR_SELECT_ALL.equals(command)) {
                if (this.isHeader) {
                    otm.setValueForCol(this.col, Boolean.TRUE);
                } else {
                    otm.setValueForRow(this.row, Boolean.TRUE);
                }
            } else if ("Clear All".equals(command)) {
                if (this.isHeader) {
                    otm.setValueForCol(this.col, Boolean.FALSE);
                } else {
                    otm.setValueForRow(this.row, Boolean.FALSE);
                }
            }
        }

        public void showMenu(MouseEvent e) {
            JMenuItem mi = new JMenuItem(STR_SELECT_ALL);
            mi.setActionCommand(STR_SELECT_ALL);
            mi.addActionListener(this);
            this.add(mi);
            mi = new JMenuItem("Clear All");
            mi.setActionCommand("Clear All");
            mi.addActionListener(this);
            this.add(mi);
            this.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public class ClearChoices
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            OrganismTableModel model = (OrganismTableModel)OrgEvidenceDlg.this.orgTable.getModel();
            ArrayList<HashMap<Organism, LinkedHashMap<String, Boolean>>> dataLookup = model.data;
            for (HashMap<Organism, LinkedHashMap<String, Boolean>> nonDisplayItem : dataLookup) {
                for (Map.Entry<Organism, LinkedHashMap<String, Boolean>> current : nonDisplayItem.entrySet()) {
                    Organism o = current.getKey();
                    LinkedHashMap<String, Boolean> lookups = current.getValue();
                    for (Map.Entry<String, Boolean> lookup : lookups.entrySet()) {
                        if (!lookup.getValue().booleanValue()) continue;
                        lookups.put(lookup.getKey(), Boolean.FALSE);
                    }
                }
            }
            model.fireTableDataChanged();
        }
    }

    public class UpdateChoices
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            OrganismTableModel model = (OrganismTableModel)OrgEvidenceDlg.this.orgTable.getModel();
            ArrayList<HashMap<Organism, LinkedHashMap<String, Boolean>>> dataLookup = model.data;
            Hashtable<Organism, HashSet<String>> nonDisplayedAnnotMatrixOrgToEvdnceLookup = new Hashtable<Organism, HashSet<String>>();
            for (HashMap<Organism, LinkedHashMap<String, Boolean>> nonDisplayItem : dataLookup) {
                for (Map.Entry<Organism, LinkedHashMap<String, Boolean>> current : nonDisplayItem.entrySet()) {
                    Organism o = current.getKey();
                    LinkedHashMap<String, Boolean> lookups = current.getValue();
                    HashSet<String> nonDisplay = new HashSet<String>();
                    for (Map.Entry<String, Boolean> lookup : lookups.entrySet()) {
                        if (!lookup.getValue().booleanValue()) continue;
                        nonDisplay.add(lookup.getKey());
                    }
                    if (nonDisplay.isEmpty()) continue;
                    nonDisplayedAnnotMatrixOrgToEvdnceLookup.put(o, nonDisplay);
                }
            }
            if (nonDisplayedAnnotMatrixOrgToEvdnceLookup.isEmpty()) {
                nonDisplayedAnnotMatrixOrgToEvdnceLookup = null;
            }
            PaintManager.inst().setnonDisplayedAnnotMatrixOrgToEvdnceLookup(nonDisplayedAnnotMatrixOrgToEvdnceLookup);
            OrgEvidenceDlg.this.changes = true;
            OrgEvidenceDlg.this.setVisible(false);
        }
    }

    public class OrganismTableModel
    extends AbstractTableModel {
        protected ArrayList<HashMap<Organism, LinkedHashMap<String, Boolean>>> data = null;
        protected ArrayList<String> columnNames = null;
        protected ArrayList<Class> columnTypes;

        OrganismTableModel(ArrayList<HashMap<Organism, LinkedHashMap<String, Boolean>>> data, ArrayList<String> columnNames, ArrayList<Class> columnTypes) {
            this.data = data;
            this.columnNames = columnNames;
            this.columnTypes = columnTypes;
        }

        public HashMap<Organism, LinkedHashMap<String, Boolean>> getInfoAtRot(int row) {
            return this.data.get(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        public Class getColumnClass(int c) {
            return this.columnTypes.get(c);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        public void setValueForCol(int col, Boolean value) {
            for (int i = 0; i < this.data.size(); ++i) {
                this.setValueAt(value, i, col);
            }
        }

        public void setValueForRow(int row, Boolean value) {
            for (int i = 0; i < this.columnNames.size(); ++i) {
                this.setValueAt(value, row, i);
            }
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Object oldValue = this.getValueAt(row, col);
            if (!(oldValue instanceof Boolean)) {
                return;
            }
            HashMap<Organism, LinkedHashMap<String, Boolean>> current = this.data.get(row);
            String colHeader = this.columnNames.get(col);
            Iterator<Map.Entry<Organism, LinkedHashMap<String, Boolean>>> iterator = current.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<Organism, LinkedHashMap<String, Boolean>> entry = iterator.next();
                LinkedHashMap<String, Boolean> lookup = entry.getValue();
                lookup.put(colHeader, (Boolean)value);
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || columnIndex < 0) {
                return null;
            }
            HashMap<Organism, LinkedHashMap<String, Boolean>> currentRow = this.data.get(rowIndex);
            String colHeader = this.columnNames.get(columnIndex);
            Iterator<Map.Entry<Organism, LinkedHashMap<String, Boolean>>> iterator = currentRow.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<Organism, LinkedHashMap<String, Boolean>> entry = iterator.next();
                if (OrgEvidenceDlg.COLUMN_NAME_ORGANISM.equals(colHeader)) {
                    Organism o = entry.getKey();
                    return o.getLongName() + " (" + o.getShortName() + ")";
                }
                LinkedHashMap<String, Boolean> lookup = entry.getValue();
                return lookup.get(colHeader);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            String colHeader = this.columnNames.get(columnIndex);
            return !OrgEvidenceDlg.COLUMN_NAME_ORGANISM.equals(colHeader);
        }
    }
}

