/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import com.sri.panther.paintCommon.FixedInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.paint.config.PantherDbInfo;
import org.paint.config.Preferences;
import org.paint.dataadapter.PantherServer;
import org.paint.util.LoginUtil;

public class PantherURLSelectionDlg
extends JDialog {
    private FixedInfo fi;
    private JTable table;
    private JTextField panther_url;
    private JButton saveChoices;
    private JLabel status;

    public PantherURLSelectionDlg(Frame frame) {
        super(frame, true);
        this.setTitle("Panther DB URL Selection");
        JPanel mainPanel = new JPanel();
        BoxLayout layout = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(layout);
        JPanel versionPanel = this.initVersionPanel();
        JPanel decisionPanel = this.initButtonPanel();
        mainPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        mainPanel.add(versionPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        mainPanel.add(decisionPanel);
        this.setContentPane(mainPanel);
        this.getRootPane().setDefaultButton(this.saveChoices);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private JPanel initVersionPanel() {
        JLabel url_label = new JLabel("URL");
        JLabel vers_label = new JLabel("Versions");
        this.status = new JLabel("");
        this.status.setForeground(Color.red);
        this.panther_url = new JTextField(Preferences.inst().getPantherURL());
        this.panther_url.addActionListener(new SetURLActionListener());
        this.panther_url.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.panther_url.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    PantherURLSelectionDlg.this.updateURL();
                }
            }
        });
        this.fi = PantherDbInfo.getFixedInfo();
        URLTableModel model = new URLTableModel(PantherDbInfo.getVersions());
        this.table = new JTable(model);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        int row = model.findInitialRow();
        this.table.setRowSelectionInterval(row, row);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        url_label.setLabelFor(this.panther_url);
        vers_label.setLabelFor(scrollPane);
        JPanel label_pane = new JPanel();
        label_pane.setLayout(new BoxLayout(label_pane, 1));
        label_pane.add(Box.createVerticalStrut(12));
        label_pane.add(url_label);
        label_pane.add(Box.createVerticalGlue());
        label_pane.add(vers_label);
        label_pane.add(Box.createVerticalStrut(12));
        JPanel select_pane = new JPanel();
        select_pane.setLayout(new BoxLayout(select_pane, 1));
        select_pane.add(Box.createHorizontalStrut(12));
        select_pane.add(this.status);
        select_pane.add(Box.createVerticalStrut(12));
        select_pane.add(this.panther_url);
        select_pane.add(Box.createVerticalGlue());
        select_pane.add(scrollPane);
        select_pane.add(Box.createVerticalStrut(12));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(12));
        panel.add(label_pane);
        panel.add(Box.createHorizontalStrut(12));
        panel.add(select_pane);
        panel.add(Box.createHorizontalStrut(12));
        return panel;
    }

    private JPanel initButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.saveChoices = new JButton("OK");
        this.saveChoices.addActionListener(new OKButtonActionListener());
        JButton cancelChoices = new JButton("Cancel");
        cancelChoices.addActionListener(new CancelButtonActionListener());
        panel.add(Box.createHorizontalGlue());
        panel.add(this.saveChoices);
        panel.add(Box.createHorizontalStrut(12));
        panel.add(cancelChoices);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public void display() {
        this.setVisible(true);
    }

    protected void saveChoice() {
        if (this.updateURL()) {
            LoginUtil.logout();
            int row = this.table.getSelectedRow();
            String pantherURL = this.panther_url.getText();
            Preferences.inst().setPantherURL(pantherURL);
            String selection = this.table.getValueAt(row, 0) + "|" + this.table.getValueAt(row, 1);
            PantherDbInfo.setFixedInfo(this.fi);
            LoginUtil.login();
        }
    }

    private boolean updateURL() {
        int row;
        String pantherURL = this.panther_url.getText();
        this.fi = PantherServer.inst().getFixedInfoFromServer(pantherURL);
        URLTableModel model = (URLTableModel)this.table.getModel();
        if (this.fi != null) {
            this.status.setText("");
            row = model.setData(this.fi.getDbToUploadInfo());
        } else {
            this.status.setText(PantherServer.inst().getServerStatus());
            row = model.setData(null);
        }
        if (row >= 0) {
            this.table.setRowSelectionInterval(row, row);
        }
        return this.fi != null;
    }

    class URLTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Database", "Version", "Date"};
        String[][] rowData;

        public URLTableModel(Hashtable<String, Hashtable<String, Vector<String>>> dbToUPLTable) {
            this.setData(dbToUPLTable);
        }

        public int findInitialRow() {
            int selected_row = -1;
            if (this.rowData != null) {
                String currentDB = PantherDbInfo.getCurrentDB();
                String currentVersion = PantherDbInfo.getCurrentVersionName();
                for (int row = 0; row < this.rowData.length && selected_row < 0; ++row) {
                    if (!this.rowData[row][0].equals(currentDB) || !this.rowData[row][1].equals(currentVersion)) continue;
                    selected_row = row;
                }
            }
            return selected_row;
        }

        public int setData(Hashtable<String, Hashtable<String, Vector<String>>> dbToUPLTable) {
            if (dbToUPLTable == null) {
                this.rowData = null;
                return -1;
            }
            Set<String> db_names = dbToUPLTable.keySet();
            int row_count = 0;
            for (String db_name : db_names) {
                Hashtable<String, Vector<String>> versions = dbToUPLTable.get(db_name);
                Set<String> version_keys = versions.keySet();
                row_count += version_keys.size();
            }
            this.rowData = new String[row_count][3];
            int row = 0;
            int selected_row = 0;
            String currentDB = PantherDbInfo.getCurrentDB();
            String currentVersion = PantherDbInfo.getCurrentVersionName();
            int db_width = 0;
            int v_width = 0;
            for (String db_name : db_names) {
                if (db_name.length() > db_width) {
                    db_width = db_name.length();
                }
                Hashtable<String, Vector<String>> versions = dbToUPLTable.get(db_name);
                Set<String> version_keys = versions.keySet();
                for (String v_key : version_keys) {
                    String vers_name;
                    this.rowData[row][0] = db_name;
                    this.rowData[row][1] = vers_name = versions.get(v_key).firstElement();
                    String vers_date = versions.get(v_key).lastElement();
                    String string = this.rowData[row][2] = vers_date != null ? vers_date : "";
                    if (db_name.equals(currentDB) && vers_name.equals(currentVersion)) {
                        selected_row = row;
                    }
                    if (vers_name.length() > v_width) {
                        v_width = versions.get(v_key).firstElement().length();
                    }
                    ++row;
                }
            }
            this.fireTableDataChanged();
            return selected_row;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        @Override
        public int getRowCount() {
            if (this.rowData != null) {
                return this.rowData.length;
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.rowData != null) {
                return this.rowData[row][col];
            }
            return null;
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PantherURLSelectionDlg.this.setVisible(false);
        }
    }

    private class OKButtonActionListener
    implements ActionListener {
        private OKButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PantherURLSelectionDlg.this.saveChoice();
            PantherURLSelectionDlg.this.setVisible(false);
        }
    }

    private class SetURLActionListener
    implements ActionListener {
        private SetURLActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PantherURLSelectionDlg.this.updateURL();
        }
    }
}

