/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.geneontology.db.model.Term;
import org.paint.datamodel.GeneNode;
import org.paint.util.RenderUtil;

public class QualifierDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Map<JCheckBox, Term> selections;
    Set<Term> qual_list;

    public QualifierDialog(Frame frame, Map<Term, Set<GeneNode>> qual2node) {
        super(frame, true);
        this.setLayout(new BorderLayout());
        this.setContentPane(this.qualifyPane(qual2node));
        this.qual_list = new HashSet<Term>();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public Set<Term> getQualifiers() {
        this.setVisible(true);
        return this.qual_list;
    }

    private JPanel qualifyPane(Map<Term, Set<GeneNode>> qual2node) {
        JPanel qualify = new JPanel();
        qualify.setLayout(new BoxLayout(qualify, 3));
        JPanel selectionPane = this.createSelectionPane(qual2node);
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(true);
        buttonPane.setBackground(RenderUtil.getAspectColor());
        JButton doneButton = null;
        doneButton = new JButton("Continue");
        doneButton.addActionListener(this);
        this.getRootPane().setDefaultButton(doneButton);
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(doneButton);
        qualify.add(selectionPane);
        qualify.add(buttonPane);
        return qualify;
    }

    private JPanel createSelectionPane(Map<Term, Set<GeneNode>> qual2node) {
        String description = qual2node.size() == 1 ? "Check the box if you also want to propagate this qualifier." : "Check the boxes if you also want to propagate any of these qualifiers.";
        JPanel box = new JPanel();
        JLabel label = new JLabel(description);
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        box.setOpaque(true);
        box.setBackground(RenderUtil.getAspectColor());
        box.setLayout(new BoxLayout(box, 3));
        box.add(label);
        this.selections = new HashMap<JCheckBox, Term>();
        Set<Term> qualifiers = qual2node.keySet();
        for (Term qual : qualifiers) {
            Set<GeneNode> nodes = qual2node.get(qual);
            JCheckBox check = new JCheckBox();
            StringBuffer qual_label = new StringBuffer(qual.getName() + " (from ");
            String prefix = "";
            for (GeneNode node : nodes) {
                qual_label.append(prefix + node.getNodeLabel());
                prefix = ", ";
            }
            check.setText(qual_label.toString() + ")");
            check.setSelected(false);
            this.selections.put(check, qual);
            box.add(check);
        }
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)box, "First");
        Border padding = BorderFactory.createEmptyBorder(20, 20, 5, 20);
        pane.setBorder(padding);
        pane.setOpaque(true);
        pane.setBackground(RenderUtil.getAspectColor());
        return pane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Set<JCheckBox> checkboxes = this.selections.keySet();
        for (JCheckBox check : checkboxes) {
            if (!check.isSelected()) continue;
            Term qual = this.selections.get(check);
            this.qual_list.add(qual);
        }
        this.setVisible(false);
    }
}

