/*
 * Decompiled with CFR 0.152.
 */
package org.paint.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScaleTreeDlg
extends JDialog {
    Frame frame;
    JPanel mainPanel;
    JTextField scale;
    Double scaleValue;

    public ScaleTreeDlg(Frame frame, double scale) {
        super(frame, true);
        this.setTitle("Scale Tree");
        this.frame = frame;
        this.scaleValue = new Double(scale);
        this.initializePanel();
    }

    protected void initializePanel() {
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new GridLayout(0, 1));
        labelPane.add(new JLabel("Scale:"));
        JPanel fieldPane = new JPanel();
        fieldPane.setLayout(new GridLayout(0, 1));
        this.scale = new JTextField(5);
        this.scale.setText(this.scaleValue.toString());
        fieldPane.add(this.scale);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)labelPane, "Center");
        this.mainPanel.add((Component)fieldPane, "East");
        JPanel decisionPanel = new JPanel();
        decisionPanel.setLayout(new BoxLayout(decisionPanel, 0));
        JButton saveChoices = new JButton("OK");
        saveChoices.addActionListener(new OKButtonActionListener());
        JButton cancelChoices = new JButton("Cancel");
        cancelChoices.addActionListener(new CancelButtonActionListener());
        decisionPanel.add(saveChoices);
        decisionPanel.add(cancelChoices);
        this.mainPanel.add((Component)decisionPanel, "South");
        this.getRootPane().setDefaultButton(saveChoices);
        this.setContentPane(this.mainPanel);
        Rectangle r = this.frame.getBounds();
        this.setBounds(r.x + r.width / 2, r.y + r.height / 2, 300, 100);
    }

    public Double display() {
        this.setVisible(true);
        return this.scaleValue;
    }

    protected boolean saveUserInfo() {
        try {
            this.scaleValue = new Double(this.scale.getText());
            return true;
        }
        catch (NumberFormatException nfe) {
            this.scaleValue = null;
            return false;
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScaleTreeDlg.this.scaleValue = null;
            ScaleTreeDlg.this.setVisible(false);
        }
    }

    private class OKButtonActionListener
    implements ActionListener {
        private OKButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ScaleTreeDlg.this.saveUserInfo()) {
                JOptionPane.showMessageDialog(ScaleTreeDlg.this.frame, "Please specify a valid scale factor");
                return;
            }
            ScaleTreeDlg.this.setVisible(false);
        }
    }
}

