/*
 * Decompiled with CFR 0.152.
 */
package org.paint.error;

import java.util.ArrayList;
import java.util.List;
import org.paint.error.ErrorEvent;
import org.paint.error.ErrorListener;

public class ErrorManager {
    private static ErrorManager singleton;
    private List<ErrorListener> errorListeners = new ArrayList<ErrorListener>(2);
    private List<ErrorEvent> errors = new ArrayList<ErrorEvent>(3);

    public static ErrorManager inst() {
        if (singleton == null) {
            singleton = new ErrorManager();
        }
        return singleton;
    }

    public static void reset() {
        singleton = null;
    }

    public void error(ErrorEvent e) {
        for (ErrorListener l : this.errorListeners) {
            l.handleError(e);
        }
        this.errors.add(e);
    }

    public List<ErrorEvent> getErrors() {
        return this.errors;
    }

    public void addErrorListener(ErrorListener el) {
        this.errorListeners.add(el);
    }
}

