/*
 * Decompiled with CFR 0.152.
 */
package org.paint.go;

import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.geneontology.db.factory.GOobjectFactory;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.DB;
import org.geneontology.db.model.DBXref;
import org.geneontology.db.model.GeneProduct;
import org.geneontology.db.model.GraphPath;
import org.geneontology.db.model.Species;
import org.geneontology.db.model.Term;
import org.hibernate.Session;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MultiIDObject;
import org.paint.config.Preferences;
import org.paint.datamodel.Family;
import org.paint.datamodel.GeneNode;
import org.paint.main.PaintManager;
import org.paint.util.InternetChecker;

public class GO_Util {
    private static final HashSet<String> mod_list = new HashSet();
    private static final HashSet<String> EXP_strings;
    private static DBXref paint_dbxref;
    private static HashMap<LinkedObject, Term> term2term;
    private static HashMap<String, Term> name2term;
    private HashMap<GeneProduct, GeneNode> gp2node;
    private static long patience;
    public static int PENDING;
    public static int SUCCESS;
    public static int FAILURE;
    private static JProgressBar progressBar;
    private static int finished_count;
    private static GO_Util go_util;
    private static Logger log;
    private Map<String, LinkedObject> alternateIdObjects;
    private Map<String, DB> nameToDB;
    private Map<String, Species> taxonToSpecies;
    private Map<String, Term> accToTerm;
    private Map<String, Term> altAccToTerm;

    private GO_Util() {
    }

    public static GO_Util inst() {
        if (go_util == null) {
            go_util = new GO_Util();
        }
        return go_util;
    }

    public GOobjectFactory getGOfactory() {
        return new GOobjectFactory("config/hibernate.cfg.xml");
    }

    public int threadFinished(Thread thread, long startTime) {
        int status;
        int n = status = thread == null ? PENDING : SUCCESS;
        if (thread != null && thread.isAlive()) {
            try {
                thread.join(10L);
                if (System.currentTimeMillis() - startTime > patience && thread.isAlive()) {
                    thread.interrupt();
                    thread.join();
                } else {
                    status = PENDING;
                }
            }
            catch (InterruptedException e) {
                status = FAILURE;
            }
        }
        JFrame frame = GUIManager.getManager().getFrame();
        if (status == SUCCESS) {
            progressBar.setValue(++finished_count);
            progressBar.setString("Getting GO annotations...");
            progressBar.repaint();
        } else if (frame.isAncestorOf(progressBar)) {
            ((Container)frame).remove(progressBar);
        }
        return status;
    }

    public GeneNode getGeneNode(GeneProduct gp) {
        GeneNode node = null;
        if (this.gp2node != null) {
            node = this.gp2node.get(gp);
        }
        if (node == null) {
            String db_id = gp.getDbxref().getAccession();
            node = PaintManager.inst().getGeneByGP(gp.getDbxref().getDb_name(), db_id);
            if (node != null) {
                this.gp2node.put(gp, node);
            }
        }
        if (node == null) {
            log.debug((Object)("No node for gene_product " + gp.getSymbol() + " database id " + gp.getDbxref().getAccession()));
        }
        return node;
    }

    public synchronized Term getTermByAcc(String acc) {
        if (this.accToTerm == null) {
            this.accToTerm = new HashMap<String, Term>();
        }
        Term term = this.accToTerm.get(acc);
        boolean online = InternetChecker.getInstance().isConnectionPresent();
        if (term == null && online) {
            GOobjectFactory factory = this.getGOfactory();
            Session session = factory.startSession();
            term = factory.getTermByAcc(acc, session);
            this.initTerm(term);
            session.close();
            factory.close();
        }
        if (term == null) {
            term = new Term();
            term.setAcc(acc);
            LinkDatabase linkDb = PaintManager.inst().getGoRoot().getLinkDatabase();
            LinkedObject obo_term = (LinkedObject)GO_Util.inst().getObject(linkDb, term.getAcc());
            term.setName(obo_term.getName());
            term.setCv(obo_term.getNamespace().getID());
        }
        if (term != null) {
            this.accToTerm.put(acc, term);
        }
        return term;
    }

    private void initTerm(Term term) {
        if (term == null) {
            log.debug((Object)"Failed to get term, will have to synthesize: ");
        } else {
            StringBuffer force = new StringBuffer();
            force.append(term.getName());
            force.append(term.getAcc());
            force.append(term.getCv());
            force.append(term.isObsolete());
        }
    }

    public synchronized Term getTermByName(String name) {
        if (name2term == null) {
            name2term = new HashMap();
        }
        Term term = name2term.get(name);
        boolean online = InternetChecker.getInstance().isConnectionPresent();
        if (term == null && online) {
            try {
                GOobjectFactory factory = this.getGOfactory();
                Session session = factory.startSession();
                term = factory.getTermByName(name, session);
                this.initTerm(term);
                session.close();
                factory.close();
            }
            catch (Exception e) {
                log.debug((Object)("Failed to connect to GODB to find term, will have to synthesize: " + name));
            }
        }
        if (term != null) {
            name2term.put(name, term);
        }
        return term;
    }

    public void indexTerm(Term term, String acc) {
        if (acc != null && !acc.equals("")) {
            if (this.accToTerm == null) {
                this.accToTerm = new HashMap<String, Term>();
            }
            this.accToTerm.put(acc, term);
            this.initTerm(term);
        }
    }

    public synchronized Term getTermByAlternateAcc(String acc) {
        Term term;
        if (this.altAccToTerm == null) {
            this.altAccToTerm = new HashMap<String, Term>();
        }
        if ((term = this.altAccToTerm.get(acc)) == null) {
            GOobjectFactory factory = this.getGOfactory();
            Session session = factory.startSession();
            term = factory.getTermByAlternateAcc(acc, session);
            this.initTerm(term);
            session.close();
            factory.close();
            this.accToTerm.put(acc, term);
            this.accToTerm.put(term.getAcc(), term);
        }
        return term;
    }

    public synchronized GraphPath getGraphPath(Term term1, Term term2) {
        GOobjectFactory factory = this.getGOfactory();
        Session session = factory.startSession();
        GraphPath path = factory.getPath(term1, term2, session);
        session.close();
        factory.close();
        return path;
    }

    public Species getSpecies(GeneNode node) {
        Species species = null;
        List<String> names = node.getSpeciesList();
        if (this.taxonToSpecies == null) {
            this.taxonToSpecies = new HashMap<String, Species>();
        }
        if (names == null || names.size() == 0) {
            log.debug((Object)("No species name available for " + node.getNodeLabel() + " " + node.getSpeciesLabel()));
            node.addSpeciesLabel("root");
            names = node.getSpeciesList();
        }
        ArrayList<String> taxa = new ArrayList<String>();
        for (String name : names) {
            String taxon_id = Preferences.inst().getTaxonID(name);
            if (taxon_id == null) continue;
            boolean duplicate = false;
            for (String t : taxa) {
                duplicate |= t.equals(taxon_id);
            }
            if (duplicate) continue;
            taxa.add(taxon_id);
        }
        if (taxa.size() == 1) {
            String taxon_id = (String)taxa.get(0);
            if (taxon_id != null && taxon_id.length() > "taxon:".length() && (species = this.taxonToSpecies.get(taxon_id)) == null) {
                species = this.createSpecies(taxon_id);
                this.taxonToSpecies.put(taxon_id, species);
            }
        } else if (taxa.size() > 0) {
            log.debug((Object)("Multiple taxa for " + node + " " + names + " " + taxa));
        }
        return species;
    }

    public synchronized Species createSpecies(String taxon_id) {
        String name = Preferences.inst().getSpeciesName(taxon_id);
        String taxon_number = taxon_id.substring("taxon:".length());
        int taxon = new Integer(taxon_number);
        Species species = null;
        if (InternetChecker.getInstance().isConnectionPresent(true)) {
            GOobjectFactory factory = this.getGOfactory();
            Session session = factory.startSession();
            species = factory.getSpeciesByTaxa(taxon, session);
            session.close();
            factory.close();
        }
        if (species == null) {
            species = new Species();
            species.setNcbi_taxa_id(taxon);
            String[] gen_spe = name.split(" ");
            if (gen_spe.length == 1) {
                species.setGenus(gen_spe[0]);
            } else if (gen_spe.length == 2) {
                species.setGenus(gen_spe[0]);
                species.setSpecies(gen_spe[1]);
            } else {
                species.setGenus(gen_spe[0]);
                species.setSpecies(gen_spe[1] + " " + gen_spe[2]);
            }
        }
        return species;
    }

    public String dbNameHack(String name) {
        String revision = name;
        if (name.equals("UniProtKB/Swiss-Prot")) {
            revision = "UniProtKB";
        } else if (name.equals("Uniprot")) {
            revision = "UniProtKB";
        } else if (name.equals("ENTREZ")) {
            revision = "RefSeq";
        } else if (name.equals("ECOLI")) {
            revision = "EcoCyc";
        } else if (name.equals("GeneDB_Spombe")) {
            revision = "PomBase";
        } else if (name.equals("Gene")) {
            revision = "UniProtKB";
        }
        return revision;
    }

    public synchronized DB getOriginbyName(String name) {
        DB db;
        name = this.dbNameHack(name);
        if (this.nameToDB == null) {
            this.nameToDB = new HashMap<String, DB>();
        }
        if ((db = this.nameToDB.get(name)) == null) {
            if (name.equals("PANTHER")) {
                db = new DB();
                db.setName(name);
            } else if (name.equals("GO_Central") || name.equals("RefGenome")) {
                db = new DB();
                db.setName("GO_Central");
            } else if (InternetChecker.getInstance().isConnectionPresent()) {
                GOobjectFactory factory = this.getGOfactory();
                Session session = factory.startSession();
                db = factory.getDBByName(name, session);
                session.close();
                factory.close();
            } else {
                db = new DB();
                db.setName(name);
            }
            if (db != null) {
                this.nameToDB.put(name, db);
            }
        }
        return db;
    }

    public DBXref getPAINTEvidenceDBXref() {
        if (paint_dbxref == null) {
            paint_dbxref = new DBXref();
            paint_dbxref.setDb_name("PAINT_REF");
            paint_dbxref.setKeytype("Personal Communication");
            paint_dbxref.setDescription("PAINT protein family curation");
            paint_dbxref.setFor_definition(false);
        }
        paint_dbxref.setAccession(this.getPaintEvidenceAcc());
        return paint_dbxref;
    }

    public String getPaintEvidenceAcc() {
        Family family = PaintManager.inst().getFamily();
        if (family != null) {
            String pthr_id = family.getFamilyID();
            int acc = Integer.valueOf(pthr_id.substring("PTHR".length()));
            String paint_id = String.format("%1$07d", acc);
            return paint_id;
        }
        return "";
    }

    public DBXref createNodeDBXref(GeneNode node) {
        DBXref dbxref = new DBXref();
        dbxref.setDb_name(node.getDatabase());
        dbxref.setAccession(node.getDatabaseID());
        dbxref.setKeytype("id");
        dbxref.setDescription(node.getDescription());
        dbxref.setFor_definition(false);
        return dbxref;
    }

    public String getWithText(Set<DBXref> withs) {
        String prefix = null;
        Object text = "";
        try {
            for (DBXref xref : withs) {
                if (prefix == null) {
                    text = (String)text + xref.getDb_name() + ":" + xref.getAccession();
                    prefix = ", ";
                    continue;
                }
                text = (String)text + prefix + xref.getDb_name() + ":" + xref.getAccession();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return text;
    }

    public Term getTerm(LinkedObject obo_term, boolean makeitup) {
        Term term;
        if (term2term == null) {
            term2term = new HashMap();
        }
        if (name2term == null) {
            name2term = new HashMap();
        }
        if ((term = term2term.get(obo_term)) == null) {
            term = makeitup ? this.createTerm(obo_term) : this.getTermByAcc(obo_term.getID());
            term2term.put(obo_term, term);
            name2term.put(term.getName(), term);
        }
        return term;
    }

    private Term createTerm(LinkedObject obo_term) {
        Term term = new Term();
        term.setAcc(obo_term.getID());
        term.setCv(obo_term.getNamespace().toString());
        term.setName(obo_term.getName());
        term.setIs_obsolete(new Integer(0));
        term.setDefinition("");
        Collection parent_links = obo_term.getParents();
        term.setIs_root(parent_links == null ? new Integer(0) : new Integer(1));
        return term;
    }

    public void putTerm(LinkedObject obo_term, Term term) {
        if (term2term == null) {
            term2term = new HashMap();
        }
        term2term.put(obo_term, term);
    }

    private boolean hasQualifier(Association assoc, String qual) {
        Set qualifiers = assoc.getQualifiers();
        boolean has_qual = false;
        try {
            if (qualifiers != null) {
                Iterator it = qualifiers.iterator();
                while (it.hasNext() && !has_qual) {
                    Term term = (Term)it.next();
                    has_qual = term.getName().equals(qual);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return has_qual;
    }

    public boolean contributesTo(Association assoc) {
        return this.hasQualifier(assoc, "contributes_to");
    }

    public boolean colocalizes(Association assoc) {
        return this.hasQualifier(assoc, "colocalizes_with");
    }

    public IdentifiedObject getObject(LinkDatabase go_ont, String id) {
        LinkedObject ont_term = (LinkedObject)go_ont.getObject(id);
        if (ont_term == null) {
            if (this.alternateIdObjects == null) {
                this.alternateIdObjects = new HashMap<String, LinkedObject>();
            }
            if ((ont_term = this.alternateIdObjects.get(id)) == null) {
                for (IdentifiedObject o : go_ont.getObjects()) {
                    if (!(o instanceof MultiIDObject) || !((MultiIDObject)o).getSecondaryIDs().contains(id)) continue;
                    ont_term = (LinkedObject)o;
                    this.alternateIdObjects.put(id, ont_term);
                    break;
                }
            }
        }
        return ont_term;
    }

    public void clearCache() {
        if (this.alternateIdObjects == null) {
            this.alternateIdObjects = new HashMap<String, LinkedObject>();
        } else {
            this.alternateIdObjects.clear();
        }
        if (this.nameToDB == null) {
            this.nameToDB = new HashMap<String, DB>();
        } else {
            this.nameToDB.clear();
        }
        if (this.taxonToSpecies == null) {
            this.taxonToSpecies = new HashMap<String, Species>();
        } else {
            this.taxonToSpecies.clear();
        }
        if (this.accToTerm == null) {
            this.accToTerm = new HashMap<String, Term>();
        } else {
            this.accToTerm.clear();
        }
        if (this.altAccToTerm == null) {
            this.altAccToTerm = new HashMap<String, Term>();
        } else {
            this.altAccToTerm.clear();
        }
    }

    static {
        mod_list.add("MGI");
        mod_list.add("RGD");
        mod_list.add("FB");
        mod_list.add("SGD");
        mod_list.add("PomBase");
        mod_list.add("TAIR");
        mod_list.add("ZFIN");
        mod_list.add("WB");
        mod_list.add("dictyBase");
        mod_list.add("EcoCyc");
        EXP_strings = new HashSet();
        EXP_strings.add("EXP");
        EXP_strings.add("IDA");
        EXP_strings.add("IEP");
        EXP_strings.add("IGI");
        EXP_strings.add("IMP");
        EXP_strings.add("IPI");
        EXP_strings.add("IKR");
        EXP_strings.add("IRD");
        EXP_strings.add("TAS");
        patience = 300000L;
        PENDING = 0;
        SUCCESS = 1;
        FAILURE = -1;
        log = Logger.getLogger(GO_Util.class);
    }
}

