/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.geneontology.db.model.Term;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.paint.config.Preferences;
import org.paint.go.GO_Util;
import org.paint.gui.AspectSelector;
import org.paint.gui.event.AspectChangeEvent;
import org.paint.gui.event.AspectChangeListener;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.TermSelectEvent;
import org.paint.gui.event.TermSelectionListener;
import org.paint.main.PaintManager;

public class AspectSelectorPanel
extends JPanel
implements AspectChangeListener,
TermSelectionListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton bpButton;
    private JRadioButton ccButton;
    private JRadioButton mfButton;
    private Border plainBorder;

    public AspectSelectorPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.mfButton = new JRadioButton("  Molecular Function  ", true);
        this.ccButton = new JRadioButton("  Cellular Component  ", false);
        this.bpButton = new JRadioButton("  Biological Process  ", false);
        AspectSelectorListener aspectSelectionListener = new AspectSelectorListener();
        this.bpButton.addActionListener(aspectSelectionListener);
        this.ccButton.addActionListener(aspectSelectionListener);
        this.mfButton.addActionListener(aspectSelectionListener);
        this.add(this.mfButton);
        this.add(this.ccButton);
        this.add(this.bpButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mfButton);
        group.add(this.ccButton);
        group.add(this.bpButton);
        this.mfButton.setOpaque(true);
        this.ccButton.setOpaque(true);
        this.bpButton.setOpaque(true);
        Preferences prefs = Preferences.inst();
        this.mfButton.setBackground(prefs.getAspectColor(4).darker());
        this.ccButton.setBackground(prefs.getAspectColor(2));
        this.bpButton.setBackground(prefs.getAspectColor(1));
        this.plainBorder = BorderFactory.createEtchedBorder(0);
        this.mfButton.setMargin(new Insets(2, 12, 2, 12));
        this.mfButton.setBorderPainted(true);
        this.ccButton.setBorderPainted(true);
        this.bpButton.setBorderPainted(true);
        this.mfButton.setBorder(this.plainBorder);
        this.ccButton.setBorder(this.plainBorder);
        this.bpButton.setBorder(this.plainBorder);
        EventManager.inst().registerAspectChangeListener(this);
        EventManager.inst().registerTermListener(this);
    }

    @Override
    public void handleAspectChangeEvent(AspectChangeEvent event) {
        if (event.getSource() == this) {
            return;
        }
        Preferences prefs = Preferences.inst();
        if (this.mfButton.isSelected()) {
            this.mfButton.setBackground(prefs.getAspectColor(4).darker());
            this.ccButton.setBackground(prefs.getAspectColor(2));
            this.bpButton.setBackground(prefs.getAspectColor(1));
        }
        if (this.bpButton.isSelected()) {
            this.mfButton.setBackground(prefs.getAspectColor(4));
            this.ccButton.setBackground(prefs.getAspectColor(2));
            this.bpButton.setBackground(prefs.getAspectColor(1).darker());
        } else if (this.ccButton.isSelected()) {
            this.mfButton.setBackground(prefs.getAspectColor(4));
            this.ccButton.setBackground(prefs.getAspectColor(2).darker());
            this.bpButton.setBackground(prefs.getAspectColor(1));
        }
    }

    @Override
    public void handleTermEvent(TermSelectEvent e) {
        List<Term> terms = e.getTermSelection();
        if (terms != null && !terms.isEmpty()) {
            Term term = terms.get(0);
            LinkDatabase go_root = PaintManager.inst().getGoRoot().getLinkDatabase();
            LinkedObject obo_term = (LinkedObject)GO_Util.inst().getObject(go_root, term.getAcc());
            String aspect_str = obo_term.getNamespace().getID().toLowerCase();
            if (aspect_str.equals(AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString()) && !this.bpButton.isSelected()) {
                this.bpButton.setSelected(true);
                this.switchAspect(this.bpButton);
            } else if (aspect_str.equals(AspectSelector.Aspect.MOLECULAR_FUNCTION.toString()) && !this.mfButton.isSelected()) {
                this.mfButton.setSelected(true);
                this.switchAspect(this.mfButton);
            } else if (aspect_str.equals(AspectSelector.Aspect.CELLULAR_COMPONENT.toString()) && !this.ccButton.isSelected()) {
                this.ccButton.setSelected(true);
                this.switchAspect(this.ccButton);
            }
        }
    }

    private void switchAspect(JRadioButton button) {
        Preferences prefs = Preferences.inst();
        if (button == this.bpButton) {
            AspectSelector.inst().setAspect(AspectSelector.Aspect.BIOLOGICAL_PROCESS);
            this.mfButton.setBackground(prefs.getAspectColor(4));
            this.ccButton.setBackground(prefs.getAspectColor(2));
            this.bpButton.setBackground(prefs.getAspectColor(1).darker());
        } else if (button == this.ccButton) {
            AspectSelector.inst().setAspect(AspectSelector.Aspect.CELLULAR_COMPONENT);
            this.mfButton.setBackground(prefs.getAspectColor(4));
            this.ccButton.setBackground(prefs.getAspectColor(2).darker());
            this.bpButton.setBackground(prefs.getAspectColor(1));
        } else if (button == this.mfButton) {
            AspectSelector.inst().setAspect(AspectSelector.Aspect.MOLECULAR_FUNCTION);
            this.mfButton.setBackground(prefs.getAspectColor(4).darker());
            this.ccButton.setBackground(prefs.getAspectColor(2));
            this.bpButton.setBackground(prefs.getAspectColor(1));
        }
    }

    class AspectSelectorListener
    implements ActionListener {
        AspectSelectorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton button = (JRadioButton)e.getSource();
            AspectSelectorPanel.this.switchAspect(button);
        }
    }
}

