/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui;

import org.apache.log4j.Logger;
import org.bbop.framework.VetoableShutdownListener;
import org.paint.datamodel.Family;
import org.paint.main.PaintManager;

public class DirtyIndicator
implements VetoableShutdownListener {
    private static DirtyIndicator singleton;
    private static boolean dirty_genes;
    private static boolean annotated;

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    private DirtyIndicator() {
    }

    public static DirtyIndicator inst() {
        if (singleton == null) {
            singleton = new DirtyIndicator();
        }
        return singleton;
    }

    public boolean willShutdown() {
        return true;
    }

    public boolean familyLoaded() {
        Family family = PaintManager.inst().getFamily();
        return family != null && family.isLoaded();
    }

    public boolean genesAreDirty() {
        return dirty_genes;
    }

    public void dirtyGenes(boolean soiled) {
        dirty_genes = soiled;
    }

    public boolean isPainted() {
        if (this.familyLoaded()) {
            return annotated;
        }
        return false;
    }

    public void setAnnotated(boolean annotated) {
        DirtyIndicator.annotated = annotated;
    }

    public boolean bookUpdated() {
        return annotated;
    }

    static {
        dirty_genes = false;
        annotated = false;
    }
}

