/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;
import org.paint.gui.AbstractPaintGUIComponent;
import org.paint.gui.AspectSelectorPanel;
import org.paint.gui.NodeScroller;
import org.paint.gui.event.AspectChangeEvent;
import org.paint.gui.event.AspectChangeListener;
import org.paint.gui.event.EventManager;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.matrix.AnnotationMatrix;
import org.paint.gui.matrix.AnnotationTransferHndlr;
import org.paint.gui.msa.MSAPanel;
import org.paint.gui.table.GeneTable;
import org.paint.main.PaintManager;
import org.paint.util.RenderUtil;

public class FamilyViews
extends AbstractPaintGUIComponent
implements AspectChangeListener {
    private static final long serialVersionUID = 1L;
    private static FamilyViews singleton;
    private NodeScroller treePanel;
    private NodeScroller tablePanel;
    private NodeScroller msaPanel;
    private NodeScroller matrixPanel;
    private JTabbedPane gtabbedPane;
    private JTabbedPane ttabbedPane;
    private static Logger log;
    private List<NodeScroller> scrollables;
    public static final int TREE_PANE = 0;
    public static final int MATRIX_PANE = 1;
    public static final int TABLE_PANE = 2;
    public static final int MSA_PANE = 3;

    public FamilyViews() {
        super("tree-info:tree-info");
        this.initializeInterface();
    }

    private void initializeInterface() {
        if (this.treePanel == null) {
            GeneTable gene_table = new GeneTable();
            this.tablePanel = new NodeScroller(gene_table);
            MSAPanel msa = new MSAPanel();
            this.msaPanel = new NodeScroller(msa);
            AnnotationMatrix annot_matrix = new AnnotationMatrix();
            this.matrixPanel = new NodeScroller(annot_matrix);
            this.gtabbedPane = new JTabbedPane();
            this.gtabbedPane.addTab("Annotation Matrix", this.matrixPanel);
            this.gtabbedPane.addTab("Protein Information", this.tablePanel);
            this.gtabbedPane.addTab("MSA", this.msaPanel);
            this.gtabbedPane.setOpaque(true);
            TreePanel tree_pane = new TreePanel();
            this.treePanel = new NodeScroller(tree_pane);
            this.ttabbedPane = new JTabbedPane();
            this.ttabbedPane.addTab("Tree", this.treePanel);
            this.ttabbedPane.setOpaque(true);
            this.setBackground();
            PaintManager.inst().setGeneTable(gene_table);
            PaintManager.inst().setTreePane(tree_pane);
            PaintManager.inst().setMSAPane(msa);
            PaintManager.inst().setMatrix(annot_matrix);
            tree_pane.setTransferHandler(new AnnotationTransferHndlr());
            JSplitPane splitPane = new JSplitPane(1, this.ttabbedPane, this.gtabbedPane);
            splitPane.setResizeWeight(0.75);
            this.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.add(new AspectSelectorPanel(), "North");
            this.add(splitPane, "Center");
            this.scrollables = new ArrayList<NodeScroller>();
            this.scrollables.add(0, this.treePanel);
            this.scrollables.add(1, this.matrixPanel);
            this.scrollables.add(2, this.tablePanel);
            this.scrollables.add(3, this.msaPanel);
            EventManager.inst().registerAspectChangeListener(this);
        }
    }

    public static FamilyViews inst() {
        if (singleton == null) {
            singleton = new FamilyViews();
        }
        return singleton;
    }

    public int getBottomMargin(int scroller_index) {
        NodeScroller scrolling_pane = this.scrollables.get(scroller_index);
        JScrollBar scroller = scrolling_pane.getHorizontalScrollBar();
        int scrollHeight = 0;
        if (scroller == null || scroller != null && !scroller.isVisible()) {
            for (int i = 0; i < this.scrollables.size() && scrollHeight == 0; ++i) {
                NodeScroller alt_pane = this.scrollables.get(i);
                scroller = alt_pane.getHorizontalScrollBar();
                if (i == scroller_index || !scroller.isVisible()) continue;
                scrollHeight = scroller.getHeight();
            }
        }
        if (scrollHeight > 0) {
            ++scrollHeight;
        }
        return scrollHeight;
    }

    public int getHScrollerHeight(int scroller_index) {
        NodeScroller scrolling_pane = this.scrollables.get(scroller_index);
        JScrollBar scroller = scrolling_pane.getHorizontalScrollBar();
        int scrollHeight = scroller.getHeight();
        if (scrollHeight > 0) {
            ++scrollHeight;
        }
        return scrollHeight;
    }

    @Override
    public void handleAspectChangeEvent(AspectChangeEvent event) {
        this.setBackground();
    }

    private void setBackground() {
        Color bg_color = RenderUtil.getAspectColor();
        this.setBackground(bg_color);
        this.gtabbedPane.setBackground(bg_color);
        this.ttabbedPane.setBackground(bg_color);
    }

    static {
        log = Logger.getLogger(FamilyViews.class);
    }
}

