/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui;

import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.NodeScrollEvent;
import org.paint.gui.event.NodeScrollListener;

public class NodeScroller
extends JScrollPane
implements AdjustmentListener,
NodeScrollListener {
    private static final long serialVersionUID = 1L;
    public Component nodePanel;

    public NodeScroller(Component nodePanel) {
        super(nodePanel, 20, 30);
        this.nodePanel = nodePanel;
        JScrollBar vsb = this.getVerticalScrollBar();
        JScrollBar hsb = this.getHorizontalScrollBar();
        vsb.addAdjustmentListener(this);
        hsb.addAdjustmentListener(this);
        EventManager.inst().registerNodeScrollListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getValueIsAdjusting() || EventManager.inst().isAdjusting()) {
            return;
        }
        JScrollBar scroller = this.getVerticalScrollBar();
        if (e.getSource() == scroller) {
            int position = e.getValue();
            int range = scroller.getMaximum() - scroller.getMinimum() - scroller.getModel().getExtent();
            if (range > 0) {
                float percent = (float)position / (float)range;
                NodeScrollEvent event = new NodeScrollEvent(e, percent);
                EventManager.inst().fireNodeScrollEvent(event);
            }
        } else {
            scroller = this.getHorizontalScrollBar();
            this.repaint();
        }
    }

    @Override
    public void handleNodeScrollEvent(NodeScrollEvent e) {
        JScrollBar scroller = this.getVerticalScrollBar();
        if (e.getSource() != scroller) {
            float percent = e.getPosition();
            int range = scroller.getMaximum() - scroller.getMinimum() - scroller.getModel().getExtent();
            int new_position = (int)(percent * (float)range);
            scroller.setValue(new_position);
        }
    }
}

