/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui;

import java.awt.Container;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import net.infonode.docking.View;
import org.paint.gui.AbstractPaintGUIComponent;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.ProgressEvent;
import org.paint.gui.event.ProgressListener;

public class StatusView
extends AbstractPaintGUIComponent
implements ProgressListener {
    private static final long serialVersionUID = 1L;
    private static StatusView singleton;
    private JLabel messageLabel;
    private JProgressBar progressBar;

    public StatusView() {
        super("status-info:status-info");
        this.initLayout();
    }

    public static StatusView getSingleton() {
        if (singleton == null) {
            singleton = new StatusView();
        }
        EventManager.inst().registerProgressListener(singleton);
        return singleton;
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setMessage(String message) {
        if (message != null) {
            this.messageLabel.setText(message);
        }
    }

    public void setPercentageDone(int percentage) {
        if (percentage == 0) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
        }
        this.progressBar.setValue(percentage);
        if (percentage == 100) {
            this.setMessage(this.getMessage() + " (Done)");
        }
    }

    @Override
    public void handleProgressEvent(ProgressEvent event) {
        this.setMessage(event.getMessage());
        this.setPercentageDone(event.getPercentageDone());
        if (event.getStatus() == ProgressEvent.Status.START) {
            this.restore();
        } else if (event.getStatus() == ProgressEvent.Status.END) {
            this.minimize();
        } else if (event.getStatus() == ProgressEvent.Status.FAIL) {
            this.setMessage(this.getMessage() + " (Fail)");
        }
    }

    private void restore() {
        final View view = this.getIdwView();
        if (view.isMinimized() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        view.restore();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void minimize() {
        final View view = this.getIdwView();
        if (!view.isMinimized() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        view.minimize();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void initLayout() {
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.messageLabel = new JLabel(" ");
        this.messageLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar(0, 100);
        this.add(this.messageLabel);
        this.add(this.progressBar);
    }
}

