/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.paint.datamodel.GeneNode;
import org.paint.gui.association.AssociationTable;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.FamilyChangeEvent;
import org.paint.gui.event.FamilyChangeListener;
import org.paint.gui.event.GeneSelectEvent;
import org.paint.gui.event.GeneSelectListener;
import org.paint.gui.event.TermSelectEvent;
import org.paint.gui.event.TermSelectionListener;
import org.paint.gui.familytree.TreePanel;
import org.paint.main.PaintManager;

public class AssociationList
extends JPanel
implements GeneSelectListener,
FamilyChangeListener,
TermSelectionListener {
    private static final long serialVersionUID = 1L;
    private TitledBorder border;
    private GeneNode node;
    private AssociationTable assoc_table;
    static final int HEADER_HEIGHT = 20;
    static final int HEADER_MARGIN = 2;
    protected String dragTitle = "";

    public AssociationList() {
        this.setLayout(new BorderLayout());
        this.assoc_table = new AssociationTable();
        JScrollPane annot_scroll = new JScrollPane(this.assoc_table);
        this.border = this.createBorder("");
        this.setBorder(this.border);
        this.add((Component)annot_scroll, "Center");
        EventManager.inst().registerGeneListener(this);
        EventManager.inst().registerFamilyListener(this);
        EventManager.inst().registerTermListener(this);
    }

    private TitledBorder createBorder(String title) {
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        CompoundBorder border = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        return BorderFactory.createTitledBorder(border, title);
    }

    @Override
    public void handleGeneSelectEvent(GeneSelectEvent event) {
        GeneNode ancestor = event.getAncestor();
        if (null != ancestor) {
            this.setNode(ancestor);
        } else {
            this.setNode(null);
        }
        this.repaint();
    }

    @Override
    public void newFamilyData(FamilyChangeEvent e) {
        TreePanel tree = PaintManager.inst().getTree();
        GeneNode root = tree.getRoot();
        this.setNode(null);
    }

    @Override
    public void handleTermEvent(TermSelectEvent e) {
        GeneNode mrca = EventManager.inst().getAncestralSelection();
        if (!mrca.equals(this.node) && !e.getSource().equals(this.assoc_table)) {
            this.setNode(mrca);
        }
    }

    private void setNode(GeneNode node) {
        this.node = node;
        if (node == null) {
            this.border.setTitle("");
        } else {
            this.border.setTitle(node.getNodeLabel() + node.getNode().getStaticInfo().getPublicId());
        }
        this.repaint();
    }
}

