/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.paint.datamodel.GeneNode;
import org.paint.gui.association.AssociationTableModel;
import org.paint.gui.association.DeleteButtonRenderer;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.AnnotationChangeListener;
import org.paint.gui.event.AspectChangeEvent;
import org.paint.gui.event.AspectChangeListener;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.FamilyChangeEvent;
import org.paint.gui.event.FamilyChangeListener;
import org.paint.gui.event.GeneSelectEvent;
import org.paint.gui.event.GeneSelectListener;
import org.paint.main.PaintManager;
import org.paint.util.HTMLUtil;

public class AssociationTable
extends JTable
implements GeneSelectListener,
MouseListener,
FamilyChangeListener,
AnnotationChangeListener,
AspectChangeListener {
    private GeneNode node;
    private AssociationTableModel associationModel = new AssociationTableModel();
    private boolean widthsInit = false;
    public static final String URL_LINK_PREFIX_AMIGO = "http://amigo.geneontology.org/amigo/term/";
    public static final String URL_LINK_PREFIX_PMID = "https://www.ncbi.nlm.nih.gov/pubmed/";
    public static final String URL_LINK_PREFIX_PANTREE_NODE = "http://www.pantree.org/node/annotationNode.jsp?id=";

    public AssociationTable() {
        this.setModel(this.associationModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(1, 1));
        this.addMouseListener(this);
        EventManager.inst().registerGeneListener(this);
        EventManager.inst().registerFamilyListener(this);
        EventManager.inst().registerGeneAnnotationChangeListener(this);
        EventManager.inst().registerAspectChangeListener(this);
        ListSelectionModel select_model = this.getSelectionModel();
        select_model.setSelectionMode(2);
        this.setSelectionModel(select_model);
        ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        String tag = AssociationTableModel.column_headings[column];
        if (tag.equals("Delete")) {
            return new DeleteButtonRenderer();
        }
        if (tag.equals("NOT") || tag.equals("Colocalizes with") || tag.equals("Contributes to")) {
            return this.getDefaultRenderer(Boolean.class);
        }
        return this.getDefaultRenderer(String.class);
    }

    @Override
    public void handleGeneSelectEvent(GeneSelectEvent event) {
        this.clearSelection();
        GeneNode ancestor = event.getAncestor();
        if (null != ancestor) {
            this.setAnnotations(ancestor);
        } else {
            this.setAnnotations(null);
        }
    }

    private void setAnnotations(GeneNode node) {
        this.node = node;
        this.associationModel.setNode(node);
        this.setColumnWidths();
        this.revalidate();
        this.repaint();
    }

    private void setColumnWidths() {
        if (!this.widthsInit) {
            Insets insets = new DefaultTableCellRenderer().getInsets();
            int col_count = this.getColumnCount();
            TableColumnModel col_model = this.getColumnModel();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int remainder = this.getWidth();
            TableColumn term_col = null;
            for (int i = 0; i < col_count; ++i) {
                String col_name = this.getColumnName(i);
                int col_width = -1;
                if (col_name.equals("ECO")) {
                    col_width = fm.stringWidth("IDA") + insets.left + insets.right + 2;
                } else if (col_name.equals("Delete")) {
                    col_width = fm.stringWidth(col_name) + insets.left + insets.right + 2;
                } else if (col_name.equals("Reference")) {
                    col_width = (fm.stringWidth("PUBMED:0000000000") + insets.left + insets.right + 2) * 2;
                } else if (col_name.equals("With")) {
                    col_width = (fm.stringWidth("XXXX0000000000") + insets.left + insets.right + 2) * 2;
                } else if (col_name.equals("NOT") || col_name.equals("Colocalizes with") || col_name.equals("Contributes to")) {
                    col_width = fm.stringWidth("XXX") + insets.left + insets.right + 2;
                } else if (col_name.equals("Term")) {
                    term_col = col_model.getColumn(i);
                }
                if (col_width <= 0) continue;
                TableColumn col = col_model.getColumn(i);
                col.setPreferredWidth(col_width);
                col.setWidth(col_width);
                remainder -= col_width;
            }
            term_col.setPreferredWidth(remainder);
            term_col.setWidth(remainder);
            this.widthsInit = true;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point point = e.getPoint();
        int row = this.rowAtPoint(point);
        if (row >= 0 && row <= this.associationModel.getRowCount()) {
            BrowserLauncher bl;
            ArrayList<String> links;
            Annotation a;
            int column = this.columnAtPoint(point);
            String columnName = this.associationModel.getColumnName(column);
            if ("Term".equals(columnName)) {
                Annotation a2 = this.associationModel.getAnnotation(row);
                if (null == a2) {
                    return;
                }
                HTMLUtil.bringUpInBrowser(PaintManager.inst().getBrowserLauncher(), URL_LINK_PREFIX_AMIGO + a2.getGoTerm());
                return;
            }
            if ("Reference".equals(columnName)) {
                a = this.associationModel.getAnnotation(row);
                if (null == a) {
                    return;
                }
                links = this.associationModel.getLinksForReferenceCol(a);
                bl = PaintManager.inst().getBrowserLauncher();
                if (null != links) {
                    for (String link : links) {
                        HTMLUtil.bringUpInBrowser(bl, link);
                    }
                }
            }
            if ("With".equals(columnName)) {
                a = this.associationModel.getAnnotation(row);
                if (null == a) {
                    return;
                }
                links = this.associationModel.getLinksForWithCol(a);
                bl = PaintManager.inst().getBrowserLauncher();
                if (null != links) {
                    for (String link : links) {
                        HTMLUtil.bringUpInBrowser(bl, link);
                    }
                }
            }
            if (!this.associationModel.isCellEditable(row, column)) {
                return;
            }
            if ("Delete".equals(columnName)) {
                this.associationModel.deleteRow(row);
            }
            if ("NOT".equals(columnName)) {
                this.associationModel.notAnnotation(row);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void newFamilyData(FamilyChangeEvent e) {
        this.clearSelection();
        this.setAnnotations(null);
    }

    @Override
    public void handleAnnotationChangeEvent(AnnotationChangeEvent event) {
        this.associationModel = new AssociationTableModel();
        this.node = (GeneNode)event.getSource();
        this.associationModel.setNode(this.node);
        this.setModel(this.associationModel);
        this.associationModel.fireTableDataChanged();
    }

    @Override
    public void handleAspectChangeEvent(AspectChangeEvent event) {
        this.associationModel = new AssociationTableModel();
        this.associationModel.setNode(this.node);
        this.setModel(this.associationModel);
        this.associationModel.fireTableDataChanged();
    }
}

