/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import com.sri.panther.paintCommon.util.StringUtils;
import edu.usc.ksom.pm.panther.paint.matrix.NodeInfoForMatrix;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationDetail;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.DBReference;
import edu.usc.ksom.pm.panther.paintCommon.Evidence;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import edu.usc.ksom.pm.panther.paintCommon.WithEvidence;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.paint.datamodel.GeneNode;
import org.paint.go.GO_Util;
import org.paint.gui.AspectSelector;
import org.paint.gui.DirtyIndicator;
import org.paint.gui.PaintTable;
import org.paint.gui.association.DeleteButtonRenderer;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.EventManager;
import org.paint.gui.evidence.PaintAction;
import org.paint.main.PaintManager;
import org.paint.util.AnnotationUtil;
import org.paint.util.GeneNodeUtil;
import org.paint.util.RenderUtil;

public class AssociationTableModel
extends AbstractTableModel
implements PaintTable {
    protected static final String TERM_COL_NAME = "Term";
    protected static final String CODE_COL_NAME = "ECO";
    protected static final String REFERENCE_COL_NAME = "Reference";
    protected static final String WITH_COL_NAME = "With";
    protected static final String COL_NAME_QUALIFIER_NOT = "NOT";
    protected static final String COL_NAME_QUALIFIER_COLOCALIZES_WITH = "Colocalizes with";
    protected static final String COL_NAME_QUALIFIER_CONTRIBUTES_TO = "Contributes to";
    protected static final String COL_NAME_DELETE = "Delete";
    public static final String INFERRED_NOT = "inferred NOT";
    public static final String INFERRED = "inferred";
    protected static final String[] column_headings = new String[]{"ECO", "Term", "Reference", "With", "NOT", "Colocalizes with", "Contributes to", "Delete"};
    protected GeneNode gNode;
    protected ArrayList<Annotation> annotList;
    protected String aspect;
    protected GOTermHelper gth;
    protected PaintManager pm;
    protected AnnotationComparator ac = new AnnotationComparator();

    public Annotation getAnnotation(int row) {
        if (null == this.annotList) {
            return null;
        }
        if (row >= 0 && row < this.annotList.size()) {
            return this.annotList.get(row);
        }
        return null;
    }

    public void setNode(GeneNode gene) {
        this.gNode = gene;
        if (null == gene) {
            this.annotList = null;
            return;
        }
        if (GeneNodeUtil.inPrunedBranch(this.gNode)) {
            this.annotList = null;
            return;
        }
        this.pm = PaintManager.inst();
        this.gth = this.pm.goTermHelper();
        Node n = this.gNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            this.annotList = null;
            return;
        }
        ArrayList allAnnot = nvi.getGoAnnotationList();
        if (null == allAnnot) {
            this.annotList = null;
            return;
        }
        this.annotList = new ArrayList();
        this.annotList.addAll(allAnnot);
        Collections.sort(this.annotList, this.ac);
    }

    @Override
    public int getRowCount() {
        if (null == this.annotList) {
            return 0;
        }
        return this.annotList.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= column_headings.length) {
            System.out.println("Invalid column index requested");
            return null;
        }
        return column_headings[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        String tag = column_headings[columnIndex];
        if (tag.equals(COL_NAME_QUALIFIER_NOT) || tag.equals(COL_NAME_QUALIFIER_COLOCALIZES_WITH) || tag.equals(COL_NAME_QUALIFIER_CONTRIBUTES_TO)) {
            return Boolean.class;
        }
        if (tag.equals(COL_NAME_DELETE)) {
            return DeleteButtonRenderer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        HashSet withAnnots;
        if (columnIndex < 0 || columnIndex >= column_headings.length) {
            return false;
        }
        String tag = column_headings[columnIndex];
        if (CODE_COL_NAME.equals(tag) || TERM_COL_NAME.equals(tag) || REFERENCE_COL_NAME.equals(tag) || WITH_COL_NAME.equals(tag) || COL_NAME_QUALIFIER_CONTRIBUTES_TO.equals(tag) || COL_NAME_QUALIFIER_COLOCALIZES_WITH.equals(tag)) {
            return false;
        }
        Object cell = this.getValueAt(rowIndex, columnIndex);
        if (null == cell || !(cell instanceof Boolean)) {
            return false;
        }
        Annotation a = this.annotList.get(rowIndex);
        String code = a.getSingleEvidenceCodeFromSet();
        AnnotationDetail ad = a.getAnnotationDetail();
        if (tag.equals(COL_NAME_QUALIFIER_NOT) && "IBA".equals(code) && null != ad && null != (withAnnots = ad.getWithAnnotSet())) {
            for (Annotation with : withAnnots) {
                String evCodeWith = with.getSingleEvidenceCodeFromSet();
                if (!"IKR".equals(evCodeWith)) continue;
                return false;
            }
        }
        if (tag.equals(COL_NAME_QUALIFIER_NOT) && "IBA".equals(code) && !AnnotationUtil.isIBAFromIBDAndForIKRorIRD(a, this.gNode) && !"TCV".equals(code)) {
            return true;
        }
        if (tag.equals(COL_NAME_DELETE)) {
            if ("TCV".equals(a.getSingleEvidenceCodeFromSet())) {
                return false;
            }
            return AnnotationHelper.isDirectAnnotation((Annotation)a) || a.isExpAnnotCreatedInPaint();
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return column_headings.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HashSet qualifierSet;
        if (null == this.annotList) {
            return null;
        }
        Annotation a = this.annotList.get(rowIndex);
        String tag = column_headings[columnIndex];
        HashSet actualSet = a.getEvidenceCodeSet();
        HashSet<String> displayEvSet = new HashSet<String>();
        for (String code : actualSet) {
            displayEvSet.add(code);
        }
        String evidenceCode = StringUtils.listToString(displayEvSet, (String)"", (String)",");
        if (CODE_COL_NAME.equals(tag)) {
            return evidenceCode;
        }
        if (TERM_COL_NAME.equals(tag)) {
            GOTermHelper gth = PaintManager.inst().goTermHelper();
            GOTerm term = gth.getTerm(a.getGoTerm());
            NodeInfoForMatrix nifm = new NodeInfoForMatrix(this.gNode, term, gth);
            String inferred = null;
            boolean containsNeg = QualifierDif.containsNegative((Set)gth.getValidQualifiersForTerm(term, a.getQualifierSet()));
            if (!containsNeg && (nifm.isExpNot() || nifm.isNonExpNot())) {
                inferred = INFERRED_NOT;
            } else if (!(!containsNeg || nifm.isExpNot() && nifm.isNonExpNot())) {
                inferred = INFERRED;
            }
            Color aspectColor = RenderUtil.getAspectColor(AspectSelector.LETTER_TO_ASPECT.get(term.getAspect()));
            String hexColor = String.format("#%02X%02X%02X", aspectColor.getRed(), aspectColor.getGreen(), aspectColor.getBlue());
            String style = "<head><style>  body {  background-color: " + hexColor + " ; } </style> </head>";
            if (QualifierDif.containsNegative((Set)a.getQualifierSet())) {
                return "<html>" + style + "<body><s>" + term.getName() + "</s> (<a href=\"http://amigo.geneontology.org/amigo/term/" + term.getAcc() + "\" >" + term.getAcc() + "</a>)</body></html>";
            }
            if (INFERRED_NOT.equals(inferred)) {
                return "<html>" + style + "<body><s>" + term.getName() + "</s> (<a href=\"http://amigo.geneontology.org/amigo/term/" + term.getAcc() + "\" >" + term.getAcc() + "</a>) " + inferred + " </body></html>";
            }
            if (INFERRED.equals(inferred)) {
                return "<html>" + style + "<body>" + term.getName() + " (<a href=\"http://amigo.geneontology.org/amigo/term/" + term.getAcc() + "\" >" + term.getAcc() + "</a>) " + inferred + " </body></html>";
            }
            return "<html>" + style + "<body>" + term.getName() + " (<a href=\"http://amigo.geneontology.org/amigo/term/" + term.getAcc() + "\" >" + term.getAcc() + "</a>)</body></html>";
        }
        if (REFERENCE_COL_NAME.equals(tag)) {
            if (a.isExperimental()) {
                return this.getTextForWith(a);
            }
            HashSet withSet = a.getAnnotationDetail().getWithEvidenceSet();
            if (null == withSet || 0 == withSet.size()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            HashMap<CallSite, CallSite> lookup = new HashMap<CallSite, CallSite>();
            for (WithEvidence we : withSet) {
                String key;
                String type = we.getEvidenceType();
                String value = null;
                if (!we.isPAINTType() || lookup.containsKey(key = (type = "PAINT_REF") + (value = GO_Util.inst().getPaintEvidenceAcc()))) continue;
                lookup.put((CallSite)((Object)key), (CallSite)((Object)key));
                sb.append(type);
                sb.append(":");
                sb.append(value);
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        if (WITH_COL_NAME.equals(tag)) {
            if (a.isExperimental()) {
                return "";
            }
            return this.getTextForWith(a);
        }
        if (COL_NAME_QUALIFIER_NOT.equals(tag)) {
            if ("TCV".equals(a.getSingleEvidenceCodeFromSet())) {
                return false;
            }
            qualifierSet = a.getQualifierSet();
            qualifierSet = this.gth.getValidQualifiersForTerm(this.gth.getTerm(a.getGoTerm()), qualifierSet);
            if (null == qualifierSet) {
                return Boolean.FALSE;
            }
            for (Qualifier q : qualifierSet) {
                if (!q.isNot()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (COL_NAME_QUALIFIER_COLOCALIZES_WITH.equals(tag)) {
            qualifierSet = a.getQualifierSet();
            GOTerm term = this.gth.getTerm(a.getGoTerm());
            if (!this.gth.canTermHaveQualifier(term, "COLOCALIZES_WITH")) {
                return null;
            }
            if (null == (qualifierSet = this.gth.getValidQualifiersForTerm(term, qualifierSet))) {
                return Boolean.FALSE;
            }
            for (Qualifier q : qualifierSet) {
                if (!q.isColocalizesWith()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (COL_NAME_QUALIFIER_CONTRIBUTES_TO.equals(tag)) {
            qualifierSet = a.getQualifierSet();
            GOTerm term = this.gth.getTerm(a.getGoTerm());
            if (!this.gth.canTermHaveQualifier(term, "CONTRIBUTES_TO")) {
                return null;
            }
            qualifierSet = this.gth.getValidQualifiersForTerm(this.gth.getTerm(a.getGoTerm()), qualifierSet);
            if (null == qualifierSet) {
                return Boolean.FALSE;
            }
            for (Qualifier q : qualifierSet) {
                if (!q.isContributesTo()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (COL_NAME_DELETE.equals(tag)) {
            if ("TCV".equals(a.getSingleEvidenceCodeFromSet())) {
                return "";
            }
            if (AnnotationHelper.isDirectAnnotation((Annotation)a) || a.isExpAnnotCreatedInPaint()) {
                return Boolean.TRUE;
            }
            return null;
        }
        return "";
    }

    public Vector<WithEvidence> sortWithEvidence(HashSet<WithEvidence> origList) {
        if (null == origList) {
            return null;
        }
        Vector<WithEvidence> rtnList = new Vector<WithEvidence>(origList.size());
        for (WithEvidence withEv : origList) {
            String code = withEv.getEvidenceCode();
            if (!Evidence.isExperimental((String)code) && !Evidence.isPaint((String)code)) {
                rtnList.add(withEv);
                continue;
            }
            DBReference withDBRef = (DBReference)withEv.getWith();
            if (!"PMID".equals(withDBRef.getEvidenceType())) continue;
            rtnList.insertElementAt(withEv, 0);
        }
        return rtnList;
    }

    public String getTextForWith(Annotation a) {
        HashSet nodeSet;
        AnnotationDetail ad = a.getAnnotationDetail();
        HashSet withEvSet = ad.getWithEvidenceDBRefSet();
        StringBuffer sb = new StringBuffer();
        if (null != withEvSet) {
            Vector<WithEvidence> withDBRefSorted = this.sortWithEvidence(withEvSet);
            for (WithEvidence withEv : withDBRefSorted) {
                String code = withEv.getEvidenceCode();
                if (!Evidence.isExperimental((String)code) && !Evidence.isPaint((String)code)) continue;
                DBReference withDBRef = (DBReference)withEv.getWith();
                sb.append(this.getDBValueFormatPMID(withDBRef).toString());
            }
        }
        LinkedHashSet<Node> addedList = new LinkedHashSet<Node>();
        withEvSet = ad.getWithEvidenceAnnotSet();
        if (null != withEvSet) {
            for (WithEvidence withEv : withEvSet) {
                Annotation withAnnot = (Annotation)withEv.getWith();
                Node n = withAnnot.getAnnotationDetail().getAnnotatedNode();
                GeneNode gn = PaintManager.inst().getGeneByPTNId(n.getStaticInfo().getPublicId());
                if (("IKR".equals(withAnnot.getSingleEvidenceCodeFromSet()) || "IRD".equals(a.getSingleEvidenceCodeFromSet()) || "TCV".equals(a.getSingleEvidenceCodeFromSet())) && withAnnot == a) continue;
                addedList.add(withAnnot.getAnnotationDetail().getAnnotatedNode());
            }
        }
        if (null != (nodeSet = ad.getWithNodeSet())) {
            for (Node n : nodeSet) {
                addedList.add(n);
            }
        }
        for (Node node : addedList) {
            sb.append(this.getNodeHttpLink(this.pm.getGeneByPTNId(node.getStaticInfo().getPublicId())));
            sb.append(" ");
        }
        return "<html><body>" + sb.toString().trim() + "</body></html>";
    }

    public ArrayList<String> getLinksForReferenceCol(Annotation a) {
        HashSet actualSet = a.getEvidenceCodeSet();
        HashSet<String> displayEvSet = new HashSet<String>();
        boolean isExperimental = false;
        boolean isPaint = false;
        for (String code : actualSet) {
            if (Evidence.isExperimental((String)code)) {
                displayEvSet.add(code);
                isExperimental = true;
                continue;
            }
            if (!Evidence.isPaint((String)code)) continue;
            displayEvSet.add(code);
            isPaint = true;
        }
        if (isExperimental && !isPaint) {
            return this.getLinksForAnnot(a);
        }
        return null;
    }

    public ArrayList<String> getLinksForWithCol(Annotation a) {
        return this.getLinksForAnnot(a);
    }

    public ArrayList<String> getLinksForAnnot(Annotation a) {
        HashSet nodeSet;
        ArrayList<String> rtnList = new ArrayList<String>();
        AnnotationDetail ad = a.getAnnotationDetail();
        LinkedHashSet<Node> addedList = new LinkedHashSet<Node>();
        HashSet withEvSet = ad.getWithEvidenceAnnotSet();
        if (null != withEvSet) {
            for (WithEvidence withEv : withEvSet) {
                Annotation withAnnot = (Annotation)withEv.getWith();
                Node n = withAnnot.getAnnotationDetail().getAnnotatedNode();
                GeneNode gn = PaintManager.inst().getGeneByPTNId(n.getStaticInfo().getPublicId());
                if (("IKR".equals(withAnnot.getSingleEvidenceCodeFromSet()) && !gn.isLeaf() || "IRD".equals(a.getSingleEvidenceCodeFromSet()) || "TCV".equals(a.getSingleEvidenceCodeFromSet())) && withAnnot == a) continue;
                addedList.add(withAnnot.getAnnotationDetail().getAnnotatedNode());
            }
        }
        if (null != (nodeSet = ad.getWithNodeSet())) {
            for (Node n : nodeSet) {
                addedList.add(n);
            }
        }
        for (Node node : addedList) {
            rtnList.add("http://www.pantree.org/node/annotationNode.jsp?id=" + node.getStaticInfo().getPublicId());
        }
        HashSet dbSet = ad.getWithOtherSet();
        if (null != dbSet) {
            for (DBReference dbRef : dbSet) {
                if (!"PMID".equals(dbRef.getEvidenceType())) continue;
                rtnList.add("https://www.ncbi.nlm.nih.gov/pubmed/" + dbRef.getEvidenceValue());
            }
        }
        if (rtnList.isEmpty()) {
            return null;
        }
        return rtnList;
    }

    @Override
    public String getTextAt(int row, int column) {
        if (null == this.annotList) {
            return null;
        }
        Annotation a = this.annotList.get(row);
        String tag = column_headings[column];
        if (CODE_COL_NAME.equals(tag)) {
            HashSet evidenceCodeSet = a.getEvidenceCodeSet();
            return StringUtils.listToString((Collection)evidenceCodeSet, (String)"", (String)",");
        }
        if (TERM_COL_NAME.equals(tag)) {
            GOTerm term = PaintManager.inst().goTermHelper().getTerm(a.getGoTerm());
            return term.getName() + "(" + term.getAcc() + ")";
        }
        if (REFERENCE_COL_NAME.equals(tag)) {
            HashSet withSet = a.getAnnotationDetail().getWithEvidenceSet();
            if (null == withSet || 0 == withSet.size()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            HashMap<CallSite, CallSite> lookup = new HashMap<CallSite, CallSite>();
            for (WithEvidence we : withSet) {
                String key;
                String type = we.getEvidenceType();
                String value = we.getEvidenceId();
                if (we.isPAINTType()) {
                    type = "PAINT_REF";
                    value = GO_Util.inst().getPaintEvidenceAcc();
                }
                if (lookup.containsKey(key = type + value)) continue;
                lookup.put((CallSite)((Object)key), (CallSite)((Object)key));
                sb.append(type);
                sb.append(":");
                sb.append(value);
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        if (WITH_COL_NAME.equals(tag)) {
            HashSet nodeSet;
            AnnotationDetail ad = a.getAnnotationDetail();
            LinkedHashSet<Node> addedList = new LinkedHashSet<Node>();
            HashSet withs = ad.getWithAnnotSet();
            if (null != withs) {
                for (Annotation with : withs) {
                    Node n = with.getAnnotationDetail().getAnnotatedNode();
                    GeneNode gn = PaintManager.inst().getGeneByPTNId(n.getStaticInfo().getPublicId());
                    if (("IKR".equals(a.getSingleEvidenceCodeFromSet()) && !gn.isLeaf() || "IRD".equals(a.getSingleEvidenceCodeFromSet())) && with == a) continue;
                    addedList.add(with.getAnnotationDetail().getAnnotatedNode());
                }
            }
            if (null != (nodeSet = ad.getWithNodeSet())) {
                for (Node n : nodeSet) {
                    addedList.add(n);
                }
            }
            StringBuffer sb = new StringBuffer();
            for (Node node : addedList) {
                sb.append(this.pm.getGeneByPTNId(node.getStaticInfo().getPublicId()).getNodeLabel() + node.getStaticInfo().getPublicId());
                sb.append(" ");
            }
            HashSet dbSet = ad.getWithOtherSet();
            if (null != dbSet) {
                for (DBReference dbref : dbSet) {
                    sb.append(this.getDBValue(dbref).toString());
                }
            }
            return sb.toString().trim();
        }
        return "";
    }

    private StringBuffer getDBValue(DBReference dbRef) {
        StringBuffer sb = new StringBuffer();
        if ("PANTHER".equals(dbRef.getEvidenceType())) {
            String value = dbRef.getEvidenceValue();
            GeneNode gn = PaintManager.inst().getGeneByPTNId(value);
            if (null != gn && gn.isLeaf()) {
                sb.append(gn.getNodeLabel());
                sb.append(" ");
                return sb;
            }
        }
        sb.append(dbRef.getEvidenceType());
        sb.append(":");
        sb.append(dbRef.getEvidenceValue());
        sb.append(" ");
        return sb;
    }

    private StringBuffer getNodeHttpLink(GeneNode gNode) {
        StringBuffer sb = new StringBuffer();
        String nodeLabel = gNode.getNodeLabelWithPTN();
        if (null == nodeLabel || 0 == nodeLabel.trim().length()) {
            nodeLabel = gNode.getNode().getStaticInfo().getPublicId();
        }
        sb.append("<a href=\"http://www.pantree.org/node/annotationNode.jsp?id=" + gNode.getNode().getStaticInfo().getPublicId() + "\">" + nodeLabel + "</a>");
        sb.append(" ");
        return sb;
    }

    private StringBuffer getDBValueFormatPMID(DBReference dbRef) {
        StringBuffer sb = new StringBuffer();
        String evidenceType = dbRef.getEvidenceType();
        if ("PANTHER".equals(evidenceType)) {
            System.out.println("Dont expect to get here anymore");
            String value = dbRef.getEvidenceValue();
            GeneNode gn = PaintManager.inst().getGeneByPTNId(value);
            if (null != gn && gn.isLeaf()) {
                sb.append(gn.getNodeLabel());
                sb.append(" ");
                return sb;
            }
        }
        if ("PMID".equals(evidenceType)) {
            sb.append("<a href=\"https://www.ncbi.nlm.nih.gov/pubmed/" + dbRef.getEvidenceValue() + "\"> PMID:" + dbRef.getEvidenceValue() + "</a>");
            sb.append(" ");
            return sb;
        }
        sb.append(evidenceType);
        sb.append(":");
        sb.append(dbRef.getEvidenceValue());
        sb.append(" ");
        return sb;
    }

    @Override
    public boolean isSquare(int column) {
        String tag = this.getColumnName(column);
        return tag.equals(COL_NAME_QUALIFIER_NOT) || tag.equals(COL_NAME_QUALIFIER_COLOCALIZES_WITH) || tag.equals(COL_NAME_QUALIFIER_CONTRIBUTES_TO) || tag.equals(COL_NAME_DELETE);
    }

    public void deleteRow(int rowIndex) {
        if (null == this.annotList || rowIndex > this.annotList.size() || rowIndex < 0) {
            return;
        }
        Annotation a = this.annotList.get(rowIndex);
        if (a.isExpAnnotCreatedInPaint()) {
            PaintAction.inst().removeExperimentalAnnotation(this.gNode, a);
            return;
        }
        AnnotationHelper.deleteAnnotationAndRepropagate((Annotation)a, (TaxonomyHelper)this.pm.getTaxonHelper(), (GOTermHelper)this.pm.goTermHelper());
        DirtyIndicator.inst().setAnnotated(true);
        EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(this.gNode));
    }

    public void notAnnotation(int rowIndex) {
        if (null == this.annotList || rowIndex > this.annotList.size() || rowIndex < 0) {
            return;
        }
        Annotation a = this.annotList.get(rowIndex);
        PaintAction.inst().notAnnotation(this.gNode, a);
    }

    private class AnnotationComparator
    implements Comparator {
        private AnnotationComparator() {
        }

        public int compare(Object o1, Object o2) {
            GOTerm a2;
            String term1 = ((Annotation)o1).getGoTerm();
            String term2 = ((Annotation)o2).getGoTerm();
            if (null == term1 && null == term2) {
                return 0;
            }
            if (null != term1 && null == term2) {
                return 1;
            }
            if (null == term1 && null != term2) {
                return -1;
            }
            GOTerm a1 = AssociationTableModel.this.gth.getTerm(term1);
            if (a1.equals(a2 = AssociationTableModel.this.gth.getTerm(term2))) {
                return 0;
            }
            int comp = a1.getAspect().compareTo(a2.getAspect());
            if (0 == comp) {
                return a1.getAcc().compareTo(a2.getAcc());
            }
            return comp;
        }
    }
}

