/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.bbop.swing.HyperlinkLabel;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.DBXref;
import org.geneontology.db.model.Evidence;
import org.geneontology.db.model.Term;
import org.paint.datamodel.GeneNode;
import org.paint.go.GO_Util;
import org.paint.gui.PaintTable;
import org.paint.gui.association.EvidenceComparator;

public class AssociationsTableModel
extends AbstractTableModel
implements PaintTable {
    private static final long serialVersionUID = 1L;
    protected static final String TERM_COL_NAME = "Term";
    protected static final String CODE_COL_NAME = "ECO";
    protected static final String REFERENCE_COL_NAME = "Reference";
    protected static final String WITH_COL_NAME = "With";
    protected static final String TRASH_COL_NAME = "DEL";
    protected static final String[] column_headings = new String[]{"ECO", "Term", "Reference", "With", "DEL"};
    protected GeneNode node;
    protected ArrayList<Evidence> evidence = new ArrayList();
    protected HashMap<Evidence, HyperlinkLabel> pub_labels = new HashMap();
    protected HashMap<Evidence, Set<HyperlinkLabel>> with_labels = new HashMap();
    protected static Logger log = Logger.getLogger(AssociationsTableModel.class);

    public void setNode(GeneNode gene) {
        this.node = gene;
        this.evidence.clear();
        this.pub_labels.clear();
        this.with_labels.clear();
    }

    public void removeAssociation(Association assoc) {
        for (int i = this.evidence.size() - 1; i >= 0; --i) {
            Evidence table_evi = this.evidence.get(i);
            if (!table_evi.getAssociation().equals((Object)assoc)) continue;
            this.pub_labels.remove(table_evi);
            this.with_labels.remove(table_evi);
            this.evidence.remove(i);
        }
    }

    @Override
    public String getTextAt(int row, int column) {
        if (this.getRowCount() == 0) {
            return null;
        }
        String tag = column_headings[column];
        Evidence evi = this.evidence.get(row);
        if (tag.equals(CODE_COL_NAME)) {
            return CODE_COL_NAME;
        }
        if (tag.equals(TERM_COL_NAME)) {
            return evi.getAssociation().getTerm().getName();
        }
        if (tag.equals(REFERENCE_COL_NAME)) {
            DBXref xref = evi.getDbxref();
            String xref_text = xref.getDb_name() + ":" + xref.getAccession();
            return xref_text;
        }
        if (tag.equals(TRASH_COL_NAME)) {
            return TRASH_COL_NAME;
        }
        if (tag.equals(WITH_COL_NAME)) {
            return GO_Util.inst().getWithText(evi.getWiths());
        }
        return "";
    }

    public Term getTermForRow(int row) {
        Evidence evi = this.evidence.get(row);
        Term term = evi.getAssociation().getTerm();
        return term;
    }

    public Evidence getEvidenceForRow(int row) {
        return this.evidence.get(row);
    }

    public Class getColumnClass(int columnIndex) {
        Class<Object> check = null;
        Object value = this.getValueAt(0, columnIndex);
        if (value != null) {
            check = value.getClass();
            if (check == null) {
                System.out.println("Table returning null for column " + columnIndex);
            }
        } else {
            String tag = column_headings[columnIndex];
            if (tag.equals(CODE_COL_NAME)) {
                check = Evidence.class;
            } else if (tag.equals(TERM_COL_NAME)) {
                check = Association.class;
            } else if (tag.equals(REFERENCE_COL_NAME)) {
                check = HyperlinkLabel.class;
            } else if (tag.equals(TRASH_COL_NAME)) {
                check = Boolean.class;
            } else if (tag.equals(WITH_COL_NAME)) {
                check = Set.class;
            }
        }
        return check;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return column_headings[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (null == this.evidence || rowIndex >= this.getRowCount() || rowIndex < 0) {
            return null;
        }
        Evidence evi = this.evidence.get(rowIndex);
        String tag = column_headings[columnIndex];
        if (tag.equals(CODE_COL_NAME)) {
            return evi;
        }
        if (tag.equals(TERM_COL_NAME)) {
            Association assoc = evi.getAssociation();
            return assoc;
        }
        if (tag.equals(REFERENCE_COL_NAME)) {
            return this.pub_labels.get(evi);
        }
        if (tag.equals(TRASH_COL_NAME)) {
            return Boolean.FALSE;
        }
        if (tag.equals(WITH_COL_NAME)) {
            return this.with_labels.get(evi);
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return column_headings.length;
    }

    @Override
    public int getRowCount() {
        return this.evidence.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        Object cell = this.getValueAt(rowIndex, colIndex);
        return cell != null && cell instanceof Boolean;
    }

    private void sort() {
        Collections.sort(this.evidence, new EvidenceComparator());
    }

    @Override
    public boolean isSquare(int column) {
        return this.getColumnName(column).equals(TRASH_COL_NAME);
    }
}

