/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.geneontology.db.model.Evidence;
import org.geneontology.db.model.Term;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOSession;
import org.paint.go.GO_Util;
import org.paint.main.PaintManager;

public class EvidenceComparator
implements Comparator<Evidence> {
    public static final int LESS_THAN = -1;
    public static final int GREATER_THAN = 1;
    public static final int EQUAL_TO = 0;

    @Override
    public int compare(Evidence fa, Evidence fb) {
        String aspect_b;
        Term term_a = fa.getAssociation().getTerm();
        Term term_b = fb.getAssociation().getTerm();
        String aspect_a = term_a.getCv();
        int comparison = this.compareStrings(aspect_a, aspect_b = term_b.getCv()) * -1;
        if (comparison == 0) {
            OBOSession go_root = PaintManager.inst().getGoRoot();
            LinkDatabase ld = go_root.getLinkDatabase();
            LinkedObject go_a = (LinkedObject)GO_Util.inst().getObject(ld, term_a.getAcc());
            LinkedObject go_b = (LinkedObject)GO_Util.inst().getObject(ld, term_b.getAcc());
            if (go_a != null && go_b != null) {
                comparison = EvidenceComparator.isParent(go_a, go_b);
                if (comparison == 0) {
                    comparison = EvidenceComparator.isParent(go_b, go_a) * -1;
                }
                if (comparison == 0) {
                    comparison = this.compareStrings(go_a.getName(), go_b.getName());
                }
            }
        }
        return comparison;
    }

    private int compareStrings(String a, String b) {
        int comparison = a.compareTo(b);
        comparison = comparison < 0 ? -1 : (comparison > 0 ? 1 : 0);
        return comparison;
    }

    protected static int isParent(LinkedObject c, LinkedObject p) {
        int comparison = 0;
        Collection parents = c.getParents();
        if (parents.size() > 0) {
            if (parents.contains(p)) {
                comparison = -1;
            } else {
                Iterator it = parents.iterator();
                while (it.hasNext() && comparison == 0) {
                    Link l = (Link)it.next();
                    comparison = EvidenceComparator.isParent(l.getParent(), p);
                }
            }
        }
        return comparison;
    }
}

