/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.paint.datamodel.GeneNode;
import org.paint.gui.association.DeleteButtonRenderer;
import org.paint.gui.association.ExpAssociationTableModel;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.AnnotationChangeListener;
import org.paint.gui.event.EventManager;

public class ExpAssociationTable
extends JTable
implements AnnotationChangeListener,
MouseListener {
    private GeneNode node;
    private ExpAssociationTableModel associationModel;

    @Override
    public void handleAnnotationChangeEvent(AnnotationChangeEvent event) {
        this.associationModel = new ExpAssociationTableModel();
        this.node = (GeneNode)event.getSource();
        this.associationModel.setNode(this.node);
        this.setModel(this.associationModel);
        this.associationModel.fireTableDataChanged();
    }

    public ExpAssociationTable(GeneNode node) {
        this.node = node;
        this.associationModel = new ExpAssociationTableModel();
        this.setModel(this.associationModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.associationModel.setNode(node);
        EventManager.inst().registerGeneAnnotationChangeListener(this);
        this.addMouseListener(this);
    }

    public void windowClosing() {
        EventManager.inst().removeGeneAnnotationChangeListener(this);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        String tag = ExpAssociationTableModel.column_headings[column];
        if (tag.equals("Delete")) {
            return new DeleteButtonRenderer();
        }
        if (tag.equals("NOT") || tag.equals("Colocalizes with") || tag.equals("Contributes to")) {
            return this.getDefaultRenderer(Boolean.class);
        }
        return this.getDefaultRenderer(String.class);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point point = e.getPoint();
        int row = this.rowAtPoint(point);
        if (row >= 0 && row <= this.associationModel.getRowCount()) {
            int column = this.columnAtPoint(point);
            String columnName = this.associationModel.getColumnName(column);
            if ("Delete".equals(columnName)) {
                this.associationModel.deleteRow(row);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

