/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import com.sri.panther.paintCommon.util.StringUtils;
import edu.usc.ksom.pm.panther.paint.matrix.NodeInfoForMatrix;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import edu.usc.ksom.pm.panther.paintCommon.WithEvidence;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.paint.go.GO_Util;
import org.paint.gui.AspectSelector;
import org.paint.gui.association.AssociationTableModel;
import org.paint.gui.association.DeleteButtonRenderer;
import org.paint.gui.evidence.PaintAction;
import org.paint.main.PaintManager;
import org.paint.util.RenderUtil;

public class ExpAssociationTableModel
extends AssociationTableModel {
    @Override
    public Class getColumnClass(int columnIndex) {
        String tag = column_headings[columnIndex];
        if (tag.equals("NOT") || tag.equals("Colocalizes with") || tag.equals("Contributes to")) {
            return Boolean.class;
        }
        if (tag.equals("Delete")) {
            return DeleteButtonRenderer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= column_headings.length) {
            return false;
        }
        String tag = column_headings[columnIndex];
        if (!tag.equals("Delete")) {
            return false;
        }
        Annotation a = (Annotation)this.annotList.get(rowIndex);
        return false != a.isExpAnnotCreatedInPaint();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HashSet qualifierSet;
        if (null == this.annotList) {
            return null;
        }
        Annotation a = (Annotation)this.annotList.get(rowIndex);
        String tag = column_headings[columnIndex];
        HashSet actualSet = a.getEvidenceCodeSet();
        HashSet<String> displayEvSet = new HashSet<String>();
        for (String code : actualSet) {
            displayEvSet.add(code);
        }
        String evidenceCode = StringUtils.listToString(displayEvSet, (String)"", (String)",");
        if ("ECO".equals(tag)) {
            return evidenceCode;
        }
        if ("Term".equals(tag)) {
            GOTermHelper gth = PaintManager.inst().goTermHelper();
            GOTerm term = gth.getTerm(a.getGoTerm());
            NodeInfoForMatrix nifm = new NodeInfoForMatrix(this.gNode, term, gth);
            String inferred = null;
            boolean containsNeg = QualifierDif.containsNegative((Set)gth.getValidQualifiersForTerm(term, a.getQualifierSet()));
            if (!containsNeg && (nifm.isExpNot() || nifm.isNonExpNot())) {
                inferred = "inferred NOT";
            } else if (!(!containsNeg || nifm.isExpNot() && nifm.isNonExpNot())) {
                inferred = "inferred";
            }
            Color aspectColor = RenderUtil.getAspectColor(AspectSelector.LETTER_TO_ASPECT.get(term.getAspect()));
            String hexColor = String.format("#%02X%02X%02X", aspectColor.getRed(), aspectColor.getGreen(), aspectColor.getBlue());
            String style = "<head><style>  body {  background-color: " + hexColor + " ; } </style> </head>";
            if (QualifierDif.containsNegative((Set)a.getQualifierSet())) {
                return "<html>" + style + "<body><s>" + term.getName() + "</s> (<a href=\"http://amigo.geneontology.org/amigo/term/" + term.getAcc() + "\" >" + term.getAcc() + "</a>)</body></html>";
            }
            if ("inferred NOT".equals(inferred)) {
                return "<html>" + style + "<body><s>" + term.getName() + "</s> (<a href=\"http://amigo.geneontology.org/amigo/term/" + term.getAcc() + "\" >" + term.getAcc() + "</a>) " + inferred + " </body></html>";
            }
            if ("inferred".equals(inferred)) {
                return "<html>" + style + "<body>" + term.getName() + " (<a href=\"http://amigo.geneontology.org/amigo/term/" + term.getAcc() + "\" >" + term.getAcc() + "</a>) " + inferred + " </body></html>";
            }
            return "<html>" + style + "<body>" + term.getName() + " (<a href=\"http://amigo.geneontology.org/amigo/term/" + term.getAcc() + "\" >" + term.getAcc() + "</a>)</body></html>";
        }
        if ("Reference".equals(tag)) {
            if (a.isExperimental()) {
                return this.getTextForWith(a);
            }
            HashSet withSet = a.getAnnotationDetail().getWithEvidenceSet();
            if (null == withSet || 0 == withSet.size()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            HashMap<CallSite, CallSite> lookup = new HashMap<CallSite, CallSite>();
            for (WithEvidence we : withSet) {
                String key;
                String type = we.getEvidenceType();
                String value = null;
                if (!we.isPAINTType() || lookup.containsKey(key = (type = "PAINT_REF") + (value = GO_Util.inst().getPaintEvidenceAcc()))) continue;
                lookup.put((CallSite)((Object)key), (CallSite)((Object)key));
                sb.append(type);
                sb.append(":");
                sb.append(value);
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        if ("With".equals(tag)) {
            if (a.isExperimental()) {
                return "";
            }
            return this.getTextForWith(a);
        }
        if ("NOT".equals(tag)) {
            if ("TCV".equals(a.getSingleEvidenceCodeFromSet())) {
                return false;
            }
            qualifierSet = a.getQualifierSet();
            qualifierSet = this.gth.getValidQualifiersForTerm(this.gth.getTerm(a.getGoTerm()), qualifierSet);
            if (null == qualifierSet) {
                return Boolean.FALSE;
            }
            for (Qualifier q : qualifierSet) {
                if (!q.isNot()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if ("Colocalizes with".equals(tag)) {
            qualifierSet = a.getQualifierSet();
            GOTerm term = this.gth.getTerm(a.getGoTerm());
            if (!this.gth.canTermHaveQualifier(term, "COLOCALIZES_WITH")) {
                return null;
            }
            if (null == (qualifierSet = this.gth.getValidQualifiersForTerm(term, qualifierSet))) {
                return Boolean.FALSE;
            }
            for (Qualifier q : qualifierSet) {
                if (!q.isColocalizesWith()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if ("Contributes to".equals(tag)) {
            qualifierSet = a.getQualifierSet();
            GOTerm term = this.gth.getTerm(a.getGoTerm());
            if (!this.gth.canTermHaveQualifier(term, "CONTRIBUTES_TO")) {
                return null;
            }
            qualifierSet = this.gth.getValidQualifiersForTerm(this.gth.getTerm(a.getGoTerm()), qualifierSet);
            if (null == qualifierSet) {
                return Boolean.FALSE;
            }
            for (Qualifier q : qualifierSet) {
                if (!q.isContributesTo()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if ("Delete".equals(tag)) {
            if (this.isCellEditable(rowIndex, columnIndex)) {
                return Boolean.TRUE;
            }
            return null;
        }
        return "";
    }

    @Override
    public void deleteRow(int rowIndex) {
        if (null == this.annotList || rowIndex > this.annotList.size() || rowIndex < 0) {
            return;
        }
        Annotation a = (Annotation)this.annotList.get(rowIndex);
        PaintAction.inst().removeExperimentalAnnotation(this.gNode, a);
    }
}

