/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;
import org.bbop.swing.ScaledIcon;
import org.geneontology.db.model.Evidence;
import org.geneontology.db.model.Term;
import org.paint.config.Preferences;
import org.paint.go.GO_Util;
import org.paint.gui.association.AssociationsTableModel;
import org.paint.util.RenderUtil;

public class GOTermRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected boolean selected = false;
    protected int row = 0;
    protected int column = 0;
    protected static Logger log = Logger.getLogger(GOTermRenderer.class);
    protected static final String CONTRIBUTES_ICON = "images/contributes.gif";
    protected static final String COLOCATES_ICON = "images/colocate.gif";
    private Evidence evi;
    private Term term;
    private Color bg_color;
    protected ScaledIcon contributes_icon = new ScaledIcon(null);
    protected ScaledIcon colocates_icon = new ScaledIcon(null);

    public GOTermRenderer() {
        this.contributes_icon = new ScaledIcon(null);
        Icon icon = Preferences.inst().getIconByName("colocate");
        this.colocates_icon.setIcon(icon);
        if (this.colocates_icon != null) {
            this.colocates_icon.setDimension(15);
        }
        icon = Preferences.inst().getIconByName("contribute");
        this.contributes_icon.setIcon(icon);
        if (this.contributes_icon != null) {
            this.contributes_icon.setDimension(15);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Preferences dp = Preferences.inst();
        this.setFont(dp.getFont());
        this.setForeground(dp.getForegroundColor());
        this.selected = isSelected;
        this.row = row;
        this.column = column;
        this.evi = ((AssociationsTableModel)table.getModel()).getEvidenceForRow(row);
        this.term = this.evi.getAssociation().getTerm();
        this.bg_color = RenderUtil.getAspectColor(this.term.getCv());
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        int x = 6;
        RenderUtil.paintBorder(g, new Rectangle(0, 0, bounds.width, bounds.height), this.bg_color, this.selected);
        if (GO_Util.inst().colocalizes(this.evi.getAssociation()) && this.colocates_icon != null) {
            this.colocates_icon.paintIcon((Component)this, g, x, 1);
            x += this.colocates_icon.getIconWidth();
        }
        if (GO_Util.inst().contributesTo(this.evi.getAssociation()) && this.contributes_icon != null) {
            this.contributes_icon.paintIcon((Component)this, g, x, 1);
            x += this.contributes_icon.getIconWidth();
        }
        g.setColor(Color.blue);
        Font font = g.getFont();
        AttributedString as = new AttributedString(this.term.getName() + " (" + this.term.getAcc() + ")");
        as.addAttribute(TextAttribute.FONT, font);
        if (this.evi.getAssociation().isNot()) {
            g.setColor(Color.magenta);
            as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        g.drawString(as.getIterator(), x, bounds.height - 3);
    }
}

