/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;
import org.bbop.swing.ExtensibleLabelUI;
import org.bbop.swing.HyperlinkLabel;
import org.geneontology.db.model.Term;
import org.paint.config.Preferences;
import org.paint.gui.association.AssociationsTableModel;
import org.paint.util.RenderUtil;

public class HyperlinkCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(HyperlinkCellRenderer.class);
    protected HyperlinkLabel label;
    private Color bg_color;
    private boolean selected;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.selected = isSelected;
        Preferences dp = Preferences.inst();
        this.setFont(dp.getFont());
        this.setForeground(dp.getForegroundColor());
        if (value != null) {
            this.label = (HyperlinkLabel)value;
            String tip = this.label.getToolTipText();
            this.setToolTipText(tip);
            UIManager.put("ToolTip.foreground", dp.getForegroundColor());
            ToolTipManager.sharedInstance().setDismissDelay(999999999);
        }
        Term term = ((AssociationsTableModel)table.getModel()).getTermForRow(row);
        this.bg_color = RenderUtil.getAspectColor(term.getCv());
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        Rectangle local_bounds = new Rectangle(0, 0, bounds.width, bounds.height);
        RenderUtil.paintBorder(g, local_bounds, this.bg_color, this.selected);
        if (this.label != null) {
            ExtensibleLabelUI.Renderer r = (ExtensibleLabelUI.Renderer)this.label.getClientProperty((Object)"html");
            r.paint(g, (Shape)local_bounds);
        }
    }
}

