/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.bbop.swing.ScaledIcon;
import org.geneontology.db.model.Term;
import org.paint.config.Preferences;
import org.paint.gui.association.AssociationsTableModel;
import org.paint.util.RenderUtil;

public class TrashCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected ScaledIcon scaledIcon = new ScaledIcon(null);
    private boolean selected;
    private Color bg_color;

    public TrashCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.selected = isSelected;
        Icon icon = null;
        this.setText("");
        boolean deletable = (Boolean)value;
        if (deletable) {
            icon = Preferences.inst().getIconByName("trash");
        }
        this.scaledIcon.setIcon(icon);
        if (this.scaledIcon != null) {
            this.scaledIcon.setDimension(15);
            this.setIcon((Icon)this.scaledIcon);
        } else {
            this.setIcon(null);
        }
        Term term = ((AssociationsTableModel)table.getModel()).getTermForRow(row);
        this.bg_color = RenderUtil.getAspectColor(term.getCv());
        this.setBackground(this.bg_color);
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        RenderUtil.paintBorder(g, new Rectangle(0, 0, this.getWidth(), this.getHeight()), null, this.selected);
    }
}

