/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.association;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;
import org.bbop.swing.ExtensibleLabelUI;
import org.bbop.swing.HyperlinkLabel;
import org.geneontology.db.model.Term;
import org.paint.config.Preferences;
import org.paint.gui.association.AssociationsTableModel;
import org.paint.util.RenderUtil;

public class WithCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(WithCellRenderer.class);
    private boolean selected;
    private Color bg_color;
    private HyperlinkLabel with;

    public WithCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.selected = isSelected;
        Preferences prefs = Preferences.inst();
        this.setFont(prefs.getFont());
        this.setForeground(prefs.getForegroundColor());
        Term term = ((AssociationsTableModel)table.getModel()).getTermForRow(row);
        this.bg_color = RenderUtil.getAspectColor(term.getCv());
        this.setBackground(this.bg_color);
        Set withs = (Set)value;
        if (withs != null) {
            this.with = (HyperlinkLabel)withs.iterator().next();
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        Rectangle local_bounds = new Rectangle(0, 0, bounds.width, bounds.height);
        RenderUtil.paintBorder(g, local_bounds, this.bg_color, this.selected);
        if (this.with != null) {
            ExtensibleLabelUI.Renderer r = (ExtensibleLabelUI.Renderer)this.with.getClientProperty((Object)"html");
            r.paint(g, (Shape)local_bounds);
        }
    }
}

