/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.event;

import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.geneontology.db.model.Term;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.paint.datamodel.Family;
import org.paint.datamodel.GeneNode;
import org.paint.go.GO_Util;
import org.paint.gui.AspectSelector;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.AnnotationChangeListener;
import org.paint.gui.event.AnnotationDisplayEvent;
import org.paint.gui.event.AnnotationDisplayListener;
import org.paint.gui.event.AnnotationDragEvent;
import org.paint.gui.event.AnnotationDragListener;
import org.paint.gui.event.AspectChangeEvent;
import org.paint.gui.event.AspectChangeListener;
import org.paint.gui.event.CommentChangeEvent;
import org.paint.gui.event.CommentChangeListener;
import org.paint.gui.event.CurationColorEvent;
import org.paint.gui.event.CurationColorListener;
import org.paint.gui.event.FamilyChangeEvent;
import org.paint.gui.event.FamilyChangeListener;
import org.paint.gui.event.GeneDataEvent;
import org.paint.gui.event.GeneSelectEvent;
import org.paint.gui.event.GeneSelectListener;
import org.paint.gui.event.NodeReorderEvent;
import org.paint.gui.event.NodeReorderListener;
import org.paint.gui.event.NodeScrollEvent;
import org.paint.gui.event.NodeScrollListener;
import org.paint.gui.event.ProgressEvent;
import org.paint.gui.event.ProgressListener;
import org.paint.gui.event.SubFamilyListener;
import org.paint.gui.event.TermAncestorSelectionListener;
import org.paint.gui.event.TermSelectEvent;
import org.paint.gui.event.TermSelectionListener;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.table.GeneTable;
import org.paint.gui.table.GeneTableModel;
import org.paint.main.PaintManager;

public class EventManager {
    private static EventManager INSTANCE = null;
    private static final long serialVersionUID = 1L;
    private HashSet<NodeScrollListener> scroll_listeners;
    private HashSet<GeneSelectListener> gene_listeners;
    private HashSet<TermSelectionListener> term_listeners;
    private HashSet<TermAncestorSelectionListener> termAncestorListeners;
    private HashSet<NodeReorderListener> node_listeners;
    private HashSet<SubFamilyListener> subfamily_listeners;
    private HashSet<ProgressListener> progressListeners;
    private HashSet<AnnotationChangeListener> geneAnnotationChangeListeners;
    private HashSet<AspectChangeListener> aspectChangeListeners;
    private HashSet<CurationColorListener> colorChangeListeners;
    private HashSet<AnnotationDragListener> annotationDragListeners;
    private HashSet<CommentChangeListener> commentChangeListeners;
    private HashSet<AnnotationDisplayListener> annotationDisplayListeners;
    protected List<GeneNode> selectedNodes;
    protected List<Term> term_selection;
    protected TermAncestor termAncestor;
    protected GeneNode top_node;
    private List<FamilyChangeListener> family_listeners = new ArrayList<FamilyChangeListener>(6);
    private boolean is_adjusting = false;

    private EventManager() {
    }

    public static synchronized EventManager inst() {
        if (INSTANCE == null) {
            INSTANCE = new EventManager();
        }
        return INSTANCE;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void registerNodeScrollListener(NodeScrollListener listener) {
        if (this.scroll_listeners == null) {
            this.scroll_listeners = new HashSet();
        }
        if (!this.scroll_listeners.contains(listener)) {
            this.scroll_listeners.add(listener);
        }
    }

    public void registerGeneListener(GeneSelectListener listener) {
        if (this.gene_listeners == null) {
            this.gene_listeners = new HashSet();
        }
        if (!this.gene_listeners.contains(listener)) {
            this.gene_listeners.add(listener);
        }
    }

    public void registerTermListener(TermSelectionListener listener) {
        if (this.term_listeners == null) {
            this.term_listeners = new HashSet();
        }
        if (!this.term_listeners.contains(listener)) {
            this.term_listeners.add(listener);
        }
    }

    public void registerTermAncestorListener(TermAncestorSelectionListener listener) {
        if (this.termAncestorListeners == null) {
            this.termAncestorListeners = new HashSet();
        }
        if (!this.termAncestorListeners.contains(listener)) {
            this.termAncestorListeners.add(listener);
        }
    }

    public void registerSubFamilyListener(SubFamilyListener listener) {
        if (this.subfamily_listeners == null) {
            this.subfamily_listeners = new HashSet();
        }
        if (!this.subfamily_listeners.contains(listener)) {
            this.subfamily_listeners.add(listener);
        }
    }

    public void registerNodeReorderListener(NodeReorderListener listener) {
        if (this.node_listeners == null) {
            this.node_listeners = new HashSet();
        }
        if (!this.node_listeners.contains(listener)) {
            this.node_listeners.add(listener);
        }
    }

    public void registerProgressListener(ProgressListener listener) {
        if (this.progressListeners == null) {
            this.progressListeners = new HashSet();
        }
        if (!this.progressListeners.contains(listener)) {
            this.progressListeners.add(listener);
        }
    }

    public void registerGeneAnnotationChangeListener(AnnotationChangeListener listener) {
        if (this.geneAnnotationChangeListeners == null) {
            this.geneAnnotationChangeListeners = new HashSet();
        }
        if (!this.geneAnnotationChangeListeners.contains(listener)) {
            this.geneAnnotationChangeListeners.add(listener);
        }
    }

    public void removeGeneAnnotationChangeListener(AnnotationChangeListener listener) {
        if (this.geneAnnotationChangeListeners != null) {
            this.geneAnnotationChangeListeners.remove(listener);
        }
    }

    public void registerCommentChangeListener(CommentChangeListener listener) {
        if (null == this.commentChangeListeners) {
            this.commentChangeListeners = new HashSet();
        }
        this.commentChangeListeners.add(listener);
    }

    public void registerAnnotationDisplayListener(AnnotationDisplayListener listener) {
        if (null == this.annotationDisplayListeners) {
            this.annotationDisplayListeners = new HashSet();
        }
        this.annotationDisplayListeners.add(listener);
    }

    public void registerAspectChangeListener(AspectChangeListener listener) {
        if (this.aspectChangeListeners == null) {
            this.aspectChangeListeners = new HashSet();
        }
        if (!this.aspectChangeListeners.contains(listener)) {
            this.aspectChangeListeners.add(listener);
        }
    }

    public void registerCurationColorListener(CurationColorListener listener) {
        if (this.colorChangeListeners == null) {
            this.colorChangeListeners = new HashSet();
        }
        if (!this.colorChangeListeners.contains(listener)) {
            this.colorChangeListeners.add(listener);
        }
    }

    public void registerAnnotationDragListener(AnnotationDragListener listener) {
        if (this.annotationDragListeners == null) {
            this.annotationDragListeners = new HashSet();
        }
        if (!this.annotationDragListeners.contains(listener)) {
            this.annotationDragListeners.add(listener);
        }
    }

    public void fireGeneEvent(GeneSelectEvent e) {
        boolean selection_changed;
        List<GeneNode> new_genes = e.getGenes();
        boolean bl = selection_changed = this.selectedNodes == null || this.selectedNodes != null && new_genes.size() != this.selectedNodes.size();
        if (!selection_changed) {
            Iterator<Object> it = this.selectedNodes.iterator();
            while (it.hasNext() && !selection_changed) {
                GeneNode current_gene = it.next();
                selection_changed = !new_genes.contains(current_gene);
            }
        }
        this.selectNodes(false);
        e.setPrevious(this.selectedNodes);
        this.top_node = e.getAncestor();
        this.selectedNodes = e.getGenes();
        this.selectNodes(true);
        if (selection_changed) {
            for (GeneSelectListener listener : this.gene_listeners) {
                listener.handleGeneSelectEvent(e);
            }
        }
    }

    private void selectNodes(boolean selected) {
        if (this.selectedNodes != null) {
            for (GeneNode node : this.selectedNodes) {
                node.setSelected(selected);
            }
        }
    }

    public List<GeneNode> fireTermEvent(TermSelectEvent e) {
        List<Term> old_terms = this.term_selection;
        List<Term> new_terms = e.getTermSelection();
        ArrayList<GeneNode> new_nodes = new ArrayList<GeneNode>();
        this.term_selection = null;
        if (new_terms != null && !new_terms.isEmpty() && old_terms != null && !old_terms.isEmpty()) {
            LinkDatabase go_root = PaintManager.inst().getGoRoot().getLinkDatabase();
            String aspect = AspectSelector.inst().getAspect().name();
            for (Term old_term : old_terms) {
                LinkedObject obo_term = (LinkedObject)GO_Util.inst().getObject(go_root, old_term.getAcc());
                if (obo_term.getNamespace().getID().equals(aspect) || new_terms.contains(old_term)) continue;
                new_terms.add(old_term);
            }
        }
        if (new_terms != null && new_terms.size() > 0) {
            Object mrca = null;
            this.top_node = e.selectNode();
            if (this.top_node == null) {
                TreePanel tree = PaintManager.inst().getTree();
                List<GeneNode> genes = tree.getAllNodes();
                Object min_node = null;
                GeneNode max_node = null;
                for (int i = 0; i < genes.size(); ++i) {
                    GeneNode node = genes.get(i);
                    node.setSelected(false);
                }
                if (!min_node.equals(max_node)) {
                    mrca = tree.getMRCA((GeneNode)min_node, max_node);
                    new_nodes.add((GeneNode)mrca);
                } else {
                    mrca = min_node;
                }
                this.top_node = mrca;
            } else {
                new_nodes.add(this.top_node);
            }
            this.top_node.setSelected(true);
            for (TermSelectionListener listener : this.term_listeners) {
                listener.handleTermEvent(e);
            }
        }
        return new_nodes;
    }

    public void fireNodeReorderEvent(NodeReorderEvent e) {
        for (NodeReorderListener listener : this.node_listeners) {
            listener.handleNodeReorderEvent(e);
        }
        GeneTable table = PaintManager.inst().getGeneTable();
        int row_index = ((GeneTableModel)table.getModel()).getRow(this.top_node);
        table.scrollToVisible(row_index);
    }

    public void fireSubFamilyEvent(GeneDataEvent e) {
        for (SubFamilyListener listener : this.subfamily_listeners) {
            listener.handleSubFamilyEvent(e);
        }
    }

    public void fireProgressEvent(ProgressEvent event) {
        if (this.progressListeners != null) {
            for (ProgressListener listener : this.progressListeners) {
                listener.handleProgressEvent(event);
            }
        }
    }

    public void fireAnnotationChangeEvent(AnnotationChangeEvent event) {
        if (this.geneAnnotationChangeListeners != null) {
            for (AnnotationChangeListener listener : this.geneAnnotationChangeListeners) {
                listener.handleAnnotationChangeEvent(event);
            }
        }
    }

    public void fireCommentChangeEvent(CommentChangeEvent event) {
        if (null == this.commentChangeListeners) {
            return;
        }
        for (CommentChangeListener listener : this.commentChangeListeners) {
            listener.handleCommentChangeEvent(event);
        }
    }

    public void fireAnnotationDisplayEvent(AnnotationDisplayEvent event) {
        if (null == this.annotationDisplayListeners) {
            return;
        }
        for (AnnotationDisplayListener listener : this.annotationDisplayListeners) {
            listener.handleAnnotationDisplayEvent(event);
        }
    }

    public void fireAspectChangeEvent(AspectChangeEvent event) {
        if (this.aspectChangeListeners != null) {
            for (AspectChangeListener listener : this.aspectChangeListeners) {
                listener.handleAspectChangeEvent(event);
            }
        }
        if (this.term_selection == null) {
            this.term_selection = new ArrayList<Term>();
        } else {
            this.term_selection.clear();
        }
        TermSelectEvent term_event = new TermSelectEvent(event.getSource(), this.term_selection);
        this.fireTermEvent(term_event);
    }

    public void fireCurationColorEvent(CurationColorEvent event) {
        if (this.colorChangeListeners != null) {
            for (CurationColorListener listener : this.colorChangeListeners) {
                listener.handleCurationColorEvent(event);
            }
        }
    }

    public void fireAnnotationDragEvent(AnnotationDragEvent event) {
        if (this.annotationDragListeners != null) {
            for (AnnotationDragListener listener : this.annotationDragListeners) {
                listener.handleAspectChangeEvent(event);
            }
        }
    }

    public List<GeneNode> getCurrentGeneSelection() {
        return this.selectedNodes;
    }

    public List<Term> getCurrentTermSelection() {
        return this.term_selection;
    }

    public GeneNode getAncestralSelection() {
        return this.top_node;
    }

    public void fireNewFamilyEvent(Object source, Family data_bag) {
        FamilyChangeEvent e = new FamilyChangeEvent(source, data_bag);
        if (data_bag != null) {
            for (FamilyChangeListener l : this.family_listeners) {
                l.newFamilyData(e);
            }
        }
        GeneTable table = PaintManager.inst().getGeneTable();
        table.scrollToVisible(0);
        if (this.selectedNodes != null) {
            this.selectedNodes = null;
        }
        if (this.term_selection != null) {
            this.term_selection.clear();
        }
        this.top_node = null;
    }

    public void fireNodeScrollEvent(NodeScrollEvent e) {
        if (this.scroll_listeners != null) {
            this.is_adjusting = true;
            for (NodeScrollListener listener : this.scroll_listeners) {
                listener.handleNodeScrollEvent(e);
            }
            this.is_adjusting = false;
        }
    }

    public void registerFamilyListener(FamilyChangeListener l) {
        this.family_listeners.add(l);
    }

    public boolean isAdjusting() {
        return this.is_adjusting;
    }
}

