/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.evidence;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.Evidence;
import org.geneontology.db.model.Term;
import org.paint.datamodel.GeneNode;
import org.paint.gui.evidence.LogAssociation;
import org.paint.gui.evidence.LogEntry;

public class ActionLog {
    private static final long serialVersionUID = 1L;
    protected static ActionLog singleton;
    private List<LogEntry> done_log = new ArrayList<LogEntry>();
    private List<LogEntry> undone_log = new ArrayList<LogEntry>();
    private static Logger logger;

    public static ActionLog inst() {
        if (singleton == null) {
            singleton = new ActionLog();
        }
        return singleton;
    }

    public void clearLog() {
        this.done_log.clear();
        this.undone_log.clear();
    }

    public void logAssociation(GeneNode node, Association assoc, List<LogAssociation> removed) {
    }

    public void logDisassociation(GeneNode node, Association removed) {
    }

    public void logNot(GeneNode node, Evidence evidence, String ev_code) {
    }

    public void logUnNot(GeneNode node, Evidence evi) {
    }

    public void logPruning(GeneNode node, List<LogAssociation> purged) {
    }

    public void logGrafting(GeneNode node) {
    }

    public String doneString() {
        return this.actionString(this.done_log);
    }

    public String undoneString() {
        return this.actionString(this.undone_log);
    }

    private String actionString(List<LogEntry> log) {
        if (log.size() > 0) {
            StringBuffer buf = new StringBuffer();
            int index = log.size() - 1;
            LogEntry entry = log.get(index);
            switch (entry.getAction()) {
                case ASSOC: {
                    buf.append(entry.getAction() + " to " + entry.getTerm().getName());
                    break;
                }
                case NOT: {
                    buf.append(entry.getAction() + " " + entry.getTerm().getName());
                    break;
                }
                case PRUNE: {
                    buf.append(entry.getAction() + " of " + entry.getNode().getNodeLabel());
                }
            }
            return buf.toString();
        }
        return null;
    }

    public void undo(Association assoc) {
        LogEntry entry = null;
        for (int i = 0; i < this.done_log.size() && entry == null; ++i) {
            LogEntry logEntry = this.done_log.get(i);
        }
        this.done_log.remove(entry);
        this.undone_log.add(entry);
        this.takeAction(entry, true);
    }

    public void undo() {
        int index = this.done_log.size() - 1;
        LogEntry entry = this.done_log.get(index);
        this.done_log.remove(index);
        this.undone_log.add(entry);
        this.takeAction(entry, true);
    }

    public void redo() {
        int index = this.undone_log.size() - 1;
        LogEntry entry = this.undone_log.remove(index);
        this.done_log.add(entry);
        this.takeAction(entry, false);
    }

    private void takeAction(LogEntry entry, boolean undo) {
    }

    private LogEntry findEntry(GeneNode node, Term term, LogEntry.Action action) {
        LogEntry found = null;
        for (LogEntry entry : this.done_log) {
            if (found != null || entry.getNode() != node || (term == null || entry.getTerm() != term || action != entry.getAction()) && (term != null || action != entry.getAction())) continue;
            found = entry;
        }
        return found;
    }

    static {
        logger = Logger.getLogger(ActionLog.class);
    }
}

