/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.evidence;

import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.go.GO_Util;
import org.paint.gui.AbstractPaintGUIComponent;
import org.paint.gui.AspectSelector;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.AnnotationChangeListener;
import org.paint.gui.event.CommentChangeEvent;
import org.paint.gui.event.CommentChangeListener;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.FamilyChangeEvent;
import org.paint.gui.event.FamilyChangeListener;
import org.paint.main.PaintManager;
import org.paint.util.RenderUtil;

public class EvidencePanel
extends AbstractPaintGUIComponent
implements CommentChangeListener,
AnnotationChangeListener,
FamilyChangeListener {
    private static final long serialVersionUID = 1L;
    protected static EvidencePanel singleton;
    private JTextArea comment_panel;
    private JTextArea warning_panel;
    private HashMap<String, JTextArea> aspectPanelLookup = new HashMap();
    private JTextArea prune_panel;
    public static final String STR_EMPTY = "";
    public static final String STR_BRACKET_START = "(";
    public static final String STR_BRACKET_END = ")";
    public static final String STR_COMMA = ",";
    private static Logger logger;

    public EvidencePanel() {
        super("evidence:evidence");
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(Preferences.inst().getBackgroundColor());
        JPanel pane = new JPanel();
        pane.setOpaque(true);
        pane.setLayout(new BoxLayout(pane, 1));
        this.aspectPanelLookup.put(AspectSelector.aspects.get(AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString()), this.initAspectPanel(AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString()));
        this.aspectPanelLookup.put(AspectSelector.aspects.get(AspectSelector.Aspect.MOLECULAR_FUNCTION.toString()), this.initAspectPanel(AspectSelector.Aspect.MOLECULAR_FUNCTION.toString()));
        this.aspectPanelLookup.put(AspectSelector.aspects.get(AspectSelector.Aspect.CELLULAR_COMPONENT.toString()), this.initAspectPanel(AspectSelector.Aspect.CELLULAR_COMPONENT.toString()));
        for (JTextArea textArea : this.aspectPanelLookup.values()) {
            pane.add(textArea);
        }
        this.initPrunePane();
        pane.add(this.prune_panel);
        this.initCommentPane();
        pane.add(this.comment_panel);
        this.initWarningPane();
        pane.add(this.warning_panel);
        JScrollPane scrollPane = new JScrollPane(new OnlyVerticalScrollPanel(pane));
        this.add(scrollPane, "Center");
        super.setTitle(GO_Util.inst().getPaintEvidenceAcc());
        EventManager.inst().registerCommentChangeListener(this);
        EventManager.inst().registerGeneAnnotationChangeListener(this);
        EventManager.inst().registerFamilyListener(this);
    }

    public static EvidencePanel inst() {
        if (singleton == null) {
            singleton = new EvidencePanel();
        }
        return singleton;
    }

    public String getWarnings() {
        return this.warning_panel.getText();
    }

    private void initPrunePane() {
        this.prune_panel = new JTextArea(STR_EMPTY);
        this.prune_panel.setEditable(false);
        this.prune_panel.setOpaque(true);
        this.prune_panel.setLineWrap(true);
        this.prune_panel.setWrapStyleWord(true);
        Border titled = this.loggerBorder(Preferences.inst().getBackgroundColor(), "Pruned");
        this.prune_panel.setBorder(titled);
    }

    private void initCommentPane() {
        this.comment_panel = new JTextArea(STR_EMPTY);
        this.comment_panel.setEditable(false);
        this.comment_panel.setOpaque(true);
        this.comment_panel.setLineWrap(true);
        this.comment_panel.setWrapStyleWord(true);
        Border titled = this.loggerBorder(Preferences.inst().getBackgroundColor(), "Notes");
        this.comment_panel.setBorder(titled);
    }

    private void initWarningPane() {
        this.warning_panel = new JTextArea();
        this.warning_panel.setOpaque(true);
        this.warning_panel.setEditable(false);
        this.warning_panel.setLineWrap(true);
        this.warning_panel.setWrapStyleWord(true);
        Border titled = this.loggerBorder(Color.RED.darker(), "WARNINGS");
        this.warning_panel.setBorder(titled);
    }

    private JTextArea initAspectPanel(String category) {
        JTextArea aspect_panel = new JTextArea();
        aspect_panel.setOpaque(true);
        aspect_panel.setEditable(false);
        aspect_panel.setLineWrap(true);
        aspect_panel.setWrapStyleWord(true);
        Color border_color = RenderUtil.getAspectColor(category);
        Border border = this.loggerBorder(border_color, category);
        aspect_panel.setBorder(border);
        return aspect_panel;
    }

    private Border loggerBorder(Color border_color, String category) {
        Border raisedbevel = BorderFactory.createBevelBorder(0, border_color, border_color.darker());
        Border loweredbevel = BorderFactory.createBevelBorder(1, border_color, border_color.darker());
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        TitledBorder titled = BorderFactory.createTitledBorder(compound, category, 1, 2);
        return titled;
    }

    @Override
    public void handleAnnotationChangeEvent(AnnotationChangeEvent event) {
        this.handleAnnotationChange();
    }

    public void handleAnnotationChange() {
        PaintManager pm = PaintManager.inst();
        GOTermHelper gth = pm.goTermHelper();
        TaxonomyHelper th = pm.getTaxonHelper();
        ArrayList<Annotation> annotList = pm.getAnnotatedList();
        ArrayList<Annotation> expAnnotList = pm.getExpAddedAnnotList();
        annotList.addAll(expAnnotList);
        StringBuffer prunedBuf = new StringBuffer();
        StringBuffer warningBuf = new StringBuffer();
        HashMap<String, StringBuffer> aspectLookup = new HashMap<String, StringBuffer>();
        for (Annotation a : annotList) {
            GOTerm term = gth.getTerm(a.getGoTerm());
            String aspect = term.getAspect();
            StringBuffer sb = (StringBuffer)aspectLookup.get(aspect);
            if (null == sb) {
                sb = new StringBuffer();
                aspectLookup.put(aspect, sb);
            }
            if (0 != sb.length()) {
                sb.append("\n");
            }
            Node n = a.getAnnotationDetail().getAnnotatedNode();
            String publicId = n.getStaticInfo().getPublicId();
            GeneNode gn = pm.getGeneByPTNId(publicId);
            if ("IBD".equals(a.getSingleEvidenceCodeFromSet()) && !th.isTermAndQualifierValidForSpecies(a.getGoTerm(), n.getStaticInfo().getCalculatedSpecies(), (Set)a.getQualifierSet())) {
                if (0 != warningBuf.length()) {
                    warningBuf.append("\n");
                }
                warningBuf.append(gn.getNodeLabel() + publicId + " annotated to term " + term.getName() + STR_BRACKET_START + term.getAcc() + ") violates taxonomy constraint");
            }
            sb.append(gn.getNodeLabel() + publicId + "\t" + a.getSingleEvidenceCodeFromSet() + "\t" + term.getName() + STR_BRACKET_START + term.getAcc() + STR_BRACKET_END);
            String qualifierStr = this.getQualifierString(a.getQualifierSet());
            if (null == qualifierStr || 0 == qualifierStr.length()) continue;
            sb.append("\t");
            sb.append(qualifierStr);
        }
        for (JTextArea ta : this.aspectPanelLookup.values()) {
            ta.setText(STR_EMPTY);
        }
        for (String aspect : aspectLookup.keySet()) {
            JTextArea textArea = this.aspectPanelLookup.get(aspect);
            textArea.setText(((StringBuffer)aspectLookup.get(aspect)).toString());
        }
        this.warning_panel.setText(warningBuf.toString());
        ArrayList<Node> prunedList = pm.getPrunedList();
        for (Node n : prunedList) {
            if (0 != prunedBuf.length()) {
                prunedBuf.append("\n");
            }
            String publicId = n.getStaticInfo().getPublicId();
            GeneNode gn = pm.getGeneByPTNId(publicId);
            prunedBuf.append(gn.getNodeLabel() + publicId);
        }
        this.prune_panel.setText(prunedBuf.toString());
    }

    private String getQualifierString(HashSet<Qualifier> qualifierSet) {
        if (null == qualifierSet || 0 == qualifierSet.size()) {
            return STR_EMPTY;
        }
        StringBuffer sb = new StringBuffer(STR_BRACKET_START);
        boolean added = false;
        Iterator<Qualifier> iter = qualifierSet.iterator();
        while (iter.hasNext()) {
            if (added) {
                sb.append(STR_COMMA);
            }
            Qualifier q = iter.next();
            sb.append(q.getText().toUpperCase());
            added = true;
        }
        sb.append(STR_BRACKET_END);
        return sb.toString();
    }

    @Override
    public void handleCommentChangeEvent(CommentChangeEvent event) {
        this.handleCommentChange();
    }

    private void handleCommentChange() {
        PaintManager pm = PaintManager.inst();
        String curComment = pm.getFullComment();
        if (null == curComment) {
            this.comment_panel.setText(STR_EMPTY);
            return;
        }
        this.comment_panel.setText(curComment);
    }

    @Override
    public void newFamilyData(FamilyChangeEvent e) {
        this.handleAnnotationChange();
        this.handleCommentChange();
    }

    static {
        logger = Logger.getLogger(EvidencePanel.class);
    }

    private class OnlyVerticalScrollPanel
    extends JPanel
    implements Scrollable {
        public OnlyVerticalScrollPanel() {
            this(new GridLayout(0, 1));
        }

        public OnlyVerticalScrollPanel(LayoutManager lm) {
            super(lm);
        }

        public OnlyVerticalScrollPanel(Component comp) {
            this();
            this.add(comp);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

