/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.evidence;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.geneontology.db.model.Association;
import org.geneontology.db.model.Evidence;
import org.geneontology.db.model.Term;
import org.paint.datamodel.GeneNode;
import org.paint.go.GO_Util;
import org.paint.gui.AspectSelector;
import org.paint.gui.evidence.LogAssociation;
import org.paint.gui.evidence.LoggingPanel;

public class LogEntry {
    private static final long serialVersionUID = 1L;
    private String description;
    private String notes;
    private Evidence evidence;
    private List<LogAssociation> removed;
    private List<LogAssociation> added;
    private Action action;
    private LoggingPanel log_pane;

    public LogEntry(GeneNode node, Association assoc, List<LogAssociation> removed, LoggingPanel log_pane) {
        String aspect;
        LogAssociation mini = new LogAssociation(node, assoc);
        this.added = new ArrayList<LogAssociation>();
        this.added.add(mini);
        this.removed = removed;
        this.action = Action.ASSOC;
        this.log_pane = log_pane;
        this.description = GO_Util.inst().contributesTo(assoc) ? assoc.getDate() + ": " + node.getNodeLabel() + " contributes to " + this.termLog(assoc.getTerm()) : (GO_Util.inst().colocalizes(assoc) ? assoc.getDate() + ": " + node.getNodeLabel() + " colocated with " + this.termLog(assoc.getTerm()) : ((aspect = assoc.getTerm().getCv()).equals(AspectSelector.Aspect.MOLECULAR_FUNCTION.toString()) ? assoc.getDate() + ": " + node.getNodeLabel() + " has function " + this.termLog(assoc.getTerm()) : (aspect.equals(AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString()) ? assoc.getDate() + ": " + node.getNodeLabel() + " participates in " + this.termLog(assoc.getTerm()) : assoc.getDate() + ": " + node.getNodeLabel() + " located in " + this.termLog(assoc.getTerm()))));
    }

    public LogEntry(GeneNode node, Evidence evidence, LoggingPanel log_pane) {
        LogAssociation mini = new LogAssociation(node, evidence.getAssociation());
        this.added = new ArrayList<LogAssociation>();
        this.added.add(mini);
        this.evidence = evidence;
        this.action = Action.NOT;
        this.log_pane = log_pane;
        this.description = this.dateNow() + ": " + node.getNodeLabel() + " lost/modified " + this.termLog(evidence.getAssociation().getTerm()) + " capacity";
    }

    public LogEntry(GeneNode node, List<LogAssociation> pruned, LoggingPanel log_pane) {
        LogAssociation mini = new LogAssociation(node);
        this.added = new ArrayList<LogAssociation>();
        this.added.add(mini);
        this.removed = pruned;
        this.action = Action.PRUNE;
        this.log_pane = log_pane;
        StringBuffer buf = new StringBuffer();
        buf.append(this.dateNow() + ": Pruned " + node.getNodeLabel());
        String prefix = " [";
        for (LogAssociation assoc : pruned) {
            buf.append(prefix + this.termLog(assoc.getTerm()));
            prefix = ", ";
        }
        if (pruned.size() > 0) {
            buf.append(']');
        }
        this.description = buf.toString();
        this.notes = "";
    }

    public LoggingPanel getLogPane() {
        return this.log_pane;
    }

    public Term getTerm() {
        if (this.added != null && this.added.size() == 1 && this.action != Action.PRUNE) {
            LogAssociation mini = this.added.get(0);
            return mini.getTerm();
        }
        return null;
    }

    public GeneNode getNode() {
        if (this.added != null && this.added.size() == 1) {
            LogAssociation mini = this.added.get(0);
            return mini.getNode();
        }
        return null;
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    public LogAssociation getLoggedAssociation() {
        if (this.added != null && this.added.size() == 1 && this.action != Action.PRUNE) {
            LogAssociation mini = this.added.get(0);
            return mini;
        }
        return null;
    }

    public List<LogAssociation> getRemovedAssociations() {
        return this.removed;
    }

    public void setRemovedAssociations(List<LogAssociation> removed) {
        this.removed = removed;
    }

    public String getDescription() {
        return this.description;
    }

    public Action getAction() {
        return this.action;
    }

    private String termLog(Term term) {
        return term.getName() + " (" + term.getAcc() + ")";
    }

    private String dateNow() {
        long timestamp = System.currentTimeMillis();
        Date when = new Date(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(when);
    }

    public String toString() {
        return this.description;
    }

    public static enum Action {
        ASSOC,
        NOT,
        PRUNE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

