/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.evidence;

import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.apache.log4j.Logger;
import org.paint.config.Preferences;
import org.paint.gui.evidence.EvidencePanel;

public class LoggingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static LoggingPanel singleton;
    private JTextArea annotation_log;
    private List<String> entries;
    private static Logger logger;

    public LoggingPanel(Border border) {
        this.setLayout(new BoxLayout(this, 1));
        this.entries = new ArrayList<String>();
        this.annotation_log = new JTextArea();
        this.annotation_log.setEditable(false);
        this.annotation_log.setLineWrap(true);
        this.annotation_log.setWrapStyleWord(true);
        this.setOpaque(true);
        this.setBorder(border);
        this.setBackground(Preferences.inst().getBackgroundColor());
        this.add(this.annotation_log);
    }

    public String getEntry() {
        return this.annotation_log.getText();
    }

    public void logEntry(String text) {
        this.entries.add(0, text);
        this.setLogText();
    }

    public boolean logErase(String text) {
        boolean removed = false;
        for (int i = this.entries.size() - 1; i >= 0 && !removed; --i) {
            String check = this.entries.get(i);
            removed = check.contains(text);
            if (!removed) continue;
            this.entries.remove(i);
            removed = true;
        }
        this.setLogText();
        return removed;
    }

    private void setLogText() {
        this.annotation_log.setText("");
        String prefix = "";
        for (String entry : this.entries) {
            this.annotation_log.setText(this.annotation_log.getText() + prefix + entry);
            prefix = "\n";
        }
        this.repaint();
    }

    protected void clearLog() {
        this.entries.clear();
        this.annotation_log.setText("");
    }

    static {
        logger = Logger.getLogger(EvidencePanel.class);
    }
}

