/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.evidence;

import edu.usc.ksom.pm.panther.paint.annotation.AnnotationForTerm;
import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import edu.usc.ksom.pm.panther.paint.matrix.TermToAssociation;
import edu.usc.ksom.pm.panther.paintCommon.Annotation;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationDetail;
import edu.usc.ksom.pm.panther.paintCommon.AnnotationHelper;
import edu.usc.ksom.pm.panther.paintCommon.DBReference;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.GOTermHelper;
import edu.usc.ksom.pm.panther.paintCommon.IWith;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeStaticInfo;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import edu.usc.ksom.pm.panther.paintCommon.Qualifier;
import edu.usc.ksom.pm.panther.paintCommon.QualifierDif;
import edu.usc.ksom.pm.panther.paintCommon.TaxonomyHelper;
import edu.usc.ksom.pm.panther.paintCommon.WithEvidence;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.geneontology.db.model.Evidence;
import org.geneontology.db.model.Term;
import org.paint.datamodel.GeneNode;
import org.paint.dialog.EvdnceCdeAndNewAnnotDlg;
import org.paint.gui.DirtyIndicator;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.EventManager;
import org.paint.gui.evidence.LogAssociation;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.matrix.MatrixTransferInfo;
import org.paint.gui.msa.MSAPanel;
import org.paint.main.PaintManager;
import org.paint.util.AnnotationUtil;
import org.paint.util.GeneNodeUtil;

public class PaintAction {
    private static PaintAction stroke;
    private static Logger log;
    private static final String MSG_DESC_MORE_SPECIFIC_PART1 = "Descendent node ";
    private static final String MSG_DESC_MORE_SPECIFIC_PART2 = " has direct annotation to term ";
    private static final String MSG_DESC_MORE_SPECIFIC_PART3 = "(";
    private static final String MSG_DESC_MORE_SPECIFIC_PART4 = ") which is less specific than term ";
    private static final String MSG_DESC_MORE_SPECIFIC_PART5 = " (";
    private static final String MSG_DESC_MORE_SPECIFIC_PART6 = "). If you want to annotate the node with this term, delete annotation to descendent term.";

    private PaintAction() {
    }

    public static PaintAction inst() {
        if (stroke == null) {
            stroke = new PaintAction();
        }
        return stroke;
    }

    public String isValidTermOld(MatrixTransferInfo matrixTransferInfo, GeneNode gnode) {
        TermAncestor termAncestor = matrixTransferInfo.getTermAncestor();
        GeneNode nodeClickedInMatrix = matrixTransferInfo.getMatrixClickedNode();
        TermToAssociation toa = termAncestor.getTermToAssociation();
        PaintManager pm = PaintManager.inst();
        GOTermHelper gth = pm.goTermHelper();
        GOTerm term = toa.getTerm();
        AnnotationForTerm aft = new AnnotationForTerm(nodeClickedInMatrix, term, gth);
        if (!aft.annotationExists()) {
            return "NO ANNOTATIONS TO TERM";
        }
        boolean negativeAnnot = QualifierDif.containsNegative(aft.getQset());
        Node n = gnode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null != nvi) {
            if (GeneNodeUtil.inPrunedBranch(gnode)) {
                return "PRUNED";
            }
            ArrayList annotationList = nvi.getGoAnnotationList();
            if (null != annotationList) {
                for (Annotation annot : annotationList) {
                    String curTerm = annot.getGoTerm();
                    if (term.getAcc().equals(curTerm)) {
                        return "IS ALREADY ANNOTATED TO " + term.getName() + MSG_DESC_MORE_SPECIFIC_PART3 + term.getAcc() + ")";
                    }
                    GOTerm curGoTerm = gth.getTerm(curTerm);
                    ArrayList ancestorList = gth.getAncestors(curGoTerm);
                    if (!ancestorList.contains(term)) continue;
                    return "NODE ALREADY ANNOTATED TO MORE SPECIFIC TERM (" + curGoTerm.getName() + MSG_DESC_MORE_SPECIFIC_PART3 + curGoTerm.getAcc() + ") is more specific than " + term.getName() + MSG_DESC_MORE_SPECIFIC_PART3 + term.getAcc() + ")";
                }
            }
            ArrayList<GeneNode> allDescendents = new ArrayList<GeneNode>();
            GeneNodeUtil.allNonPrunedDescendents(gnode, allDescendents);
            StringBuffer sb = new StringBuffer();
            if (this.termIsMoreSpecifictThanDirectAnnotations(allDescendents, gth, term, sb)) {
                return "DESCENDENT ANNOTATED WITH LESS SPECIFIC TERM";
            }
            List<GeneNode> leafDescendents = GeneNodeUtil.getAllLeaves(allDescendents);
            if (null == leafDescendents || 0 == leafDescendents.size()) {
                return "NO LEAVES IN DESCENDENTS";
            }
            boolean foundAnnot = false;
            for (GeneNode gNode : leafDescendents) {
                if (!AnnotationForTerm.annotationApplicable(aft, new AnnotationForTerm(gNode, term, gth))) continue;
                foundAnnot = true;
                break;
            }
            if (!foundAnnot) {
                return "NO LEAVES WITH EXPERIMENTAL ANNOTATIONS FOR TERM";
            }
        }
        return null;
    }

    public boolean termIsMoreSpecifictThanDirectAnnotations(ArrayList<GeneNode> nodeList, GOTermHelper gth, GOTerm term, StringBuffer sb) {
        if (null == nodeList || null == term) {
            return false;
        }
        for (GeneNode node : nodeList) {
            ArrayList annotList;
            Node n = node.getNode();
            NodeVariableInfo nvi = n.getVariableInfo();
            if (null == nvi || null == (annotList = nvi.getGoAnnotationList())) continue;
            for (Annotation annot : annotList) {
                String code = annot.getSingleEvidenceCodeFromSet();
                if (null == code || !code.equals("IBD") && !code.equals("IKR") && !code.equals("IRD")) continue;
                String goTerm = annot.getGoTerm();
                GOTerm curTerm = gth.getTerm(goTerm);
                if (!gth.getAncestors(term).contains(curTerm)) continue;
                sb.append(MSG_DESC_MORE_SPECIFIC_PART1 + n.getStaticInfo().getPublicId() + MSG_DESC_MORE_SPECIFIC_PART2 + goTerm + MSG_DESC_MORE_SPECIFIC_PART3 + curTerm.getName() + MSG_DESC_MORE_SPECIFIC_PART4 + term.getAcc() + MSG_DESC_MORE_SPECIFIC_PART5 + term.getName() + MSG_DESC_MORE_SPECIFIC_PART6);
                return true;
            }
        }
        return false;
    }

    private void removeMoreGeneralTerms(GeneNode node, Term term, List<LogAssociation> removed) {
        this.removeMoreGeneralTermsFromNode(node, term, removed);
        List<GeneNode> children = node.getChildren();
        if (children != null) {
            for (GeneNode child : children) {
                this.removeMoreGeneralTerms(child, term, removed);
            }
        }
    }

    private void removeMoreGeneralTermsFromNode(GeneNode node, Term term, List<LogAssociation> removed) {
    }

    public void pruneBranch(GeneNode node, boolean log_it) {
    }

    private void branchNotify(GeneNode node) {
        TreePanel tree = PaintManager.inst().getTree();
        tree.handlePruning(node);
        if (node.isLeaf()) {
            MSAPanel msa = PaintManager.inst().getMSAPanel();
            msa.handlePruning(node);
        }
        EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(node));
    }

    public void setNot(Evidence evidence, GeneNode node, String evi_code, boolean log) {
    }

    public void addIBDAnnotationAndPropagate(GOTerm term, GeneNode node, HashSet<Annotation> annotWithSet, HashSet<Qualifier> qualifierSet) {
        Annotation ibd = new Annotation();
        Node n = node.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            nvi = new NodeVariableInfo();
            n.setVariableInfo(nvi);
        }
        nvi.addGOAnnotation(ibd);
        ibd.setAnnotStoredInDb(true);
        ibd.setQualifierSet(qualifierSet);
        ibd.setGoTerm(term.getAcc());
        AnnotationDetail ad = ibd.getAnnotationDetail();
        ad.setAnnotatedNode(node.getNode());
        for (Annotation with : annotWithSet) {
            HashSet withQset;
            WithEvidence we = new WithEvidence();
            we.setEvidenceCode("IBD");
            we.setEvidenceType("PAINT_EXP");
            we.setWith((IWith)with);
            ad.addWithEvidence(we);
            if (null == qualifierSet || null == (withQset = with.getQualifierSet())) continue;
            for (Qualifier wq : withQset) {
                if (!QualifierDif.exists(qualifierSet, (Qualifier)wq)) continue;
                ad.addToInheritedQualifierLookup(wq, with);
            }
        }
        HashSet modifiedSet = new HashSet();
        StringBuffer errorMsgBuf = new StringBuffer();
        PaintManager pm = PaintManager.inst();
        AnnotationHelper.propagateIBD((Annotation)ibd, (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper(), (StringBuffer)errorMsgBuf, modifiedSet, new HashSet());
        EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(node));
    }

    public void addExperimentalAnnotation(String term, GeneNode node, String evidenceCode, String PMID, HashSet<Qualifier> qualifierSet) {
        Node n = node.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            nvi = new NodeVariableInfo();
            n.setVariableInfo(nvi);
        }
        PaintManager pm = PaintManager.inst();
        Annotation a = new Annotation();
        AnnotationDetail ad = new AnnotationDetail();
        a.setAnnotationDetail(ad);
        nvi.addGOAnnotation(a);
        ad.setAnnotatedNode(n);
        a.setAnnotStoredInDb(true);
        a.setQualifierSet(qualifierSet);
        a.setGoTerm(term);
        a.setExpAnnotCreatedInPaint(true);
        a.setExperimental(true);
        if (!qualifierSet.isEmpty()) {
            a.setQualifierSet(qualifierSet);
            for (Qualifier q : qualifierSet) {
                a.getAnnotationDetail().addToAddedQualifierLookup(q, a);
            }
        }
        WithEvidence we = new WithEvidence();
        we.setEvidenceCode(evidenceCode);
        DBReference dbRef = new DBReference();
        dbRef.setEvidenceType("PMID");
        dbRef.setEvidenceValue(PMID);
        we.setWith((IWith)dbRef);
        a.addWithEvidence(we);
        EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(node));
        pm.handleExpTermUpdate();
        AnnotationHelper.fixAnnotationsForGraftPruneExpOperation((Node)pm.getTree().getRoot().getNode(), (Node)node.getNode(), (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper());
        DirtyIndicator.inst().setAnnotated(true);
        AnnotationUtil.branchNotify(node);
    }

    public void removeExperimentalAnnotation(GeneNode geneNode, Annotation a) {
        Node n = geneNode.getNode();
        NodeVariableInfo nvi = n.getVariableInfo();
        if (null == nvi) {
            System.out.println("No NVI info to delete for " + n.getStaticInfo().getPublicId());
            return;
        }
        ArrayList annotList = nvi.getGoAnnotationList();
        if (null == annotList) {
            System.out.println("No annotations to delete for " + n.getStaticInfo().getPublicId());
            return;
        }
        if (!annotList.contains(a)) {
            System.out.println("Annotation not found for " + n.getStaticInfo().getPublicId());
            return;
        }
        annotList.remove(a);
        DirtyIndicator.inst().setAnnotated(true);
        EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(geneNode));
        PaintManager pm = PaintManager.inst();
        pm.handleExpTermUpdate();
        AnnotationHelper.fixAnnotationsForGraftPruneExpOperation((Node)pm.getTree().getRoot().getNode(), (Node)geneNode.getNode(), (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper());
        this.branchNotify(geneNode);
    }

    public GeneNode getPropagator(Annotation a) {
        HashSet withEvSet = a.getAnnotationDetail().getWithEvidenceAnnotSet();
        if (null == withEvSet) {
            return null;
        }
        PaintManager pm = PaintManager.inst();
        for (WithEvidence we : withEvSet) {
            Node n;
            GeneNode gn;
            Annotation annot = (Annotation)we.getWith();
            if (annot == a || null == (gn = pm.getGeneByPTNId((n = a.getAnnotationDetail().getAnnotatedNode()).getStaticInfo().getPublicId())) || gn.isLeaf()) continue;
            return gn;
        }
        return null;
    }

    public Annotation annotationWithOppositeQualifier(Node node, String gTerm, HashSet<Qualifier> qualifierSet) {
        NodeVariableInfo nvi = node.getVariableInfo();
        if (null == nvi) {
            return null;
        }
        ArrayList goAnnotList = nvi.getGoAnnotationList();
        if (null == goAnnotList) {
            return null;
        }
        for (Annotation annot : goAnnotList) {
            HashSet curSet;
            String annotTerm = annot.getGoTerm();
            if (!annotTerm.equals(gTerm) || !QualifierDif.areOpposite((Set)(curSet = annot.getQualifierSet()), qualifierSet)) continue;
            return annot;
        }
        return null;
    }

    public Annotation getAncestorAnnotationWithSameQualifier(Node node, String gTerm, HashSet<Qualifier> propQualifierSet) {
        GOTerm term;
        NodeVariableInfo nvi = node.getVariableInfo();
        if (null == nvi) {
            return null;
        }
        ArrayList goAnnotList = nvi.getGoAnnotationList();
        if (null == goAnnotList) {
            return null;
        }
        GOTermHelper gth = PaintManager.inst().goTermHelper();
        ArrayList ancestorList = gth.getAncestors(term = gth.getTerm(gTerm));
        if (null == ancestorList) {
            return null;
        }
        Iterator iter = ancestorList.iterator();
        while (iter.hasNext()) {
            GOTerm t = (GOTerm)iter.next();
            if (term.getAspect().equals(t.getAspect())) continue;
            iter.remove();
        }
        for (Annotation annot : goAnnotList) {
            GOTerm currentTerm;
            HashSet curSet = annot.getQualifierSet();
            if (!QualifierDif.allQualifiersSame((Set)curSet, propQualifierSet) || !"IBD".equals(annot.getSingleEvidenceCodeFromSet()) || !ancestorList.contains(currentTerm = gth.getTerm(annot.getGoTerm()))) continue;
            return annot;
        }
        return null;
    }

    public Annotation getPropagatorForIKR_IRD_TCV(Annotation ikrIrdtcv) {
        HashSet withEvSet = ikrIrdtcv.getAnnotationDetail().getWithEvidenceSet();
        if (null == withEvSet) {
            return null;
        }
        for (WithEvidence we : withEvSet) {
            Annotation a = (Annotation)we.getWith();
            Node n = a.getAnnotationDetail().getAnnotatedNode();
            GeneNode gn = PaintManager.inst().getGeneByPTNId(n.getStaticInfo().getPublicId());
            if (gn.isLeaf() || a == ikrIrdtcv || !QualifierDif.areOpposite((Set)a.getQualifierSet(), (Set)ikrIrdtcv.getQualifierSet())) continue;
            return a;
        }
        return null;
    }

    public void deleteChildAndDescendentIBAAnnotation(GeneNode gNode, Annotation childAnnot) {
        Annotation propagatorAnnot = AnnotationUtil.getSingleWithPropagatorAnnot(childAnnot);
        HashSet chidQualifierSet = childAnnot.getQualifierSet();
        String goTerm = childAnnot.getGoTerm();
        ArrayList<GeneNode> descList = new ArrayList<GeneNode>();
        GeneNodeUtil.allNonPrunedDescendents(gNode, descList);
        descList.add(gNode);
        for (GeneNode gn : descList) {
            ArrayList annotList;
            NodeVariableInfo nvi = gn.getNode().getVariableInfo();
            if (null == nvi || null == (annotList = nvi.getGoAnnotationList())) continue;
            Iterator annotIter = annotList.iterator();
            while (annotIter.hasNext()) {
                Annotation curProp;
                Annotation annot = (Annotation)annotIter.next();
                if (!goTerm.equals(annot.getGoTerm()) || !QualifierDif.allQualifiersSame((Set)chidQualifierSet, (Set)annot.getQualifierSet()) || !"IBA".equals(annot.getSingleEvidenceCodeFromSet()) || propagatorAnnot != (curProp = AnnotationUtil.getSingleWithPropagatorAnnot(annot))) continue;
                annotIter.remove();
            }
        }
    }

    public void deleteAnnotation(GeneNode gNode, Annotation a) {
        PaintManager pm = PaintManager.inst();
        AnnotationHelper.deleteAnnotationAndRepropagate((Annotation)a, (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper());
    }

    public void notAnnotation(GeneNode gNode, Annotation a) {
        GOTerm ancestorTerm;
        WithEvidence nodeWith;
        PaintManager pm = PaintManager.inst();
        HashSet origQualifierSet = a.getQualifierSet();
        HashSet<Qualifier> newSet = new HashSet<Qualifier>();
        if (null == origQualifierSet) {
            Qualifier notQualifier = new Qualifier();
            notQualifier.setText("NOT");
            newSet.add(notQualifier);
        } else {
            boolean containsNot = false;
            for (Qualifier q : origQualifierSet) {
                if (q.isNot()) {
                    containsNot = true;
                    continue;
                }
                newSet.add(q);
            }
            if (!containsNot) {
                Qualifier notQualifier = new Qualifier();
                notQualifier.setText("NOT");
                newSet.add(notQualifier);
            }
        }
        if (newSet.isEmpty()) {
            newSet = null;
        }
        String term = a.getGoTerm();
        if (!"IBA".equals(a.getSingleEvidenceCodeFromSet())) {
            return;
        }
        Node node = gNode.getNode();
        NodeVariableInfo nvi = node.getVariableInfo();
        NodeStaticInfo nsi = node.getStaticInfo();
        HashSet withEvSet = a.getAnnotationDetail().getWithEvidenceSet();
        if (null == withEvSet) {
            return;
        }
        for (WithEvidence we : withEvSet) {
            if (we.isPAINTType()) continue;
            return;
        }
        Annotation propagatorAnnot = AnnotationHelper.getIBDpropagator((Annotation)a);
        Node annotatorNode = propagatorAnnot.getAnnotationDetail().getAnnotatedNode();
        GeneNode annotator = PaintManager.inst().getGeneByPTNId(annotatorNode.getStaticInfo().getPublicId());
        if (null == annotator) {
            return;
        }
        ArrayList leaves = Node.getAllNonPrunedLeaves((Node)node);
        ArrayList withs = AnnotationHelper.getPossibleExperimentalAnnots((String)term, newSet, (ArrayList)leaves, (GOTermHelper)PaintManager.inst().goTermHelper());
        ArrayList<Node> defaultLeaves = new ArrayList<Node>();
        for (Annotation with : withs) {
            defaultLeaves.add(with.getAnnotationDetail().getAnnotatedNode());
        }
        ArrayList<GeneNode> gnLeaves = new ArrayList<GeneNode>();
        ArrayList<GeneNode> gnDefaultLeaves = new ArrayList<GeneNode>();
        for (Node leaf : leaves) {
            gnLeaves.add(pm.getGeneByPTNId(leaf.getStaticInfo().getPublicId()));
        }
        for (Node dfLeaf : defaultLeaves) {
            gnDefaultLeaves.add(pm.getGeneByPTNId(dfLeaf.getStaticInfo().getPublicId()));
        }
        EvdnceCdeAndNewAnnotDlg dlg = new EvdnceCdeAndNewAnnotDlg((Frame)GUIManager.getManager().getFrame(), a, gnLeaves, gnDefaultLeaves);
        String evidenceCode = dlg.getSelectedEvidenceCode();
        if (null == evidenceCode) {
            return;
        }
        DirtyIndicator.inst().setAnnotated(true);
        AnnotationHelper.deletePropagatedIBA((Annotation)a, (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper());
        System.out.println("Notting annotation for " + nsi.getPublicId());
        if ("IRD".equals(evidenceCode)) {
            GOTerm ancestorTerm2;
            WithEvidence nodeWith2;
            Annotation newAnnotation = new Annotation();
            newAnnotation.setAnnotStoredInDb(true);
            newAnnotation.setGoTerm(term);
            AnnotationDetail ad = newAnnotation.getAnnotationDetail();
            ad.setAnnotatedNode(node);
            newAnnotation.setQualifierSet(newSet);
            WithEvidence propWithEv = new WithEvidence();
            propWithEv.setEvidenceCode("IRD");
            propWithEv.setEvidenceType("PAINT_ANCESTOR");
            propWithEv.setWith((IWith)propagatorAnnot);
            ad.addWithEvidence(propWithEv);
            WithEvidence newAnnotWithEv = new WithEvidence();
            newAnnotWithEv.setEvidenceCode("IRD");
            newAnnotWithEv.setEvidenceType("PAINT_ANCESTOR");
            newAnnotWithEv.setWith((IWith)newAnnotation);
            ad.addWithEvidence(newAnnotWithEv);
            if (null != origQualifierSet) {
                for (Qualifier origQ : origQualifierSet) {
                    ad.addToInheritedQualifierLookup(origQ, propagatorAnnot);
                }
            }
            if (QualifierDif.containsNegative(newSet)) {
                ad.addToAddedQualifierLookup(QualifierDif.getNOT(newSet), newAnnotation);
            } else {
                ad.addToRemovedQualifierLookup(QualifierDif.getNOT((HashSet)origQualifierSet), newAnnotation);
            }
            if (null != dlg.getPMID()) {
                WithEvidence otherWith = new WithEvidence();
                otherWith.setEvidenceCode("IRD");
                otherWith.setEvidenceType("PMID");
                DBReference pmidRef = new DBReference();
                pmidRef.setEvidenceType("PMID");
                pmidRef.setEvidenceValue(dlg.getPMID());
                otherWith.setWith((IWith)pmidRef);
                ad.addWithEvidence(otherWith);
            }
            for (GeneNode defaultLeaf : gnDefaultLeaves) {
                nodeWith2 = new WithEvidence();
                nodeWith2.setEvidenceCode("IRD");
                nodeWith2.setEvidenceType("PAINT_REF");
                nodeWith2.setWith((IWith)defaultLeaf.getNode());
                ad.addWithEvidence(nodeWith2);
            }
            int[] selectedIndices = dlg.getSelectedLeafIndices();
            if (0 < selectedIndices.length) {
                for (int i = 0; i < selectedIndices.length; ++i) {
                    nodeWith2 = new WithEvidence();
                    nodeWith2.setEvidenceCode("IRD");
                    nodeWith2.setEvidenceType("PAINT_REF");
                    nodeWith2.setWith((IWith)gnLeaves.get(selectedIndices[i]).getNode());
                    ad.addWithEvidence(nodeWith2);
                }
            }
            nvi.addGOAnnotation(newAnnotation);
            if (dlg.areAncestorsApplicable() && null != (ancestorTerm2 = dlg.getAncestor())) {
                AnnotationHelper.propagateIBA((Node)node, (String)ancestorTerm2.getAcc(), (HashSet)propagatorAnnot.getQualifierSet(), (Annotation)propagatorAnnot, (HashSet)propagatorAnnot.getAnnotationDetail().getWithNodeSet(), (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper(), (StringBuffer)new StringBuffer(), new HashSet(), new HashSet());
            }
            EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(gNode));
            return;
        }
        Annotation newAnnotation = new Annotation();
        newAnnotation.setAnnotStoredInDb(true);
        newAnnotation.setGoTerm(term);
        AnnotationDetail ad = newAnnotation.getAnnotationDetail();
        ad.setAnnotatedNode(node);
        newAnnotation.setQualifierSet(newSet);
        WithEvidence propWithEv = new WithEvidence();
        propWithEv.setEvidenceCode("IKR");
        propWithEv.setEvidenceType("PAINT_ANCESTOR");
        propWithEv.setWith((IWith)propagatorAnnot);
        ad.addWithEvidence(propWithEv);
        WithEvidence newAnnotWithEv = new WithEvidence();
        newAnnotWithEv.setEvidenceCode("IKR");
        newAnnotWithEv.setEvidenceType("PAINT_ANCESTOR");
        newAnnotWithEv.setWith((IWith)newAnnotation);
        ad.addWithEvidence(newAnnotWithEv);
        if (null != origQualifierSet) {
            for (Qualifier origQ : origQualifierSet) {
                ad.addToInheritedQualifierLookup(origQ, propagatorAnnot);
            }
        }
        if (QualifierDif.containsNegative(newSet)) {
            ad.addToAddedQualifierLookup(QualifierDif.getNOT(newSet), newAnnotation);
        } else {
            ad.addToRemovedQualifierLookup(QualifierDif.getNOT((HashSet)origQualifierSet), newAnnotation);
        }
        if (null != dlg.getPMID()) {
            WithEvidence otherWith = new WithEvidence();
            otherWith.setEvidenceCode("IKR");
            otherWith.setEvidenceType("PMID");
            DBReference pmidRef = new DBReference();
            pmidRef.setEvidenceType("PMID");
            pmidRef.setEvidenceValue(dlg.getPMID());
            otherWith.setWith((IWith)pmidRef);
            ad.addWithEvidence(otherWith);
        }
        for (GeneNode defaultLeaf : gnDefaultLeaves) {
            nodeWith = new WithEvidence();
            nodeWith.setEvidenceCode("IKR");
            nodeWith.setEvidenceType("PAINT_REF");
            nodeWith.setWith((IWith)defaultLeaf.getNode());
            ad.addWithEvidence(nodeWith);
        }
        int[] nArray = dlg.getSelectedLeafIndices();
        Object selectedIndices = nArray;
        selectedIndices = nArray;
        if (0 < ((Object)selectedIndices).length) {
            for (int i = 0; i < ((Object)selectedIndices).length; ++i) {
                nodeWith = new WithEvidence();
                nodeWith.setEvidenceCode("IKR");
                nodeWith.setEvidenceType("PAINT_REF");
                nodeWith.setWith((IWith)gnLeaves.get((int)selectedIndices[i]).getNode());
                ad.addWithEvidence(nodeWith);
            }
        }
        nvi.addGOAnnotation(newAnnotation);
        AnnotationDetail ibdDetail = propagatorAnnot.getAnnotationDetail();
        HashSet withSet = ibdDetail.getWithAnnotSet();
        HashSet<Node> evidenceNodes = new HashSet<Node>();
        for (Object with : withSet) {
            evidenceNodes.add(with.getAnnotationDetail().getAnnotatedNode());
        }
        ArrayList children = node.getStaticInfo().getChildren();
        if (null != children) {
            for (Node child : children) {
                AnnotationHelper.propagateIBA((Node)child, (String)term, newSet, (Annotation)newAnnotation, evidenceNodes, (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper(), (StringBuffer)new StringBuffer(), new HashSet(), new HashSet());
            }
        }
        if (dlg.areAncestorsApplicable() && null != (ancestorTerm = dlg.getAncestor())) {
            AnnotationHelper.propagateIBA((Node)node, (String)ancestorTerm.getAcc(), (HashSet)propagatorAnnot.getQualifierSet(), (Annotation)propagatorAnnot, (HashSet)propagatorAnnot.getAnnotationDetail().getWithNodeSet(), (TaxonomyHelper)pm.getTaxonHelper(), (GOTermHelper)pm.goTermHelper(), (StringBuffer)new StringBuffer(), new HashSet(), new HashSet());
        }
        EventManager.inst().fireAnnotationChangeEvent(new AnnotationChangeEvent(gNode));
    }

    public ArrayList<GeneNode> getReferencesWithoutNode(ArrayList<DBReference> references, GeneNode gNode) {
        if (null == references || null == gNode) {
            return null;
        }
        ArrayList<GeneNode> outList = new ArrayList<GeneNode>();
        for (DBReference ref : references) {
            String type = ref.getEvidenceType();
            if (!"PANTHER".equals(type)) continue;
            GeneNode curNode = PaintManager.inst().getGeneByPTNId(ref.getEvidenceValue());
            if (null == gNode || curNode == gNode) continue;
            outList.add(curNode);
        }
        return outList;
    }

    static {
        log = Logger.getLogger(PaintAction.class);
    }
}

