/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.familytree;

import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeStaticInfo;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.NodeReorderEvent;
import org.paint.main.PaintManager;
import org.paint.util.DuplicationColor;

public class TreeModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(TreeModel.class);
    private GeneNode root = null;
    private GeneNode currentRoot = null;
    private List<GeneNode> allNodes = null;
    private List<GeneNode> currentNodes = null;
    private List<GeneNode> terminusNodes = null;
    private double tree_distance_scaling = -1.0;
    private Map<GeneNode, Integer> descendent_count;
    private int species_count;
    private Map<GeneNode, Integer> species_index;
    private TreeColorSchema treeColorSchema = Preferences.inst().getColorSchema();
    public static final Set<String> SPECIES_CLASSIFICATION = new HashSet<String>(Arrays.asList("BACTERIA", "ARCHEA", "FUNGUS", "PLANTS"));

    public TreeModel(GeneNode dsn) {
        if (null == dsn) {
            return;
        }
        this.root = dsn;
        this.currentRoot = dsn;
        this.descendent_count = new HashMap<GeneNode, Integer>();
        this.species_index = new HashMap<GeneNode, Integer>();
        this.species_count = 0;
        this.initSortGuides(this.root);
        this.allNodes = new ArrayList<GeneNode>();
        this.addChildNodesInOrder(this.root, this.allNodes);
        this.currentNodes = new ArrayList<GeneNode>();
        this.terminusNodes = new ArrayList<GeneNode>();
        this.initCurrentNodes(false);
        this.setSubtreeColor(this.root, Color.BLACK);
        log.info((Object)("There are " + this.allNodes.size() + " nodes in " + PaintManager.inst().getFamily().getFamilyID() + " tree"));
    }

    protected double getDistanceScaling() {
        if (this.tree_distance_scaling < 0.0) {
            this.tree_distance_scaling = Preferences.inst().getTree_distance_scaling();
        }
        return this.tree_distance_scaling;
    }

    protected void setDistance(double scale) {
        this.tree_distance_scaling = scale;
        Preferences.inst().setTree_distance_scaling(scale);
    }

    private void addChildNodesInOrder(GeneNode dsn, List<GeneNode> node_list) {
        if (dsn != null) {
            if (dsn.isTerminus()) {
                node_list.add(dsn);
            } else {
                List<GeneNode> topChildren = this.getTopChildren(dsn);
                Iterator<GeneNode> it = topChildren.iterator();
                while (it.hasNext()) {
                    this.addChildNodesInOrder(it.next(), node_list);
                }
                node_list.add(dsn);
                List<GeneNode> bottomChildren = this.getBottomChildren(dsn);
                Iterator<GeneNode> it2 = bottomChildren.iterator();
                while (it2.hasNext()) {
                    this.addChildNodesInOrder(it2.next(), node_list);
                }
            }
        }
    }

    private int initSortGuides(GeneNode dsn) {
        int count = 0;
        this.species_index.put(dsn, new Integer(this.species_count++));
        if (dsn != null) {
            if (!dsn.isTerminus()) {
                count = dsn.getChildren().size();
                List<GeneNode> children = dsn.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    GeneNode child = children.get(i);
                    count += this.initSortGuides(child);
                }
            }
            this.descendent_count.put(dsn, new Integer(count));
        }
        return count;
    }

    protected List<GeneNode> getTopChildren(GeneNode dsn) {
        return this.getChildren(true, dsn);
    }

    protected List<GeneNode> getBottomChildren(GeneNode dsn) {
        return this.getChildren(false, dsn);
    }

    private List<GeneNode> getChildren(boolean top, GeneNode dsn) {
        List<GeneNode> children = dsn.getChildren();
        if (null == children) {
            return null;
        }
        int half = children.size() / 2 + children.size() % 2;
        ArrayList<GeneNode> returnList = new ArrayList<GeneNode>();
        if (top) {
            for (int i = 0; i < half; ++i) {
                GeneNode node = children.get(i);
                if (returnList.contains(node)) continue;
                returnList.add(node);
            }
        } else {
            for (int i = half; i < children.size(); ++i) {
                GeneNode node = children.get(i);
                if (returnList.contains(node)) continue;
                returnList.add(node);
            }
        }
        return returnList;
    }

    protected GeneNode getTopLeafNode(GeneNode node) {
        GeneNode top_leaf = null;
        if (node != null) {
            top_leaf = !this.terminusNodes.contains(node) && node.getChildren() != null ? this.getTopLeafNode(node.getChildren().get(0)) : node;
        }
        return top_leaf;
    }

    protected GeneNode getBottomLeafNode(GeneNode node) {
        GeneNode bottom_leaf = null;
        if (node != null) {
            if (!this.terminusNodes.contains(node) && node.getChildren() != null) {
                List<GeneNode> children = node.getChildren();
                bottom_leaf = this.getBottomLeafNode(children.get(children.size() - 1));
            } else {
                bottom_leaf = node;
            }
        }
        return bottom_leaf;
    }

    protected void expandAllNodes() {
        this.expandAllNodes(this.currentRoot);
    }

    private void setSubtreeColor(GeneNode dsn, Color c) {
        if (null == dsn) {
            return;
        }
        dsn.setSubFamilyColor(c);
        List<GeneNode> children = dsn.getChildren();
        if (null == children) {
            return;
        }
        Iterator<GeneNode> it = children.iterator();
        while (it.hasNext()) {
            this.setSubtreeColor(it.next(), c);
        }
    }

    private void resetExpansion(GeneNode dsn) {
        List<GeneNode> children;
        if (!dsn.isExpanded()) {
            this.setNodeExpanded(dsn);
        }
        if (null != (children = dsn.getChildren())) {
            Iterator<GeneNode> it = children.iterator();
            while (it.hasNext()) {
                this.resetExpansion(it.next());
            }
        }
    }

    private void expandAllNodes(GeneNode dsn) {
        this.resetExpansion(dsn);
        this.initCurrentNodes(true);
    }

    protected void collapseNonExperimental() {
        this.resetExpansion(this.root);
        this.collapseMRC(this.root);
        this.initCurrentNodes(true);
    }

    private void collapseMRC(GeneNode mrc) {
        Vector<GeneNode> twigList = new Vector<GeneNode>();
        this.getLeafDescendants(mrc, twigList);
        boolean no_exp = true;
        for (int i = 0; i < twigList.size() && no_exp; ++i) {
            GeneNode geneNode = twigList.get(i);
        }
        List<GeneNode> children = mrc.getChildren();
        if (children != null) {
            for (GeneNode child : children) {
                this.collapseMRC(child);
            }
        }
    }

    private void initCurrentNodes(boolean notify) {
        this.currentNodes.clear();
        this.terminusNodes.clear();
        this.addChildNodesInOrder(this.currentRoot, this.currentNodes);
        this.setTerminusNodes();
        DuplicationColor.inst().initColorIndex();
        this.setSpeciesClassification();
        this.setDupColorIndex(this.currentRoot, 0);
        this.setHorizontalColorIndex(this.currentRoot, 1);
        if (notify) {
            NodeReorderEvent event = new NodeReorderEvent(this);
            event.setNodes(this.getTerminusNodes());
            EventManager.inst().fireNodeReorderEvent(event);
        }
    }

    private void setSpeciesClassification() {
        for (GeneNode leaf : this.terminusNodes) {
            this.setSpeciesClassification(leaf, leaf);
        }
    }

    private void setSpeciesClassification(GeneNode leaf, GeneNode current) {
        NodeStaticInfo nsi;
        if (null == current) {
            return;
        }
        Node n = current.getNode();
        if (n != null && null != (nsi = n.getStaticInfo())) {
            leaf.setSpeciesClassification(nsi.getSpeciesConversion());
        }
    }

    private void setDupColorIndex(GeneNode node, int color_index) {
        block9: {
            node.setDupColorIndex(color_index);
            if (node.isLeaf()) break block9;
            List<GeneNode> children = node.getChildren();
            if (node.isDuplication()) {
                boolean only_leaves = true;
                for (GeneNode geneNode : children) {
                    only_leaves &= geneNode.isLeaf();
                }
                if (!only_leaves) {
                    ArrayList ordered_by_distance = new ArrayList();
                    ordered_by_distance.addAll(children);
                    Collections.sort(ordered_by_distance, new DistanceSort());
                    Iterator iterator = ordered_by_distance.iterator();
                    while (iterator.hasNext()) {
                        GeneNode sib;
                        GeneNode child2 = (GeneNode)iterator.next();
                        int index = ordered_by_distance.indexOf(child2);
                        if (index < ordered_by_distance.size() - 2 && (sib = (GeneNode)ordered_by_distance.get(index + 1)).getDistanceFromParent() == child2.getDistanceFromParent()) {
                            color_index = DuplicationColor.inst().getNextIndex();
                            log.info((Object)(child2 + " and " + sib + " are equally distance from parent"));
                        }
                        this.setDupColorIndex(child2, color_index);
                        if (ordered_by_distance.indexOf(child2) >= ordered_by_distance.size() - 1) continue;
                        color_index = DuplicationColor.inst().getNextIndex();
                    }
                } else {
                    for (GeneNode geneNode : children) {
                        this.setDupColorIndex(geneNode, color_index);
                    }
                }
            } else {
                for (GeneNode child : children) {
                    this.setDupColorIndex(child, color_index);
                }
            }
        }
    }

    private void setHorizontalColorIndex(GeneNode node, int colorIndex) {
        List<GeneNode> children;
        boolean isHorizontalTransfer = false;
        if (node.isHorizontalTransfer()) {
            node.setHorizontalColorIndex(colorIndex);
            isHorizontalTransfer = true;
        }
        if (null == (children = node.getChildren())) {
            return;
        }
        for (GeneNode child : children) {
            child.setHorizontalColorIndex(node.getHorizontalColorIndex());
            if (isHorizontalTransfer) {
                this.setHorizontalColorIndex(child, colorIndex++);
                continue;
            }
            this.setHorizontalColorIndex(child, colorIndex);
        }
    }

    private void setTerminusNodes() {
        for (GeneNode node : this.currentNodes) {
            if (!node.isTerminus()) continue;
            this.terminusNodes.add(node);
        }
    }

    private void setNodeExpanded(GeneNode dsn) {
        if (!dsn.isLeaf()) {
            dsn.setExpanded(!dsn.isExpanded());
        }
    }

    protected void nodeReroot(GeneNode node) {
        if (node != null && !node.isTerminus()) {
            this.resetToRoot(node);
        }
    }

    protected void handleCollapseExpand(GeneNode node) {
        boolean change;
        boolean bl = change = node != null && !node.isLeaf();
        if (change) {
            this.setNodeExpanded(node);
            this.initCurrentNodes(true);
        }
    }

    protected boolean handlePruning(GeneNode node) {
        boolean change;
        boolean bl = change = node != null && !node.isLeaf();
        if (change) {
            this.initCurrentNodes(true);
        }
        return change;
    }

    protected void scaleTree(double scale) {
        if (this.getDistanceScaling() != scale) {
            this.setDistance(scale);
        }
    }

    protected GeneNode getMRCA(GeneNode gene1, GeneNode gene2) {
        GeneNode ancestor = null;
        if (gene1.isLeaf() && gene2.isLeaf()) {
            if (gene1 == gene2) {
                ancestor = gene1;
            } else {
                while (ancestor == null && gene1 != null) {
                    GeneNode ancestor1 = gene1.getParent();
                    if (this.isDescendentOf(ancestor1, gene2)) {
                        ancestor = ancestor1;
                        continue;
                    }
                    gene1 = ancestor1;
                }
            }
        }
        return ancestor;
    }

    private boolean isDescendentOf(GeneNode ancestor, GeneNode gene) {
        List<GeneNode> children = ancestor.getChildren();
        boolean is_descendent = false;
        if (children != null) {
            if (children.contains(gene)) {
                is_descendent = true;
            } else {
                Iterator<GeneNode> it = children.iterator();
                while (it.hasNext() && !is_descendent) {
                    is_descendent = this.isDescendentOf(it.next(), gene);
                }
            }
        }
        return is_descendent;
    }

    protected boolean resetRootToMain() {
        return this.resetToRoot(this.root);
    }

    protected boolean resetToRoot(GeneNode dsn) {
        if (this.currentRoot != dsn) {
            this.currentRoot = dsn;
            this.initCurrentNodes(true);
            return true;
        }
        return false;
    }

    protected GeneNode getRoot() {
        return this.root;
    }

    protected List<GeneNode> getAllNodes() {
        return this.allNodes;
    }

    protected List<GeneNode> getTerminusNodes() {
        return this.terminusNodes;
    }

    public List<GeneNode> getCurrentNodes() {
        return this.currentNodes;
    }

    protected GeneNode getCurrentRoot() {
        return this.currentRoot;
    }

    protected void speciesOrder() {
        SpeciesSort comp = new SpeciesSort();
        this.ladder(this.currentRoot, comp);
        this.allNodes.clear();
        this.addChildNodesInOrder(this.currentRoot, this.allNodes);
        this.initCurrentNodes(true);
    }

    protected void descendentCountLadder(boolean most_leaves_at_top) {
        LeafCountSort comp = new LeafCountSort(most_leaves_at_top);
        this.ladder(this.currentRoot, comp);
        this.allNodes.clear();
        this.addChildNodesInOrder(this.currentRoot, this.allNodes);
        this.initCurrentNodes(true);
    }

    private void ladder(GeneNode dsn, Comparator<GeneNode> comp) {
        List<GeneNode> children = dsn.getChildren();
        if (null == children) {
            return;
        }
        for (GeneNode child : children) {
            this.ladder(child, comp);
        }
        Collections.sort(children, comp);
    }

    protected void getDescendentList(GeneNode node, List<GeneNode> v) {
        if (!node.isTerminus()) {
            List<GeneNode> children = node.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                GeneNode child = children.get(i);
                v.add(child);
                this.getDescendentList(child, v);
            }
        }
    }

    protected void getLeafDescendants(GeneNode node, Vector<GeneNode> leafList) {
        if (null == node) {
            return;
        }
        if (node.isLeaf() && !node.isPruned()) {
            leafList.addElement(node);
        } else {
            List<GeneNode> children = node.getChildren();
            for (int i = 0; children != null && i < children.size(); ++i) {
                GeneNode child = children.get(i);
                if (child.isPruned()) continue;
                this.getLeafDescendants(child, leafList);
            }
        }
    }

    public int getNumNodes() {
        return this.allNodes.size();
    }

    public TreeColorSchema getTreeColorSchema() {
        return this.treeColorSchema;
    }

    public void setTreeColorSchema(TreeColorSchema treeColorSchema) {
        this.treeColorSchema = treeColorSchema;
        Preferences.inst().setTreeColorSchema(treeColorSchema);
    }

    private class DistanceSort
    implements Comparator<GeneNode> {
        private DistanceSort() {
        }

        @Override
        public int compare(GeneNode o1, GeneNode o2) {
            float o2_distance;
            float o1_distance = o1.getDistanceFromParent();
            if (o1_distance < (o2_distance = o2.getDistanceFromParent())) {
                return -1;
            }
            if (o1_distance < o2_distance) {
                return 1;
            }
            return 0;
        }
    }

    private class SpeciesSort
    implements Comparator<GeneNode> {
        private SpeciesSort() {
        }

        @Override
        public int compare(GeneNode o1, GeneNode o2) {
            int o1_descendents = TreeModel.this.species_index.get(o1);
            int o2_descendents = TreeModel.this.species_index.get(o2);
            return o1_descendents - o2_descendents;
        }
    }

    private class LeafCountSort
    implements Comparator<GeneNode> {
        private boolean most_leaves_at_top;

        private LeafCountSort(boolean most_leaves_at_top) {
            this.most_leaves_at_top = most_leaves_at_top;
        }

        @Override
        public int compare(GeneNode o1, GeneNode o2) {
            int o1_descendents = TreeModel.this.descendent_count.get(o1);
            int o2_descendents = TreeModel.this.descendent_count.get(o2);
            int sort_value = o1_descendents - o2_descendents;
            if (this.most_leaves_at_top) {
                sort_value *= -1;
            }
            return sort_value;
        }
    }

    public static enum TreeColorSchema {
        DUPLICATION,
        SPECIES_CLS,
        HORIZONTAL_TRANSFER;

    }
}

