/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.familytree;

import edu.usc.ksom.pm.panther.paintCommon.Node;
import edu.usc.ksom.pm.panther.paintCommon.NodeVariableInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.dialog.AddExpEvidenceDlg;
import org.paint.gui.DirtyIndicator;
import org.paint.gui.FamilyViews;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.AnnotationChangeListener;
import org.paint.gui.event.AnnotationDisplayEvent;
import org.paint.gui.event.AnnotationDisplayListener;
import org.paint.gui.event.AnnotationDragEvent;
import org.paint.gui.event.AnnotationDragListener;
import org.paint.gui.event.AspectChangeEvent;
import org.paint.gui.event.AspectChangeListener;
import org.paint.gui.event.CurationColorEvent;
import org.paint.gui.event.CurationColorListener;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.GeneSelectEvent;
import org.paint.gui.event.GeneSelectListener;
import org.paint.gui.event.TermAncestorSelectionEvent;
import org.paint.gui.event.TermAncestorSelectionListener;
import org.paint.gui.event.TermSelectEvent;
import org.paint.gui.event.TermSelectionListener;
import org.paint.gui.familytree.TreeModel;
import org.paint.gui.table.GeneTable;
import org.paint.main.PaintManager;
import org.paint.util.AnnotationUtil;

public class TreePanel
extends JPanel
implements MouseListener,
MouseMotionListener,
Scrollable,
GeneSelectListener,
CurationColorListener,
TermSelectionListener,
TermAncestorSelectionListener,
AnnotationChangeListener,
AspectChangeListener,
AnnotationDragListener,
AnnotationDisplayListener {
    private static final long serialVersionUID = 1L;
    protected boolean first_time = true;
    protected int prevWidth = 0;
    protected static Logger logger = Logger.getLogger((String)TreePanel.class.getName());
    protected static final String TOOLTIP_FOREGROUND = "ToolTip.foreground";
    public static final String POPUP_MENU_COLLAPSE = "Collapse node";
    public static final String POPUP_MENU_EXPAND = "Expand node";
    public static final String POPUP_MENU_OUTPUT_SEQ = "Output seq ids for leaves";
    public static final String POPUP_MENU_UPDATE_EXP = "Update exp evidence added via PAINT";
    public static final String POPUP_MENU_REROOT = "Reroot to node";
    public static final String POPUP_MENU_RESET_ROOT = "Reset Root to Main";
    public static final String POPUP_MENU_PRUNE = "Prune";
    public static final int TREE_COLLAPSE_NONEXP_NODES = 201;
    public static final int TREE_EXPAND_ALL_NODES = 202;
    public static final int TREE_RESET_ROOT_TO_MAIN = 203;
    public static final int TREE_USE_DISTANCES = 204;
    public static final int TREE_SPECIES = 205;
    public static final int TREE_TOP = 206;
    public static final int TREE_BOTTOM = 207;
    private static final String OUTPUT_SEQ_INFO_TITLE = "#Descendant sequence information for node ";
    private static final String OUTPUT_SEQ_DELIM = "\t";
    private static final String OUTPUT_SEQ_INFO_COLUMNS = "#Database id\tSequence id";
    private boolean need_update = true;
    private Rectangle tree_rect = new Rectangle(0, 0, 0, 0);
    protected static final int LEFTMARGIN = 20;
    private TreeModel tree;
    private static Logger log = Logger.getLogger(TreePanel.class);

    public TreePanel() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        EventManager manager = EventManager.inst();
        manager.registerGeneListener(this);
        manager.registerGeneAnnotationChangeListener(this);
        manager.registerAspectChangeListener(this);
        manager.registerTermListener(this);
        manager.registerTermAncestorListener(this);
        manager.registerCurationColorListener(this);
        manager.registerAnnotationDisplayListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setTreeModel(TreeModel tree) {
        this.tree = tree;
        this.setNeedPositionUpdate();
    }

    public TreeModel getTreeModel() {
        return this.tree;
    }

    public GeneNode getRoot() {
        if (this.tree != null) {
            return this.tree.getRoot();
        }
        return null;
    }

    public GeneNode getCurrentRoot() {
        if (this.tree != null) {
            return this.tree.getCurrentRoot();
        }
        return null;
    }

    public List<GeneNode> getAllNodes() {
        if (this.tree != null) {
            return this.tree.getAllNodes();
        }
        return null;
    }

    public void updateColoring(TreeModel.TreeColorSchema colSchema) {
        if (null == this.tree) {
            return;
        }
        this.tree.setTreeColorSchema(colSchema);
        this.repaint();
    }

    public void scaleTree(double scale) {
        if (this.tree != null) {
            this.tree.scaleTree(scale);
            this.setNeedPositionUpdate();
        } else {
            Preferences.inst().setTree_distance_scaling(scale);
        }
    }

    public void speciesOrder() {
        if (this.tree != null) {
            this.tree.speciesOrder();
            this.setNeedPositionUpdate();
        }
    }

    public void descendentCountLadder(boolean most_leaves_at_top) {
        if (this.tree != null) {
            this.tree.descendentCountLadder(most_leaves_at_top);
            this.setNeedPositionUpdate();
        }
    }

    public List<GeneNode> getTerminusNodes() {
        if (this.tree != null) {
            return this.tree.getTerminusNodes();
        }
        return null;
    }

    public void getDescendentList(GeneNode node, List<GeneNode> v) {
        if (this.tree != null) {
            this.tree.getDescendentList(node, v);
        }
    }

    public void getLeafDescendants(GeneNode node, Vector<GeneNode> leafList) {
        if (this.tree != null) {
            this.tree.getLeafDescendants(node, leafList);
        }
    }

    public void adjustTree() {
        this.setNeedPositionUpdate();
    }

    public void expandAllNodes() {
        if (this.tree != null) {
            this.tree.expandAllNodes();
            this.setNeedPositionUpdate();
        }
    }

    public void collapseNonExperimental() {
        if (this.tree != null) {
            this.tree.collapseNonExperimental();
            this.setNeedPositionUpdate();
        }
    }

    public void resetRootToMain() {
        if (this.tree != null && this.tree.resetRootToMain()) {
            this.setNeedPositionUpdate();
        }
    }

    public GeneNode getMRCA(GeneNode gene1, GeneNode gene2) {
        if (this.tree != null) {
            return this.tree.getMRCA(gene1, gene2);
        }
        return null;
    }

    public GeneNode getTopLeafNode(GeneNode node) {
        if (this.tree != null) {
            return this.tree.getTopLeafNode(node);
        }
        return null;
    }

    public GeneNode getBottomLeafNode(GeneNode node) {
        if (this.tree != null) {
            return this.tree.getBottomLeafNode(node);
        }
        return null;
    }

    public void handlePruning(GeneNode node) {
        boolean shift = this.tree.handlePruning(node);
        if (shift) {
            this.setNeedPositionUpdate();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.tree != null && g != null) {
            Rectangle r = ((JViewport)this.getParent()).getViewRect();
            this.paintTree(g, r);
        }
    }

    protected void paintTree(Graphics g, Rectangle r) {
        GeneNode current_root = this.getCurrentRoot();
        if (null == g || null == current_root) {
            return;
        }
        boolean use_distances = Preferences.inst().isUseDistances();
        if (this.need_update) {
            this.updateNodePositions(current_root, g, PaintManager.inst().getRowHeight(), use_distances);
        }
        Font f = g.getFont();
        this.paintBranch(current_root, current_root, g, r, use_distances);
        g.setFont(f);
    }

    private void paintBranch(GeneNode current_root, GeneNode dsn, Graphics g, Rectangle r, boolean use_distances) {
        Iterator<GeneNode> it;
        if (null == dsn) {
            return;
        }
        List<GeneNode> topChildren = this.tree.getTopChildren(dsn);
        List<GeneNode> bottomChildren = this.tree.getBottomChildren(dsn);
        if (!dsn.isTerminus() && null != topChildren) {
            it = topChildren.iterator();
            while (it.hasNext()) {
                this.paintBranch(current_root, it.next(), g, r, use_distances);
            }
        }
        dsn.drawMarker(current_root, g, current_root == dsn && current_root != this.tree.getRoot(), r);
        if (!dsn.isTerminus() && null != bottomChildren) {
            it = bottomChildren.iterator();
            while (it.hasNext()) {
                this.paintBranch(current_root, it.next(), g, r, use_distances);
            }
        }
    }

    private void updateNodePositions(GeneNode current_root, Graphics g, int row_height, boolean use_distances) {
        int x = 20 + this.getNodeWidth(g, current_root);
        this.setNodeRectangle(current_root, row_height, x, 0.0f, use_distances, g);
        this.tree_rect = this.calcTreeSize(g);
        this.revalidate();
        this.repaint();
        this.need_update = false;
    }

    protected void setNeedPositionUpdate() {
        this.need_update = true;
    }

    private Rectangle calcTreeSize(Graphics g) {
        this.tree_rect.setBounds(0, 0, 0, 0);
        List<GeneNode> terminus_nodes = this.tree.getTerminusNodes();
        GeneNode bottom_node = terminus_nodes.get(terminus_nodes.size() - 1);
        Rectangle bottomRect = bottom_node.getScreenRectangle();
        this.tree_rect.height = bottomRect.y;
        for (int i = 0; i < terminus_nodes.size(); ++i) {
            GeneNode dsn;
            int x = dsn.getScreenRectangle().x;
            dsn = terminus_nodes.get(i);
            int width = this.getNodeWidth(g, dsn);
            if (this.tree_rect.width >= x + width) continue;
            this.tree_rect.width = x + width;
        }
        return this.tree_rect;
    }

    protected Rectangle getTreeSize(Graphics g) {
        if (this.tree != null && this.need_update) {
            this.updateNodePositions(this.getCurrentRoot(), g, PaintManager.inst().getRowHeight(), Preferences.inst().isUseDistances());
        }
        return this.tree_rect;
    }

    private int setNodeRectangle(GeneNode node, int row_height, float base_x, float tree_depth, boolean use_distances, Graphics g) {
        int y;
        double scale = this.tree.getDistanceScaling();
        Float f = !use_distances ? new Float((double)base_x + (double)tree_depth * scale) : new Float((double)base_x + (double)Math.abs(node.getDistanceFromParent()) * scale);
        int x = f.intValue();
        int width = this.getNodeWidth(g, node);
        if (node.isTerminus()) {
            int margin = PaintManager.inst().getTopMargin() + 8;
            int row = this.tree.getTerminusNodes().indexOf(node);
            GeneTable mate = PaintManager.inst().getGeneTable();
            Rectangle position = mate.getCellRect(row, 0, false);
            double better_y = (double)margin + position.getY();
            y = (int)Math.round(better_y);
        } else {
            List<GeneNode> children = node.getChildren();
            if (null == children) {
                y = 0;
            }
            int top_y = -1;
            int bottom_y = -1;
            float child_depth = tree_depth + 1.0f;
            float child_base = f.floatValue() + (float)width;
            for (GeneNode child : children) {
                int child_y = this.setNodeRectangle(child, row_height, child_base, child_depth, use_distances, g);
                if (top_y < 0 || child_y < top_y) {
                    top_y = child_y;
                }
                if (bottom_y >= 0 && child_y <= bottom_y) continue;
                bottom_y = child_y;
            }
            y = (top_y + bottom_y) / 2 - row_height / 2;
        }
        int height = node.isTerminus() && node.getNodeLabel() != null && !node.getNodeLabel().equals("") ? row_height : 8;
        node.setNodeArea(x, y, height, width);
        return y + height / 2;
    }

    private int getNodeWidth(Graphics g, GeneNode node) {
        int width = this.getTextWidth(g, node);
        width = width == 0 ? 8 : (width += 18);
        return width;
    }

    private int getTextWidth(Graphics g, GeneNode node) {
        String s;
        int width = 0;
        if (node.isTerminus() && (s = node.getNodeLabel()) != null && !s.equals("")) {
            FontMetrics fm = g.getFontMetrics(Preferences.inst().getFont());
            width = fm.stringWidth(s);
        }
        return width;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JPopupMenu popup;
        GeneNode node;
        this.setToolTipText("");
        int modifiers = e.getModifiers();
        if ((modifiers & 0x10) != 0 && (modifiers & 4) == 0 && this.tree != null && (node = this.getClickedInNodeArea(e.getPoint())) != null) {
            boolean new_select;
            boolean bl = new_select = !node.isSelected();
            if (node.getParent() != null) {
                new_select |= node.isSelected() && node.getParent().isSelected();
            }
            if (new_select) {
                ArrayList<GeneNode> selection = new ArrayList<GeneNode>();
                selection.add(0, node);
                this.tree.getDescendentList(node, selection);
                GeneSelectEvent ge = new GeneSelectEvent(this, selection, node);
                EventManager.inst().fireGeneEvent(ge);
            } else {
                ArrayList<GeneNode> selection = new ArrayList<GeneNode>();
                GeneSelectEvent ge = new GeneSelectEvent(this, selection, node);
                EventManager.inst().fireGeneEvent(ge);
            }
        }
        if ((4 == (modifiers & 4) || (modifiers & 0x10) != 0 && (modifiers & 4) == 0 && e.isMetaDown()) && (popup = this.createPopupMenu(e)) != null) {
            this.showPopup(popup, e.getComponent(), new Point(e.getX(), e.getY()));
        }
    }

    private void showPopup(JPopupMenu popup, Component comp, Point position) {
        Component root;
        for (root = comp; root != null && !(root instanceof JFrame); root = root.getParent()) {
        }
        if (root != null) {
            SwingUtilities.convertPointToScreen(position, comp);
            Point rootPos = root.getLocationOnScreen();
            Dimension rootSize = root.getSize();
            Dimension popSize = popup.getPreferredSize();
            int x = position.x;
            int y = position.y;
            Insets insets = popup.getInsets();
            if (position.x + popSize.width + (insets.left + insets.right) > rootPos.x + rootSize.width) {
                x = rootPos.x + rootSize.width - popSize.width - insets.left;
            }
            if (position.y + popSize.height + (insets.top + insets.bottom) > rootPos.y + rootSize.height) {
                y = rootPos.y + rootSize.height - popSize.height - insets.top;
            }
            if (x >= rootPos.x + insets.left && y >= rootPos.y + insets.top) {
                position.setLocation(x, y);
            }
            SwingUtilities.convertPointFromScreen(position, comp);
        }
        popup.show(comp, position.x, position.y);
    }

    private GeneNode getPopupNode(MouseEvent e) {
        if (null == this.tree) {
            return null;
        }
        return this.getClicked(e.getPoint());
    }

    private JPopupMenu createPopupMenu(MouseEvent e) {
        JPopupMenu popup = null;
        GeneNode dsn = this.getPopupNode(e);
        if (dsn != null) {
            JMenuItem menuItem;
            popup = new JPopupMenu();
            if (!dsn.isLeaf()) {
                menuItem = dsn.isExpanded() ? new JMenuItem(POPUP_MENU_COLLAPSE) : new JMenuItem(POPUP_MENU_EXPAND);
                menuItem.addActionListener(new CollapseExpandNodeActionListener(dsn));
                popup.add(menuItem);
            }
            if (!dsn.isLeaf()) {
                if (dsn != this.getCurrentRoot()) {
                    menuItem = new JMenuItem(POPUP_MENU_REROOT);
                    menuItem.addActionListener(new InternalRerootActionListener(dsn));
                } else {
                    menuItem = new JMenuItem(POPUP_MENU_RESET_ROOT);
                    menuItem.addActionListener(new InternalRerootActionListener(this.tree.getRoot()));
                }
                popup.add(menuItem);
            }
            if (!dsn.isPruned()) {
                menuItem = new JMenuItem(POPUP_MENU_OUTPUT_SEQ);
                menuItem.addActionListener(new OutputSeqIdsActionListener(e, dsn));
                popup.add(menuItem);
            }
            JCheckBoxMenuItem checkItem = new JCheckBoxMenuItem(POPUP_MENU_PRUNE);
            checkItem.addActionListener(new PruneActionListener(e, dsn));
            checkItem.setSelected(dsn.isPruned());
            popup.add(checkItem);
            if (dsn.isLeaf()) {
                JMenuItem menuItem2 = new JMenuItem(POPUP_MENU_UPDATE_EXP);
                menuItem2.addActionListener(new UpdateExperimentalEvidenceListener(e, dsn));
                popup.add(menuItem2);
            }
        }
        return popup;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setToolTipText("");
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.tree != null) {
            if (this.pointInNode(e.getPoint())) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
            GeneNode node = this.getClickedInNodeArea(e.getPoint());
            String tool_tip = null == node ? "" : this.getToolTipInfo(node);
            this.setToolTipText(tool_tip);
            if (!tool_tip.equals("")) {
                UIManager.put(TOOLTIP_FOREGROUND, new ColorUIResource(Preferences.inst().getForegroundColor()));
                ToolTipManager.sharedInstance().setEnabled(true);
                ToolTipManager.sharedInstance().mouseMoved(e);
            }
        }
    }

    @Override
    public void handleAnnotationDisplayEvent(AnnotationDisplayEvent event) {
        this.repaint();
    }

    protected void outputInfo(GeneNode n, Vector<GeneNode> leafList) {
        int rtrnVal;
        StringBuffer sb = new StringBuffer(OUTPUT_SEQ_INFO_TITLE + n.getSeqId());
        sb.append("\n");
        sb.append(OUTPUT_SEQ_INFO_COLUMNS);
        sb.append("\n");
        for (int i = 0; i < leafList.size(); ++i) {
            GeneNode aNode = leafList.get(i);
            sb.append(aNode.getDatabase() + ":" + aNode.getDatabaseID());
            sb.append(OUTPUT_SEQ_DELIM);
            sb.append(aNode.getSeqId());
            sb.append("\n");
        }
        JFileChooser dlg = new JFileChooser();
        if (null != PaintManager.inst().getCurrentDirectory()) {
            dlg.setCurrentDirectory(PaintManager.inst().getCurrentDirectory());
        }
        if (0 != (rtrnVal = dlg.showSaveDialog(GUIManager.getManager().getFrame()))) {
            return;
        }
        File f = dlg.getSelectedFile();
        try {
            FileWriter fstream = new FileWriter(f);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(sb.toString());
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    @Override
    public void handleGeneSelectEvent(GeneSelectEvent event) {
        List<GeneNode> selection = event.getPrevious();
        this.repaintNodes(selection);
        selection = event.getGenes();
        this.repaintNodes(selection);
    }

    @Override
    public void handleTermEvent(TermSelectEvent e) {
        this.repaintNodes(this.tree.getCurrentNodes());
    }

    @Override
    public void handleTermAncestorSelectionEvent(TermAncestorSelectionEvent e) {
        this.repaintNodes(this.tree.getCurrentNodes());
    }

    private void repaintNodes(Collection<GeneNode> genes) {
        Rectangle r = null;
        int width = 0;
        int height = 0;
        if (genes != null) {
            for (GeneNode node : genes) {
                Rectangle node_rect = new Rectangle(node.getScreenRectangle());
                node_rect.x -= 8;
                node_rect.width += 16;
                --node_rect.y;
                node_rect.height += 2;
                if (r == null) {
                    r = node_rect;
                } else {
                    if (node_rect.x < r.x) {
                        r.x = node_rect.x;
                    }
                    if (node_rect.y < r.y) {
                        r.y = node_rect.y;
                    }
                }
                height += node_rect.height;
                width = Math.max(width, node_rect.width);
            }
        }
        if (r != null) {
            r.height = height;
            r.width = width;
            this.repaint(r);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.getPreferredScrollableViewportSize();
        d.height += FamilyViews.inst().getHScrollerHeight(0);
        d.height += FamilyViews.inst().getBottomMargin(0) + 2;
        return d;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension tree_size = new Dimension();
        if (this.getGraphics() != null) {
            Rectangle tree_rect = this.getTreeSize(this.getGraphics());
            tree_size.width = (int)tree_rect.getWidth();
            tree_size.height = (int)tree_rect.getHeight();
        }
        return tree_size;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int row_height = PaintManager.inst().getRowHeight();
            int rows = visibleRect.height / row_height;
            return (rows + 1) * row_height;
        }
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int newPosition;
        int maxUnitIncrement;
        int currentPosition;
        if (orientation == 1) {
            currentPosition = visibleRect.y;
            maxUnitIncrement = PaintManager.inst().getRowHeight();
        } else {
            currentPosition = visibleRect.x;
            maxUnitIncrement = 1;
        }
        int increment = direction < 0 ? ((newPosition = currentPosition - currentPosition / maxUnitIncrement * maxUnitIncrement) == 0 ? maxUnitIncrement : newPosition) : (currentPosition / maxUnitIncrement + 1) * maxUnitIncrement - currentPosition;
        return increment;
    }

    @Override
    public void handleAnnotationChangeEvent(AnnotationChangeEvent event) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void handleAspectChangeEvent(AspectChangeEvent event) {
        this.repaint();
    }

    @Override
    public void handleAspectChangeEvent(AnnotationDragEvent event) {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public void setDropInfo(GeneNode node, Point dropPoint, String dropLabel) {
        String tool_tip = dropLabel != null ? dropLabel : "";
        this.setToolTipText(tool_tip);
        UIManager.put(TOOLTIP_FOREGROUND, new ColorUIResource(Preferences.inst().getForegroundColor()));
        MouseEvent phantom = new MouseEvent(this, 503, System.currentTimeMillis(), 0, dropPoint.x, dropPoint.y, 0, false);
        ToolTipManager.sharedInstance().mouseMoved(phantom);
    }

    @Override
    public void handleCurationColorEvent(CurationColorEvent e) {
        this.repaint();
    }

    public boolean pointInNode(Point p) {
        GeneNode current_root = this.getCurrentRoot();
        return null != this.getClicked(current_root, p);
    }

    protected GeneNode getClicked(Point p) {
        GeneNode current_root = this.getCurrentRoot();
        return this.getClicked(current_root, p);
    }

    public GeneNode getClickedInNodeArea(Point p) {
        GeneNode current_root = this.getCurrentRoot();
        return this.getClickedInNodeArea(current_root, p);
    }

    private GeneNode getClicked(GeneNode dsn, Point p) {
        if (null == dsn || dsn.getScreenRectangle() == null) {
            return null;
        }
        if (dsn.getScreenRectangle().contains(p)) {
            return dsn;
        }
        List<GeneNode> children = dsn.getChildren();
        if (null == children) {
            return null;
        }
        if (dsn.isTerminus()) {
            return null;
        }
        for (int i = 0; i < children.size(); ++i) {
            GeneNode gnHit = null;
            gnHit = this.getClicked(children.get(i), p);
            if (null == gnHit) continue;
            return gnHit;
        }
        return null;
    }

    public GeneNode getClickedInNodeArea(GeneNode dsn, Point p) {
        if (null == dsn || dsn.getScreenRectangle() == null) {
            return null;
        }
        if (dsn.getScreenRectangle().contains(p)) {
            return dsn;
        }
        List<GeneNode> children = dsn.getChildren();
        if (children != null && !dsn.isTerminus()) {
            GeneNode dsnHit = null;
            for (int i = 0; i < children.size(); ++i) {
                dsnHit = this.getClickedInNodeArea(children.get(i), p);
                if (null == dsnHit) continue;
                return dsnHit;
            }
        }
        return null;
    }

    protected String getToolTipInfo(GeneNode node) {
        return node.getNodeLabel() + node.getNode().getStaticInfo().getPublicId();
    }

    private class UpdateExperimentalEvidenceListener
    implements ActionListener {
        GeneNode node;

        UpdateExperimentalEvidenceListener(MouseEvent e, GeneNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddExpEvidenceDlg dlg = new AddExpEvidenceDlg(this.node);
        }
    }

    private class PruneActionListener
    implements ActionListener {
        GeneNode node;

        PruneActionListener(MouseEvent e, GeneNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Node n = this.node.getNode();
            NodeVariableInfo nvi = n.getVariableInfo();
            if (null == nvi) {
                nvi = new NodeVariableInfo();
                n.setVariableInfo(nvi);
            }
            nvi.setPruned(!nvi.isPruned());
            if (nvi.isPruned()) {
                AnnotationUtil.pruneBranch(this.node);
            } else {
                AnnotationUtil.graftBranch(this.node);
            }
            DirtyIndicator.inst().setAnnotated(true);
            AnnotationUtil.branchNotify(this.node);
        }
    }

    private class OutputSeqIdsActionListener
    implements ActionListener {
        GeneNode node;

        OutputSeqIdsActionListener(MouseEvent e, GeneNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector<GeneNode> leafList = new Vector<GeneNode>();
            TreePanel.this.tree.getLeafDescendants(this.node, leafList);
            TreePanel.this.outputInfo(this.node, leafList);
        }
    }

    private class CollapseExpandNodeActionListener
    implements ActionListener {
        GeneNode node;

        CollapseExpandNodeActionListener(GeneNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePanel.this.tree.handleCollapseExpand(this.node);
            TreePanel.this.setNeedPositionUpdate();
            TreePanel.this.revalidate();
            TreePanel.this.repaint();
        }
    }

    private class InternalRerootActionListener
    implements ActionListener {
        GeneNode node;

        InternalRerootActionListener(GeneNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePanel.this.tree.nodeReroot(this.node);
            TreePanel.this.setNeedPositionUpdate();
            TreePanel.this.revalidate();
            TreePanel.this.repaint();
        }
    }
}

