/*
 * Decompiled with CFR 0.152.
 */
package org.paint.gui.matrix;

import edu.usc.ksom.pm.panther.paint.matrix.MatrixBuilder;
import edu.usc.ksom.pm.panther.paint.matrix.MatrixGroup;
import edu.usc.ksom.pm.panther.paint.matrix.MatrixInfo;
import edu.usc.ksom.pm.panther.paint.matrix.NodeInfoForMatrix;
import edu.usc.ksom.pm.panther.paint.matrix.TermAncestor;
import edu.usc.ksom.pm.panther.paint.matrix.TermToAssociation;
import edu.usc.ksom.pm.panther.paintCommon.GOTerm;
import edu.usc.ksom.pm.panther.paintCommon.Node;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.paint.config.Preferences;
import org.paint.datamodel.GeneNode;
import org.paint.gui.AspectSelector;
import org.paint.gui.event.AnnotationChangeEvent;
import org.paint.gui.event.AnnotationChangeListener;
import org.paint.gui.event.AnnotationDisplayEvent;
import org.paint.gui.event.AnnotationDisplayListener;
import org.paint.gui.event.AspectChangeEvent;
import org.paint.gui.event.AspectChangeListener;
import org.paint.gui.event.EventManager;
import org.paint.gui.event.GeneSelectEvent;
import org.paint.gui.event.GeneSelectListener;
import org.paint.gui.event.NodeReorderEvent;
import org.paint.gui.event.NodeReorderListener;
import org.paint.gui.familytree.TreePanel;
import org.paint.gui.matrix.AnnotationMatrixCellRenderer;
import org.paint.gui.matrix.AnnotationMatrixHeaderRenderer;
import org.paint.gui.matrix.AnnotationMatrixModel;
import org.paint.gui.matrix.AnnotationTransferHndlr;
import org.paint.main.PaintManager;

public class AnnotationMatrix
extends JTable
implements AnnotationChangeListener,
MouseListener,
MouseMotionListener,
GeneSelectListener,
NodeReorderListener,
AspectChangeListener,
AnnotationDisplayListener {
    private AnnotationMatrixHeaderRenderer header_renderer;
    private AnnotationMatrixCellRenderer matrix_renderer;
    private HashMap<String, AnnotationMatrixModel> models;
    private AnnotationTransferHndlr annot_handler;
    private int selectedColumn = -1;
    private int clickedRow = -1;
    private MatrixInfo mi;

    public AnnotationMatrix() {
        this.setOpaque(true);
        this.setBackground(new Color(205, 205, 255));
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.addMouseListener(this);
        EventManager manager = EventManager.inst();
        manager.registerGeneListener(this);
        manager.registerNodeReorderListener(this);
        manager.registerAspectChangeListener(this);
        manager.registerGeneAnnotationChangeListener(this);
        manager.registerAnnotationDisplayListener(this);
        this.setFont(Preferences.inst().getFont());
        this.setDragEnabled(true);
        this.annot_handler = new AnnotationTransferHndlr();
        this.setTransferHandler(this.annot_handler);
        this.setRowMargin(0);
        this.matrix_renderer = new AnnotationMatrixCellRenderer();
        this.setDefaultRenderer(NodeInfoForMatrix.class, this.matrix_renderer);
        this.header_renderer = new AnnotationMatrixHeaderRenderer(this.getTableHeader());
    }

    public void setModels(List<GeneNode> orderedNodes, MatrixInfo mi) {
        this.mi = mi;
        if (this.models == null) {
            this.models = new HashMap();
        }
        this.models.clear();
        AnnotationMatrixModel annot_model = new AnnotationMatrixModel(orderedNodes, AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString(), mi.getGroups(AspectSelector.aspects.get(AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString())));
        this.models.put(AspectSelector.Aspect.BIOLOGICAL_PROCESS.toString(), annot_model);
        annot_model = new AnnotationMatrixModel(orderedNodes, AspectSelector.Aspect.CELLULAR_COMPONENT.toString(), mi.getGroups(AspectSelector.aspects.get(AspectSelector.Aspect.CELLULAR_COMPONENT.toString())));
        this.models.put(AspectSelector.Aspect.CELLULAR_COMPONENT.toString(), annot_model);
        annot_model = new AnnotationMatrixModel(orderedNodes, AspectSelector.Aspect.MOLECULAR_FUNCTION.toString(), mi.getGroups(AspectSelector.aspects.get(AspectSelector.Aspect.MOLECULAR_FUNCTION.toString())));
        this.models.put(AspectSelector.Aspect.MOLECULAR_FUNCTION.toString(), annot_model);
        String go_aspect = AspectSelector.inst().getAspect().toString();
        AnnotationMatrixModel matrix = this.models.get(go_aspect);
        this.setModel(matrix);
        if (matrix.getColumnCount() > 0 && this.selectedColumn < 0 || this.selectedColumn > matrix.getColumnCount()) {
            this.setSelectedColumn(0);
        }
        matrix.fireTableDataChanged();
        this.invalidate();
        System.gc();
    }

    public void setModel(AnnotationMatrixModel model) {
        if (model == null) {
            return;
        }
        super.setModel(model);
        int columns = model.getColumnCount();
        DefaultTableColumnModel column_model = new DefaultTableColumnModel();
        for (int i = 0; i < columns; ++i) {
            TableColumn col = new TableColumn(i);
            col.setPreferredWidth(12);
            col.setHeaderRenderer(this.header_renderer);
            col.setResizable(false);
            column_model.addColumn(col);
        }
        this.setDefaultRenderer(NodeInfoForMatrix.class, this.matrix_renderer);
        this.setColumnModel(column_model);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        Point point = event.getPoint();
        int row = this.rowAtPoint(point);
        AnnotationMatrixModel model = (AnnotationMatrixModel)this.getModel();
        if (row >= 0 && row < this.getRowCount()) {
            int column;
            GeneNode selectedNode = model.getNode(this.clickedRow);
            List<GeneNode> previous_genes = EventManager.inst().getCurrentGeneSelection();
            ArrayList<GeneNode> previousCopy = null;
            if (null != previous_genes) {
                previousCopy = new ArrayList<GeneNode>();
                previousCopy.addAll(previous_genes);
            }
            List<GeneNode> selected_genes = null;
            if (!(event.isMetaDown() || event.isShiftDown() || event.isAltDown() || event.isControlDown())) {
                column = this.columnAtPoint(point);
                if (column < 0) {
                    return;
                }
                this.setSelectedColumn(column);
                this.clickedRow = row;
                selectedNode = model.getNode(this.clickedRow);
                if (null != selectedNode) {
                    selected_genes = new ArrayList<GeneNode>(1);
                    selected_genes.add(selectedNode);
                }
            }
            if (event.isMetaDown() && !event.isShiftDown() && !event.isAltDown() && !event.isControlDown()) {
                column = this.columnAtPoint(point);
                if (column < 0) {
                    return;
                }
                this.setSelectedColumn(column);
                this.clickedRow = row;
                System.out.println("Column selected");
                TermAncestor termAncestor = ((AnnotationMatrixModel)this.getModel()).getTermAncestorAtColumn(column);
                if (termAncestor != null) {
                    if (null != selectedNode) {
                        System.out.println("Right click single node selected id = " + selectedNode.getNodeLabel() + " term is " + termAncestor.getTermToAssociation().getTerm().getAcc());
                    }
                    if (null != (selected_genes = this.getMRCAForTerm(termAncestor)) && 0 < selected_genes.size()) {
                        System.out.println("Selecting " + selected_genes.size() + " genes which include MCRA and descendents for selected term");
                        selectedNode = selected_genes.get(selected_genes.size() - 1);
                    }
                }
            }
            if (null != selected_genes && null != selectedNode) {
                ArrayList<GeneNode> selection = new ArrayList<GeneNode>();
                selection.addAll(selected_genes);
                GeneSelectEvent ge = new GeneSelectEvent(this, selection, selectedNode);
                EventManager.inst().fireGeneEvent(ge);
                if (selection != null) {
                    System.out.println("Going to select genes");
                    if (previousCopy == null) {
                        this.updateRows(selected_genes);
                    } else if (previousCopy.size() != selected_genes.size()) {
                        this.updateRows(previousCopy);
                        this.updateRows(selected_genes);
                    } else {
                        boolean need_update = false;
                        for (GeneNode gene : previousCopy) {
                            need_update |= !selected_genes.contains(gene);
                        }
                        if (need_update) {
                            this.updateRows(previousCopy);
                            this.updateRows(selected_genes);
                        }
                    }
                } else {
                    System.out.println("No genes selected");
                }
            }
        }
        System.out.println("Going to export as drag");
        this.annot_handler.exportAsDrag(this, event, 1);
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void handleAspectChangeEvent(AspectChangeEvent event) {
        AnnotationMatrixModel matrix = null;
        if (this.models != null) {
            String go_aspect = AspectSelector.inst().getAspect().toString();
            matrix = this.models.get(go_aspect);
        }
        this.setModel(matrix);
        if (matrix.getColumnCount() > 0) {
            this.setSelectedColumn(0);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public void setSelectedColumn(int col) {
        this.updateColumn(this.selectedColumn);
        this.selectedColumn = col;
        this.clearSelection();
        this.addColumnSelectionInterval(col, col);
        this.updateColumn(this.selectedColumn);
    }

    public int getClickedRow() {
        return this.clickedRow;
    }

    private void updateColumn(int col) {
        for (int row = 0; row < this.getRowCount() && col >= 0; ++row) {
            AnnotationMatrixModel model = (AnnotationMatrixModel)this.getModel();
            model.fireTableCellUpdated(row, col);
        }
    }

    private void updateRows(List<GeneNode> genes) {
        AnnotationMatrixModel model = (AnnotationMatrixModel)this.getModel();
        for (GeneNode gene : genes) {
            int row = model.getRow(gene);
            this.updateRow(row);
        }
    }

    private void updateRow(int row) {
        AnnotationMatrixModel model = (AnnotationMatrixModel)this.getModel();
        for (int col = 0; col < this.getColumnCount() && row >= 0; ++col) {
            model.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public void handleAnnotationChangeEvent(AnnotationChangeEvent event) {
        PaintManager pm = PaintManager.inst();
        this.mi = MatrixBuilder.getMatrixInfo(pm.getTree().getTreeModel());
        this.setModels(pm.getTree().getTerminusNodes(), this.mi);
    }

    @Override
    public void handleGeneSelectEvent(GeneSelectEvent event) {
        if (event.getGenes() == null) {
            System.out.println("AnnotationTable: wierd, have a null gene selected");
        }
        if (event.getSource() == this) {
            return;
        }
        this.clearSelection();
        AnnotationMatrixModel model = (AnnotationMatrixModel)this.getModel();
        int maxRowCount = model.getRowCount();
        for (GeneNode node : event.getGenes()) {
            int row = model.getRow(node);
            if (0 > row || row > maxRowCount) continue;
            this.addRowSelectionInterval(row, row);
            this.updateRow(row);
        }
        this.repaint();
    }

    @Override
    public void handleNodeReorderEvent(NodeReorderEvent e) {
        PaintManager pm = PaintManager.inst();
        this.mi = MatrixBuilder.getMatrixInfo(pm.getTree().getTreeModel());
        this.setModels(pm.getTree().getTerminusNodes(), this.mi);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.repaint();
    }

    public boolean termInMatrix(GOTerm term) {
        if (null == this.mi) {
            return false;
        }
        Set<String> keySet = this.mi.getAspects();
        for (String aspect : keySet) {
            ArrayList<MatrixGroup> groups = this.mi.getGroups(aspect);
            for (MatrixGroup group : groups) {
                ArrayList<TermAncestor> items = group.getItems();
                for (TermAncestor ta : items) {
                    if (!ta.getTermToAssociation().getTerm().equals(term)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<GeneNode> getMRCAForTerm(TermAncestor newTermAncestor) {
        TermToAssociation toa = newTermAncestor.getTermToAssociation();
        ArrayList<Node> nodesForAssociation = toa.getExperimentalNodesForAssociation();
        ArrayList<GeneNode> geneNodesForAsn = new ArrayList<GeneNode>(nodesForAssociation.size());
        TreePanel treePanel = PaintManager.inst().getTree();
        List<GeneNode> allNodes = treePanel.getAllNodes();
        for (GeneNode gNode : allNodes) {
            gNode.setSelected(false);
            if (null == nodesForAssociation) continue;
            for (Node node : nodesForAssociation) {
                if (!gNode.getNode().equals(node)) continue;
                geneNodesForAsn.add(gNode);
            }
        }
        if (null == nodesForAssociation) {
            return null;
        }
        GeneNode gn = AnnotationMatrix.getMRCA(geneNodesForAsn);
        if (null == gn) {
            return null;
        }
        ArrayList<GeneNode> descendants = new ArrayList<GeneNode>();
        ArrayList nodeDescendants = new ArrayList();
        gn.getNode();
        Node.getDescendants((Node)gn.getNode(), nodeDescendants);
        PaintManager pm = PaintManager.inst();
        for (Node descendant : nodeDescendants) {
            GeneNode curGn = pm.getGeneByPTNId(descendant.getStaticInfo().getPublicId());
            if (null != curGn) {
                descendants.add(curGn);
                continue;
            }
            System.out.println("Unable to find gene node by id " + descendant.getStaticInfo().getPublicId() + " " + descendant.getStaticInfo().getNodeAcc());
        }
        descendants.add(gn);
        return descendants;
    }

    public static GeneNode getMRCA(List<GeneNode> nodeList) {
        if (null == nodeList || 0 == nodeList.size()) {
            return null;
        }
        if (1 == nodeList.size()) {
            GeneNode gn = nodeList.get(0);
            Node n = gn.getNode();
            Node p = n.getStaticInfo().getParent();
            if (null == p) {
                return null;
            }
            return PaintManager.inst().getGeneByPTNId(p.getStaticInfo().getPublicId());
        }
        HashMap<Node, List> nodeToAncestorLookup = new HashMap<Node, List>();
        Node smallestPathNode = null;
        int size = 0;
        for (GeneNode gn : nodeList) {
            Node n = gn.getNode();
            List ancestors = Node.getAncestors((Node)n);
            if (null == ancestors || 0 == ancestors.size()) {
                return null;
            }
            nodeToAncestorLookup.put(n, ancestors);
            if (1 == nodeToAncestorLookup.size()) {
                smallestPathNode = n;
                size = ancestors.size();
            }
            if (ancestors.size() >= size) continue;
            smallestPathNode = n;
            size = ancestors.size();
        }
        if (null == smallestPathNode || 0 == size) {
            return null;
        }
        List compList = (List)nodeToAncestorLookup.get(smallestPathNode);
        Node lastCommon = null;
        for (int i = 1; i <= size; ++i) {
            Node curComp = (Node)compList.get(compList.size() - i);
            for (GeneNode gn : nodeList) {
                List ancestors;
                Node current;
                Node n = gn.getNode();
                if (n == smallestPathNode || curComp == (current = (Node)(ancestors = (List)nodeToAncestorLookup.get(n)).get(ancestors.size() - i))) continue;
                if (lastCommon != null) {
                    return PaintManager.inst().getGeneByPTNId(lastCommon.getStaticInfo().getPublicId());
                }
                return null;
            }
            lastCommon = curComp;
        }
        if (null == lastCommon) {
            return null;
        }
        return PaintManager.inst().getGeneByPTNId(lastCommon.getStaticInfo().getPublicId());
    }

    @Override
    public void handleAnnotationDisplayEvent(AnnotationDisplayEvent event) {
        PaintManager pm = PaintManager.inst();
        this.mi = MatrixBuilder.getMatrixInfo(pm.getTree().getTreeModel());
        if (null == this.mi) {
            return;
        }
        this.setModels(pm.getTree().getTerminusNodes(), this.mi);
    }
}

